// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Base/hkBase.h>
#include <Common/Base/UnitTest/hkUnitTest.h>
#include <Common/Base/UnitTest/Reflection/RecordPropertiesTest.h>


namespace UnitTest
{
    void SetterTest::init()
    {
        m_int = -1;
        m_string = "someString";
        m_pointer = hkRefNew<Foo>(new Foo(-42));
        m_nested.m_int = 1;
        m_nested.m_float = 2.0f;
        m_nested.m_plain.m_int = 3;
        m_nested.m_twiceNested.m_float = 4.0f;
        m_nested.m_array.pushBack(5);
        m_array.pushBack(6);
        m_arrayRec.expandOne().m_int = 7;
        m_arrayArray.expandOne().expandOne() = 8;
    }

    bool SetterTest::operator ==(const SetterTest& rhs) const
    {
#define TEST(ELEM) while(ELEM != rhs.ELEM) { return false; }
        TEST(m_int);
        TEST(m_string);
        TEST(pointed());
        TEST(m_nested.m_int);
        TEST(m_nested.m_float);
        TEST(m_nested.m_plain.m_int);
        TEST(m_nested.m_twiceNested.m_float);
        TEST(m_nested.m_array.getSize());
        TEST(m_nested.m_array[0]);
        TEST(m_array.getSize());
        TEST(m_array[0]);
        TEST(m_arrayRec.getSize());
        TEST(m_arrayRec[0].m_int);
        TEST(m_arrayArray.getSize());
        TEST(m_arrayArray[0].getSize());
        TEST(m_arrayArray[0][0]);
#undef TEST
        return true;
    }

    static int getInt(const hkReflect::Var& var)
    {
        hkReflect::IntVar asInt(var);
        if (HK_TEST(asInt))
        {
            return asInt.getValue().convertTo<int>();
        }
        return -1;
    }

    static void testSetters()
    {
        using namespace hkReflect;

        SetterTest obj;

        // simple fields
        {
            IntVar intField = Var::fromField(&obj, &SetterTest::m_int);
            if (HK_TEST(intField))
            {
                HK_TEST(intField.setValue(1337).isSuccess());
                HK_TEST_EQ(obj.m_int, 1337);
                HK_TEST(obj.m_intSet);
            }

            StringVar stringField = Var::fromField(&obj, &SetterTest::m_string);
            if (HK_TEST(stringField))
            {
                HK_TEST(stringField.setValue("someOtherString").isSuccess());
                HK_TEST_EQ(obj.m_string, "someOtherString");
                HK_TEST(obj.m_stringSet);
            }

            PointerVar pointerField = Var::fromField(&obj, &SetterTest::m_pointer);
            if (HK_TEST(pointerField))
            {
                hkRefPtr<SetterTest::Foo> pointed = hkRefNew<SetterTest::Foo>(new SetterTest::Foo(4242));
                HK_TEST(pointerField.setValue(pointed).isSuccess());
                HK_TEST_EQ(obj.m_pointer, pointed);
                HK_TEST(obj.m_pointerSet);
            }
        }

        // fields in nested
        {
            IntVar nestedInt;
            FloatVar nestedFloat;
            {
                Var recordField = Var::fromField(&obj, &SetterTest::m_nested);
                nestedInt = recordField[&SetterTest::Nested::m_int];
                nestedFloat = recordField[&SetterTest::Nested::m_float];
            }

            obj.m_nestedSet = false;
            if (HK_TEST(nestedInt))
            {
                HK_TEST(nestedInt.setValue(42).isSuccess());
            }
            HK_TEST_EQ(obj.m_nested.m_int, 42);
            HK_TEST(obj.m_nestedSet);

            obj.m_nestedSet = false;
            if (HK_TEST(nestedFloat))
            {
                HK_TEST(nestedFloat.setValue(3.14f).isSuccess());
            }
            HK_TEST_EQ(obj.m_nested.m_float, 3.14f);
            HK_TEST(obj.m_nestedSet);
        }

        // nested in nested
        {
            IntVar nestedInt;
            FloatVar nestedFloat;
            {
                Var recordField = Var::fromField(&obj, &SetterTest::m_nested);
                RecordVar twiceNested = recordField[&SetterTest::Nested::m_plain];
                nestedInt = twiceNested[&SetterTest::TwiceNested::m_int];
                nestedFloat = twiceNested[&SetterTest::TwiceNested::m_float];
            }

            obj.m_nestedSet = false;
            if (HK_TEST(nestedInt))
            {
                HK_TEST(nestedInt.setValue(84).isSuccess());
            }
            HK_TEST_EQ(obj.m_nested.m_plain.m_int, 84);
            HK_TEST(obj.m_nestedSet);

            obj.m_nestedSet = false;
            if (HK_TEST(nestedFloat))
            {
                HK_TEST(nestedFloat.setValue(6.28f).isSuccess());
            }
            HK_TEST_EQ(obj.m_nested.m_plain.m_float, 6.28f);
            HK_TEST(obj.m_nestedSet);
        }

        // array in nested
        {
            ArrayVar array;
            {
                Var recordField = Var::fromField(&obj, &SetterTest::m_nested);
                array = recordField[&SetterTest::Nested::m_array];
            }

            obj.m_nestedSet = false;
            HK_TEST(array.setArraySize(3).isSuccess());
            HK_TEST(obj.m_nestedSet);

            obj.m_nestedSet = false;
            HK_TEST_EQ(array.getCount(), 3);
            HK_TEST(!obj.m_nestedSet);

            IntVar(array[2]).setValue(987);
            HK_TEST(obj.m_nestedSet);
            HK_TEST_EQ(getInt(array[2]), 987);
        }


        // nested setters
        {
            FloatVar nestedFloat;
            {
                Var recordField = Var::fromField(&obj, &SetterTest::m_nested);
                RecordVar twiceNested = recordField[&SetterTest::Nested::m_twiceNested];
                nestedFloat = twiceNested[&SetterTest::TwiceNested::m_float];
            }

            obj.m_nestedSet = false;
            if (HK_TEST(nestedFloat))
            {
                HK_TEST(nestedFloat.setValue(12.56f).isSuccess());
            }
            HK_TEST_EQ(obj.m_nested.m_twiceNested.m_float, 12.56f);
            HK_TEST(obj.m_nested.m_twiceNestedSet);
            HK_TEST(obj.m_nestedSet);
        }

        // array with setter
        {
            ArrayVar arrayField = Var::fromField(&obj, &SetterTest::m_array);
            obj.m_arraySet = false;
            HK_TEST(arrayField.setArraySize(9).isSuccess());
            HK_TEST(obj.m_arraySet);

            obj.m_arraySet = false;
            int vals[2] = { 100, 200 };
            HK_TEST(arrayField.spliceInto(1, 1, ArrayValue(vals, HK_COUNT_OF(vals))).isSuccess());
            HK_TEST(obj.m_arraySet);

            obj.m_arraySet = false;
            HK_TEST_EQ(arrayField.getCount(), 10);
            HK_TEST(!obj.m_arraySet);

            ArrayValue val = arrayField.getValue();
            HK_TEST(!obj.m_arraySet);

            HK_TEST_EQ(getInt(arrayField[0]), 0);
            HK_TEST(!obj.m_arraySet);
            HK_TEST_EQ(getInt(arrayField[1]), 100);
            HK_TEST(!obj.m_arraySet);

            // set from ArrayVar
            HK_TEST(IntVar(arrayField[1]).setValue(300).isSuccess());
            HK_TEST(obj.m_arraySet);
            HK_TEST_EQ(getInt(arrayField[1]), 300);
            HK_TEST_EQ(getInt(val[1]), 300);

            // set from ArrayValue
            obj.m_arraySet = false;
            HK_TEST(IntVar(val[1]).setValue(400).isSuccess());
            HK_TEST(obj.m_arraySet);
            HK_TEST_EQ(getInt(arrayField[1]), 400);
            HK_TEST_EQ(getInt(val[1]), 400);
        }

        // array of records
        {
            {
                ArrayVar arrayRecField = Var::fromField(&obj, &SetterTest::m_arrayRec);
                obj.m_arrayRecSet = false;
                HK_TEST(arrayRecField.setArraySize(2).isSuccess());
                HK_TEST(obj.m_arrayRecSet);

                obj.m_arrayRecSet = false;
                HK_TEST_EQ(arrayRecField.getCount(), 2);
                HK_TEST(!obj.m_arrayRecSet);
            }

            FloatVar f;
            {
                ArrayVar arrayRecField = Var::fromField(&obj, &SetterTest::m_arrayRec);
                Var elem = arrayRecField[1];
                f = elem[&SetterTest::Nested::m_float];
            }

            if (HK_TEST(f))
            {
                HK_TEST(f.setValue(123.45f).isSuccess());
            }
            HK_TEST(obj.m_arrayRecSet);
            HK_TEST_EQ(obj.m_arrayRec[1].m_float, 123.45f);
        }

        // array of arrays
        {
            {
                ArrayVar arrayArrayField = Var::fromField(&obj, &SetterTest::m_arrayArray);
                obj.m_arrayArraySet = false;
                HK_TEST(arrayArrayField.setArraySize(2).isSuccess());
                HK_TEST(obj.m_arrayArraySet);

                obj.m_arrayArraySet = false;
                HK_TEST_EQ(arrayArrayField.getCount(), 2);
                HK_TEST(!obj.m_arrayArraySet);
            }

            ArrayVar array;
            {
                ArrayVar arrayArrayField = Var::fromField(&obj, &SetterTest::m_arrayArray);
                array = arrayArrayField[1];
            }

            HK_TEST(array);
            int elem = 12345;
            HK_TEST(array.pushBack(&elem).isSuccess());
            if (HK_TEST_EQ(obj.m_arrayArray[1].getSize(), 1))
            {
                HK_TEST_EQ(array.getCount(), 1);
                HK_TEST_EQ(obj.m_arrayArray[1][0], 12345);
            }
            HK_TEST(obj.m_arrayArraySet);
        }
    }
}




#if 0
template<typename HSV_TYPE>
static void test(const char* HSV_PROP_NAME)
{
    UnitTest::ColorRGB rgb012(0,1,2);
    UnitTest::ColorRGB rgb345(3,4,5);
    UnitTest::ColorRGB rgb678(6,7,8);

    UnitTest::PropertyContainer obj1;
    UnitTest::PropertyContainer obj2;

    hkReflect::RecordVar objVar1(&obj1);
    hkReflect::RecordVar objVar2(&obj2);

    hkReflect::RecordVar rgb1 = objVar1["color"];
    hkReflect::RecordVar rgb2 = objVar2["color"];

    if(1)
    {
        // set from a concrete var
        {
            obj1.setColor(rgb012);
            obj2.setColor(rgb678);
            HK_TEST( obj1.getColor() == rgb012);

            rgb1.assign( hkReflect::RecordVar(&rgb345) );

            HK_TEST( obj1.getColor() == rgb345);
        }

        // set a property from a property
        {
            obj1.setColor(rgb012);
            obj2.setColor(rgb678);

            rgb1.assign(rgb2);

            HK_TEST( obj1.getColor() == rgb678);
        }

        // mutate a field of a property
        {
            obj1.setColor(rgb012);
            obj2.setColor(rgb678);

            hkReflect::FloatVar g = rgb2["g"];
            HK_TEST(g);
            HK_TEST(g.getValue() == 7);
            g.setValue(10);
            HK_TEST(g.getValue() == 10);
        }

        if(1) // mutate a field of a property of a property
        {
            obj1.setColor(rgb012);
            obj2.setColor(rgb678);

            hkReflect::RecordVar hsv = rgb2[HSV_PROP_NAME];
            hkReflect::RecordVar rgb = rgb2;

            {
                hkReflect::Detail::RecordImpl::RecordBuffer buf;
                HSV_TYPE* h = hsv.getValue(buf).dynCast<HSV_TYPE>();
                HK_TEST(h->m_h == -6);
                HK_TEST(h->m_s == -7);
                HK_TEST(h->m_v == -8);
                UnitTest::ColorRGB* r = rgb.getValue(buf).dynCast<UnitTest::ColorRGB>();
                HK_TEST(*r == rgb678);
            }

            hkReflect::FloatVar s = hsv["s"];
            hkReflect::FloatVar g = rgb["g"];
            HK_TEST(s);
            HK_TEST(g);
            hkReflect::FloatValue origg = g.getValue();
            hkReflect::FloatValue origs = s.getValue();
            HK_TEST(origg == -origs);
            s.setValue( origs*2 );
            hkReflect::FloatValue nextg = g.getValue();
            HK_TEST( nextg == origg*2 );
        }

        if(1) // assign nested properties
        {
            obj1.setColor(rgb012);
            obj2.setColor(rgb678);

            hkReflect::RecordVar hsv1 = rgb1[HSV_PROP_NAME];
            hkReflect::RecordVar hsv2 = rgb2[HSV_PROP_NAME];
            hkReflect::FloatVar s1 = hsv1["s"];
            hkReflect::FloatVar v2 = hsv2["v"];
            HK_TEST( s1.getValue() == -1 );
            HK_TEST( v2.getValue() == -8 );

            HK_TEST( v2.assign(s1) );
            HK_TEST( v2.getValue() == -1 );
        }

        if(1) // non-property record in a property record
        {
            hkReflect::RecordVar bigger = objVar1["bigger"];
            HK_TEST(bigger);
            hkReflect::RecordVar little = bigger["little"];
            HK_TEST(little);

            hkReflect::IntVar la = little["a"];
            hkReflect::IntVar lb = little["b"];
            HK_TEST(la.getValue()=='a');
            HK_TEST(lb.getValue()=='b');

            // lb.set('B'); //Doesn't work yet
            //HK_TEST( obj1.m_biggerStore.m_little.m_b == 'B' );

            UnitTest::BiggerStruct bs;
            bs.m_pad0 = 10;
            bs.m_little.m_a = 'A';
            bs.m_little.m_b = 'B';
            bs.m_pad1 = 11;
            bigger.assign(hkReflect::RecordVar(&bs));

            HK_TEST(la.getValue()=='A');
            HK_TEST(lb.getValue()=='B');
        }
    }
}
#endif

static int RecordPropertiesTest()
{
    UnitTest::testSetters();

#if defined(HK_BUILDING_WITH_ENGINE)
//  test<UnitTest::ColorHSV>("hsv");
//  test<UnitTest::ColorHSV2>("hsv2");
#endif
    return 0;
}

HK_TEST_REGISTER(RecordPropertiesTest, "Fast", "Common/Test/UnitTest/Base/", __FILE__     );

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
