// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Base/hkBase.h>
#include <Common/Base/UnitTest/hkUnitTest.h>
#include <Common/Base/Reflect/TypeReg/hkTypeReg.h>
#include <Common/Base/Reflect/Core/Detail/hkReflectTypeDetail.h>

// Test that all reflected types have sensible behavior when default constructed, then destructed.
// You may see memory leaks and crashes from here. It's not the test, it's the type which is at fault.
static int ConstructDestruct()
{
    using namespace hkReflect;
    hkArray<const Type*> types; hkReflect::getTypeReg()->appendAllTypesToArray(types);
    hkOstream log("ConstructDestruct.txt");

#if 0 
    hkArray<char>::Temp buf;
    for(int i = 0; i < types.getSize(); ++i)
    {
        const Type* type = types[i];
        if(type->asPointer() )
        {
            continue;
        }
        if(type->isSerializable() == false)
        {
            continue;
        }
        buf.clear();
        buf.setSize(type->getSizeOf(), 0);
        hkStringBuf sb;
        if(hkReflect::TypeDetail::reflectConstruct(buf.begin(), type).isSuccess())
        {
            if(log.isOk())
            {
                log << type->getFullName(sb) << '\n';
#if !defined(HK_PLATFORM_IS_CONSOLE)
                // This can be very slow on networked file systems
                log.flush();
#endif
            }

            hkReflect::TypeDetail::destruct(buf.begin(), type, 1);
        }
    }
#endif

    return 0;
}

HK_TEST_REGISTER(ConstructDestruct, "Fast", "Common/Test/UnitTest/Base/", __FILE__);

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
