// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Common/Base/Types/Geometry/hkGeometry.h>
#include <Common/Base/Reflect/Core/hkReflectCallable.h>

namespace UnitTestClang
{
    enum ReflectedEnum
    {
        ONE,
        TWO,
        TEN = 10
    } HK_ATTR( hk::AbsMax(UnitTestClang::TEN), hk::ManualTypeRegistration );

    enum ForwardDeclaredEnum : int;

    enum HK_ATTR(hk::ManualTypeRegistration) ForwardDeclaredEnum : int
    {
        ONE_A, TWO_A
    };

    enum class EnumClassImplicit;

    enum class HK_ATTR(hk::ManualTypeRegistration) EnumClassImplicit
    {
        ONE, TWO
    };

    enum class HK_ATTR(hk::ManualTypeRegistration) EnumClassExplicit : short;

    enum class HK_ATTR(hk::ManualTypeRegistration) EnumClassExplicit : short
    {
        ONE, TWO
    };

    typedef int ReflectedTypedef HK_ATTR(hk::Default(21), hk::AbsMax(42));

    struct TestDependentType
    {
        HK_DECLARE_CLASS(TestDependentType, New, Reflect);
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);
        typedef hkReal Dependent;
    };

    typedef TestDependentType TdefWithDependent;

    template<typename A, typename B, typename C>
    struct TypedefArg
    {
        HK_DECLARE_CLASS(TypedefArg, New, Reflect, Validate);
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);
        TypedefArg() {}

        A m_t;
        typename B::Dependent m_dep;
        C m_withAttrs HK_ATTR(hk::Default(21), hk::AbsMax(42));
    };

    // Chained typedefs.
    typedef hkInt32 hkInt32_2;
    typedef TdefWithDependent TdefWithDependent_2;
    typedef hkArray<hkInt32> IntArray;

    struct TestTypedef
    {
        HK_DECLARE_CLASS(TestTypedef, New, Reflect, Validate);
        HK_RECORD_ATTR(hk::Serialize(false));
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);


        ReflectedTypedef* m_ptr;
        ReflectedTypedef m_array[10];
        ReflectedTypedef* m_ptrArray[10];
        hkArray<ReflectedTypedef> m_hkArray;

        ReflectedTypedef propGet() const { return 0; }
        void propSet(ReflectedTypedef) {}
        HK_PROPERTY(prop, propGet, propSet);

        hkInt32 tdefWithAttr HK_ATTR(hk::Default(21), hk::AbsMax(42));

        hkInt32_2 m_doubleTdef;

        TypedefArg<hkArray<int>, TestDependentType, char> m_t0;
        TypedefArg<hkArray<hkInt32_2>, TdefWithDependent, hkUint8> m_t1;
        TypedefArg<IntArray, TdefWithDependent_2, hkInt32_2> m_t2;
    };

    struct TestDefaultTypes
    {
        HK_DECLARE_CLASS(TestDefaultTypes, New, Reflect, BypassCtor, Version(1), Validate);
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);

        hkVector4 m_vec HK_ATTR( hk::Default(1,2,3,4), hk::AbsMin(-1,-2,-3,-4) );
        hkMatrix3 m_mat HK_ATTR( hk::Default({1,2,3,4}, {5,6,7,8}, {9,10,11,12}) );
        hkTransform m_trans HK_ATTR( hk::Default({1,2,3,4}, {5,6,7,8}, {9,10,11,12}, {13,14,15,16}) );
        hkQuaternion m_quat HK_ATTR( hk::Default(0,1,2,6) );
        hkReal m_real HK_ATTR( hk::AbsMin(-10), hk::AbsMax(100) );
        hkHalf16 m_half HK_ATTR( hk::Default(22.3) );
        hkEnum<ReflectedEnum, int> m_enum HK_ATTR( hk::Default(TEN) );
        hkArray<hkHalf16> m_halfArr;

        hkVector4 m_iShouldBeNormalised HK_ATTR(hk::Normalized);

        hkRefPtr<hkReferencedObject> m_aPointer HK_ATTR(hk::NonNull);

        hkResult validateContract() const { m_wasValidated = true; return m_enum==TEN ? HK_SUCCESS : HK_FAILURE; }

        // hkReal property

        bool setRadius(hkReal r) { m_radiusInternal = r; return true; }
        hkReal getRadius() const { return m_radiusInternal; }
        HK_PROPERTY(radius, getRadius, setRadius);
        hkReal m_radiusInternal;

        // int property

        void setIntVal(int i) { m_intValInternal = i; }
        int getIntVal() const { return m_intValInternal; }
        HK_PROPERTY(intVal, getIntVal, setIntVal) HK_ATTR( hk::AbsMax(1), hk::Ui_FieldName("SomeIntVal") );
        int m_intValInternal;

        // bool property

        bool setBoolVal(const bool& b) { m_boolValInternal = b; return true; }
        bool getBoolVal() const { return m_boolValInternal; }
        HK_PROPERTY(boolVal, getBoolVal, setBoolVal);
        bool m_boolValInternal;

        // string property

        bool setName(const char* n) { m_nameInternal = n; return true; }
        const char* getName() const { return m_nameInternal; }
        HK_PROPERTY(name, getName, setName);
        hkStringPtr m_nameInternal;


        // integer readonly property

        hkReal getArea() const { const hkReal rad = getRadius(); return HK_REAL_PI * rad * rad; }
        HK_PROPERTY(area, getArea);

        // pointer property
        bool setPtrProperty(struct hkGeometry* p) { m_ptrProperty = p; return true; }
        struct hkGeometry* getPtrProperty() const { return m_ptrProperty; }
        HK_PROPERTY(ptr, getPtrProperty, setPtrProperty);
        struct hkGeometry* m_ptrProperty;

        bool setPtrProperty2(int*) { return true; }
        const int* getPtrProperty2() const { return HK_NULL; }
        HK_PROPERTY(ptr2, getPtrProperty2, setPtrProperty2);

        hkReflect::Var getVarProperty() const { return hkReflect::Var(m_ptrProperty); }
        HK_PROPERTY(var, getVarProperty);

        hkHandle<hkInt32, 10, TestDefaultTypes> m_handle;

        enum HK_ATTR(hk::ManualTypeRegistration) EnumValue1 { EV_ZERO = 0, EV_ONE = 1, EV_DOZEN = 12, EV_HUNDRED = 100 };
        EnumValue1 m_enumStorage1;
        EnumValue1 getEnum1() const { return m_enumStorage1; }
        void setEnum1(EnumValue1 e) { m_enumStorage1 = e; }
        HK_PROPERTY(enum1, getEnum1, setEnum1);

        TestDefaultTypes() : m_quat(hkQuaternion::getIdentity()), m_radiusInternal(5.0f), m_intValInternal(10), m_boolValInternal(false), m_nameInternal("old"), m_enumStorage1(EV_HUNDRED)
        {
        }

        mutable bool m_wasValidated;

    private:
        bool setIntValPrivate(int i) { m_intValInternal = i; return true; }
    public:
        HK_PROPERTY(intVal2, getIntVal, setIntValPrivate);
    };

    template<typename T>
    struct TestTemplateProperty
    {
        HK_DECLARE_CLASS(TestTemplateProperty, New, Reflect);
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);
        TestTemplateProperty() {}

        // int property
        bool setIntVal(int i) { m_intValInternal = i; return true; }
        int getIntVal() const { return m_intValInternal; }
        HK_PROPERTY(intVal, getIntVal, setIntVal);

        // template property
        bool setTVal(const T& t) { m_TValInternal = t; return true;}
        T getTVal() const { return m_TValInternal; }
        HK_PROPERTY(TVal, getTVal, setTVal);

        
#if 0
        struct Nested
        {
            HK_DECLARE_CLASS(Nested, New, Reflect);
            int m_i;

            // int property
            bool setIntVal(int i) { m_intValInternal = i; return true; }
            int getIntVal() const { return m_intValInternal; }
            HK_PROPERTY(intVal, getIntVal, setIntVal);

            // template property
            bool setTVal(const T& t) { m_TValInternal = t; return true;}
            T getTVal() const { return m_TValInternal; }
            HK_PROPERTY(TVal, getTVal, setTVal);

            int m_intValInternal;
            T m_TValInternal;

        };
#endif
        int m_intValInternal;
        T m_TValInternal;
    };

    template<typename T>
    struct TestTemplateAttribute
    {
        HK_DECLARE_CLASS(TestTemplateAttribute, New, Reflect, Validate);
        HK_RECORD_ATTR( hk::Default(0) );
        HK_RECORD_ATTR( hk::AbsMin(-1) );
        HK_RECORD_ATTR( hk::ContainsRelArrays(false) );
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);

        TestTemplateAttribute() : m_t() {}
        TestTemplateAttribute(T t) : m_t(t) {}

        T m_t HK_ATTR( hk::AbsMax(1) );
    };

    struct TestRecordPresets
    {
        HK_DECLARE_CLASS(TestRecordPresets, New, Reflect);
        HK_RECORD_ATTR( hk::Presets({ZERO=0, ONE=1}) );
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);

        TestRecordPresets(int i=0) : m_value(i) {}

        int m_value;
        int m_valueWithPresets HK_ATTR(hk::Presets({ ZERO = 0, ONE = 1 }));
        int m_anotherValueWithPresets HK_ATTR(hk::Presets({ TWO = 2, THREE = 3 }));
    };
    HK_DECLARE_VALUE_ATTR2(HK_ATTR(hk::ManualTypeRegistration), ArrayAttr, hk::ValueArray<const char*>, Runtime);

    struct ArrayAttrDef
    {
        HK_DECLARE_CLASS(ArrayAttrDef, New, Reflect, RuntimeAttribute);
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);

        typedef int AttributeType;
        hk::ValueArray<int> m_value HK_ATTR(hk::Optional(implicit = true), hk::Default(1, 2, 3));
    };

    struct ArrayAttrEmptyDef
    {
        HK_DECLARE_CLASS(ArrayAttrEmptyDef, New, Reflect, RuntimeAttribute);
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);

        typedef int AttributeType;
        hk::ValueArray<int> m_value HK_ATTR(hk::Optional(implicit = true), hk::Default({}));
    };

    struct TestArrayAttr
    {
        HK_DECLARE_CLASS(TestArrayAttr, New, Reflect);
        HK_RECORD_ATTR(UnitTestClang::ArrayAttr("1"));
        HK_RECORD_ATTR(UnitTestClang::ArrayAttrDef(1, 2, 3, 4));
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);
    };

    struct TestArrayAttrDefaults
    {
        HK_DECLARE_CLASS(TestArrayAttrDefaults, New, Reflect);
        HK_RECORD_ATTR(UnitTestClang::ArrayAttr);
        HK_RECORD_ATTR(UnitTestClang::ArrayAttrDef);
        HK_RECORD_ATTR(UnitTestClang::ArrayAttrEmptyDef);
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);
    };

    struct TestEnumTypedefs
    {
        HK_DECLARE_CLASS(TestEnumTypedefs, New, Reflect);
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);

        enum HK_ATTR(hk::ManualTypeRegistration) Count
        {
            C_ONE = 1,
            C_TWO = 2,
            C_THREE = 3
        };

        typedef hkReal Real10 HK_ATTR( hk::Default(10.0f), hk::AbsMin(0.0f) );

        Count m_count;
        Real10 m_real;
    };

    HK_DECLARE_VALUE_ATTR2(HK_ATTR(hk::ManualTypeRegistration), SimpleAttr, int, Runtime);

    struct TestMethods
    {
        HK_DECLARE_CLASS(TestMethods, New, Reflect, ReflectDetails(methods=true));
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);

        TestMethods() HK_ATTR(UnitTestClang::SimpleAttr(1)) {}
        TestMethods(int i) {}

        int overloaded() HK_ATTR(UnitTestClang::SimpleAttr(2)) { return 0; }
        int overloaded(void*) { return 1; }

        static int defaultArgs(int a = 10,
            const hkVector4& v = hkVector4::getZero(),
            hkTuple<int, int> t = hkTupleT::make(42, 24),
            hkQuaternionfParameter q = hkQuaternion()) { return a; }

        static void overloaded2() HK_ATTR(UnitTestClang::SimpleAttr(3)) {}
        static void overloaded2(const hkReferencedObject&) {}
    };

    template <typename T, typename U>
    struct TestTemplateMethods
    {
        HK_DECLARE_CLASS(TestTemplateMethods, New, Reflect, ReflectDetails(methods=true));
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);

        TestTemplateMethods() {}
        TestTemplateMethods(int i) {}
        TestTemplateMethods(T t) HK_ATTR(UnitTestClang::SimpleAttr(1)) {}

        int overloaded() HK_ATTR(UnitTestClang::SimpleAttr(2)) { return 0; }
        int overloaded(T*) { return 1; }

        void dependent(T) {}
        void dependent(typename U::Dependent) {}

        static int overloaded2() { return 0; }
        static int overloaded2(const T&) { return 1; }
        static int overloaded2(typename U::Dependent*) HK_ATTR(UnitTestClang::SimpleAttr(3)) { return 2; }
    };

    template <typename T>
    struct TestTemplateDefArgs
    {
        HK_DECLARE_CLASS(TestTemplateDefArgs, New, Reflect, ReflectDetails(methods = true));
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);

        static int defaultArgs(T t = 123) { return t; }
    };

    // For these alignment tests, I have deliberately make the base fields 1 byte
    // and the derived fields larger so that there is a mix of padding rules.

    // alignment on base class

    HK_CLASSALIGN(struct, 16) Aligned_Class_Base
    {
        HK_DECLARE_CLASS(Aligned_Class_Base, NewPlacement, Reflect);
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);
        Aligned_Class_Base() {}
        hkUint8 tag;
    };

    struct Aligned_Class : public Aligned_Class_Base
    {
        HK_DECLARE_CLASS(Aligned_Class, NewPlacement, Reflect);
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);
        int val;
    };

    // alignment on derived class

    struct Mixed_Class_Base
    {
        HK_DECLARE_CLASS(Mixed_Class_Base, NewPlacement, Reflect);
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);
        hkUint8 tag;
    };

    HK_CLASSALIGN(struct,16) Mixed_Class : public Mixed_Class_Base
    {
        HK_DECLARE_CLASS(Mixed_Class, NewPlacement, Reflect);
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);
        short val;
    };

    struct Mixed_Class2 : public Mixed_Class
    {
        HK_DECLARE_CLASS(Mixed_Class2, NewPlacement, Reflect);
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);
        int val2;
    };

    // alignment via fields

    struct Aligned_Field_Base
    {
        HK_DECLARE_CLASS(Aligned_Field_Base, NewPlacement, Reflect);
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);
        Aligned_Field_Base() {}
        HK_ALIGN(hkUint8 tag, 16);
    };
    struct Aligned_Field : public Aligned_Field_Base
    {
        HK_DECLARE_CLASS(Aligned_Field, NewPlacement, Reflect);
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);
        int val;
    };

    
#if 0

    template<typename T1, typename T2 = TestDependentType>
    struct TestTemplateEnumTypedefs
    {
        HK_DECLARE_CLASS(TestEnumTypedefs, New, Reflect);
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);

        enum Count
        {
            C_ONE = 1,
            C_TWO = 2,
            C_THREE = 3
        };

        typedef T1 Real100 HK_ATTR( hk::Reflect, hk::Default(100.0f), hk::AbsMin(0.0f) );
        typedef typename T2::Dependent Real200 HK_ATTR( hk::Reflect, hk::Default(200.0f), hk::AbsMin(0.0f) );

        Count m_count;
        Real100 m_real;
    };

    struct NestedA
    {
    public:
        HK_DECLARE_CLASS(NestedA, New, Reflect);
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);

        template<typename T>
        struct Template
        {
            HK_DECLARE_CLASS(Template, New, Reflect);
            HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);
            T m_t;
        };

        struct NestedB
        {
            HK_DECLARE_CLASS(NestedB, New, Reflect);
            HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);
            struct NestedC
            {
                HK_DECLARE_CLASS(NestedC, New, Reflect);
                HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);

                int m_int HK_ATTR( hk::Default(NestedA::DEFAULT), hk::AbsMax(NestedA::MAX) );

                template<typename T>
                struct Template
                {
                    HK_DECLARE_CLASS(Template, New, Reflect);
                    T m_t;
                };
            };
        };

    private:
        enum { DEFAULT = 42, MAX = 100 };
    };

    template<typename A1, typename A2>
    struct TemplateNestedA
    {
        HK_DECLARE_CLASS(TemplateNestedA, New, Reflect);
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);

        struct NonTemplate
        {
            HK_DECLARE_CLASS(NonTemplate, New, Reflect);
            HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);
        };

        template<typename B1, int B2>
        struct TemplateNestedB
        {
            HK_DECLARE_CLASS(TemplateNestedB, New, Reflect);
            HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);

            template<typename C>
            struct TemplateNestedC
            {
                HK_DECLARE_CLASS(TemplateNestedC, New, Reflect);
                HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);

                A1 m_a;
                TemplateNestedB< TemplateNestedA<double, A1>, 10 > m_b;
                C m_c;

                struct NonTemplate
                {
                    HK_DECLARE_CLASS(NonTemplate, New, Reflect);
                    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);
                    C m_c;
                };
            };
        };
    };

    struct SpecializationsInNonTemplate
    {
        HK_DECLARE_CLASS(SpecializationsInNonTemplate, New, Reflect, BypassCtor);
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);

        TestTemplateEnumTypedefs<float>::Real100 m_r1;

        typedef TestTemplateEnumTypedefs<double> Test;
        Test::Real200 m_r2;
        Test::Count m_c;

        TemplateNestedA<int, float>::TemplateNestedB<char, 0> m_n1;
        typedef TemplateNestedA<int, double>::TemplateNestedB<char, 2> Nested;
        Nested m_n2;
        Nested::TemplateNestedC<Test> m_n3;
        NestedA::NestedB::NestedC::Template<int> m_n4;
        Nested::TemplateNestedC<int>::NonTemplate m_n5;
        TemplateNestedA<int, float>::NonTemplate m_n6;
        hkArray<Nested> m_n7;
        hkEnum<Test::Count, Test::Real200> m_n8;
    };

    template<typename T>
    struct SpecializationsInTemplate
    {
        HK_DECLARE_CLASS(SpecializationsInTemplate, New, Reflect);
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);

        typename TestTemplateEnumTypedefs<T>::Real100 m_r1;
        typename TestTemplateEnumTypedefs<T, TestDependentType>::Real200 m_r2;

        typedef TestTemplateEnumTypedefs<T> Test;
        typename Test::Count m_c;

        typename TemplateNestedA<T, T>::template TemplateNestedB<char, 2> m_n1;
        typedef typename TemplateNestedA<T, double>::template TemplateNestedB<T, 5> Nested;
        Nested m_n2;
        typename Nested::template TemplateNestedC<T> m_n3;
        typename NestedA::NestedB::NestedC::Template<int> m_n4;
        typename Nested::template TemplateNestedC<T>::NonTemplate m_n5;
        typename TemplateNestedA<T, float>::NonTemplate m_n6;
        hkArray<Nested> m_n7;
        hkEnum<typename Test::Count, typename Test::Real200> m_n8;
    };
#endif
    struct NonReflected
    {
        enum HK_ATTR(hk::ManualTypeRegistration) Enum { ONE = 1 };
        typedef int Typedef;
        struct Nested
        {
            HK_DECLARE_CLASS(Nested, New, Reflect);
            HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);
            int m_i;
        };

        template<typename T>
        struct NestedTemplate
        {
            HK_DECLARE_CLASS(NestedTemplate, New, Reflect);
            HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);
            T m_t;
        };
    };

    
#if 0
    template<typename T>
    struct NonReflectedTemplate
    {
        enum Enum { ONE = 1 };
        typedef int Typedef HK_ATTR( hk::Reflect );

        struct Nested
        {
            HK_DECLARE_CLASS(Nested, New, Reflect);
            HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);
            int m_i;
        };

//      template<typename S> //TODO
//      struct NestedTemplate
//      {
//          HK_DECLARE_CLASS(Nested, New, Reflect);
//          S m_s;
//      };
    };
#endif

    struct PrivateCtor
    {
        HK_DECLARE_CLASS(PrivateCtor, New, Reflect);
        HK_RECORD_ATTR(hk::Serialize(false), hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);

    private:
        PrivateCtor() {}
    };

    struct CastAttr
    {
        HK_DECLARE_CLASS(CastAttr, New, Reflect, RuntimeAttribute);
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);

        template<typename T>
        static HK_INLINE hkUlong ptrToLong(T* t) { return reinterpret_cast<hkUlong>(t); }

        hkUlong m_long HK_ATTR( hk::Cast(UnitTestClang::CastAttr::ptrToLong) );
    };

    struct TestCastAttr
    {
        HK_DECLARE_CLASS(TestCastAttr, New, Reflect);
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);

        static int s_int;
        static float s_float;
        static void func(const int& i) {}

        int m_1 HK_ATTR( UnitTestClang::CastAttr(&UnitTestClang::TestCastAttr::s_int));
        int m_2 HK_ATTR( UnitTestClang::CastAttr(&UnitTestClang::TestCastAttr::s_float));
        int m_3 HK_ATTR( UnitTestClang::CastAttr(&UnitTestClang::TestCastAttr::func));
    };

    struct TestAccessAttribute
    {
        HK_DECLARE_CLASS(TestAccessAttribute, New, Reflect, RuntimeAttribute);
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);

        static int s_dummy;

        int* m_value;
    };

    class AttrAccess
    {
        public:
            HK_DECLARE_CLASS(AttrAccess, New, Reflect);
            HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);
            HK_RECORD_ATTR(UnitTestClang::TestAccessAttribute(&s_protectedMember));

            /// Protected symbol in class.
            int m_int0 HK_ATTR(UnitTestClang::TestAccessAttribute(&s_protectedMember));

            /// Private symbol in class.
            int m_int1 HK_ATTR(UnitTestClang::TestAccessAttribute(&s_privateMember));

            /// Symbol in attribute class.
            int m_int2 HK_ATTR(UnitTestClang::TestAccessAttribute(&s_dummy));

        protected:
            static int s_protectedMember;

        private:
            static int s_privateMember;
    };

    template <typename T>
    struct TemplateFunctions
    {
        HK_DECLARE_CLASS(TemplateFunctions, New, Reflect, ReflectDetails(methods=true));
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);

        TemplateFunctions() : m_value(42.0f) {}
        int meth(const int& x) { m_value = (T)x; return (int)m_value; }
        static int func(int a, int b) { return a + b; }

        T templateMeth(const T& x) {m_value = x; return m_value; }
        static T templateFunc(T a, T b) { return a + b; }

        
        //struct Nested
        //{
        //  HK_DECLARE_CLASS(Nested, New, ReflectDetails(methods=true));

        //  Nested() {}
        //  void meth(int) {}
        //  static float func(char) { return 0.0f; }
        //};

        T m_value;

        //Nested nestedMeth(Nested& n) { return n; }
        //typename TemplateNestedA<T, T>::template TemplateNestedB<T, 0> otherNestedMeth(typename TemplateNestedA<T, T>::template TemplateNestedB<T, 0>& n) { return n; }
    };

    template<typename T, int I>
    struct Specializations
    {
        HK_DECLARE_CLASS(Specializations, New, Reflect);
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);
    };

    template<int I>
    struct Specializations < hkBaseObject, I >
    {
        HK_DECLARE_CLASS(Specializations, New, Reflect);
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);
        int m_int;
    };

    template<typename T>
    struct Specializations < T, 42 >
    {
        HK_DECLARE_CLASS(Specializations, New, Reflect);
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);
        Specializations() {}
        hkStringPtr m_string;
    };

    template<>
    struct Specializations < float, 100 >
    {
        HK_DECLARE_CLASS(Specializations, New, Reflect);
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);

        Specializations<hkBaseObject, 15> m_0;
        Specializations<double, 42> m_1;
        Specializations<void, 0> m_2;
    };

    template <typename T>
    struct WithPtr
    {
        HK_DECLARE_CLASS(WithPtr, New, Reflect, ReflectDetails(methods=true));
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);

        void method(T* param) {}

        T* m_rawPtr;
    };

    template< bool b >
    struct WithBoolParam
    {
        HK_DECLARE_CLASS(WithBoolParam, New, Reflect);
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);
        int m_value;
    };

    namespace AfterReflect
    {
        struct BaseVtable
        {
            HK_DECLARE_CLASS(BaseVtable, New, ReflectVirtualBase);
            HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);
            virtual ~BaseVtable() {}
        };
        struct Interface1
        {
            HK_DECLARE_CLASS(Interface1, New, ReflectVirtualBase);
            HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);
            virtual ~Interface1() {}
            virtual void do1() {}
        };
        struct Interface2
        {
            HK_DECLARE_CLASS(Interface2, New, ReflectVirtualBase);
            HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);
            virtual ~Interface2() {}
            virtual void do2() {}
        };
        struct BaseHas
        {
            HK_DECLARE_CLASS(BaseHas, New, Reflect);
            HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);
            void afterReflectNew() {}
        };

        // Indirect tests don't directly have vtables nor afterReflectNew
        // But have them via fields.

        struct Indirect1
        {
            HK_DECLARE_CLASS(Indirect1, New, Reflect);
            HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);
            BaseHas m_hasFunc_in1;
        };

        struct Indirect2
        {
            HK_DECLARE_CLASS(Indirect2, New, Reflect);
            HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);
            BaseHas m_baseHas_in2;
            Indirect1 m_indirect1_in2;
            BaseVtable m_base_in2;
        };

        struct Indirect3
        {
            HK_DECLARE_CLASS(Indirect3, New, Reflect);
            HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);
            hkUlong m_padding;
            BaseVtable m_base_in3;
        };

        // Test cases which have directly inherited vtable(s)
        // as well as indirect ones

        struct DerivedHas : public Indirect2
        {
            HK_DECLARE_CLASS(DerivedHas, New, Reflect);
            HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);
            void afterReflectNew() {}
            Indirect1 m_indirect1_inDerived;
            BaseVtable m_base_inDerived;
            Indirect3 m_indirect3_inDerived;
        };

        struct Derived2 : public BaseVtable, public Interface1, public Interface2
        {
            HK_DECLARE_CLASS(Derived2, New, Reflect);
            HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);
            double m_foo;
            BaseVtable m_base_inDerived2;
        };

        struct Indirect4
        {
            HK_DECLARE_CLASS(Indirect4, New, Reflect);
            HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);
            Derived2 m_derived2_in4;
        };
    }

    struct Abstract1
    {
        HK_DECLARE_CLASS(Abstract1, New, ReflectVirtualBase);
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);
        virtual void f() = 0;
        virtual ~Abstract1() {}
    };

    template<typename T>
    struct Abstract2
    {
        HK_DECLARE_CLASS(Abstract2, New, Reflect);
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);
        virtual void f() = 0;
        virtual ~Abstract2() {}
    };

    template<typename T>
    struct Abstract3 : public Abstract1
    {
        HK_DECLARE_CLASS(Abstract3, New, Reflect);
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);
    };

    template<typename T>
    struct Abstract4 : public hkReferencedObject, public Abstract2<T>
    {
        HK_DECLARE_CLASS(Abstract4, New, Reflect);
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);
    };

    template<typename T>
    struct NotAbstract : public Abstract3<T>
    {
        HK_DECLARE_CLASS(NotAbstract, New, Reflect);
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);
        virtual void f() {};
    };

    
    struct OldMacro
    {
        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(_, OldMacro);
        HK_DECLARE_REFLECTION();
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);
    };

    template<typename T>
    struct WithTemplateInterface : public hkReferencedObject, public T
    {
        HK_DECLARE_CLASS(WithTemplateInterface, New, Reflect);
    };

    struct AttrsOnSection
    {
        HK_DECLARE_CLASS(AttrsOnSection, New, Reflect, Validate);
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);

        int m_noAttr1;

        public HK_ATTR(hk::AbsMin(42)) :
            int m_absMin1;
            int m_absMin2;

        protected HK_ATTR(hk::Reflect):
            void f() {}

        public:
            int m_noAttr2;

        private HK_ATTR(hk::AbsMin(-42), hk::AbsMax(84)) :
            int m_twoAttrs1;
            int m_twoAttrs2;

        public:
            int m_noAttr3;
    };

    /// A class to test auto conversion of doc comments (those starting with
    /// either /// or ///<), to hk::DocString attributes.
    class AttachDocStringTest
    {
    public:
        HK_DECLARE_CLASS(AttachDocStringTest, New, Reflect);
        HK_RECORD_ATTR(hk::AttachDocString);
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);

        /// Field m_a has preceding documentation,
        ///
        /// That is, it has a documentation block
        /// which comes before the field declaration.
        int m_a;

        int m_b; ///< Field m_b has succeeding documentation,
                 ///<
                 ///< That is, it has a documentation block
                 ///< which comes after the field declaration.

        int m_c;

        /// Attached to nothing at all
#define GETTING_IN_THE_WAY 1
#undef GETTING_IN_THE_WAY
        int m_d;

        ///foo /*what??*/ ///bar
        ///     begin{ ...
        int m_e;
    };

    class DontAttachDocStringTest
    {
    public:
        HK_DECLARE_CLASS(DontAttachDocStringTest, New, Reflect);
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);

        /// Field m_a has preceding documentation,
        ///
        /// That is, it has a documentation block
        /// which comes before the field declaration.
        int m_a;
    };

    struct NeedsValidation
    {
        HK_DECLARE_CLASS(NeedsValidation, Reflect, New, Validate);
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);

        hkResult validateContract() const { s_validations++; return (m_value != 0) ? HK_SUCCESS : HK_FAILURE; }
        int m_value HK_ATTR(hk::AbsMax(10));

        static int s_validations;
    };

    struct AlsoNeedsValidation
    {
        HK_DECLARE_CLASS(AlsoNeedsValidation, Reflect, New, Validate);
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);
        NeedsValidation m_needsValidation;
        int m_dontCareAboutTheValueOfThis;
    };

    template<int N>
    struct FixedString
    {
        HK_DECLARE_CLASS(FixedString, New, Reflect);
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);
        char m_buf;// [N]; // MSFT:9656246
    };

    class SameTypeDefaultConstRefArgsWithDifferentValues
    {
    public:
        HK_DECLARE_CLASS(SameTypeDefaultConstRefArgsWithDifferentValues, New, Reflect, ReflectDetails(methods = true));
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);

        static hkTuple<int, int> func(
            const hkTuple<int>& a = hkTupleT::make(123),
            const hkTuple<int>& b = hkTupleT::make(456) )
        {
            return hkTupleT::make(a.m_0, b.m_0);
        }
    };

    template<typename T>
    class DefaultArgsWithDependentType
    {
    public:
        HK_DECLARE_CLASS(DefaultArgsWithDependentType, New, Reflect, ReflectDetails(methods = true));
        HK_RECORD_ATTR(hk::IgnoreTemplateParams(T), hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);

        static T func(T arg = 123)
        {
            return arg;
        }
    };

    struct StructWithMultipleConstructorParamsAsDefaultParameter_Helper
    {
        HK_DECLARE_CLASS(StructWithMultipleConstructorParamsAsDefaultParameter_Helper, New, Reflect);
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);
        StructWithMultipleConstructorParamsAsDefaultParameter_Helper() {}
        StructWithMultipleConstructorParamsAsDefaultParameter_Helper(int _a, int _b) : a(_a), b(_b) {}
        int a;
        int b;
    };

    class StructWithMultipleConstructorParamsAsDefaultParameter
    {
    public:
        HK_DECLARE_CLASS(StructWithMultipleConstructorParamsAsDefaultParameter, New, Reflect, ReflectDetails(methods = true));
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);
        static void func(const StructWithMultipleConstructorParamsAsDefaultParameter_Helper & arg = StructWithMultipleConstructorParamsAsDefaultParameter_Helper(123, 456) ) {}
    };
}

HK_REFLECT_ENUM(HK_EXPORT_COMMON, UnitTestClang::ReflectedEnum);
HK_REFLECT_ENUM(HK_EXPORT_COMMON, UnitTestClang::ForwardDeclaredEnum);
HK_REFLECT_ENUM(HK_EXPORT_COMMON, UnitTestClang::EnumClassImplicit);
HK_REFLECT_ENUM(HK_EXPORT_COMMON, UnitTestClang::EnumClassExplicit);
HK_REFLECT_ENUM(HK_EXPORT_COMMON, UnitTestClang::NonReflected::Enum);
HK_REFLECT_ENUM(HK_EXPORT_COMMON, UnitTestClang::TestEnumTypedefs::Count);
HK_REFLECT_ENUM(HK_EXPORT_COMMON, UnitTestClang::TestDefaultTypes::EnumValue1);

HK_REFLECT_TYPEDEF(HK_ATTR(hk::ManualTypeRegistration) HK_EXPORT_COMMON, UnitTestClang::ReflectedTypedef, UnitTestClang_ReflectedTypedef);
HK_REFLECT_TYPEDEF(HK_ATTR(hk::ManualTypeRegistration) HK_EXPORT_COMMON, UnitTestClang::TdefWithDependent, UnitTestClang_TdefWithDependent);
HK_REFLECT_TYPEDEF(HK_ATTR(hk::ManualTypeRegistration) HK_EXPORT_COMMON, UnitTestClang::hkInt32_2, UnitTestClang_hkInt32_2);
HK_REFLECT_TYPEDEF(HK_ATTR(hk::ManualTypeRegistration) HK_EXPORT_COMMON, UnitTestClang::TdefWithDependent_2, UnitTestClang_TdefWithDependent_2);
HK_REFLECT_TYPEDEF(HK_ATTR(hk::ManualTypeRegistration) HK_EXPORT_COMMON, UnitTestClang::IntArray, UnitTestClang_IntArray);

HK_REFLECT_TYPEDEF(HK_ATTR(hk::ManualTypeRegistration) HK_EXPORT_COMMON, UnitTestClang::TestEnumTypedefs::Real10, UnitTestClang_TestEnumTypedefs_Real10);
HK_REFLECT_TYPEDEF(HK_ATTR(hk::ManualTypeRegistration) HK_EXPORT_COMMON, UnitTestClang::NonReflected::Typedef, UnitTestClang_NonReflected_Typedef);
#include <Common/Base/_Auto/TemplateTypes/ClangTest_Types.inl>

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
