// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Base/hkBase.h>
#include <Common/Base/Reflect/hkReflect.h>
#include <Common/Base/UnitTest/hkUnitTest.h>
#include <Common/Base/UnitTest/Reflection/ClangTest.h>
#include <Common/Base/Reflect/Attributes/hkToolAttributes.h>
#include <Common/Base/Reflect/Core/Detail/hkReflectTypeDetail.h>
#if defined(HK_BUILDING_WITH_ENGINE)
#include <Common/NewBase/Reflection/FunctionReflection/hkReturnVariant.h> 
#endif

// For the validation functions
#define HK_DETAIL_REFLECT_DEFINITIONS
#include <Common/Base/_Auto/Types/ClangTest_Types.cxx>
#undef HK_DETAIL_REFLECT_DEFINITIONS

HK_MANUALLY_REGISTER_TYPE(UnitTestClang::ReflectedEnum, UnitTestClang_ReflectedEnum);
HK_MANUALLY_REGISTER_TYPE(UnitTestClang::ForwardDeclaredEnum, UnitTestClang_ForwardDeclaredEnum);
HK_MANUALLY_REGISTER_TYPE(UnitTestClang::EnumClassImplicit, UnitTestClang_EnumClassImplicit);
HK_MANUALLY_REGISTER_TYPE(UnitTestClang::EnumClassExplicit, UnitTestClang_EnumClassExplicit);
HK_MANUALLY_REGISTER_TYPE(UnitTestClang::TestDependentType, UnitTestClang_TestDependentType);
HK_MANUALLY_REGISTER_TYPE(UnitTestClang::TestTypedef, UnitTestClang_TestTypedef);
HK_MANUALLY_REGISTER_TYPE(UnitTestClang::TestDefaultTypes, UnitTestClang_TestDefaultTypes);
HK_MANUALLY_REGISTER_TYPE(UnitTestClang::TestRecordPresets, UnitTestClang_TestRecordPresets);
HK_MANUALLY_REGISTER_TYPE(UnitTestClang::ArrayAttrDef, UnitTestClang_ArrayAttrDef);
HK_MANUALLY_REGISTER_TYPE(UnitTestClang::ArrayAttrEmptyDef, UnitTestClang_ArrayAttrEmptyDef);
HK_MANUALLY_REGISTER_TYPE(UnitTestClang::TestArrayAttr, UnitTestClang_TestArrayAttr);
HK_MANUALLY_REGISTER_TYPE(UnitTestClang::TestArrayAttrDefaults, UnitTestClang_TestArrayAttrDefaults);
HK_MANUALLY_REGISTER_TYPE(UnitTestClang::TestEnumTypedefs, UnitTestClang_TestEnumTypedefs);
HK_MANUALLY_REGISTER_TYPE(UnitTestClang::TestMethods, UnitTestClang_TestMethods);
HK_MANUALLY_REGISTER_TYPE(UnitTestClang::Aligned_Class_Base, UnitTestClang_Aligned_Class_Base);
HK_MANUALLY_REGISTER_TYPE(UnitTestClang::Aligned_Class, UnitTestClang_Aligned_Class);
HK_MANUALLY_REGISTER_TYPE(UnitTestClang::Mixed_Class_Base, UnitTestClang_Mixed_Class_Base);
HK_MANUALLY_REGISTER_TYPE(UnitTestClang::Mixed_Class, UnitTestClang_Mixed_Class);
HK_MANUALLY_REGISTER_TYPE(UnitTestClang::Mixed_Class2, UnitTestClang_Mixed_Class2);
HK_MANUALLY_REGISTER_TYPE(UnitTestClang::Aligned_Field_Base, UnitTestClang_Aligned_Field_Base);
HK_MANUALLY_REGISTER_TYPE(UnitTestClang::Aligned_Field, UnitTestClang_Aligned_Field);
HK_MANUALLY_REGISTER_TYPE(UnitTestClang::PrivateCtor, UnitTestClang_PrivateCtor);
HK_MANUALLY_REGISTER_TYPE(UnitTestClang::CastAttr, UnitTestClang_CastAttr);
HK_MANUALLY_REGISTER_TYPE(UnitTestClang::ArrayAttr, UnitTestClang_ArrayAttr);
HK_MANUALLY_REGISTER_TYPE(UnitTestClang::TestCastAttr, UnitTestClang_TestCastAttr);
HK_MANUALLY_REGISTER_TYPE(UnitTestClang::TestAccessAttribute, UnitTestClang_TestAccessAttribute);
HK_MANUALLY_REGISTER_TYPE(UnitTestClang::AttrAccess, UnitTestClang_AttrAccess);
HK_MANUALLY_REGISTER_TYPE(UnitTestClang::AfterReflect::BaseVtable, UnitTestClang_AfterReflect_BaseVtable);
HK_MANUALLY_REGISTER_TYPE(UnitTestClang::AfterReflect::Interface1, UnitTestClang_AfterReflect_Interface1);
HK_MANUALLY_REGISTER_TYPE(UnitTestClang::AfterReflect::Interface2, UnitTestClang_AfterReflect_Interface2);
HK_MANUALLY_REGISTER_TYPE(UnitTestClang::AfterReflect::BaseHas, UnitTestClang_AfterReflect_BaseHas);
HK_MANUALLY_REGISTER_TYPE(UnitTestClang::AfterReflect::Indirect1, UnitTestClang_AfterReflect_Indirect1);
HK_MANUALLY_REGISTER_TYPE(UnitTestClang::AfterReflect::Indirect2, UnitTestClang_AfterReflect_Indirect2);
HK_MANUALLY_REGISTER_TYPE(UnitTestClang::AfterReflect::Indirect3, UnitTestClang_AfterReflect_Indirect3);
HK_MANUALLY_REGISTER_TYPE(UnitTestClang::AfterReflect::DerivedHas, UnitTestClang_AfterReflect_DerivedHas);
HK_MANUALLY_REGISTER_TYPE(UnitTestClang::AfterReflect::Derived2, UnitTestClang_AfterReflect_Derived2);
HK_MANUALLY_REGISTER_TYPE(UnitTestClang::AfterReflect::Indirect4, UnitTestClang_AfterReflect_Indirect4);
HK_MANUALLY_REGISTER_TYPE(UnitTestClang::Abstract1, UnitTestClang_Abstract1);
HK_MANUALLY_REGISTER_TYPE(UnitTestClang::OldMacro, UnitTestClang_OldMacro);
HK_MANUALLY_REGISTER_TYPE(UnitTestClang::AttrsOnSection, UnitTestClang_AttrsOnSection);
HK_MANUALLY_REGISTER_TYPE(UnitTestClang::AttachDocStringTest, UnitTestClang_AttachDocStringTest);
HK_MANUALLY_REGISTER_TYPE(UnitTestClang::DontAttachDocStringTest, UnitTestClang_DontAttachDocStringTest);
HK_MANUALLY_REGISTER_TYPE(UnitTestClang::NeedsValidation, UnitTestClang_NeedsValidation);
HK_MANUALLY_REGISTER_TYPE(UnitTestClang::AlsoNeedsValidation, UnitTestClang_AlsoNeedsValidation);
HK_MANUALLY_REGISTER_TYPE(UnitTestClang::SameTypeDefaultConstRefArgsWithDifferentValues, UnitTestClang_SameTypeDefaultConstRefArgsWithDifferentValues);
HK_MANUALLY_REGISTER_TYPE(UnitTestClang::StructWithMultipleConstructorParamsAsDefaultParameter_Helper, UnitTestClang_StructWithMultipleConstructorParamsAsDefaultParameter_Helper);
HK_MANUALLY_REGISTER_TYPE(UnitTestClang::StructWithMultipleConstructorParamsAsDefaultParameter, UnitTestClang_StructWithMultipleConstructorParamsAsDefaultParameter);

HK_MANUALLY_REGISTER_TYPE(hkReflect::Typedef::UnitTestClang_ReflectedTypedef, UnitTestClang_ReflectedTypedef);
HK_MANUALLY_REGISTER_TYPE(hkReflect::Typedef::UnitTestClang_TdefWithDependent, UnitTestClang_TdefWithDependent);
HK_MANUALLY_REGISTER_TYPE(hkReflect::Typedef::UnitTestClang_hkInt32_2, UnitTestClang_hkInt32_2);
HK_MANUALLY_REGISTER_TYPE(hkReflect::Typedef::UnitTestClang_TdefWithDependent_2, UnitTestClang_TdefWithDependent_2);
HK_MANUALLY_REGISTER_TYPE(hkReflect::Typedef::UnitTestClang_IntArray, UnitTestClang_IntArray);

HK_MANUALLY_REGISTER_TYPE(hkReflect::Typedef::UnitTestClang_TestEnumTypedefs_Real10, UnitTestClang_TestEnumTypedefs_Real10);
HK_MANUALLY_REGISTER_TYPE(hkReflect::Typedef::UnitTestClang_NonReflected_Typedef, UnitTestClang_NonReflected_Typedef);

HK_COMPILE_TIME_ASSERT(hkReflect::IsReflected<int>::result);
HK_COMPILE_TIME_ASSERT(hkReflect::IsReflected<void>::result);
HK_COMPILE_TIME_ASSERT(hkReflect::IsReflected<hkReferencedObject>::result);
HK_COMPILE_TIME_ASSERT(hkReflect::IsReflected<int[10]>::result);
HK_COMPILE_TIME_ASSERT(hkReflect::IsReflected<hkReferencedObject*>::result);
HK_COMPILE_TIME_ASSERT(hkReflect::IsReflected<const hkReferencedObject*>::result);
HK_COMPILE_TIME_ASSERT(hkReflect::IsReflected<hkReferencedObject* const>::result);
HK_COMPILE_TIME_ASSERT(hkReflect::IsReflected< hkArray<char> >::result);

HK_COMPILE_TIME_ASSERT((int)hkReflect::Detail::ReflectedKindOf<void>::value == (int)hkReflect::KIND_VOID);
HK_COMPILE_TIME_ASSERT((int)hkReflect::Detail::ReflectedKindOf<int>::value == (int)hkReflect::KIND_INT);
HK_COMPILE_TIME_ASSERT((int)hkReflect::Detail::ReflectedKindOf<int*>::value == (int)hkReflect::KIND_POINTER);
HK_COMPILE_TIME_ASSERT((int)hkReflect::Detail::ReflectedKindOf<const int*>::value == (int)hkReflect::KIND_POINTER);
HK_COMPILE_TIME_ASSERT((int)hkReflect::Detail::ReflectedKindOf<const char*>::value == (int)hkReflect::KIND_STRING);
HK_COMPILE_TIME_ASSERT((int)hkReflect::Detail::ReflectedKindOf<hkBaseObject>::value == (int)hkReflect::KIND_RECORD);
HK_COMPILE_TIME_ASSERT((int)hkReflect::Detail::ReflectedKindOf<hkBaseObject[2]>::value == (int)hkReflect::KIND_ARRAY);
HK_COMPILE_TIME_ASSERT((int)hkReflect::Detail::ReflectedKindOf< hkArray<char> >::value == (int)hkReflect::KIND_ARRAY);
HK_COMPILE_TIME_ASSERT((int)hkReflect::Detail::ReflectedKindOf< hkSimdReal >::value == (int)hkReflect::KIND_FLOAT);
HK_COMPILE_TIME_ASSERT((int)hkReflect::Detail::ReflectedKindOf< hkEnum<UnitTestClang::ReflectedEnum, int> >::value == (int)hkReflect::KIND_INT);
HK_COMPILE_TIME_ASSERT((int)hkReflect::Detail::ReflectedKindOf< UnitTestClang::ForwardDeclaredEnum >::value == (int)hkReflect::KIND_INT);
HK_COMPILE_TIME_ASSERT((int)hkReflect::Detail::ReflectedKindOf< UnitTestClang::EnumClassImplicit >::value == (int)hkReflect::KIND_INT);
HK_COMPILE_TIME_ASSERT((int)hkReflect::Detail::ReflectedKindOf< UnitTestClang::EnumClassExplicit >::value == (int)hkReflect::KIND_INT);

HK_COMPILE_TIME_ASSERT( hkTrait::TypesAreEqual< HK_REFLECT_RESOLVE( hkReflect::Typedef::hkInt32_Tag ), hkInt32 >::result );
HK_COMPILE_TIME_ASSERT( hkTrait::TypesAreEqual< HK_REFLECT_RESOLVE( hkReflect::Typedef::hkInt32_Tag* ), hkInt32* >::result );
HK_COMPILE_TIME_ASSERT( hkTrait::TypesAreEqual< HK_REFLECT_RESOLVE( hkReflect::Typedef::hkInt32_Tag[2] ), hkInt32[2] >::result );
HK_COMPILE_TIME_ASSERT( hkTrait::TypesAreEqual< HK_REFLECT_RESOLVE( hkArray<hkReflect::Typedef::hkInt32_Tag> ), hkArray<hkInt32> >::result );
HK_COMPILE_TIME_ASSERT( hkTrait::TypesAreEqual< HK_REFLECT_RESOLVE( hkEnum<UnitTestClang::ReflectedEnum, hkReflect::Typedef::hkInt32_Tag> ), hkEnum<UnitTestClang::ReflectedEnum, hkInt32> >::result );
HK_COMPILE_TIME_ASSERT(hkTrait::TypesAreEqual< HK_REFLECT_RESOLVE( UnitTestClang::ForwardDeclaredEnum ), UnitTestClang::ForwardDeclaredEnum >::result);
HK_COMPILE_TIME_ASSERT(hkTrait::TypesAreEqual< HK_REFLECT_RESOLVE(UnitTestClang::EnumClassImplicit), UnitTestClang::EnumClassImplicit >::result);
HK_COMPILE_TIME_ASSERT(hkTrait::TypesAreEqual< HK_REFLECT_RESOLVE(UnitTestClang::EnumClassExplicit), UnitTestClang::EnumClassExplicit >::result);

namespace
{
    struct NonReflected {};
    struct NonReflected2 : public hkReferencedObject {};
    struct NonReflected3 : public hkReferencedObject { HK_DECLARE_CLASS(NonReflected3, NoReflect); };
    struct NonReflected4 : public UnitTestClang::OldMacro { HK_DECLARE_CLASS(NonReflected4, NoReflect2(UnitTestClang::OldMacro)) };
    template<typename T, typename A> struct NonReflected5 : public hkArray<T, A> {};
    template<typename T, typename A> struct NonReflected6 : public hkArray<T, A> { HK_DECLARE_CLASS(NonReflected6, NoReflect); };
    template<typename T, typename A> struct NonReflected7 : public hkArray<T, A> { HK_DECLARE_CLASS(NonReflected7, NoReflect2(hkArray<T, A>)); };
}
// Non-reflected specialization of reflected template with reflected arguments.
template<>
class hkArray<UnitTestClang::TestTypedef, UnitTestClang::TestTypedef> {};

HK_COMPILE_TIME_ASSERT(!hkReflect::IsReflected<NonReflected>::result);
HK_COMPILE_TIME_ASSERT(!hkReflect::IsReflected<NonReflected*>::result);
HK_COMPILE_TIME_ASSERT(!hkReflect::IsReflected<NonReflected* const>::result);
HK_COMPILE_TIME_ASSERT(!hkReflect::IsReflected<const NonReflected[10]>::result);
HK_COMPILE_TIME_ASSERT(!hkReflect::IsReflected< hkArray<NonReflected> >::result);
HK_COMPILE_TIME_ASSERT(!hkReflect::IsReflected< hkArray<UnitTestClang::TestTypedef, UnitTestClang::TestTypedef> >::result);

HK_COMPILE_TIME_ASSERT(!hkReflect::IsReflected<NonReflected2>::result);
HK_COMPILE_TIME_ASSERT(!hkReflect::IsReflected<NonReflected3>::result);
HK_COMPILE_TIME_ASSERT(!hkReflect::IsReflected<NonReflected4>::result);
HK_COMPILE_TIME_ASSERT(!hkReflect::IsReflected< NonReflected5<int, hkContainerHeapAllocator> >::result);
HK_COMPILE_TIME_ASSERT(!hkReflect::IsReflected< NonReflected6<int, hkContainerHeapAllocator> >::result);
HK_COMPILE_TIME_ASSERT(!hkReflect::IsReflected< NonReflected7<int, hkContainerHeapAllocator> >::result);

HK_COMPILE_TIME_ASSERT(!hkReflect::IsReflected< hkReflect::Detail::MarkAsOpaque<NonReflected> >::result);
HK_COMPILE_TIME_ASSERT(hkReflect::IsReflected< hkReflect::Detail::MarkAsOpaque<NonReflected*> >::result);
HK_COMPILE_TIME_ASSERT(hkReflect::IsReflected< hkReflect::Detail::MarkAsOpaque<const NonReflected* const> >::result);
HK_COMPILE_TIME_ASSERT(hkReflect::IsReflected< hkReflect::Detail::MarkAsOpaque< hkArray<NonReflected> > >::result);

HK_COMPILE_TIME_ASSERT(HK_ALIGN_OF(hkReflect::Detail::AggregateOf<hkVector4f>::Type) == HK_FLOAT_ALIGNMENT);
HK_COMPILE_TIME_ASSERT(HK_ALIGN_OF(hkReflect::Detail::AggregateOf<hkVector4d>::Type) == HK_DOUBLE_ALIGNMENT);
HK_COMPILE_TIME_ASSERT(HK_ALIGN_OF(hkReflect::Detail::AggregateOf<hkQuaternionf>::Type) == HK_FLOAT_ALIGNMENT);
HK_COMPILE_TIME_ASSERT(HK_ALIGN_OF(hkReflect::Detail::AggregateOf<hkQuaterniond>::Type) == HK_DOUBLE_ALIGNMENT);
HK_COMPILE_TIME_ASSERT(HK_ALIGN_OF(hkReflect::Detail::AggregateOf<hkMatrix3f>::Type) == HK_FLOAT_ALIGNMENT);
HK_COMPILE_TIME_ASSERT(HK_ALIGN_OF(hkReflect::Detail::AggregateOf<hkMatrix3d>::Type) == HK_DOUBLE_ALIGNMENT);
HK_COMPILE_TIME_ASSERT(HK_ALIGN_OF(hkReflect::Detail::AggregateOf<hkMatrix4f>::Type) == HK_FLOAT_ALIGNMENT);
HK_COMPILE_TIME_ASSERT(HK_ALIGN_OF(hkReflect::Detail::AggregateOf<hkMatrix4d>::Type) == HK_DOUBLE_ALIGNMENT);
HK_COMPILE_TIME_ASSERT(HK_ALIGN_OF(hkReflect::Detail::AggregateOf<hkTransformf>::Type) == HK_FLOAT_ALIGNMENT);
HK_COMPILE_TIME_ASSERT(HK_ALIGN_OF(hkReflect::Detail::AggregateOf<hkTransformd>::Type) == HK_DOUBLE_ALIGNMENT);
HK_COMPILE_TIME_ASSERT(HK_ALIGN_OF(hkReflect::Detail::AggregateOf<hkQsTransformf>::Type) == HK_FLOAT_ALIGNMENT);
HK_COMPILE_TIME_ASSERT(HK_ALIGN_OF(hkReflect::Detail::AggregateOf<hkQsTransformd>::Type) == HK_DOUBLE_ALIGNMENT);
HK_COMPILE_TIME_ASSERT(HK_ALIGN_OF(hkReflect::Detail::AggregateOf<hkRotationf>::Type) == HK_FLOAT_ALIGNMENT);
HK_COMPILE_TIME_ASSERT(HK_ALIGN_OF(hkReflect::Detail::AggregateOf<hkRotationd>::Type) == HK_DOUBLE_ALIGNMENT);
HK_COMPILE_TIME_ASSERT(HK_ALIGN_OF(hkReflect::Detail::AggregateOf<hkQTransformf>::Type) == HK_FLOAT_ALIGNMENT);
HK_COMPILE_TIME_ASSERT(HK_ALIGN_OF(hkReflect::Detail::AggregateOf<hkQTransformd>::Type) == HK_DOUBLE_ALIGNMENT);

template<typename T>
static const hkReflect::NamedCallable* findFunctionFromTypeByUniqueName(const char * name, const hkReflect::CallableTypes callableType)
{
    const hkReflect::NamedCallable* result = nullptr;

    const hkReflect::Type* testType = hkReflect::getType<T>();
    HK_TEST(testType);

    hkReflect::CallableIterator it(testType, callableType);
    while (it.advance())
    {
        if (hkString::strCmp(it.current()->getName(), name) == 0)
        {
            HK_TEST(!result); // has to be unique
            result = it.current();
        }
    }

    return result;
}

template <typename T, int I>
static bool testTemplateArgs(const hkReflect::Type* type)
{
    const hkReflect::Template* tmplate = type->getTemplate();
    if(!tmplate) { return false; }
    bool foundValue = false;
    hkUlong valueParam = 0;
    const hkReflect::Type* typeParam = HK_NULL;
    for(int i = 0; i < tmplate->getNumParams(); ++i)
    {
        const hkReflect::Template::Parameter* p = tmplate->getParam(i);
        if(p->isValue())
        {
            if(foundValue) return false;
            foundValue = true;
            valueParam = p->getAsValue();
        }
        else if(p->isType())
        {
            if(typeParam) return false;
            typeParam = p->getAsType();
        }
        else
        {
            HK_ASSERT_NO_MSG(0x59981fe5, 0);
        }
    }
    if (typeParam==HK_NULL) { return false; }
    if (!typeParam->extendsOrEquals<T>()) { return false; }
    if (foundValue==false) { return false; }
    if (valueParam != I) { return false; }
    return true;
}

static void testIntPtrImpl(const hkReflect::PointerType* type)
{
    if (!HK_TEST(type != HK_NULL)) { return; }
    int val = 42;
    hkReflect::PointerVar ptr = type->newInstance();
    ptr.setValue(hkReflect::Var(&val));
    HK_TEST(val == 42);
    ptr.setValue(hkReflect::Var());
    HK_TEST(val == 42);
    ptr.destroy();
    HK_TEST(val == 42);
}

static void testRefPtrImpl(const hkReflect::PointerType* type, int afterSet)
{
    hkGeometry geom;
    hkReflect::PointerVar ptr = type->newInstance();
    ptr.setValue(hkReflect::Var(&geom));
    HK_TEST(geom.getReferenceCount() == afterSet);
    ptr.setValue(hkReflect::Var());
    HK_TEST(geom.getReferenceCount() == 1);
    ptr.setValue(hkReflect::Var(&geom));
    HK_TEST(geom.getReferenceCount() == afterSet);
    ptr.destroy();
    HK_TEST(geom.getReferenceCount() == 1);

}

template <typename T>
static void getFieldAndParamTypes(const hkReflect::PointerType*& fieldTypeOut, const hkReflect::PointerType*& paramTypeOut)
{
    fieldTypeOut = HK_NULL;
    paramTypeOut = HK_NULL;

    const hkReflect::RecordType* rec = hkReflect::getType< UnitTestClang::WithPtr<T> >()->asRecord();
    if (!HK_TEST(rec != HK_NULL)) { return; }
    const hkReflect::FieldDecl field = rec->findField("rawPtr", false);
    if (!HK_TEST(field != HK_NULL)) { return; }
    fieldTypeOut = field.getType()->asPointer();

    hkReflect::CallableIterator it(rec, hkReflect::CALLABLE_METHODS);
    if (!HK_TEST(it.advance())) { return; }
    const hkReflect::NamedCallable* method = it.current();
    HK_TEST(hkString::strCmp(method->getName(), "method") == 0);
    if (!HK_TEST(method->getNumParams() == 1)) { return; }
    paramTypeOut = method->getParamType(0)->asPointer();
}

#define TEST_TYPE_NAME_EQUALS(TYPE, NAME) HK_TEST_EQ(hkStringView(TYPE->getName()), hkStringView(NAME));

static int ClangTest()
{
    // Test that math typedefs are correct
    {
#define TEST_TYPE(A, B) \
    HK_TEST(hkReflect::getType<hkReflect::Typedef::A ## _Tag>() != hkReflect::getType<B>()); \
    HK_TEST(hkReflect::getType<hkReflect::Typedef::A ## _Tag>()->equals<B>())

        TEST_TYPE( hkInt8, signed char );
        TEST_TYPE( hkUint8, unsigned char );

#ifdef HK_REAL_IS_DOUBLE
        TEST_TYPE(hkReal, double);
        TEST_TYPE(hkSimdReal, hkSimdDouble64);
#define TEST_TYPE2(A) TEST_TYPE(A, A ## d)
#else
        TEST_TYPE(hkReal, float);
        TEST_TYPE(hkSimdReal, hkSimdFloat32);
#define TEST_TYPE2(A) TEST_TYPE(A, A ## f)
#endif
        TEST_TYPE2(hkVector4);
        TEST_TYPE2(hkQuaternion);
        TEST_TYPE2(hkMatrix4);
        TEST_TYPE2(hkTransform);
        TEST_TYPE2(hkQsTransform);
        TEST_TYPE2(hkMatrix3);
        TEST_TYPE2(hkRotation);
#undef TEST_TYPE
#undef TEST_TYPE2
    }

    // Test templates with typedefs.
    {
#define TEST_TYPE(A, B) \
    HK_TEST(hkReflect::getType<A>() != hkReflect::getType<B>()); \
    HK_TEST(hkReflect::getType<A>()->equals<B>())
#define TAG(T) hkReflect::Typedef:: T ## _Tag

        TEST_TYPE( hkArray<TAG(hkInt32)>, hkArray<int> );
        TEST_TYPE( TAG( hkInt64 )*, long long* );

        {
            typedef hkEnum<UnitTestClang::ReflectedEnum, TAG( hkUint32 )> Test;
            typedef hkEnum<UnitTestClang::ReflectedEnum, hkUint32> Undecorated;
            TEST_TYPE( Test, Undecorated );
        }

        {
            typedef UnitTestClang::TypedefArg<hkArray<TAG( hkInt32 )>, UnitTestClang::TestDependentType, TAG( hkReal )> TestA;
            typedef UnitTestClang::TypedefArg<hkArray<TAG( hkInt32 )>, UnitTestClang::TestDependentType, hkReal> TestB;
            typedef UnitTestClang::TypedefArg<hkArray<hkInt32>, UnitTestClang::TestDependentType, TAG( hkReal )> TestC;
            typedef UnitTestClang::TypedefArg<hkArray<hkInt32>, UnitTestClang::TestDependentType, hkReal> Raw;
            TEST_TYPE( TestA, Raw );
            TEST_TYPE( TestB, Raw );
            TEST_TYPE( TestC, Raw );
            HK_TEST( hkReflect::getType<TestA>() != hkReflect::getType<TestB>() );
            HK_TEST( hkReflect::getType<TestA>() != hkReflect::getType<TestC>() );
            HK_TEST( hkReflect::getType<TestB>() != hkReflect::getType<TestC>() );
        }

#undef TEST_TYPE
#undef TAG
    }

    do
    {
        {
            const hkReflect::PointerType* fieldType;
            const hkReflect::PointerType* paramType;
            getFieldAndParamTypes<int>(fieldType, paramType);
            // these should be exactly the same type as 'int*'
            HK_TEST(fieldType->equals<int*>());
            HK_TEST(paramType->equals<int*>());
            testIntPtrImpl(fieldType);
            testIntPtrImpl(paramType);
        }
        {
            const hkReflect::PointerType* fieldType;
            const hkReflect::PointerType* paramType;
            getFieldAndParamTypes<hkGeometry>(fieldType, paramType);
            // field ptr will add a reference
            testRefPtrImpl(fieldType, 2);
            // param ptr will not
            testRefPtrImpl(paramType, 1);
        }
        {
            const hkReflect::PointerType* fieldType;
            const hkReflect::PointerType* paramType;
            getFieldAndParamTypes<const hkGeometry>(fieldType, paramType);
            // field ptr will add a reference
            testRefPtrImpl(fieldType, 2);
            // param ptr will not
            testRefPtrImpl(paramType, 1);
        }
    }
    while (false);

    do
    {
        const hkReflect::IntType* tdefType = hkReflect::typeFromName("UnitTestClang::ReflectedTypedef")->asInteger();
        if(!HK_TEST(tdefType != HK_NULL)) { break; }

        const hk::AbsMax* attr = hkReflect::TypeDetail::localFindAttribute<hk::AbsMax>(tdefType);
        if(!HK_TEST(attr != HK_NULL)) { break; }
        int* maxVal = attr->get(tdefType).dynCast<int>();
        if(!HK_TEST(maxVal != HK_NULL)) { break; }
        HK_TEST(*maxVal == 42);

        hkReflect::IntVar value = tdefType->newInstance();
        if(!HK_TEST(value != HK_NULL)) { break; }
        value.writeDefault();
        HK_TEST(value.getValue() == 21);
        value.destroy();

        const hkReflect::RecordType* recType = hkReflect::getType<UnitTestClang::TestTypedef>()->asRecord();
        if(!HK_TEST(recType != HK_NULL)) { break; }

        const hkReflect::PointerType* ptrField = recType->findField("ptr", false).getType()->asPointer();
        if(!HK_TEST(ptrField != HK_NULL)) { break; }
        HK_TEST(ptrField->getSubType().get() == tdefType);

        const hkReflect::ArrayType* arrayField = recType->findField("array", false).getType()->asArray();
        if(!HK_TEST(arrayField != HK_NULL)) { break; }
        HK_TEST(arrayField->getSubType().get() == tdefType);

        const hkReflect::ArrayType* ptrArrayField = recType->findField("ptrArray", false).getType()->asArray();
        if(!HK_TEST(ptrArrayField != HK_NULL)) { break; }
        HK_TEST(ptrArrayField->getSubType()->asPointer()->getSubType().get() == tdefType);

        const hkReflect::ArrayType* hkArrayField = recType->findField("hkArray", false).getType()->asArray();
        if(!HK_TEST(hkArrayField != HK_NULL)) { break; }
        HK_TEST(hkArrayField->getSubType().get() == tdefType);

        const hkReflect::Type* doubleTdefType = recType->findField("doubleTdef", false).getType()->getParent();
        TEST_TYPE_NAME_EQUALS(doubleTdefType, "UnitTestClang::hkInt32_2");
        TEST_TYPE_NAME_EQUALS(doubleTdefType->getParent(), "hkInt32");
        TEST_TYPE_NAME_EQUALS(doubleTdefType->getParent()->getParent(), "int");

        //const hkReflect::Type* t0Type = recType->findField("t0", false).getType();
        const hkReflect::Type* t1Type = recType->findField("t1", false).getType();
        const hkReflect::Type* t2Type = recType->findField("t2", false).getType();

        const hkReflect::Type* hkArrayInt32Type = t1Type->getTemplate()->getParam(0)->getAsType();
        TEST_TYPE_NAME_EQUALS(hkArrayInt32Type->getTemplate()->getParam(0)->getAsType(), "UnitTestClang::hkInt32_2");
        const hkReflect::Type* tdefWithDependentType = t1Type->getTemplate()->getParam(1)->getAsType();
        TEST_TYPE_NAME_EQUALS(tdefWithDependentType, "UnitTestClang::TdefWithDependent");

        const hkReflect::Type* intArrayType = t2Type->getTemplate()->getParam(0)->getAsType();
        TEST_TYPE_NAME_EQUALS(intArrayType, "UnitTestClang::IntArray");
        TEST_TYPE_NAME_EQUALS(intArrayType->getParent()->getTemplate()->getParam(0)->getAsType(), "hkInt32");
        const hkReflect::Type* tdefWithDependent2Type = t2Type->getTemplate()->getParam(1)->getAsType();
        TEST_TYPE_NAME_EQUALS(tdefWithDependent2Type, "UnitTestClang::TdefWithDependent_2");

    } while (false);


    UnitTestClang::TestDefaultTypes obj;

    const hkReflect::RecordType* rec = hkReflect::getType<UnitTestClang::TestDefaultTypes>()->asRecord();
    HK_TEST_EQ(rec->getVersion(), 1);
    do
    {
        const hkReflect::FieldDecl intField = rec->findField("intVal", false);
        if(!HK_TEST(intField != HK_NULL)) { break; }
        const hkReflect::Type* fieldType = intField.getType();
        if(!HK_TEST(fieldType != HK_NULL)) { break; }

        const hk::Ui_FieldName* attr = hkReflect::TypeDetail::localFindAttribute<hk::Ui_FieldName>(intField.getType());
        if (!HK_TEST(attr)) { break; }
        HK_TEST(hkString::strCmp(attr->m_value, "SomeIntVal") == 0);

        const hk::AbsMax* autoAttr = hkReflect::TypeDetail::localFindAttribute<hk::AbsMax>(intField.getType());
        if (!HK_TEST(autoAttr)) { break; }
        HK_TEST(*autoAttr->get<int>() == 1);
        HK_TEST(hkReflect::IntVar(autoAttr->get(intField.getType())).getValue() == 1);

        const hkReflect::IntType* intFieldTyped = fieldType->asInteger();
        if(!HK_TEST(intFieldTyped != HK_NULL)) { break; }
        hkReflect::IntVar hInt(&obj, intFieldTyped);
        hkReflect::IntValue val = hInt.getValue();
        HK_TEST( val.absValue() == 10 );
        HK_TEST( val.isNegative() == false );
        hInt.setValue(-33);
        HK_TEST( hInt.getValue().absValue() == 33 );
        HK_TEST( hInt.getValue().isNegative() );
    } while(false);

    do
    {
        const hkReflect::FieldDecl radField = rec->findField("radius", false);
        if(!HK_TEST(radField != HK_NULL)) { break; }
        const hkReflect::Type* fieldType = radField.getType();
        if(!HK_TEST(fieldType != HK_NULL)) { break; }
        const hkReflect::FloatType* radFieldTyped = fieldType->asFloat();
        if(!HK_TEST(radFieldTyped != HK_NULL)) { break; }
        hkReflect::FloatVar hRadius(&obj, radFieldTyped);
        hkReflect::FloatValue val = hRadius.getValue();

        HK_TEST_EQ(hkFloat32(val), 5.0f);
        hRadius.setValue(123.456f);
        HK_TEST_EQ(hkFloat32(hRadius.getValue()), 123.456f);
    } while(false);

    do
    {
        const hkReflect::FieldDecl boolField = rec->findField("boolVal", false);
        if(!HK_TEST(boolField != HK_NULL)) { break; }
        const hkReflect::Type* fieldType = boolField.getType();
        if(!HK_TEST(fieldType != HK_NULL)) { break; }
        const hkReflect::BoolType* boolFieldTyped = fieldType->asBool();
        HK_TEST( boolFieldTyped != HK_NULL );
        hkReflect::BoolVar hBool(&obj, boolFieldTyped);
        hkReflect::BoolValue val = hBool.getValue();

        HK_TEST( val == false);
        hBool.setValue( true );
        HK_TEST( hBool.getValue() == true );
    } while(false);

    do
    {
        const hkReflect::FieldDecl nameField = rec->findField("name", false);
        if(!HK_TEST(nameField != HK_NULL)) { break; }
        const hkReflect::Type* fieldType = nameField.getType();
        if(!HK_TEST(fieldType != HK_NULL)) { break; }
        const hkReflect::StringType* nameFieldTyped = fieldType->asString();
        if(!HK_TEST(nameFieldTyped != HK_NULL)) { break; }
        hkReflect::StringVar hName(&obj, nameFieldTyped);

        const char* name = hName.getValue();
        HK_TEST(hkString::strCmp(name, "old") == 0);
        hName.setValue("foo");
        name = hName.getValue();
        HK_TEST( hkString::strCmp(name, "foo") == 0);
    } while(false);

    do
    {
        const hkReflect::FieldDecl areaField = rec->findField("area", false);
        if(!HK_TEST(areaField != HK_NULL)) { break; }
        const hkReflect::Type* fieldType = areaField.getType();
        if(!HK_TEST(fieldType != HK_NULL)) { break; }
        const hkReflect::FloatType* areaFieldTyped = fieldType->asFloat();
        if(!HK_TEST(areaFieldTyped != HK_NULL)) { break; }
        hkReflect::FloatVar hArea(&obj, areaFieldTyped);
        hkReflect::FloatValue val = hArea.getValue();

        const hkReal correctAreaVal = (HK_REAL_PI * 123.456f * 123.456f);
        HK_TEST(hkMath::equal((hkReal)val, correctAreaVal, 0.1f));
        hArea.setValue(123.456); // should silently fail
        HK_TEST(hkMath::equal((hkReal)hArea.getValue(), correctAreaVal, 0.1f));

        // Check it's really dependant
        {
            const hkReflect::FieldDecl radiusField = rec->findField("radius", false);
            HK_TEST( radiusField != HK_NULL );
            const hkReflect::FloatType* radiusFieldTyped = radiusField.getType()->asFloat();
            HK_TEST( radiusFieldTyped != HK_NULL );
            hkReflect::FloatVar hRadius(&obj, radiusFieldTyped);
            hRadius.setValue(1.0f);
        }

        HK_TEST(hArea.getValue() == HK_REAL_PI);

    } while(false);

    {
        hkVector4* typeDefault = hkDynCast<hkVector4>(hkReflect::getType<hkVector4>()->getDefault());
        HK_TEST(((hkUlong)typeDefault) % HK_REAL_ALIGNMENT == 0);

        hkReflect::Var vecField = hkReflect::Var(&obj)["vec"];
        hkVector4* vecFieldDefault = hkDynCast<hkVector4>(vecField.getType()->getDefault());
        HK_TEST(((hkUlong)vecFieldDefault) % HK_REAL_ALIGNMENT == 0);
        vecField.writeDefault();
        HK_TEST(hkDynCast<hkVector4>(vecField)->allExactlyEqual<4>(*vecFieldDefault));

        hkReflect::Var matField = hkReflect::Var(&obj)["mat"];
        hkMatrix3* matFieldDefault = hkDynCast<hkMatrix3>(matField.getType()->getDefault());
        HK_TEST(((hkUlong)matFieldDefault) % HK_REAL_ALIGNMENT == 0);
        matField.writeDefault();
        HK_TEST(hkDynCast<hkMatrix3>(matField)->isApproximatelyEqual(*matFieldDefault));
    }

    do
    {
        hkGeometry g;
        obj.m_ptrProperty = &g;
        hkReflect::PointerVar varProp = hkReflect::Var(&obj)["var"];
        if (!HK_TEST(varProp)) break;
        hkReflect::Var contents = varProp.getValue();
        HK_TEST(contents.dynCast<hkGeometry>() == obj.m_ptrProperty);
    } while (false);

    do
    {
        UnitTestClang::TestTemplateProperty<hkReal> instance;
        hkReflect::RecordVar var = hkReflect::Var(&instance);

        const hkReflect::Type* intPropType = var.getType()->findField("intVal", false).getType();
        HK_TEST(intPropType->extendsOrEquals<int>());

        const hkReflect::Type* TPropType = var.getType()->findField("TVal", false).getType();
        HK_TEST(TPropType->extendsOrEquals<hkReal>());

        hkReflect::IntVar intVal = var["intVal"];
        hkReflect::FloatVar TVal = var["TVal"];

        intVal.setValue(42);
        TVal.setValue(42.0f);

        HK_TEST(instance.m_intValInternal == 42);
        HK_TEST(instance.m_TValInternal == 42.0f);

        HK_TEST(intVal.getValue() == 42);
        HK_TEST(TVal.getValue() == 42.0f);

    } while (false);

    do
    {
        const hkReflect::Type* testType = hkReflect::getType< UnitTestClang::TestTemplateAttribute<int> >();
        const hk::ContainsRelArrays* craAttr = hkReflect::TypeDetail::localFindAttribute<hk::ContainsRelArrays>(testType);
        HK_TEST(craAttr && *craAttr == false);
        const hk::AbsMin* minAttr = hkReflect::TypeDetail::localFindAttribute<hk::AbsMin>(testType);
        if (HK_TEST(minAttr))
        {
            const UnitTestClang::TestTemplateAttribute<int>* min =
                hkReflect::Var(minAttr->get(testType)).dynCast< UnitTestClang::TestTemplateAttribute<int> >();
            HK_TEST(min && min->m_t == -1);
        }

        const hkReflect::Type* fieldType = testType->asRecord()->getField(0).getType();
        const hk::AbsMax* maxAttr = hkReflect::TypeDetail::localFindAttribute<hk::AbsMax>(fieldType);
        if (HK_TEST(maxAttr))
        {
            const int* max = hkReflect::Var(maxAttr->get(fieldType)).dynCast<int>();
            HK_TEST(max && *max == 1);
        }
    } while (false);

    do
    {
        const hkReflect::Type* testType = hkReflect::getType<UnitTestClang::TestArrayAttr>();
        {
            const UnitTestClang::ArrayAttr* attr = hkReflect::TypeDetail::localFindAttribute<UnitTestClang::ArrayAttr>(testType);
            if (HK_TEST(attr))
            {
                hkArrayView<const char* const> arrView(attr->m_value);
                if (HK_TEST(arrView.getSize() == 1))
                {
                    HK_TEST(hkString::strCmp(arrView[0], "1") == 0);
                }
            }
        }
        {
            const UnitTestClang::ArrayAttrDef* attr = hkReflect::TypeDetail::localFindAttribute<UnitTestClang::ArrayAttrDef>(testType);
            if (HK_TEST(attr))
            {
                hkArrayView<const int> arrView(attr->m_value);
                if (HK_TEST(arrView.getSize() == 4))
                {
                    for (int i = 0; i < 4; ++i)
                    {
                        HK_TEST(arrView[i] == i + 1);
                    }
                }
            }
        }
    } while (false);

    do
    {
        const hkReflect::Type* testType = hkReflect::getType<UnitTestClang::TestArrayAttrDefaults>();
        {
            const UnitTestClang::ArrayAttr* attr = hkReflect::TypeDetail::localFindAttribute<UnitTestClang::ArrayAttr>(testType);
            if (HK_TEST(attr))
            {
                hkArrayView<const char* const> arrView(attr->m_value);
                HK_TEST(arrView.getSize() == 0);
            }
        }
        {
            const UnitTestClang::ArrayAttrDef* attr = hkReflect::TypeDetail::localFindAttribute<UnitTestClang::ArrayAttrDef>(testType);
            if (HK_TEST(attr))
            {
                hkArrayView<const int> arrView(attr->m_value);
                if (HK_TEST(arrView.getSize() == 3))
                {
                    for (int i = 0; i < 3; ++i)
                    {
                        HK_TEST(arrView[i] == i + 1);
                    }
                }
            }
        }
        {
            const UnitTestClang::ArrayAttrEmptyDef* attr = hkReflect::TypeDetail::localFindAttribute<UnitTestClang::ArrayAttrEmptyDef>(testType);
            if (HK_TEST(attr))
            {
                hkArrayView<const int> arrView(attr->m_value);
                HK_TEST(arrView.getSize() == 0);
            }
        }
    } while (false);

    do
    {
        const hkReflect::Type* testType = hkReflect::getType<UnitTestClang::TestMethods>();
        {
            hkReflect::CallableIterator it(testType, hkReflect::CALLABLE_CONSTRUCTORS);
            if (!HK_TEST(it.advance())) { break; }
            const hkReflect::Callable* defCtor = it.current();
            const UnitTestClang::SimpleAttr* attr = defCtor->findAttribute<UnitTestClang::SimpleAttr>();
            if (!HK_TEST(attr != HK_NULL)) { break; }
            HK_TEST(attr->m_value == 1);
        }
        {
            hkReflect::CallableIterator it(testType, hkReflect::CALLABLE_STATIC_FUNCTIONS);
            while (HK_TEST(it.advance()))
            {
                if (it.current()->getNumParams() == 1)
                {
                    const hkReflect::PointerType* param = it.current()->getParamType(0)->asPointer();
                    if (!HK_TEST(param != HK_NULL)) { break; }
                    HK_TEST(!param->getImpl()->canBeNull());
                    break;
                }

                if (hkString::strCmp(it.current()->getName(), "defaultArgs") == 0)
                {
                    if (HK_TEST_EQ(it.current()->getNumParams(), 4))
                    {
                        auto intArg = hkDynCast<int>(it.current()->getParamDefaultArg(0));
                        if (HK_TEST(intArg))
                        {
                            HK_TEST_EQ(*intArg, 10);
                        }
                        auto vectorArg = hkDynCast< hkReflect::Detail::Reference<hkReflect::Typedef::hkVector4_Tag> >(it.current()->getParamDefaultArg(1));
                        if (HK_TEST(vectorArg))
                        {
                            HK_TEST((*reinterpret_cast<hkVector4**>(vectorArg))->equal(hkVector4::getZero()).allAreSet());
                        }
                        auto tupleArg = hkDynCast< hkTuple<int, int> >(it.current()->getParamDefaultArg(2));
                        if (HK_TEST(tupleArg))
                        {
                            HK_TEST(*tupleArg == hkTupleT::make(42, 24));
                        }
                        auto quaternionArg = hkDynCast< hkReflect::Detail::Reference<hkQuaternionf const> >(it.current()->getParamDefaultArg(3));
                        HK_TEST(quaternionArg);
                    }
                }
            }
        }

        

    } while (false);

    do
    {
        const hkReflect::Type* testType = hkReflect::getType< UnitTestClang::TestTemplateMethods<const char*, UnitTestClang::TestDependentType > >();
        hkReflect::CallableIterator it(testType, hkReflect::CALLABLE_METHODS);
        if (!HK_TEST(it.advance())) { break; }
        const hkReflect::Callable* defCtor = it.current();

        const UnitTestClang::SimpleAttr* attr = defCtor->findAttribute<UnitTestClang::SimpleAttr>();
        if (!HK_TEST(attr != HK_NULL)) { break; }
        HK_TEST(attr->m_value == 2);
        if (!HK_TEST(testType != HK_NULL)) { break; }

        

    } while (false);

    do
    {
        auto func = findFunctionFromTypeByUniqueName<UnitTestClang::TestTemplateDefArgs<hkInt32>>("defaultArgs", hkReflect::CALLABLE_STATIC_FUNCTIONS);
        if (!HK_TEST(func)) { break; }

        auto defArg = hkDynCast< hkInt32 >(func->getParamDefaultArg(0));
                    if (HK_TEST(defArg))
                    {
                        HK_TEST_EQ(*defArg, 123);
        }

    } while (false);

    

#if 0
    do
    {
        const hkReflect::RecordType* testType = hkReflect::getType< UnitTestClang::TestTemplateEnumTypedefs<float> >()->asRecord();
        if(!HK_TEST(testType != HK_NULL)) { break; }

        const hkReflect::IntType* countType = testType->findField("count", false).getType()->asInteger();
        if(!HK_TEST(countType != HK_NULL)) { break; }
        bool dummy = true;
        const hk::Presets* presets = countType->findAttribute<hk::Presets>(dummy);
        if(!HK_TEST(presets != HK_NULL)) { break; }

        const hkReflect::FloatType* realType = testType->findField("real", false).getType()->asFloat();
        if(!HK_TEST(realType != HK_NULL)) { break; }
        HK_TEST(hkString::strCmp(realType->getName(), "UnitTestClang::TestTemplateEnumTypedefs< T1, T2 >::Real100") == 0);
        const hk::AbsMin* minAttr = realType->findAttribute<hk::AbsMin>(dummy);
        if(!HK_TEST(minAttr != HK_NULL)) { break; }
        hkReflect::FloatVar realInst = realType->newInstance();
        realInst.writeDefault();
        HK_TEST(realInst.get() == 100.0f);
        realInst.destroy();
    } while (false);

    do
    {
        const hkReflect::RecordType* testType = hkReflect::getType< UnitTestClang::SpecializationsInTemplate<double> >()->asRecord();
        if(!HK_TEST(testType != HK_NULL)) { break; }

        const hkReflect::Type* r1Type = testType->findField("r1", false).getType();
        if(!HK_TEST(r1Type != HK_NULL)) { break; }
        HK_TEST(r1Type->asFloat());
        HK_TEST(hkString::strCmp(r1Type->getName(), "UnitTestClang::TestTemplateEnumTypedefs< T1, T2 >::Real100") == 0);

        const hkReflect::Type* r2Type = testType->findField("r2", false).getType();
        if(!HK_TEST(r2Type != HK_NULL)) { break; }
        HK_TEST(r2Type->asFloat());
        HK_TEST(hkString::strCmp(r2Type->getName(), "UnitTestClang::TestTemplateEnumTypedefs< T1, T2 >::Real200") == 0);

        const hkReflect::Type* countType = testType->findField("c", false).getType();
        if(!HK_TEST(countType != HK_NULL)) { break; }
        HK_TEST(countType->asInteger());
        HK_TEST(hkString::strCmp(countType->getName(), "UnitTestClang::TestTemplateEnumTypedefs< T1, T2 >::Count") == 0);

        const hkReflect::Type* n7type = testType->findField("n7", false).getType();
        if(!HK_TEST(n7type != HK_NULL)) { break; }
        if(!HK_TEST(n7type->asArray())) { break; }
        HK_TEST(n7type->asArray()->getSubType()->isA(testType->findField("n2", false).getType()));

        const hkReflect::Type* n8type = testType->findField("n8", false).getType();
        if(!HK_TEST(n8type != HK_NULL)) { break; }
        HK_TEST(n8type->asFloat());
        const hk::Presets* presets = n8type->findAttribute<hk::Presets>();
        HK_TEST(presets != HK_NULL);
        HK_TEST(presets == countType->findAttribute<hk::Presets>());

    } while (false);

    do
    {
        //HK_TEST(hkReflect::getType<UnitTestClang::NonReflected::Enum>());
        HK_TEST(hkReflect::typeFromName("UnitTestClang::NonReflected::Typedef"));
        HK_TEST(hkReflect::getType<UnitTestClang::NonReflected::Nested>());
        HK_TEST(hkReflect::getType< UnitTestClang::NonReflected::NestedTemplate<char> >());

        //HK_TEST(hkReflect::getType< UnitTestClang_NonReflectedTemplate_Enum<int> >());
        HK_TEST(hkReflect::getType< UnitTestClang_NonReflectedTemplate_Nested<int> >());
        //HK_TEST((hkReflect::getType< UnitTestClang_NonReflectedTemplate_NestedTemplate<int, float> >()));

    } while (false);
#endif

    do
    {
        const hkReflect::RecordType* testType = hkReflect::getType< UnitTestClang::TemplateFunctions<float> >()->asRecord();
        if(!HK_TEST(testType != HK_NULL)) { break; }

        const hkReflect::Detail::Functions* functions = hkReflect::TypeDetail::getDeclaredFunctions(testType);
        if(!HK_TEST(functions != HK_NULL)) { break; }


        
        UnitTestClang::TemplateFunctions<float> instance;
        int ints[2] = { 1, 2 };
        int* iAddr = &ints[0];
        int iRes;
        float floats[2] = { 1.0f, 2.0f };
        float* fAddr = &floats[0];
        float fRes;

        if(!HK_TEST(functions->getNumConstructors() == 1)) { break; }
        const hkReflect::NamedCallable* ctor = functions->getConstructor(0);
        ctor->callFunction(HK_NULL, &instance);
        HK_TEST(instance.m_value == 42.0f);

        if(!HK_TEST(functions->getNumMethods() == 2/*4*/)) { break; } 

        const hkReflect::NamedCallable* meth = functions->getUnboundMethod(0);
        HK_TEST(hkString::strCmp(meth->getName(), "meth") == 0);
        HK_TEST(meth->getNumParams() == 1);
        HK_TEST_EQ(hkStringView(meth->getParamName(0)), hkStringView("x"));
        meth->callMethod(&instance, &iAddr, &iRes);
        HK_TEST(hkMath::equal(instance.m_value, (float)ints[0]));
        HK_TEST(iRes == ints[0]);

        const hkReflect::NamedCallable* templateMeth = functions->getUnboundMethod(1);
        HK_TEST(hkString::strCmp(templateMeth->getName(), "templateMeth") == 0);
        templateMeth->callMethod(&instance, &fAddr, &fRes);
        HK_TEST(instance.m_value == floats[0]);
        HK_TEST(fRes == floats[0]);

        if(!HK_TEST(functions->getNumFunctions() == 2)) { break; }

        const hkReflect::NamedCallable* func = functions->getFunction(0);
        HK_TEST(hkString::strCmp(func->getName(), "func") == 0);
        HK_TEST(func->getNumParams() == 2);
        HK_TEST_EQ(hkStringView(func->getParamName(0)), hkStringView("a"));
        HK_TEST_EQ(hkStringView(func->getParamName(1)), hkStringView("b"));
        func->callFunction(ints, &iRes);
        HK_TEST(iRes == ints[0] + ints[1]);

        const hkReflect::NamedCallable* templateFunc = functions->getFunction(1);
        HK_TEST(hkString::strCmp(templateFunc->getName(), "templateFunc") == 0);
        templateFunc->callFunction(floats, &fRes);
        HK_TEST(fRes == floats[0] + floats[1]);

#if 0 
        const hkReflect::NamedCallable* nestedMeth = functions->getUnboundMethod(2);
        HK_TEST(hkString::strCmp(nestedMeth->getName(), "nestedMeth") == 0);
        const hkReflect::Type* nestedType = nestedMeth->getReturnType();

        const hkReflect::Detail::Functions* nestedFunctions = hkReflect::TypeDetail::getDeclaredFunctions(nestedType);
        if(!HK_TEST(nestedFunctions != HK_NULL)) { break; }

        if(!HK_TEST(nestedFunctions->getNumConstructors() == 1)) { break; }
        if(!HK_TEST(nestedFunctions->getNumMethods() == 1)) { break; }
        if(!HK_TEST(nestedFunctions->getNumFunctions() == 1)) { break; }
#endif

    } while (false);

    do
    {
        const hkReflect::RecordType* specType = hkReflect::getType< UnitTestClang::Specializations<float, 100> >()->asRecord();
        if (!HK_TEST(specType)) { break; }
        if (!HK_TEST(specType->getNumFields() == 3)) { break; }

        {
            const hkReflect::RecordType* fieldType = specType->getField(0).getType()->asRecord();
            if (!HK_TEST(fieldType)) { break; }
            HK_TEST((fieldType->extendsOrEquals< UnitTestClang::Specializations<hkBaseObject, 15> >()));
            HK_TEST((testTemplateArgs<hkBaseObject, 15>(fieldType)));
            if (!HK_TEST(fieldType->getNumFields() == 1)) { break; }
            HK_TEST(fieldType->getField(0).getType()->extendsOrEquals<int>());
        }

        {
            const hkReflect::RecordType* fieldType = specType->getField(1).getType()->asRecord();
            if (!HK_TEST(fieldType)) { break; }
            HK_TEST((fieldType->extendsOrEquals< UnitTestClang::Specializations<double, 42> >()));
            HK_TEST((testTemplateArgs<double, 42>(fieldType)));
            if (!HK_TEST(fieldType->getNumFields() == 1)) { break; }
            HK_TEST(fieldType->getField(0).getType()->extendsOrEquals<hkStringPtr>());
        }

        {
            const hkReflect::RecordType* fieldType = specType->getField(2).getType()->asRecord();
            if (!HK_TEST(fieldType)) { break; }
            HK_TEST((fieldType->extendsOrEquals< UnitTestClang::Specializations<void, 0> >()));
            HK_TEST((testTemplateArgs<void, 0>(fieldType)));
            HK_TEST(fieldType->getNumFields() == 0);
        }

    } while (false);

    do
    {
        using namespace hkReflect;
        Decl enum1 = rec->findDecl("enum1");
        HK_TEST(enum1);
    } while(0);

    {
        HK_TEST( hkReflect::TypeDetail::getDefaultConstructionFunction(hkReflect::getType<UnitTestClang::PrivateCtor>()) == HK_NULL );
        HK_TEST( hkReflect::TypeDetail::getCopyAssignmentFunction(hkReflect::getType<UnitTestClang::PrivateCtor>()) != HK_NULL );
    }

    {
        HK_TEST(hkReflect::getType< UnitTestClang::Abstract1 >()->isAbstract());
        HK_TEST(hkReflect::getType< UnitTestClang::Abstract2<int> >()->isAbstract());
        HK_TEST(hkReflect::getType< UnitTestClang::Abstract3<int> >()->isAbstract());
        HK_TEST(hkReflect::getType< UnitTestClang::Abstract4<int> >()->isAbstract());
        HK_TEST(hkReflect::getType< UnitTestClang::NotAbstract<int> >()->isAbstract());
    }

    {
        NonReflected3 nrObj;
        const hkReflect::Type* type = hkReflect::exactTypeOf(static_cast<hkReferencedObject*>(&nrObj));
        HK_TEST(type->extendsOrEquals<hkReferencedObject>());
        HK_TEST(!type->isSerializable());
    }

    {
        const hkReflect::Type* type = hkReflect::getType< UnitTestClang::WithTemplateInterface<UnitTestClang::AfterReflect::Interface1> >();
        HK_TEST(type->implements(hkReflect::getType<UnitTestClang::AfterReflect::Interface1>()));
    }

    {
        auto type = hkReflect::getType<UnitTestClang::AttrsOnSection>();

        HK_TEST(!hkReflect::TypeDetail::localHasOptional(type->findDecl("noAttr1").getType(), hkReflect::Opt::ATTRIBUTES));
        HK_TEST(!hkReflect::TypeDetail::localHasOptional(type->findDecl("noAttr2").getType(), hkReflect::Opt::ATTRIBUTES));
        HK_TEST(!hkReflect::TypeDetail::localHasOptional(type->findDecl("noAttr3").getType(), hkReflect::Opt::ATTRIBUTES));

        {
            auto absMin1 = type->findDecl("absMin1").getType();
            auto absMinAttr = absMin1->findAttribute<hk::AbsMin>();
            if (HK_TEST(absMinAttr)) { HK_TEST_EQ(*absMinAttr->get<int>(), 42); }
            HK_TEST_EQ(absMin1->findAttribute<hk::AbsMax>(), (void*)HK_NULL);
        }

        {
            auto absMin2 = type->findDecl("absMin2").getType();
            auto absMinAttr = absMin2->findAttribute<hk::AbsMin>();
            if (HK_TEST(absMinAttr)) { HK_TEST_EQ(*absMinAttr->get<int>(), 42); }
            HK_TEST_EQ(absMin2->findAttribute<hk::AbsMax>(), (void*)HK_NULL);
        }

        {
            auto twoAttrs1 = type->findDecl("twoAttrs1").getType();
            auto absMinAttr = twoAttrs1->findAttribute<hk::AbsMin>();
            auto absMaxAttr = twoAttrs1->findAttribute<hk::AbsMax>();
            if (HK_TEST(absMinAttr)) { HK_TEST_EQ(*absMinAttr->get<int>(), -42); }
            if (HK_TEST(absMaxAttr)) { HK_TEST_EQ(*absMaxAttr->get<int>(), 84); }
        }

        {
            auto twoAttrs2 = type->findDecl("twoAttrs2").getType();
            auto absMinAttr = twoAttrs2->findAttribute<hk::AbsMin>();
            auto absMaxAttr = twoAttrs2->findAttribute<hk::AbsMax>();
            if (HK_TEST(absMinAttr)) { HK_TEST_EQ(*absMinAttr->get<int>(), -42); }
            if (HK_TEST(absMaxAttr)) { HK_TEST_EQ(*absMaxAttr->get<int>(), 84); }
        }

        {
            hkReflect::CallableIterator it(type, hkReflect::CALLABLE_METHODS);
            if (HK_TEST(it.advance())) { HK_TEST_EQ(it.current()->getName(), "f"); }
            HK_TEST(!it.advance());
        }
    }

    {
        auto type = hkReflect::getType<UnitTestClang::AttachDocStringTest>();

        {
            auto classDocAttr = type->findAttribute<hk::DocString>();
            HK_TEST(hkString::strCmp(classDocAttr->m_value,
                "A class to test auto conversion of doc comments (those starting with "
                "either /// or ///<), to hk::DocString attributes.") == 0);
        }

        {
            auto aDeclType = type->findDecl("a").asField().getType();
            auto aDocAttr = aDeclType->findAttribute<hk::DocString>();
            HK_TEST(hkString::strCmp(aDocAttr->m_value,
                "Field m_a has preceding documentation,\n\nThat is, it has a "
                "documentation block which comes before the field declaration.") == 0);
        }

        {
            auto bDeclType = type->findDecl("b").getType();
            auto bDocAttr = bDeclType->findAttribute<hk::DocString>();
            HK_TEST(hkString::strCmp(bDocAttr->m_value,
                "Field m_b has succeeding documentation,\n\nThat is, it has a "
                "documentation block which comes after the field declaration.") == 0);
        }

        {
            auto cDeclType = type->findDecl("c").getType();
            HK_TEST(cDeclType->findAttribute<hk::DocString>() == HK_NULL);
        }

        {
            auto dDeclType = type->findDecl("d").getType();
            HK_TEST(dDeclType->findAttribute<hk::DocString>() == HK_NULL);
        }

        {
            auto eDeclType = type->findDecl("e").getType();
            auto eDocAttr = eDeclType->findAttribute<hk::DocString>();
            HK_TEST(hkString::strCmp(eDocAttr->m_value, "foo /*what??*/ ///bar begin{ ...") == 0);
        }
    }

    {
        auto type = hkReflect::getType<UnitTestClang::DontAttachDocStringTest>();
        auto declType = type->findDecl("a").getType();
        HK_TEST(declType->findAttribute<hk::DocString>() == HK_NULL);
    }

    // Test validation
    {
        // Capture and ignore warnings, we expect validation to warn when it fails
        UnitTest::Raii::CaptureThreadLogOutput eatLogOutput;

        UnitTestClang::TestDefaultTypes tdt;
        tdt.m_vec.setZero();
        tdt.m_real = 0.0f;
        tdt.m_enum = UnitTestClang::TEN;
        hkVector4 notNormalised; notNormalised.set(1.0f, 2.0f, 3.0f, 4.05f);
        tdt.m_quat.setImag(notNormalised);
        tdt.m_wasValidated = false;
        tdt.m_iShouldBeNormalised.set(1, 0, 0, 0); // Normalized
        tdt.m_aPointer.setAndDontIncrementRefCount(new hkReferencedObject);

        // Quaternion is not normalised
        HK_TEST(HK_REFLECT_VALIDATE_OBJECT(UnitTestClang::TestDefaultTypes, tdt).isFailure());
        HK_TEST(!tdt.m_wasValidated);

        tdt.m_quat.normalize();
        HK_TEST(HK_REFLECT_VALIDATE_OBJECT(UnitTestClang::TestDefaultTypes, tdt).isSuccess());
        HK_TEST(tdt.m_wasValidated);

        tdt.m_aPointer = nullptr;
        HK_TEST(HK_REFLECT_VALIDATE_OBJECT(UnitTestClang::TestDefaultTypes, tdt).isFailure());

        tdt.m_aPointer.setAndDontIncrementRefCount(new hkReferencedObject);

        tdt.m_enum = UnitTestClang::ONE;
        tdt.m_wasValidated = false;
        HK_TEST(HK_REFLECT_VALIDATE_OBJECT(UnitTestClang::TestDefaultTypes, tdt).isFailure());
        HK_TEST(tdt.m_wasValidated);

        tdt.m_enum = UnitTestClang::TEN;
        HK_TEST(HK_REFLECT_VALIDATE_OBJECT(UnitTestClang::TestDefaultTypes, tdt).isSuccess());

        tdt.m_vec.setAll(-5.0f);
        tdt.m_wasValidated = false;

        HK_TEST(HK_REFLECT_VALIDATE_OBJECT(UnitTestClang::TestDefaultTypes, tdt).isFailure());

        tdt.m_real = -20;
        HK_TEST(HK_REFLECT_VALIDATE_OBJECT(UnitTestClang::TestDefaultTypes, tdt).isFailure());

        tdt.m_real = 120;
        HK_TEST(HK_REFLECT_VALIDATE_OBJECT(UnitTestClang::TestDefaultTypes, tdt).isFailure());

        tdt.m_wasValidated = false;
        tdt.m_real = 5.0f;
        tdt.m_vec.setZero();

        HK_TEST(HK_REFLECT_VALIDATE_OBJECT(UnitTestClang::TestDefaultTypes, tdt).isSuccess());
        HK_TEST(tdt.m_wasValidated);

        tdt.m_iShouldBeNormalised.set(1, 2, 3, 4); // Not normalized
        HK_TEST(HK_REFLECT_VALIDATE_OBJECT(UnitTestClang::TestDefaultTypes, tdt).isFailure());

        tdt.m_iShouldBeNormalised.normalize<4>();
        HK_TEST(HK_REFLECT_VALIDATE_OBJECT(UnitTestClang::TestDefaultTypes, tdt).isSuccess());

        UnitTestClang::TestTemplateAttribute<int> tattrInt;
        tattrInt.m_t = 2;
        HK_TEST(HK_REFLECT_VALIDATE_OBJECT(UnitTestClang::TestTemplateAttribute<int>, tattrInt).isFailure());

        tattrInt.m_t = 1;
        HK_TEST(HK_REFLECT_VALIDATE_OBJECT(UnitTestClang::TestTemplateAttribute<int>, tattrInt).isSuccess());

        UnitTestClang::TestTemplateAttribute<float> tattrFloat;
        tattrFloat.m_t = 7.23f;
        HK_TEST(!HK_REFLECT_VALIDATE_OBJECT(UnitTestClang::TestTemplateAttribute<float>, tattrFloat).isSuccess());

        tattrFloat.m_t = -0.111f;
        HK_TEST(HK_REFLECT_VALIDATE_OBJECT(UnitTestClang::TestTemplateAttribute<float>, tattrFloat).isSuccess());

        // NOT valid, m_vec has AbsMin(-1, -2, -3, -4)
        hkVector4f correctVecValue; correctVecValue.set(-2, -2, -2, -2);
        HK_TEST(HK_REFLECT_VALIDATE_FIELD(UnitTestClang::TestDefaultTypes, m_vec, correctVecValue).isFailure());
        // valid, m_real has AbsMin(-10)
        const hkReal correctVal = 1.1f;
        HK_TEST(HK_REFLECT_VALIDATE_FIELD(UnitTestClang::TestDefaultTypes, m_real, correctVal).isSuccess());

        UnitTestClang::NeedsValidation::s_validations = 0;

        // valid, < 10 and != 0. Also test we called validateContract
        UnitTestClang::NeedsValidation correctValue = { 2 };
        HK_TEST(HK_REFLECT_VALIDATE_FIELD(UnitTestClang::AlsoNeedsValidation, m_needsValidation, correctValue).isSuccess());
        HK_TEST(hkReflect::validateByType(&correctValue, HK_REFLECT_FIELD_OF(UnitTestClang::AlsoNeedsValidation, m_needsValidation).getType()).isSuccess());
        HK_TEST(UnitTestClang::NeedsValidation::s_validations == 2);

        // NOT valid, > 10. Don't need to call validate contract
        correctValue.m_value = 12;
        HK_TEST(HK_REFLECT_VALIDATE_FIELD(UnitTestClang::AlsoNeedsValidation, m_needsValidation, correctValue).isFailure());
        HK_TEST(hkReflect::validateByType(&correctValue, HK_REFLECT_FIELD_OF(UnitTestClang::AlsoNeedsValidation, m_needsValidation).getType()).isFailure());
        HK_TEST(UnitTestClang::NeedsValidation::s_validations == 2);

        // NOT valid, = 0. Also test we called validateContract
        correctValue.m_value = 0;
        HK_TEST(HK_REFLECT_VALIDATE_FIELD(UnitTestClang::AlsoNeedsValidation, m_needsValidation, correctValue).isFailure());
        HK_TEST(hkReflect::validateByType(&correctValue, HK_REFLECT_FIELD_OF(UnitTestClang::AlsoNeedsValidation, m_needsValidation).getType()).isFailure());
        HK_TEST(UnitTestClang::NeedsValidation::s_validations == 4);

        // valid, < 10, != 0. calls validate
        correctValue.m_value = 3;
        HK_TEST(HK_REFLECT_VALIDATE_FIELD(UnitTestClang::AlsoNeedsValidation, m_needsValidation, correctValue).isSuccess());
        HK_TEST(hkReflect::validateByType(&correctValue, HK_REFLECT_FIELD_OF(UnitTestClang::AlsoNeedsValidation, m_needsValidation).getType()).isSuccess());
        HK_TEST(UnitTestClang::NeedsValidation::s_validations == 6);

        // valid, this field is not validated so it can take any value
        int correctIntValue = 222;
        HK_TEST(hkReflect::validateByType(&correctIntValue, HK_REFLECT_FIELD_OF(UnitTestClang::AlsoNeedsValidation, m_dontCareAboutTheValueOfThis).getType()).isSuccess());
        HK_TEST(UnitTestClang::NeedsValidation::s_validations == 6);

        UnitTestClang::AlsoNeedsValidation anv;
        anv.m_needsValidation.m_value = 1;
        anv.m_dontCareAboutTheValueOfThis = -2;

        HK_TEST(HK_REFLECT_VALIDATE_OBJECT(UnitTestClang::AlsoNeedsValidation, anv).isSuccess());
    }
    do {
        auto func = findFunctionFromTypeByUniqueName<UnitTestClang::SameTypeDefaultConstRefArgsWithDifferentValues>("func", hkReflect::CALLABLE_STATIC_FUNCTIONS);
        if (!HK_TEST(func)) { break; }

        if (HK_TEST_EQ(func->getNumParams(), 2))
        {
            auto tuple0Arg = hkDynCast< hkReflect::Detail::Reference<hkTuple<int>> >(func->getParamDefaultArg(0));
            if (HK_TEST(tuple0Arg))
            {
                HK_TEST(**reinterpret_cast<const hkTuple<int>**>(tuple0Arg) == hkTupleT::make(123) );
            }
            auto tuple1Arg = hkDynCast< hkReflect::Detail::Reference<hkTuple<int>> >(func->getParamDefaultArg(1));
            if (HK_TEST(tuple1Arg))
            {
                HK_TEST(**reinterpret_cast<const hkTuple<int>**>(tuple1Arg) == hkTupleT::make(456) );
            }
        }
    } while (0);

    do {
        auto func = findFunctionFromTypeByUniqueName<UnitTestClang::DefaultArgsWithDependentType<const int&>>("func", hkReflect::CALLABLE_STATIC_FUNCTIONS);
        if (!HK_TEST(func)) { break; }

        if (HK_TEST_EQ(func->getNumParams(), 1))
        {
            auto arg = hkDynCast< hkReflect::Detail::Reference<int> >(func->getParamDefaultArg(0));
            if (HK_TEST(arg))
            {
                HK_TEST(**reinterpret_cast<const hkTuple<int>**>(arg) == hkTupleT::make(123) );
            }
        }
    } while (0);

    do {
        auto func = findFunctionFromTypeByUniqueName<UnitTestClang::StructWithMultipleConstructorParamsAsDefaultParameter>("func", hkReflect::CALLABLE_STATIC_FUNCTIONS);
        if (!HK_TEST(func)) { break; }

        if (HK_TEST_EQ(func->getNumParams(), 1))
        {
            auto arg = hkDynCast< hkReflect::Detail::Reference<UnitTestClang::StructWithMultipleConstructorParamsAsDefaultParameter_Helper> >(func->getParamDefaultArg(0));
            if (HK_TEST(arg))
            {
                const auto def = **reinterpret_cast<const UnitTestClang::StructWithMultipleConstructorParamsAsDefaultParameter_Helper**>(arg);
                HK_TEST(def.a == 123 && def.b == 456);
            }
        }
    } while (0);
    return 0;
}

HK_TEST_REGISTER(ClangTest, "Fast", "Common/Test/UnitTest/Base/", __FILE__     );

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
