// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/UnitTest/hkUnitTest.h>

HK_DETAIL_DIAG_MSVC_PUSH()
HK_DETAIL_DIAG_MSVC_OFF(4355)

namespace UnitTest
{

class TrackerTestA;
class TrackerTestB;
class TrackerTestC;

class SimplePtr
{
public:
    HK_DECLARE_CLASS(SimplePtr, New, Reflect);
    HK_RECORD_ATTR(hk::Serialize(false));
    SimplePtr(void* ptr) : m_ptr(ptr) {}
    void* m_ptr;
};

class TrackerTestC : public SimplePtr
{
public:
    HK_DECLARE_CLASS(TrackerTestC, New);
    HK_RECORD_ATTR(hk::MemoryTracker(opaque=true, handler=&UnitTest::TrackerTestC::trackerHandler));
    TrackerTestA* m_ptrA;
    void* m_manual;
    TrackerTestC(TrackerTestA* ptrA) : SimplePtr(ptrA), m_ptrA(ptrA), m_manual(ptrA) {}
    TrackerTestC(void* ptr) : SimplePtr(ptr), m_ptrA(HK_NULL), m_manual(ptr) {}

    static void trackerHandler(const hkReflect::Var& var, hkMemoryTrackerSnapshot& snapshot);
};

class Reflected : public SimplePtr
{
public:
    HK_DECLARE_CLASS(Reflected, NewOpaque, Reflect);
    HK_RECORD_ATTR(hk::Serialize(false));
    TrackerTestA* m_ptr2 HK_ATTR(hk::OpaqueType);
    Reflected(TrackerTestA* ptrA) : SimplePtr(ptrA), m_ptr2(ptrA) {}
    Reflected(void* ptr) : SimplePtr(ptr), m_ptr2(HK_NULL) {}
};


class TrackerTestA : public Reflected
{
public:
    HK_DECLARE_CLASS(TrackerTestA, New, Reflect);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);
    TrackerTestA* m_ptrA;
    hkLong m_l;
    TrackerTestB* m_ptrB HK_ATTR(hk::OpaqueType);
    Reflected m_reflected;

    TrackerTestA() : Reflected(this), m_ptrA(HK_NULL), m_ptrB(HK_NULL), m_reflected(this) {}
};

struct Data
{
    float m_arr[10];
};

class TrackerTestB : public TrackerTestC
{
public:
    HK_DECLARE_CLASS(TrackerTestB, New);
    TrackerTestB* m_ptrB;
    hkArray<TrackerTestC*> m_array;
    Data* m_data;
    TrackerTestC m_manual;
    TrackerTestB() : TrackerTestC(this), m_ptrB(HK_NULL), m_data(HK_NULL), m_manual(this) {}
};

template<typename T>
struct TrackerTestTemplate
{
    HK_DECLARE_CLASS(TrackerTestTemplate, NewTemplate);

    T m_value;
    T* m_ptr;
};

template<typename T, int N>
class ManualTrack : public SimplePtr
{
public:
    HK_DECLARE_CLASS(ManualTrack, NewManual);

    ManualTrack(T* ptr) : SimplePtr(ptr)
    {
        for (int i = 0; i < N; ++i)
        {
            m_ptrs[i] = HK_NULL;
        }
        m_ptrs[0] = ptr;
        m_arr.pushBack(*ptr);
    }

    int m_ints[N];
    const void* m_ptrs[N];
    hkArray<T> m_arr;
};

}

HK_MEMORY_TRACKER_MANUAL_BEGIN_TEMPLATE((typename T, int N), 2, UnitTest::ManualTrack<T, N>);
HK_MEMORY_TRACKER_MANUAL_PARENT(SimplePtr);
HK_MEMORY_TRACKER_MANUAL_FIELD(m_ptrs, const void*[N]);
HK_MEMORY_TRACKER_MANUAL_FIELD(m_arr, hkArray<T>);
HK_MEMORY_TRACKER_MANUAL_END();

HK_DETAIL_DIAG_MSVC_POP()


#include <Common/Base/_Auto/TemplateTypes/tracker_tests_Types.inl>

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
