// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Base/hkBase.h>
#include <Common/Base/UnitTest/hkUnitTest.h>
#include <Common/Base/Memory/Allocator/FreeList/hkFreeListAllocator.h>
#include <Common/Base/Memory/Allocator/Malloc/hkMallocAllocator.h>
#include <Common/Base/Memory/Allocator/Pooled/hkPooledAllocator.h>
#include <Common/Base/Memory/Allocator/Checking/hkGuardingAllocator.h>

static void testZeroSizeAlloc(hkMemoryAllocator& a)
{
    int size = 0;
    {
        void* p = a.blockAlloc(size);
        a.blockFree(p, size);
    }
    {
        void* p = a.bufAlloc(size);
        a.bufFree(p, size);
    }
}

static void testSizeNAlloc(hkMemoryAllocator& a, int n)
{
    {
        void* p = a.blockAlloc(n);
        a.blockFree(p, n);
    }
    {
        void* p = a.bufAlloc(n);
        a.bufFree(p, n);
    }
}


int allocators_test()
{
    // test builtin ones to catch any new ones which haven't been added here yet
    {
        hkMemoryRouter& m = hkMemoryRouter::getInstance();
        testZeroSizeAlloc( m.heap() );
        testZeroSizeAlloc( m.temp() );
        testZeroSizeAlloc( m.debug() );
        testZeroSizeAlloc( m.stack() );
    }
    {
        hkMallocAllocator m;
        testZeroSizeAlloc(m);
    }
    {
        hkMallocAllocator mal;
        hkThreadMemory thr;
        thr.setMemory(&mal);
        testZeroSizeAlloc(thr);
    }
    {
        hkMallocAllocator mal;
        hkFreeListAllocator fre(&mal, HK_NULL);
        testZeroSizeAlloc(fre);
    }
    {
        hkMallocAllocator mal;
        hkPooledAllocator p;
        p.init(&mal, &mal, &mal, 2048);
        testZeroSizeAlloc(p);
    }
    {
        hkGuardingAllocator guardingAlloc;
        testZeroSizeAlloc( guardingAlloc );
        testSizeNAlloc(guardingAlloc, 16);
        testSizeNAlloc(guardingAlloc, 16);
    }
    return 0;
}

HK_TEST_REGISTER(allocators_test, "Fast", "Common/Test/UnitTest/Base/", __FILE__);

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
