// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Base/hkBase.h>

#include <Common/Base/UnitTest/hkUnitTest.h>
#include <Common/Base/Math/Util/hkPack.h>

using namespace hkPack;

#define makeCase( BITS ) case BITS: return hkPackInt<BITS>( hkPackInt<BITS>::maxValue() )
template<typename Ret>
static Ret makeInt( int bits )
{
    HK_ASSERT_NOT_IMPLEMENTED(0x5960ae49 );
    return Ret( 0 );
}
template<>
hkInt64 makeInt( int bits )
{
    switch ( bits )
    {
        makeCase( 1 ); makeCase( 2 ); makeCase( 3 ); makeCase( 4 ); makeCase( 5 ); makeCase( 6 ); makeCase( 7 ); makeCase( 8 ); makeCase( 9 );
        makeCase( 10 ); makeCase( 11 ); makeCase( 12 ); makeCase( 13 ); makeCase( 14 ); makeCase( 15 ); makeCase( 16 ); makeCase( 17 ); makeCase( 18 ); makeCase( 19 );
        makeCase( 20 ); makeCase( 21 ); makeCase( 22 ); makeCase( 23 ); makeCase( 24 ); makeCase( 25 ); makeCase( 26 ); makeCase( 27 ); makeCase( 28 ); makeCase( 29 );
        makeCase( 30 ); makeCase( 31 ); makeCase( 32 ); makeCase( 33 ); makeCase( 34 ); makeCase( 35 ); makeCase( 36 ); makeCase( 37 ); makeCase( 38 ); makeCase( 39 );
        makeCase( 40 ); makeCase( 41 ); makeCase( 42 ); makeCase( 43 ); makeCase( 44 ); makeCase( 45 ); makeCase( 46 ); makeCase( 47 ); makeCase( 48 ); makeCase( 49 );
        makeCase( 50 ); makeCase( 51 ); makeCase( 52 ); makeCase( 53 ); makeCase( 54 ); makeCase( 55 ); makeCase( 56 ); makeCase( 57 ); makeCase( 58 ); makeCase( 59 );
        makeCase( 60 ); makeCase( 61 ); makeCase( 62 ); makeCase( 63 ); makeCase( 64 );
        default:
        {
            HK_ASSERT_NOT_IMPLEMENTED(0x2c7466cd );
            return hkInt64( 0 );
        }
    }
}
template<>
hkInt32 makeInt( int bits )
{
    switch ( bits )
    {
        makeCase( 1 ); makeCase( 2 ); makeCase( 3 ); makeCase( 4 ); makeCase( 5 ); makeCase( 6 ); makeCase( 7 ); makeCase( 8 ); makeCase( 9 );
        makeCase( 10 ); makeCase( 11 ); makeCase( 12 ); makeCase( 13 ); makeCase( 14 ); makeCase( 15 ); makeCase( 16 ); makeCase( 17 ); makeCase( 18 ); makeCase( 19 );
        makeCase( 20 ); makeCase( 21 ); makeCase( 22 ); makeCase( 23 ); makeCase( 24 ); makeCase( 25 ); makeCase( 26 ); makeCase( 27 ); makeCase( 28 ); makeCase( 29 );
        makeCase( 30 ); makeCase( 31 ); makeCase( 32 );
        default:
        {
            HK_ASSERT_NOT_IMPLEMENTED(0x723a8926 );
            return hkInt32( 0 );
        }
    }
}
template<>
hkInt16 makeInt( int bits )
{
    switch ( bits )
    {
        makeCase( 1 ); makeCase( 2 ); makeCase( 3 ); makeCase( 4 ); makeCase( 5 ); makeCase( 6 ); makeCase( 7 ); makeCase( 8 ); makeCase( 9 );
        makeCase( 10 ); makeCase( 11 ); makeCase( 12 ); makeCase( 13 ); makeCase( 14 ); makeCase( 15 ); makeCase( 16 );
        default:
        {
            HK_ASSERT_NOT_IMPLEMENTED(0x4a1045c8 );
            return hkInt16( 0 );
        }
    }
}
template<>
hkInt8 makeInt( int bits )
{
    switch ( bits )
    {
        makeCase( 1 ); makeCase( 2 ); makeCase( 3 ); makeCase( 4 ); makeCase( 5 ); makeCase( 6 ); makeCase( 7 ); makeCase( 8 );
        default:
        {
            HK_ASSERT_NOT_IMPLEMENTED(0x6f20cb3d );
            return hkInt8( 0 );
        }
    }
}
#undef makeCase

#define anyInt( BITS ) hkPackInt<BITS>( BITS )

static void AnyInt()
{
    // Check ctors and assignment
    {
        for ( int i = 1; i <= 64; i++ )
        {
            if ( i <= 8 )
            {
                hkInt8 i8 = makeInt<hkInt8>( i );
                i8;
            }
            if ( i <= 16 )
            {
                hkInt16 i16 = makeInt<hkInt16>( i );
                i16;
            }
            if ( i <= 32 )
            {
                hkInt32 i32 = makeInt<hkInt32>( i );
                i32;
            }
            if ( i <= 64 )
            {
                hkInt64 i64 = makeInt<hkInt64>( i );
                i64;
            }
        }
    }

    // These should not compile
#if 0
    {
        hkInt8 _i8 = hkInt9( 0 ); _i8;
        _i8 = 0;
        hkInt16 _i16 = hkInt17( 0 ); _i16;
        hkInt32 _i32 = hkInt33( 0 ); _i32;
        hkInt7 _i7;
        _i7 = hkPackInt<8>::mask();
        hkPackInt<8> _i8;
        _i8 = hkPackInt<9>::mask();
        hkInt15 _i15;
        _i15 = hkPackInt<16>::mask();
        hkPackInt<16> _i16;
        _i16 = hkPackInt<17>::mask();
        hkInt31 _i31;
        _i31 = hkPackInt<32>::mask();
        hkPackInt<32> _i32;
        _i32 = hkPackInt<33>::mask();
        hkInt63 _i63;
        _i63 = hkPackInt<64>::mask();
    }
#endif

    // These should assert
#if 0
    {
        {
            hkInt7 _i7( hkUint8( 0xff ) ); _i7;
            hkInt15 _i15( hkUint16( 0xffff ) ); _i15;
            hkInt31 _i31( hkUint32( 0xffffffff ) ); _i31;
            hkInt63 _i63( hkUint64( 0xffffffffffffffff ) ); _i63;
        }
        {
            hkInt7 _i7( hkPackInt<8>::maxValue() ); _i7;
            hkPackInt<8> _i8( hkPackInt<9>::maxValue() ); _i8;
            hkInt15 _i15( hkPackInt<16>::maxValue() ); _i15;
            hkPackInt<16> _i16( hkPackInt<17>::maxValue() ); _i16;
            hkInt31 _i31( hkPackInt<32>::maxValue() ); _i31;
            hkPackInt<32> _i32( hkPackInt<33>::maxValue() ); _i32;
            hkInt63 _i63( hkPackInt<64>::maxValue() ); _i63;
        }
        {
            hkInt7 _i7( hkPackInt<8>::mask() );
            _i7 = hkPackInt<8>::mask();
            hkPackInt<8> _i8( hkPackInt<9>::mask() );
            _i8 = hkPackInt<9>::mask();
            hkInt15 _i15( hkPackInt<16>::mask() );
            _i15 = hkPackInt<16>::mask();
            hkPackInt<16> _i16( hkPackInt<17>::mask() );
            _i16 = hkPackInt<17>::mask();
            hkInt31 _i31( hkPackInt<32>::mask() );
            _i31 = hkPackInt<32>::mask();
            hkPackInt<32> _i32( hkPackInt<33>::mask() );
            _i32 = hkPackInt<33>::mask();
            hkInt63 _i63( hkPackInt<64>::mask() );
            _i63 = hkPackInt<64>::mask();
        }
    }
#endif

    // These should not assert
#if 1
    {
        {
            hkPackInt7 _i7( hkUint8( 0x7f ) ); _i7;
            hkPackInt15 _i15( hkUint16( 0x7fff ) ); _i15;
            hkPackInt31 _i31( hkUint32( 0x7fffffff ) ); _i31;
            hkPackInt63 _i63( hkUint64( 0x7fffffffffffffff ) ); _i63;
        }
        {
            hkPackInt7 _i7( hkPackInt7::maxValue() ); _i7;
            hkPackInt<8> _i8( hkPackInt7::maxValue() ); _i8;
            hkPackInt15 _i15( hkPackInt15::maxValue() ); _i15;
            hkPackInt<16> _i16( hkPackInt15::maxValue() ); _i16;
            hkPackInt31 _i31( hkPackInt31::maxValue() ); _i31;
            hkPackInt<32> _i32( hkPackInt31::maxValue() ); _i32;
            hkPackInt63 _i63( hkPackInt63::maxValue() ); _i63;
            hkPackInt<64> _i64( hkPackInt63::maxValue() ); _i63;
        }
        {
            hkPackInt7 _i7( hkPackInt7::mask() );
            _i7 = hkPackInt7::mask();
            hkPackInt<8> _i8( hkPackInt7::mask() );
            _i8 = hkPackInt7::mask();
            hkPackInt15 _i15( hkPackInt15::mask() );
            _i15 = hkPackInt15::mask();
            hkPackInt<16> _i16( hkPackInt15::mask() );
            _i16 = hkPackInt15::mask();
            hkPackInt31 _i31( hkPackInt31::mask() );
            _i31 = hkPackInt31::mask();
            hkPackInt<32> _i32( hkPackInt31::mask() );
            _i32 = hkPackInt31::mask();
            hkPackInt63 _i63( hkPackInt63::mask() );
            _i63 = hkPackInt63::mask();
            hkPackInt<64> _i64( hkPackInt63::mask() );
            _i64 = hkPackInt63::mask();
        }
    }
#endif

    // Operator/ctor checks
    {
        hkPackInt4 _i4 = 4;
        hkPackInt5 _i5( 5 );
        _i4 = hkPackInt4( 4 );
        _i4 = hkPackInt3( 3 );
        HK_TEST( _i4 == 3 );
        HK_TEST( _i4 == hkPackInt4( 3 ) );
        HK_TEST( _i4 == hkPackInt3( 3 ) );
        HK_TEST( _i4 != 2 );
        HK_TEST( _i4 != hkPackInt4( 2 ) );
        HK_TEST( _i4 != hkPackInt3( 2 ) );
    }

    // Array checks
    {
        hkArray<hkPackInt4> _i4s( 3 );
        _i4s[0] = hkPackInt4( 0 );
        HK_TEST( _i4s[0] == hkPackInt4( 0 ) );
        HK_TEST( _i4s[0] != hkPackInt4( 1 ) );
        _i4s[1] = hkPackInt4( 1 );
        _i4s[2] = hkPackInt4::maxValue();
        _i4s.pushBack( hkPackInt4::maxValue() );
        HK_TEST( _i4s.indexOf( hkPackInt4( 0 ) ) == 0 );
        HK_TEST( _i4s.indexOf( hkPackInt4( 1 ) ) == 1 );
        HK_TEST( _i4s.indexOf( hkPackInt4::maxValue() ) == 2 );
        HK_TEST( _i4s.lastIndexOf( hkPackInt4::maxValue() ) == 3 );
        HK_TEST( _i4s.indexOf( hkPackInt4( 2 ) ) == -1 );
    }
}

static void Pack()
{
    // These should not compile
#if 0
    {
        hkUint8 _i8 = Pack<hkUint8>( hkInt9(0) ); _i8;
        hkUint16 _i16 = Pack<hkUint16>( hkInt17(0) ); _i16;
        hkUint32 _i32 = Pack<hkUint32>( hkInt33(0) ); _i32;
    }
#endif

    // These should assert
    // (Ideally the wouldn't compile, but HK_COMPILE_TIME_ASSERT doesn't seem work with inlined static func return values
#if 0
    {
        hkUint8 _i8 = Pack<hkUint8>( hkUint8(0), hkInt1() ); _i8;
        hkUint16 _i16 = Pack<hkUint16>( hkUint16(), hkInt1(0) ); _i16;
        hkUint32 _i32 = Pack<hkUint32>( hkUint32(0), hkInt1() ); _i32;
        hkUint64 _i64 = Pack<hkUint64>( hkUint64(), hkInt1(0) ); _i64;
    }
    {
        hkUint8 _i8 = Pack<hkUint8>( hkInt7(), hkInt1(0), hkInt1() ); _i8;
        hkUint16 _i16 = Pack<hkUint16>( hkInt15(0), hkInt1(), hkInt1(0) ); _i16;
        hkUint32 _i32 = Pack<hkUint32>( hkInt31(), hkInt1(0), hkInt1() ); _i32;
        hkUint64 _i64 = Pack<hkUint64>( hkInt63(0), hkInt1(), hkInt1(0) ); _i64;
    }
#endif

    // These should not assert
    {
        hkUint8 _i8 = Pack<hkUint8>( hkInt8(0) ); _i8;
        hkUint16 _i16 = Pack<hkUint16>( hkInt16(0) ); _i16;
        hkUint32 _i32 = Pack<hkUint32>( hkInt32(0) ); _i32;
        hkUint64 _i64 = Pack<hkUint64>( hkInt64(0) ); _i64;
    }
    {
        hkUint8 _i8 = Pack<hkUint8>( hkPackInt7(0), hkPackInt1() ); _i8;
        hkUint16 _i16 = Pack<hkUint16>( hkPackInt15(), hkPackInt1(0) ); _i16;
        hkUint32 _i32 = Pack<hkUint32>( hkPackInt31(0), hkPackInt1() ); _i32;
        hkUint64 _i64 = Pack<hkUint64>( hkPackInt63(), hkPackInt1(0) ); _i64;
    }
    {
        hkUint8 _i8 = Pack<hkUint8>( hkPackInt6(), hkPackInt1(0), hkPackInt1() ); _i8;
        hkUint16 _i16 = Pack<hkUint16>( hkPackInt14(0), hkPackInt1(), hkPackInt1(0) ); _i16;
        hkUint32 _i32 = Pack<hkUint32>( hkPackInt30(), hkPackInt1(0), hkPackInt1() ); _i32;
        hkUint64 _i64 = Pack<hkUint64>( hkPackInt62(0), hkPackInt1(), hkPackInt1(0) ); _i64;
    }

    // These tests should pass
    {
        hkUint64 pack1 = Pack<hkUint64>( anyInt( 1 ) );
        hkUint64 pack2 = Pack<hkUint64>( anyInt( 1 ), anyInt( 2 ) );
        hkUint64 pack3 = Pack<hkUint64>( anyInt( 1 ), anyInt( 2 ), anyInt( 3 ) );
        hkUint64 pack4 = Pack<hkUint64>( anyInt( 1 ), anyInt( 2 ), anyInt( 3 ), anyInt( 4 ) );
        hkUint64 pack5 = Pack<hkUint64>( anyInt( 1 ), anyInt( 2 ), anyInt( 3 ), anyInt( 4 ), anyInt( 5 ) );
        hkUint64 pack6 = Pack<hkUint64>( anyInt( 1 ), anyInt( 32 ), anyInt( 16 ), anyInt( 8 ), anyInt( 2 ) );

        hkPackInt1 _i1; hkPackInt2 _i2; hkPackInt3 _i3; hkPackInt4 _i4; hkPackInt5 _i5;
        _i1 = hkPackInt1(0);
        Unpack( pack1, _i1 );
        HK_TEST( _i1 == 1 );
        _i1 = hkPackInt1(0); _i2 = hkPackInt1(0);
        Unpack( pack2, _i1, _i2 );
        HK_TEST( ( _i1 == 1 ) && ( _i2 == 2 ) );
        _i1 = hkPackInt1(0); _i2 = hkPackInt1(0); _i3 = hkPackInt1(0);
        Unpack( pack3, _i1, _i2, _i3 );
        HK_TEST( ( _i1 == 1 ) && ( _i2 == 2 ) && ( _i3 == 3 ) );
        _i1 = hkPackInt1(0); _i2 = hkPackInt1(0); _i3 = hkPackInt1(0); _i4 = hkPackInt1(0);
        Unpack( pack4, _i1, _i2, _i3, _i4 );
        HK_TEST( ( _i1 == 1 ) && ( _i2 == 2 ) && ( _i3 == 3 ) && ( _i4 == 4 ) );
        _i1 = hkPackInt1(0); _i2 = hkPackInt1(0); _i3 = hkPackInt1(0); _i4 = hkPackInt1(0); _i5 = hkPackInt1(0);
        Unpack( pack5, _i1, _i2, _i3, _i4, _i5 );
        HK_TEST( ( _i1 == 1 ) && ( _i2 == 2 ) && ( _i3 == 3 ) && ( _i4 == 4 ) && ( _i5 == 5 ) );
        hkInt32 _i32; hkInt16 _i16; hkInt8 _i8;
        Unpack( pack6, _i1, _i32, _i16, _i8, _i2 );
        HK_TEST( ( _i1 == 1 ) && ( _i32 == 32 ) && ( _i16 == 16 ) && ( _i8 == 8 ) && ( _i2 == 2 ) );
    }
    {
        hkUint64 pack1 = Pack<hkUint64>( anyInt( 64 ) );
        hkUint64 pack2 = Pack<hkUint64>( anyInt( 31 ), anyInt( 33 ) );
        hkUint64 pack3 = Pack<hkUint64>( anyInt( 20 ), anyInt( 21 ), anyInt( 23 ) );
        hkUint64 pack4 = Pack<hkUint64>( anyInt( 14 ), anyInt( 15 ), anyInt( 16 ), anyInt( 19 ) );
        hkUint64 pack5 = Pack<hkUint64>( anyInt( 10 ), anyInt( 11 ), anyInt( 12 ), anyInt( 13 ), anyInt( 18 ) );
        hkUint64 pack6 = Pack<hkUint64>( anyInt( 8 ), anyInt( 8 ), anyInt( 8 ), anyInt( 8 ), anyInt( 8 ) );

        hkInt64 _i64(0);
        Unpack( pack1, _i64 );
        HK_TEST( _i64 == 64 );
        hkPackInt31 _i31(0); hkPackInt33 _i33(0);
        Unpack( pack2, _i31, _i33 );
        HK_TEST( ( _i31 == 31 ) && ( _i33 == 33 ) );
        hkPackInt20 _i20(0); hkPackInt21 _i21(0); hkPackInt23 _i23(0);
        Unpack( pack3, _i20, _i21, _i23 );
        HK_TEST( ( _i20 == 20 ) && ( _i21 == 21 ) && ( _i23 == 23 ) );
        hkPackInt14 _i14(0); hkPackInt15 _i15(0); hkInt16 _i16(0); hkPackInt19 _i19(0);
        Unpack( pack4, _i14, _i15, _i16, _i19 );
        HK_TEST( ( _i14 == 14 ) && ( _i15 == 15 ) && ( _i16 == 16 ) && ( _i19 == 19 ) );
        hkPackInt10 _i10(0); hkPackInt11 _i11(0); hkPackInt12 _i12(0); hkPackInt13 _i13(0); hkPackInt18 _i18(0);
        Unpack( pack5, _i10, _i11, _i12, _i13, _i18 );
        HK_TEST( ( _i10 == 10 ) && ( _i11 == 11 ) && ( _i12 == 12 ) && ( _i13 == 13 ) && ( _i18 == 18 ) );
        hkInt8 _i8;
        Unpack( pack6, _i8, _i8, _i8, _i8, _i8 );
        HK_TEST( _i8 == 8 );
    }
}

int pack_main()
{
    AnyInt();
    Pack();
    return 0;
}

HK_TEST_REGISTER( pack_main, "Slow", "Common/Test/UnitTest/Base/", __FILE__ );

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
