// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/hkBase.h>
#include <Common/Base/UnitTest/hkUnitTest.h>
#include <Common/Base/Math/Matrix/hkMatrix4CameraUtil.h>

static void matrixCameraUtils()
{

    // Look At
    #if 0  // needs to be redone now that setLookAt produces view matrix rather than camera world transform
    {
        hkMatrix4 lookAt;
        hkVector4 from; from.set(0.f, 1.f, 2.f);
        hkVector4 to; to.set(0.f, 0.f, 0.f);
        hkVector4 up; up.set(1.f, 0.f, 0.f);

        hkMatrix4CameraUtil::setLookAt(from, to, up, lookAt);

        hkVector4 testDir; testDir.setSub(to, from); testDir.normalize<3>();
        hkVector4 testLeft; testLeft.setCross(up, testDir);
        hkVector4 testUp; testUp.setCross(testDir, testLeft);
        testDir.setW(hkSimdReal::getConstant<HK_QUADREAL_0>());
        testLeft.setW(hkSimdReal::getConstant<HK_QUADREAL_0>());
        testUp.setW(hkSimdReal::getConstant<HK_QUADREAL_0>());
        from.setW(hkSimdReal::getConstant<HK_QUADREAL_1>());
        hkSimdReal matTol = hkSimdReal::fromFloat(0.00001f);
        HK_TEST(lookAt.getColumn<0>().allEqual<4>(testDir, matTol));
        HK_TEST(lookAt.getColumn<1>().allEqual<4>(testLeft, matTol));
        HK_TEST(lookAt.getColumn<2>().allEqual<4>(testUp, matTol));
        HK_TEST(lookAt.getColumn<3>().allEqual<4>(from, matTol));

        hkVector4 pup; pup = testDir;
        hkMatrix4CameraUtil::setLookAt(from, to, pup, lookAt); // should pick different up

        HK_TEST(lookAt.getColumn<0>().allEqual<4>(testDir, matTol));
        HK_TEST(lookAt.getColumn<3>().allEqual<4>(from, matTol));

        // test up it chose is perp to its left and left is perp to dir etc
        hkSimdReal upDotDir = lookAt.getColumn<2>().dot<3>(testDir);
        hkSimdReal upDotLeft = lookAt.getColumn<2>().dot<3>(lookAt.getColumn<1>());
        hkSimdReal perpTol = hkSimdReal::fromFloat(0.00001f);
        HK_TEST(upDotDir.less(perpTol).allAreSet<hkVector4ComparisonMask::MASK_X>());
        HK_TEST(upDotLeft.less(perpTol).allAreSet<hkVector4ComparisonMask::MASK_X>());

    }
    #endif

#if defined(HK_REAL_IS_FLOAT)
    // Run the tests for both depth range variants, hkMatrix4CameraUtil::ClipSpaceDepthRange::MinusOneToOne and hkMatrix4CameraUtil::ClipSpaceDepthRange::ZeroToOne.
    for ( int i = 0; i < 2; ++i )
    {
        hkMatrix4CameraUtil::ClipSpaceDepthRange::Enum clipSpaceDepthRange = ( hkMatrix4CameraUtil::ClipSpaceDepthRange::Enum )i;
        hkReal depthRangeLowerLimit = clipSpaceDepthRange == hkMatrix4CameraUtil::ClipSpaceDepthRange::MinusOneToOne ? -1.0f : 0.0f;

        // Perspective
        {
            hkMatrix4f p;
            hkMatrix4CameraUtil::setPerspectiveProjectionFromFovX(90.0f, 640.0f / 480.0f, 2.0f, 100.0f, clipSpaceDepthRange, hkMatrix4CameraUtil::ClipSpaceYRange::MinusOneToOne, p);

            hkVector4f vn; vn.set(0, 0, -2.0f); // should be on near plane (looking along -z)
            hkVector4f tvn; p.transformPosition(vn, tvn);
            hkVector4f tvnw; tvnw.setAll(tvn.getComponent<3>());
            tvn.div(tvnw);
            hkSimdFloat32 perpTol = hkSimdFloat32::fromFloat(0.00001f);
            hkVector4f testTvn; testTvn.set(0, 0, depthRangeLowerLimit, 1.0f);
            HK_TEST(tvn.allEqual<4>(testTvn, perpTol));

            hkVector4f vf; vf.set(0, 0, -100.0f); // should be on far plane (looking along -z)
            hkVector4f tvf; p.transformPosition(vf, tvf);
            hkVector4f testTvf; testTvf.set(0, 0, 1.0f, 1.0f);
            hkVector4f tvfw; tvfw.setAll(tvf.getComponent<3>());
            tvf.div(tvfw);
            HK_TEST(tvf.allEqual<4>(testTvf, perpTol));

            hkVector4f v45; v45.set(5.0f, 0, -5.0f); // 45 degree angle (half of fov), should project back to right edge of camera
            hkVector4f tv45; p.transformPosition(v45, tv45);
            hkVector4f tv45w; tv45w.setAll(tv45.getComponent<3>());
            tv45.div(tv45w);
            HK_TEST( hkMath::equal(tv45(0), 1.0f, 0.0001f) );

            hkVector4f vm45; vm45.set(-40.0f, 0, -40.0f); // -45 degree angle (half of fov), should project back to left edge of camera
            hkVector4f tvm45; p.transformPosition(vm45, tvm45);
            hkVector4f tvm45w; tvm45w.setAll(tvm45.getComponent<3>());
            tvm45.div(tvm45w);
            HK_TEST(hkMath::equal(tvm45(0), -1.0f, 0.0001f));
        }

        // Ortho
        {
            hkMatrix4f o;
            hkMatrix4CameraUtil::setOrthographicProjection(-50.0f, 150.0f, -30.0f, 90.0f, 2.0f, 100.0f, clipSpaceDepthRange, hkMatrix4CameraUtil::ClipSpaceYRange::MinusOneToOne, o);

            hkVector4f vn; vn.set(50.0f, 30.0f, -2.0f); // should be on near plane, right in the middle
            hkVector4f tvn; o.transformPosition(vn, tvn);
            hkSimdFloat32 perpTol = hkSimdFloat32::fromFloat(0.00001f);
            hkVector4f testTvn; testTvn.set(0, 0, depthRangeLowerLimit, 1.0f);
            HK_TEST(tvn.allEqual<4>(testTvn, perpTol));

            hkVector4f vf; vf.set(150.0f, 30.0f, -100.0f); // should be on far plane, on the right hand side
            hkVector4f tvf; o.transformPosition(vf, tvf);
            hkVector4f testTvf; testTvf.set(1.0f, 0, 1.0f, 1.0f);
            HK_TEST(tvf.allEqual<4>(testTvf, perpTol));

            hkVector4f vt; vt.set(-50.0f, 90.0f, -51.0f); // should half way along z (so 0 as -1 to 1), on the left hand side, top
            hkVector4f tvt; o.transformPosition(vt, tvt);
            hkVector4f testTvt; testTvt.set(-1.0f, 1.0f, 0.5f * ( 1.0f + depthRangeLowerLimit ), 1.0f);
            HK_TEST(tvt.allEqual<4>(testTvt, perpTol));

        }
    }
#endif
}

int matrixCameraUtils_main()
{
    matrixCameraUtils();
    return 0;
}

HK_TEST_REGISTER(matrixCameraUtils_main, "Fast", "Common/Test/UnitTest/Base/", __FILE__     );

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
