// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Base/hkBase.h>
#include <Common/Base/Math/Vector/hkPackedVector3.h>
#include <Common/Base/UnitTest/hkUnitTest.h>



template< hkMathAccuracyMode ACC, typename VecType >
static void vector_divide_by_zero_impl()
{
#if defined(HK_ALLOW_FPU_EXCEPTION_CHECKING)
    // Not too concerned with the values here, just that they don't trigger FPU exceptions.
    VecType zero; zero.setZero();
    VecType x; x.setReciprocal(zero);
    x.setReciprocal(zero);
    x.setReciprocal<ACC, HK_DIV_SET_ZERO        >(zero);
    x.setReciprocal<ACC, HK_DIV_SET_ZERO_AND_ONE>(zero);
    x.setReciprocal<ACC, HK_DIV_SET_MAX         >(zero);
    x.setReciprocal<ACC, HK_DIV_SET_HIGH        >(zero);

    VecType y; y = VecType::getConstant< HK_QUADREAL_1 >();
    VecType z;
    z.setDiv(y, zero);
    z.setDiv<ACC, HK_DIV_SET_ZERO        >(y, zero);
    z.setDiv<ACC, HK_DIV_SET_ZERO_AND_ONE>(y, zero);
    z.setDiv<ACC, HK_DIV_SET_MAX         >(y, zero);
    z.setDiv<ACC, HK_DIV_SET_HIGH        >(y, zero);

    z = y; z.div(zero);
    z = y; z.div<ACC, HK_DIV_SET_ZERO        >(zero);
    z = y; z.div<ACC, HK_DIV_SET_ZERO_AND_ONE>(zero);
    z = y; z.div<ACC, HK_DIV_SET_MAX         >(zero);
    z = y; z.div<ACC, HK_DIV_SET_HIGH        >(zero);

    z.setSqrt(zero);
    z.setSqrt<ACC, HK_SQRT_SET_ZERO>(zero);

    z.setSqrtInverse(zero);
    z.setSqrtInverse<ACC, HK_SQRT_SET_ZERO>(zero);
#endif
}

static void vector_divide_by_zero()
{
    vector_divide_by_zero_impl<HK_ACC_FULL  , hkVector4f>();
    vector_divide_by_zero_impl<HK_ACC_23_BIT, hkVector4f>();
    vector_divide_by_zero_impl<HK_ACC_12_BIT, hkVector4f>();

    vector_divide_by_zero_impl<HK_ACC_FULL  , hkVector4d>();
    vector_divide_by_zero_impl<HK_ACC_23_BIT, hkVector4d>();
    vector_divide_by_zero_impl<HK_ACC_12_BIT, hkVector4d>();
}


template< hkMathAccuracyMode ACC, typename SimdRealType >
static void simdreal_divide_by_zero_impl()
{
#if defined(HK_ALLOW_FPU_EXCEPTION_CHECKING)
    // Not too concerned with the values here, just that they don't trigger FPU exceptions.
    SimdRealType zero; zero.setZero();
    SimdRealType x = zero;
    x.setReciprocal(zero);
    x.setReciprocal<ACC, HK_DIV_SET_ZERO        >(zero);
    x.setReciprocal<ACC, HK_DIV_SET_ZERO_AND_ONE>(zero);
    x.setReciprocal<ACC, HK_DIV_SET_MAX         >(zero);
    x.setReciprocal<ACC, HK_DIV_SET_HIGH        >(zero);

    SimdRealType y = SimdRealType::getConstant< HK_QUADREAL_1 >();
    SimdRealType z;
    z.setDiv(y, zero);
    z.setDiv<ACC, HK_DIV_SET_ZERO        >(y, zero);
    z.setDiv<ACC, HK_DIV_SET_ZERO_AND_ONE>(y, zero);
    z.setDiv<ACC, HK_DIV_SET_MAX         >(y, zero);
    z.setDiv<ACC, HK_DIV_SET_HIGH        >(y, zero);

    z = y; z.div(zero);
    z = y; z.div<ACC, HK_DIV_SET_ZERO        >(zero);
    z = y; z.div<ACC, HK_DIV_SET_ZERO_AND_ONE>(zero);
    z = y; z.div<ACC, HK_DIV_SET_MAX         >(zero);
    z = y; z.div<ACC, HK_DIV_SET_HIGH        >(zero);

    z = zero; z.sqrt();
    z = zero; z.sqrt<ACC, HK_SQRT_SET_ZERO>();

    z = zero; z.sqrtInverse();
    z = zero; z.sqrtInverse<ACC, HK_SQRT_SET_ZERO>();
#endif
}

static void simdreal_divide_by_zero()
{
    simdreal_divide_by_zero_impl<HK_ACC_FULL  , hkSimdFloat32>();
    simdreal_divide_by_zero_impl<HK_ACC_23_BIT, hkSimdFloat32>();
    simdreal_divide_by_zero_impl<HK_ACC_12_BIT, hkSimdFloat32>();

    simdreal_divide_by_zero_impl<HK_ACC_FULL  , hkSimdDouble64>();
    simdreal_divide_by_zero_impl<HK_ACC_23_BIT, hkSimdDouble64>();
    simdreal_divide_by_zero_impl<HK_ACC_12_BIT, hkSimdDouble64>();
}

int divideByZero_main()
{
    vector_divide_by_zero();
    simdreal_divide_by_zero();
    return 0;
}

HK_TEST_REGISTER(divideByZero_main, "Fast", "Common/Test/UnitTest/Base/", "UnitTest/Math/Linear/divideByZero.cpp"     );

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
