// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Base/hkBase.h>
#include <Common/Base/UnitTest/hkUnitTest.h>

// Not Linux32 FPU
#if defined(HK_COMPILER_HAS_INTRINSICS_IA32) && !( defined(HK_PLATFORM_LINUX) && !defined(HK_ARCH_X64) && HK_CONFIG_SIMD == HK_CONFIG_SIMD_DISABLED )
#       if defined(HK_PLATFORM_PS4)
#           include <emmintrin.h>
#       elif defined(HK_COMPILER_MSVC)
#           include <intrin.h>
#       else
#           include <xmmintrin.h>
#       endif

void test( double autoD )
{
    float autoF = (float)autoD;
    hkInt64 autoDHex = *reinterpret_cast<hkInt64*>(&autoD);
    hkInt32 autoFHex = *reinterpret_cast<hkInt32*>(&autoF);
    hkInt32 manualFHex = hkMath::doubleToFloat( autoDHex );
    HK_TEST( autoFHex == manualFHex );
}

#       ifdef HK_COMPILER_CLANG
// They get optimized into infinite loops...
template<hkUint32 INCREMENT, hkUint32 START, hkUint32 END>
void doubleToFloatWithFloat() __attribute__ ((optnone));
template<hkUint64 INCREMENT, hkUint64 START, hkUint64 END>
void doubleToFloatWithDouble() __attribute__ ((optnone));
template<hkUint64 START, hkUint64 END>
void doubleToFloatWithDoubleShift() __attribute__ ((optnone));
#       endif

template<hkUint32 INCREMENT, hkUint32 START, hkUint32 END>
void doubleToFloatWithFloat()
{
    for( hkUint32 i = START, n = END - INCREMENT; i <= n; i += INCREMENT )
    {
        test( (double)*reinterpret_cast<float*>(&i) );
    }
}

template<hkUint64 INCREMENT, hkUint64 START, hkUint64 END>
void doubleToFloatWithDouble()
{
    for( hkUint64 i = START, n = END - INCREMENT; i <= n; i += INCREMENT )
    {
        test( *reinterpret_cast<double*>(&i) );
    }
}

template<hkUint64 START, hkUint64 END>
void doubleToFloatWithDoubleShift()
{
    for( hkUint64 i = 0, s = 1, n = END - START; i < n; s = s << 1 )
    {
        test( *reinterpret_cast<double*>(&i) );
        if( (n - i) >= s )
        {
            i += s;
        }
        else
        {
            break;
        }
    }
}

void specialCasesFromDouble()
{
    doubleToFloatWithDouble<0x1000000000000000, 0x0FFFFFFFF0000000, 0xFFFFFFFFF0000000>(); // Rounding tests
    doubleToFloatWithDouble<0x1000000000000000, 0x0FFFFFFF10000000, 0xFFFFFFFF10000000>(); // Rounding tests
    doubleToFloatWithDouble<0x1000000000000000, 0x0FFFFFFF00000000, 0xFFFFFFFF00000000>(); // Rounding tests
    doubleToFloatWithDouble<0x1000000000000000, 0x0FFFFFFF0FFFFFFF, 0xFFFFFFFF0FFFFFFF>(); // Rounding tests
    doubleToFloatWithDouble<0x1000000000000000, 0x0FFFFFFFFFFFFFFF, 0xFFFFFFFFFFFFFFFF>(); // Rounding tests
    doubleToFloatWithDouble<0x0001000000000000, 0x3600FFFFFFFFFFFF, 0x36FFFFFFFFFFFFFF>(); // Exponent tests
    doubleToFloatWithDoubleShift<0x0000000000000000, 0xFFFFFFFFFFFFFFFF>(); // General tests
}

template<typename T>
void setDenormalFlushOffScope( T* func )
{
#       if ( defined(_MSC_VER) && (_MSC_VER >= 1700) ) || defined(HK_PLATFORM_PS4) || defined(HK_PLATFORM_MAC) || ((defined(HK_PLATFORM_ANDROID) || defined(HK_PLATFORM_LINUX)) && defined(HK_COMPILER_CLANG))
    auto mode = _MM_GET_FLUSH_ZERO_MODE();
#       else
#           if defined(HK_COMPILER_MSVC)
#               define DUMMY_ARG 1
#           else
#               define DUMMY_ARG
#           endif
    auto mode = _MM_GET_FLUSH_ZERO_MODE( DUMMY_ARG );
#       endif

    _MM_SET_FLUSH_ZERO_MODE( _MM_FLUSH_ZERO_OFF );
    func();
    _MM_SET_FLUSH_ZERO_MODE( mode );
}

int doubleToFloatFullMain()
{
    // Checks every single possible double value
    setDenormalFlushOffScope( doubleToFloatWithDouble<0x0000000000000001, 0x0000000000000000, 0xFFFFFFFFFFFFFFFF> );
    return 0;
}

int doubleToFloatVerySlowMain()
{
    // Checks every single possible float value
    setDenormalFlushOffScope( doubleToFloatWithFloat<0x1, 0x0, 0xFFFFFFFF> );
    return 0;
}

int doubleToFloatSlowMain()
{
    setDenormalFlushOffScope( doubleToFloatWithFloat<0xe7, 0x0, 0xFFFFFFFF> );
    return 0;
}

int doubleToFloatFastMain()
{
    setDenormalFlushOffScope( specialCasesFromDouble );
    return 0;
}

#else

int doubleToFloatFastMain()
{
    return 0;
}

int doubleToFloatSlowMain()
{
    return 0;
}

#endif

HK_TEST_REGISTER( doubleToFloatFastMain, "Fast", "Common/Test/UnitTest/Base/", "UnitTest/Math/DoubleToFloat.cpp(FAST)" );
HK_TEST_REGISTER( doubleToFloatSlowMain, "Slow", "Common/Test/UnitTest/Base/", "UnitTest/Math/DoubleToFloat.cpp(SLOW)" );
//HK_TEST_REGISTER( doubleToFloatVerySlowMain, "Very Slow", "Common/Test/UnitTest/Base/", "UnitTest/Math/DoubleToFloat.cpp(VERY SLOW)" ); // Takes around a minute...
//HK_TEST_REGISTER( doubleToFloatFullMain, "Very Slow", "Common/Test/UnitTest/Base/", "UnitTest/Math/DoubleToFloat.cpp(Full)" ); // Takes around a day...

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
