// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/hkBase.h>
#include <Common/Base/UnitTest/hkUnitTest.h>
#include <Common/Base/Container/Tuple/hkTuple.h>

namespace HK_UNITY_ANONYMOUS_NAMESPACE
{
    struct Test1
    {
        int a;
        float b;
    };
    HK_COMPILE_TIME_ASSERT(sizeof(hkTuple<int, float>) == sizeof(Test1));

    struct Test2
    {
        int* a;
        double b;
        char c;
    };
    HK_COMPILE_TIME_ASSERT(sizeof(hkTuple<int*, double, char>) == sizeof(Test2));

    struct Test3
    {
        hkUint16 a;
        Test2 b;
    };
    HK_COMPILE_TIME_ASSERT(sizeof(hkTuple<hkUint16, Test2>) == sizeof(Test3));

    struct A
    {
        A() {}
    };

    struct B
    {
        B() {}
        B(hkReflect::BypassCtorFlag) {}
    };
}

int tuple_main()
{
    HK_UNITY_USING_ANONYMOUS_NAMESPACE;
    {
        hkTuple<int, float> tuple(5, 5.6f);
        int a = tuple.m_0;
        HK_TEST(a == 5);
        float b = tuple.m_1;
        HK_TEST(b == 5.6f);
        HK_TEST(hkTupleT::get<0>(tuple) == tuple.m_0);
        HK_TEST(hkTupleT::get<1>(tuple) == tuple.m_1);
    }

    {
        hkTuple<double, char, char, char, char> tuple(3.0f, 'a', 'b', 0, 0);

        char c = tuple.m_2;
        HK_TEST(c == 'b');
        tuple.m_4 = 'd';
        c = tuple.m_4;
        HK_TEST(c == 'd');
        HK_TEST(hkTupleT::get<0>(tuple) == tuple.m_0);
        HK_TEST(hkTupleT::get<1>(tuple) == tuple.m_1);
        HK_TEST(hkTupleT::get<2>(tuple) == tuple.m_2);
        HK_TEST(hkTupleT::get<3>(tuple) == tuple.m_3);
        HK_TEST(hkTupleT::get<4>(tuple) == tuple.m_4);
    }

    {
        hkTuple<char, char, char, char, char, char, char, char> tuple;

        HK_TEST(&hkTupleT::get<0>(tuple) == &tuple.m_0);
        HK_TEST(&hkTupleT::get<1>(tuple) == &tuple.m_1);
        HK_TEST(&hkTupleT::get<2>(tuple) == &tuple.m_2);
        HK_TEST(&hkTupleT::get<3>(tuple) == &tuple.m_3);
        HK_TEST(&hkTupleT::get<4>(tuple) == &tuple.m_4);
        HK_TEST(&hkTupleT::get<5>(tuple) == &tuple.m_5);
        HK_TEST(&hkTupleT::get<6>(tuple) == &tuple.m_6);
        HK_TEST(&hkTupleT::get<7>(tuple) == &tuple.m_7);
    }

#if 0 // Re-enable when pointerfinder is merged
    {
        int a = 0;
        hkTuple<int*, float> tuple(&a, 0.4f);
        hkArray<hkPointerFinder::Pointer>::Temp pointers;

        const hkReflect::Type* type = hkReflect::getType< hkTuple<int*, float> >();
        const hkReflect::RecordType* recordType = type->asRecord();
        HK_TEST(recordType->getNumFields() == 2);
        hkPointerFinder::getPointers(&tuple, hkPointerFinder::FLAGS_DEFAULT, pointers);
        HK_TEST(pointers.getSize() == 1);
        HK_TEST(pointers[0].get().getAddress() == tuple.m_0);
    }
#endif

    {
        // Check that the tuple can be properly constructed with the finish loaded object flag.
//      hkReflect::BypassCtorFlag flag;
//      hkTuple<A, B, float, int> t(flag);
    }

    return 0;
}

HK_TEST_REGISTER(tuple_main, "Fast", "Common/Test/UnitTest/Base/", __FILE__     );

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
