// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/hkBase.h>
#include <Common/Base/UnitTest/hkUnitTest.h>
#include <Common/Base/Reflect/Util/hkReflectClone.h>
#include <Common/Base/UnitTest/Cloning/CloneTestClasses.h>
#include <Common/Base/UnitTest/Cloning/CloneTest.h>

static hkReflect::Var cloneTest(const char* testName, const hkReflect::Var& root)
{
    hkReflect::Var res = hkReflect::Cloner().cloneVarRecursive(root);
    // hack: keep alive root object
    if (hkReferencedObject* refObj = res.dynCast<hkReferencedObject>())
    {
        refObj->addReference();
    }
    return res;
}

static int reflect_clone_test()
{
    bool testEnabled = true;

    if( testEnabled )
    {
        UnitTest::Cloning::test(&cloneTest);
    }

    hkReflect::Detail::CloneOnHeap cb;

    if( testEnabled )
    {
        // unhandled conversion double->hkStringPtr
        UnitTest::ClassTest0 src;
        // Because the clone fails, the output is not constructed and is left in an
        // indeterminate state, it can not be destructed
        unsigned char dst[hkSizeOf(UnitTest::ClassTest1)];
        hkReflect::Var vsrc(&src);
        hkReflect::Var vdst(&dst, hkReflect::getType<UnitTest::ClassTest1>());
        {
            // Compilation failed
            UnitTest::Raii::CaptureThreadLogOutput captureOutput;
            hkReflect::Var res = hkReflect::Detail::cloneVarInto(vdst, vsrc, cb);
            HK_TEST(!res);
        }

    }

    if( testEnabled )
    {
        // conversions between pointers - derived to base is OK
        UnitTest::ClassTest2 ptd;
        UnitTest::ClassTest2 src; src.m_field0 = &ptd;
        UnitTest::ClassTest3 dst;
        hkReflect::Var vsrc(&src);
        hkReflect::Var vdst(&dst);
        hkReflect::Var res = hkReflect::Detail::cloneVarInto(vdst, vsrc, cb);
        HK_TEST( res );
    }

    if( testEnabled )
    {
        // conversions between pointers - base to derived is not OK
        hkReferencedObject ptd;
        UnitTest::ClassTest3 src; src.m_field0 = &ptd;
        // As above, the clone fails so we can not destruct this object
        unsigned char dst[hkSizeOf(UnitTest::ClassTest2)];
        hkReflect::Var vsrc(&src);
        hkReflect::Var vdst(&dst, hkReflect::getType<UnitTest::ClassTest2>());
        UnitTest::Raii::CaptureThreadLogOutput captureOutput;
        hkReflect::Var res = hkReflect::Detail::cloneVarInto(vdst, vsrc, cb);
        HK_TEST( !res );
    }

    if ( testEnabled )
    {
        UnitTest::ConversionTest0 src;
        UnitTest::ConversionTest1 dst;

        hkReflect::Var vdst( &dst );
        hkReflect::Detail::cloneVarInto( vdst, &src, cb );
        if ( HK_TEST( vdst ) )
        {
            HK_TEST_EQ( src.m_smallToLarge, dst.m_smallToLarge );
            HK_TEST_EQ( src.m_largeToSmall, dst.m_largeToSmall );
            HK_TEST_EQ( (bool)src.m_intToBool, dst.m_intToBool );
            HK_TEST_EQ( src.m_boolToInt, (bool)dst.m_boolToInt );
            HK_TEST_EQ( (bool)src.m_boolToBool, (bool)dst.m_boolToBool );
            HK_TEST_EQ( src.m_floatToDouble, dst.m_floatToDouble );
            HK_TEST_EQ( src.m_doubleToFloat, dst.m_doubleToFloat );
        }
    }
    return 0;
}

HK_TEST_REGISTER(reflect_clone_test, "Fast", "Common/Test/UnitTest/Base/", __FILE__);

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
