// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL !ANDROID
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/UnitTest/hkUnitTest.h>
#include <Common/Base/Reflect/Impl/Std/hkReflectStd.h>

namespace UnitTest
{

struct TestVector
{
    HK_DECLARE_CLASS(TestVector, New, Reflect);
    HK_RECORD_ATTR(hk::Retargetable(false));
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);

    //~TestVector() {}

    std::vector<hkUint16> m_vec;
};

struct TestString
{
    HK_DECLARE_CLASS(TestString, New, Reflect);
    HK_RECORD_ATTR(hk::Retargetable(false));
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);
    //~TestString() {}

    std::string m_str;
};

struct TestVectorString
{
    HK_DECLARE_CLASS(TestVectorString, New, Reflect);
    HK_RECORD_ATTR(hk::Retargetable(false));
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);

    std::vector<std::string> m_vecStr;
};

struct TestComplicated
{
    HK_DECLARE_CLASS(TestComplicated, New, Reflect);
    HK_RECORD_ATTR(hk::Retargetable(false));
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);

    struct NestedRef : public hkReferencedObject
    {
        HK_DECLARE_CLASS(NestedRef, New, Reflect, BypassCtor);
        HK_RECORD_ATTR(hk::Retargetable(false));
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);

        NestedRef() {}
        std::string m_name;
        hkArray<int> m_data;
    };

    struct Nested
    {
        HK_DECLARE_CLASS(Nested, New, Reflect, BypassCtor);
        HK_RECORD_ATTR(hk::Retargetable(false));
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);

        Nested(NestedRef* nr = HK_NULL, const char* n = HK_NULL) : m_ref(nr), m_containerName(n) {}
        hkRefPtr<NestedRef> m_ref;
        hkStringPtr m_containerName;
    };

    std::vector<std::string> m_names;
    std::vector<Nested> m_nests;
    NestedRef* m_root;
};

}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
