// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/UnitTest/hkUnitTest.h>

#include <Common/Base/Container/RelArray/hkRelArray.h>
#include <Common/Base/Container/Tuple/hkTuple.h>
#include <Common/Base/Container/Array/hkVariantArray.h>
#include <Common/Base/Container/Hash/hkHashMap.h>
#include <Common/Base/Container/Hash/hkHashSet.h>

#ifdef HK_PLATFORM_ANDROID
#define HK_NO_STL_TESTS
#else
#include <Common/Base/UnitTest/Cloning/CloneTestClassesStl.h>
#endif

#if defined(HK_BUILDING_WITH_ENGINE)
#include <Common/NewBase/UnitTest/Types/DynamicFieldTest.h> 
#endif

struct hkGeometry;

namespace UnitTest
{

class hkTestGeometryContainer
{
public:
    HK_DECLARE_CLASS(hkTestGeometryContainer, New, Reflect);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);

    hkStringPtr m_name;
    struct hkGeometry* m_obj;
    class hkTestGeometryContainer* m_link;
    hkInt32 m_a_member;
};

class hkTestRecursive
{
public:
    HK_DECLARE_CLASS(hkTestRecursive, New, Reflect);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);

    struct Nested
    {
        HK_DECLARE_CLASS(Nested, New, Reflect);
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);
        double m_double0;
        hkTestRecursive* m_ptr;
        hkLong m_array[2];
        hkReal m_real;
    };

    hkTestRecursive()
    {
        m_int0 = 0xaaaa;
        m_u64 = 0xffffffffffffffffULL;
        m_nested.m_double0 = -123456.0;
        m_nested.m_real = 3.14;
        m_nested.m_ptr = this;
        m_nested.m_array[0] = 22;
        m_nested.m_array[1] = -55;
        m_ulong = 0x01020304;
        m_bool32.m_storage = 0;
        m_someOtherBool = true;
        m_real = 1.23456f;
        m_vector.set(0.0f, 0.1f, 0.2f, 0.3f);
    }

    int m_int0;
    char m_nonSerializable HK_ATTR( hk::Serialize( false ) );
    hkUint64 m_u64;
    Nested m_nested;
    hkUlong m_ulong;
    hkReal m_real;
    hkBool32Le m_bool32;
    bool m_someOtherBool;
    hkVector4 m_vector;
};

class hkTestRelArray : public hkReferencedObject
{
public:
    HK_DECLARE_CLASS(hkTestRelArray, New, Reflect, BypassCtor);
    HK_RECORD_ATTR( hk::ContainsRelArrays );
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);
    hkTestRelArray() {}

    static hkTestRelArray* create();

    hkRelArray<int> m_array;
};

class hkTFEmbedType
{
public:
    //+version(2)
    HK_DECLARE_CLASS(hkTFEmbedType, New, Reflect);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);
    //int m_emb_a; // Removed in 1->2
    int m_emb_b; //+default(0xeebbeebb)
};

class hkTFSecondEmbedType
{
public:
    //+version(1)
    HK_DECLARE_CLASS(hkTFSecondEmbedType, New, Reflect);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);
    int m_emb_c; //+default(0xeecceecc)

    class hkTFTestNewPatching* m_tnp;
};

class hkTFPatchParent
{
public:
    //+version(0)
    HK_DECLARE_CLASS(hkTFPatchParent, New, Reflect);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);

    hkReal m_mem; //+default(2.0)
};

class hkTFTestNewPatching : public hkTFPatchParent
{
public:
    //+version(4)
    HK_DECLARE_CLASS(hkTFTestNewPatching, New, Reflect);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);
    int m_a; //+default(0xaaaaaaaa)
    hkTFEmbedType m_embed;
    int m_e; //+default(0xeeeeeeee)
    int m_add_rem_add; //+default(0xaaddaadd)
    hkTFSecondEmbedType m_embed2;
    hkTFSecondEmbedType* m_embedPtr;
    hkTFEmbedType* m_ptr;
    hkMatrix3* m_matPtr;
    int m_array[4];
};

struct CustomArrayType_Impl;
extern const CustomArrayType_Impl CustomArrayType_impl;

template<typename T>
struct CustomArrayType
{
    HK_DECLARE_CLASS(CustomArrayType, New, Reflect, NonCopyable);
    HK_RECORD_ATTR(hk::ReflectDetails(fields = true));
    HK_REFLECT_AS_ARRAY(&UnitTest::CustomArrayType_impl, T);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);

    CustomArrayType() : m_pad0(0x0101), m_data(HK_NULL), m_pad1(0x1111), m_size(0), m_pad2(0x2121), m_afterReflectNewCalled(false), m_dontDeallocate(false) {}
    ~CustomArrayType() { if ( !m_dontDeallocate) { hkMemDebugBlockFree<T>(m_data, m_size); } }

    int getSize() { return m_size; }
    T& operator[] (int i) { return m_data[i]; }
    void setSize(int newSize)
    {
        T* d = hkMemDebugBlockAlloc<T>(newSize);
        hkMemUtil::memCpy(d, m_data, hkMath::min2<int>(newSize,m_size));
        hkMemUtil::memSet(d + m_size, 0, (newSize - m_size) * sizeof(T));
        hkMemDebugBlockFree<T>(m_data, m_size);
        m_data = d;
        m_size = hkInt16(newSize);
    }
    HK_NEVER_INLINE void afterReflectNew() { m_afterReflectNewCalled = true; }

    hkUlong m_pad0; // we insert padding to make offsets & sizes differ
    T* m_data;
    hkUlong m_pad1;
    hkInt16 m_size;
    hkUlong m_pad2;
    bool m_afterReflectNewCalled;
    bool m_dontDeallocate;
};

struct EmptyClass0 : public hkReferencedObject
{
    HK_DECLARE_CLASS(EmptyClass0, New, Reflect, BypassCtor);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);
    EmptyClass0() {}
    int getIntVal() const { return 10; }
    HK_PROPERTY(ival, getIntVal);
};
struct EmptyClass1 : public hkReferencedObject
{
    HK_DECLARE_CLASS(EmptyClass1, New, Reflect, BypassCtor);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);
    EmptyClass1() {}
};
struct WithEmpty : public hkReferencedObject
{
    HK_DECLARE_CLASS(WithEmpty, New, Reflect, BypassCtor);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);
    WithEmpty() {}
    hkRefPtr<EmptyClass0> m_0;
    hkRefPtr<EmptyClass1> m_1;
};

class SemanticArrayTest
{
public:
    HK_DECLARE_CLASS(SemanticArrayTest, New, Reflect, BypassCtor);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);

    CustomArrayType<hkTFEmbedType> m_embedTypeArray;
    CustomArrayType<int> m_emptyArray;
    CustomArrayType<int> m_simpleArray;
    CustomArrayType<hkReal> m_realArray;
    CustomArrayType<hkUint8> m_realSize;

    SemanticArrayTest()
    {
    }
};

class NativeArrayTest
{
public:
    HK_DECLARE_CLASS(NativeArrayTest, New, Reflect, BypassCtor);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);
    NativeArrayTest() {}
    hkArray<hkTFEmbedType> m_embedTypehkArray;
    hkArray<int> m_emptyArray;
    hkArray<int> m_simpleArray;
    hkArray<hkReal> m_realArray;
};

class StringTest
{
public:
    HK_DECLARE_CLASS(StringTest, New, Reflect, BypassCtor);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);

    hkStringPtr m_emptyString;
    hkStringPtr m_string1;
    hkStringPtr m_string2;
    hkStringPtr m_emptyStringAgain;
    hkStringPtr m_string1again;
    hkStringPtr m_nullString;
    hkStringPtr m_literallyNull;
    hkArray<hkStringPtr> m_stringArray;

    StringTest()
        : m_emptyString("")
        , m_string1("string1")
        , m_string2("string2")
        , m_string1again("string1")
        , m_literallyNull("null")
    {
        // tests a non-static empty string
        char s[1];
        s[0] = 0;
        m_emptyStringAgain = s;
    }
};

class ArrayTestElem
{
public:
    HK_DECLARE_CLASS(ArrayTestElem, New, Reflect, BypassCtor);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);

    hkStringPtr m_name;
    hkArray<hkStringPtr> m_strings;

    ArrayTestElem() {}
    ArrayTestElem(const ArrayTestElem& other) : m_name(other.m_name)
    {
        m_strings.append(other.m_strings);
    }
};

class ArrayTestParent
{
public:
    HK_DECLARE_CLASS(ArrayTestParent, New, Reflect, BypassCtor);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);

    hkArray<ArrayTestElem> m_array;

    ArrayTestParent() {}
    ArrayTestParent(const ArrayTestParent& other)
    {
        m_array.append(other.m_array);
    }
};

class ArrayTest : public ArrayTestParent
{
public:
    HK_DECLARE_CLASS(ArrayTest, New, Reflect, BypassCtor);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);

    hkStringPtr m_name;

    ArrayTest() {}
};

class EmbedWithVtable : public hkReferencedObject
{
public:
    HK_DECLARE_CLASS(EmbedWithVtable, New, Reflect);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);

    float m_float;

    EmbedWithVtable() {}
    EmbedWithVtable(float f) : m_float(f) {}

    void set(float f) { m_float = f; }
};

struct ArrayOfVirtuals
{
    HK_DECLARE_CLASS(ArrayOfVirtuals, New, Reflect);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);
    int m_memA;
    hkArray<EmbedWithVtable> m_arr;

    ArrayOfVirtuals() {}
    ArrayOfVirtuals(const ArrayOfVirtuals& other) : m_memA(other.m_memA) { m_arr.append(other.m_arr); }
};

struct ArrayOfArrayOfVirtuals
{
    HK_DECLARE_CLASS(ArrayOfArrayOfVirtuals, New, Reflect);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);
    int m_memA;
    hkArray<ArrayOfVirtuals> m_arr;

    ArrayOfArrayOfVirtuals() {}
};

struct TupleTest
{
    HK_DECLARE_CLASS(TupleTest, New, Reflect);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);

    struct NestedFinishCtor
    {
        HK_DECLARE_CLASS(NestedFinishCtor, New, Reflect, BypassCtor);
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);
        NestedFinishCtor() : m_field(0) {} // must be default constructible to live in a tuple.

        int m_field;
    };

    struct NestedNonFinishCtor
    {
        HK_DECLARE_CLASS(NestedNonFinishCtor, New, Reflect);
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);
        NestedNonFinishCtor() : m_field(0) {} // must be default constructible to live in a tuple.

        int m_field;
    };

    TupleTest() {}

    hkTuple<int, float> m_tuple1;
    hkTuple<NestedFinishCtor, NestedNonFinishCtor> m_tuple2;
    hkUint16 m_integer;
};

template< typename T >
struct TemplateTest_A
{
    HK_DECLARE_CLASS(TemplateTest_A, New, Reflect);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);

    TemplateTest_A() {}

    T m_t;
};

struct TemplateTest_B : public TemplateTest_A<int>
{
    HK_DECLARE_CLASS(TemplateTest_B, New, Reflect);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);

    TemplateTest_B() {}

    TemplateTest_A<double> m_dA;
};

struct TypeCycleTest_Y;

struct TypeCycleTest_Base
{
    HK_DECLARE_CLASS(TypeCycleTest_Base, New, Reflect);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);

    TypeCycleTest_Base() {}

    hkViewPtr<TypeCycleTest_Y> m_y;
    int m_int;
};

struct TypeCycleTest_A : public TypeCycleTest_Base
{
    HK_DECLARE_CLASS(TypeCycleTest_A, New, Reflect);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);

    TypeCycleTest_A() {}

    double m_double;
};

struct TypeCycleTest_X : public TypeCycleTest_Base
{
    HK_DECLARE_CLASS(TypeCycleTest_X, New, Reflect, BypassCtor);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);

    TypeCycleTest_X() {}
};

struct TypeCycleTest_Y : public TypeCycleTest_X
{
    HK_DECLARE_CLASS(TypeCycleTest_Y, New, Reflect, BypassCtor);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);

    TypeCycleTest_Y() {}
    hkUint16 m_shortInt;
};


struct VariantArrayTest
{
    HK_DECLARE_CLASS(VariantArrayTest, New, Reflect);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);
    VariantArrayTest() {}
    hkVariantArray m_array;
};


struct CArrayOfhkArray : public hkReferencedObject
{
    HK_DECLARE_CLASS(CArrayOfhkArray, New, Reflect, EmptyCtor);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);

    hkArray<int> m_arrays[3];
};

struct WithTypeRef
{
    HK_DECLARE_CLASS(WithTypeRef, New, Reflect, EmptyCtor);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);
    float m_float;
    UnitTest::StringTest* m_string;
    hkReflect::QualType m_type0;
    hkReflect::QualType m_type1;
    hkReflect::QualType m_type2;
    hkReflect::QualType m_type3;
    const hkReflect::Type* m_type4;

    hkReflect::FieldDecl m_decl0;
    hkReflect::FieldDecl m_decl1;
    hkReflect::FieldDecl m_decl2;
    hkReflect::FieldDecl m_decl3;
    hkReflect::FieldDecl m_decl4;
    hkReflect::FieldDecl m_decl5;
};

struct WithProperty
{
    HK_DECLARE_CLASS(WithProperty, New, Reflect);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);
    WithProperty() : m_id(0) {}
    WithProperty(const char* name) : m_id(0) { if(name) registerName(name); }

    hkUint32 m_id
        HK_ATTR(hk::Serialize(false));

    const char* getName() const;
    HK_PROPERTY(name, getName, registerName)
        HK_ATTR(hk::Serialize(true));

    int getProp() const { return m_id; }
    HK_PROPERTY( prop, getProp );

protected:
    void registerName(const char*);
};

class NonReflectedTest
{
public:
    HK_DECLARE_CLASS(NonReflectedTest, New);
    int m_a;
};


class OpaqueTest
{
    public:
        HK_DECLARE_CLASS(OpaqueTest, New, Reflect);
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);

        OpaqueTest() : m_nrPtr(HK_NULL) {}

        void afterReflectNew()
        {
            m_nrPtr = new NonReflectedTest;
            m_nrPtr->m_a = (int)m_f;
            m_nrArray.expandOne().m_a = (int)m_f * 2;
        }

        ~OpaqueTest()
        {
            // [COM-4136] We have to manually call this out-of-line to avoid
            // triggering undefined behavior when this object is in-place unloaded
            m_nrArray.clearAndDeallocate();
            delete m_nrPtr;
        }

        float m_f;
        NonReflectedTest* m_nrPtr
            HK_ATTR(hk::OpaqueType);
        hkArray<NonReflectedTest> m_nrArray
            HK_ATTR(hk::OpaqueType);
};

class Ref0 : public hkReferencedObject
{
    public:
        HK_DECLARE_CLASS(Ref0, New, Reflect, BypassCtor);
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);
        Ref0() {}
        int m_i0;
        double m_d;
};

class Ref1 : public hkReferencedObject
{
    public:
        HK_DECLARE_CLASS(Ref1, New, Reflect, BypassCtor);
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);
        Ref1() {}
        hkStringPtr m_s;
};

struct TestDynamic
{
    HK_DECLARE_CLASS(TestDynamic, New, Reflect);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);

    hkStringPtr m_name;
    hkVariantArray m_data;
};

struct TestCharArray
{
public:
    HK_DECLARE_CLASS(TestCharArray, New, Reflect);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);

    char m_chars[60];
};


struct ClassTest0
{
    HK_DECLARE_CLASS(ClassTest0, New, Reflect);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);
    double m_field0;
};

struct ClassTest1
{
    HK_DECLARE_CLASS(ClassTest1, New, Reflect, BypassCtor);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);
    ClassTest1() {}
    hkStringPtr m_field0;
};

struct ClassTest2 : public hkReferencedObject
{
    HK_DECLARE_CLASS(ClassTest2, New, Reflect, BypassCtor);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);
    ClassTest2() {}
    hkRefPtr<ClassTest2> m_field0;
};

struct ClassTest3 : public hkReferencedObject
{
    HK_DECLARE_CLASS(ClassTest3, New, Reflect, BypassCtor);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);
    ClassTest3() {}
    hkRefPtr<hkReferencedObject> m_field0;
};

template<typename KEY>
struct ClassWithHashMap : public hkReferencedObject
{
    HK_DECLARE_CLASS(ClassWithHashMap, New, Reflect, EmptyCtor);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);

    ClassWithHashMap( hkArrayView<KEY> keys )
    {
        for ( int i = 0; i < keys.getSize(); ++i )
        {
            m_keys.pushBack( keys[i] );
            m_hashMap.insert( keys[i], i );
            m_hashSet.insert( keys[i] );
        }
    }

    // This lets us relate keys in original and loaded versions.
    hkArray< KEY > m_keys;

    typedef hkHashMap<KEY, int> HashMap;
    typedef hkHashSet<KEY> HashSet;
    HashMap m_hashMap;
    HashSet m_hashSet;

};

struct ClassWithClassWithHashMap : public hkReferencedObject
{
    HK_DECLARE_CLASS(ClassWithClassWithHashMap, New, Reflect);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);

    ClassWithClassWithHashMap() {}
    ClassWithClassWithHashMap(hkArrayView<int> keys)
        : m_rec(keys)
    {}

    ClassWithHashMap<int> m_rec;
};

struct ClassWithArrayOfClassWithClassWithHashMap : public hkReferencedObject
{
    HK_DECLARE_CLASS(ClassWithArrayOfClassWithClassWithHashMap, New, Reflect);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);

    ClassWithArrayOfClassWithClassWithHashMap() {}
    ClassWithArrayOfClassWithClassWithHashMap(hkArrayView<int> keys)
    {
        m_arr.pushBack(ClassWithClassWithHashMap(keys));
    }

    hkArray<ClassWithClassWithHashMap> m_arr;
};

struct AfterReflect
{
    HK_DECLARE_CLASS(AfterReflect, New, Reflect);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);

    AfterReflect() : m_i(-1) {}
    ~AfterReflect()
    {
        m_i = -1;
    }

    void afterReflectNew() { HK_ASSERT_NO_MSG(0x3467941, m_i == 0 || m_i == -1); m_i = 42; }

    int m_i HK_ATTR(hk::Serialize(false));
};

struct AfterReflectWrapper1
{
    HK_DECLARE_CLASS(AfterReflectWrapper1, New, Reflect);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);
    AfterReflect m_ar;
};

struct AfterReflectWrapper2
{
    HK_DECLARE_CLASS(AfterReflectWrapper2, New, Reflect);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);

    AfterReflectWrapper2() {}

    void init()
    {
        m_ar.m_i = 42;
        m_arw.m_ar.m_i = 42;
        m_array.setSize(10);
        for (int i = 0; i < 10; ++i)
        {
            m_repeat[i].m_i = 42;
            m_array[i].m_i = 42;
        }
    }

    AfterReflect m_ar;
    AfterReflectWrapper1 m_arw;
    AfterReflect m_repeat[10];
    hkArray<AfterReflect> m_array;
};

struct ObjKey : public hkReferencedObject
{
    HK_DECLARE_CLASS(ObjKey, New, Reflect, EmptyCtor);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);

    ObjKey( int i ) : m_i( i ) {};

    int m_i;
};


class ArrayOfRefPtrs : public hkReferencedObject
{
    public:
        HK_DECLARE_CLASS(ArrayOfRefPtrs, New, Reflect);
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);

        hkRefPtr<ArrayOfRefPtrs> m_child;
        hkArray< hkRefPtr<hkReferencedObject> > m_ptrs;
};

struct PointerToArray
{
    HK_DECLARE_CLASS(PointerToArray, New, Reflect);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);
    hkVector4* m_vec;
    hkArray<int>* m_arr;
};

struct Interface0
{
    HK_DECLARE_CLASS(Interface0, New, ReflectVirtualBase);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);
    virtual void func0() = 0;
    virtual ~Interface0() {}
};

struct Interface1
{
    HK_DECLARE_CLASS(Interface1, New, ReflectVirtualBase);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);
    virtual void func1() = 0;
    virtual ~Interface1() {}
};

struct MultipleInheritance : public hkReferencedObject, public Interface0, public Interface1
{
    HK_DECLARE_CLASS(MultipleInheritance, New, Reflect);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);
    virtual void func0() {}
    virtual void func1() {}
    virtual ~MultipleInheritance() {}
    double m_double;
};

struct NonSerializableField
{
    HK_DECLARE_CLASS( NonSerializableField, New, Reflect );
    HK_RECORD_ATTR( hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);
    double m_double HK_ATTR( hk::Serialize(false) );
};

struct AlignTest0
{
    HK_DECLARE_CLASS(AlignTest0, New, Reflect);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);
    int m_first;
    //pad12
    HK_ALIGN16(int m_aligned);
    int m_array[3];
};

struct AlignTest1
{
    HK_DECLARE_CLASS(AlignTest1, New, Reflect);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);
    int m_first;
    //pad12 or pad28
    HK_ALIGN_REAL(int m_aligned);
    int m_array[3];
};

HK_CLASSALIGN(struct,8) AlignTest2
{
    HK_DECLARE_CLASS(AlignTest2, New, Reflect);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);
    int m_first;
    int m_aligned;
    int m_array[1];
};

HK_CLASSALIGN(struct, 16) AlignTest3
{
    HK_DECLARE_CLASS(AlignTest3, New, Reflect);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);
    int m_first;
    //pad4
    HK_ALIGN8(int m_aligned);
    int m_array[5];
};

enum HK_ATTR(hk::ManualTypeRegistration) TestEnum
{
    VALUE0 = 0,
    VALUE1 = 1,
    VALUE2 = 2,
};

enum class HK_ATTR(hk::ManualTypeRegistration) EnumClassImplicit
{
    VALUE0 = 0,
    VALUE1 = 1,
    VALUE2 = 2,
};

enum class HK_ATTR(hk::ManualTypeRegistration) EnumClassExplicit : short
{
    VALUE0 = 0,
    VALUE1 = 1,
    VALUE2 = 2,
};

struct WithEnum
{
    HK_DECLARE_CLASS(WithEnum, New, Reflect);
    HK_RECORD_ATTR(hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);

    TestEnum m_enum;
    EnumClassImplicit m_implicit;
    EnumClassExplicit m_explicit;
};

struct ConversionTest0
{
    HK_DECLARE_CLASS( ConversionTest0, New, Reflect );
    HK_RECORD_ATTR( hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);

    ConversionTest0();

    hkUint64 m_largeToSmall;
    hkInt16 m_smallToLarge;
    hkInt32 m_intToBool;
    hkBool m_boolToInt;
    hkBool m_boolToBool;
    float m_floatToDouble;
    double m_doubleToFloat;
};

struct ConversionTest1
{
    HK_DECLARE_CLASS( ConversionTest1, New, Reflect );
    HK_RECORD_ATTR( hk::ExcludeFromVersionCheck, hk::ManualTypeRegistration);

    ConversionTest1();

    hkInt16 m_largeToSmall;
    hkInt32 m_smallToLarge;
    hkBool m_intToBool;
    hkInt32 m_boolToInt;
    hkBool32 m_boolToBool;
    double m_floatToDouble;
    float m_doubleToFloat;
};

}

HK_REFLECT_ENUM(, UnitTest::TestEnum);
HK_REFLECT_ENUM(, UnitTest::EnumClassImplicit);
HK_REFLECT_ENUM(, UnitTest::EnumClassExplicit);


#include <Common/Base/_Auto/TemplateTypes/CloneTestClasses_Types.inl>

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
