// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/hkBase.h>
#include <Common/Base/UnitTest/hkUnitTest.h>
#include <Common/Base/UnitTest/Cloning/CloneTestClasses.h>
#include <Common/Base/Container/RelArray/hkRelArrayUtil.h>
#include <Common/Base/Types/Geometry/hkGeometry.h>

#if !defined(HK_PLATFORM_ANDROID)

#define HK_DETAIL_REFLECT_DEFINITIONS
#include <Common/Base/_Auto/Types/CloneTestClassesStl_Types.cxx>
#undef HK_DETAIL_REFLECT_DEFINITIONS
HK_MANUALLY_REGISTER_TYPE(UnitTest::TestVector, UnitTest_TestVector);
HK_MANUALLY_REGISTER_TYPE(UnitTest::TestString, UnitTest_TestString);
HK_MANUALLY_REGISTER_TYPE(UnitTest::TestVectorString, UnitTest_TestVectorString);
HK_MANUALLY_REGISTER_TYPE(UnitTest::TestComplicated, UnitTest_TestComplicated);
HK_MANUALLY_REGISTER_TYPE(UnitTest::TestComplicated::NestedRef, UnitTest_TestComplicated_NestedRef);
HK_MANUALLY_REGISTER_TYPE(UnitTest::TestComplicated::Nested, UnitTest_TestComplicated_Nested);

#endif

#define HK_DETAIL_REFLECT_DEFINITIONS
#include <Common/Base/_Auto/Types/CloneTestClasses_Types.cxx>
#undef HK_DETAIL_REFLECT_DEFINITIONS

HK_MANUALLY_REGISTER_TYPE(UnitTest::hkTestGeometryContainer, UnitTest_hkTestGeometryContainer);
HK_MANUALLY_REGISTER_TYPE(UnitTest::hkTestRecursive, UnitTest_hkTestRecursive);
HK_MANUALLY_REGISTER_TYPE(UnitTest::hkTestRecursive::Nested, UnitTest_hkTestRecursive_Nested);
HK_MANUALLY_REGISTER_TYPE(UnitTest::hkTestRelArray, UnitTest_hkTestRelArray);
HK_MANUALLY_REGISTER_TYPE(UnitTest::hkTFEmbedType, UnitTest_hkTFEmbedType);
HK_MANUALLY_REGISTER_TYPE(UnitTest::hkTFSecondEmbedType, UnitTest_hkTFSecondEmbedType);
HK_MANUALLY_REGISTER_TYPE(UnitTest::hkTFPatchParent, UnitTest_hkTFPatchParent);
HK_MANUALLY_REGISTER_TYPE(UnitTest::hkTFTestNewPatching, UnitTest_hkTFTestNewPatching);
HK_MANUALLY_REGISTER_TYPE(UnitTest::EmptyClass0, UnitTest_EmptyClass0);
HK_MANUALLY_REGISTER_TYPE(UnitTest::EmptyClass1, UnitTest_EmptyClass1);
HK_MANUALLY_REGISTER_TYPE(UnitTest::WithEmpty, UnitTest_WithEmpty);
HK_MANUALLY_REGISTER_TYPE(UnitTest::SemanticArrayTest, UnitTest_SemanticArrayTest);
HK_MANUALLY_REGISTER_TYPE(UnitTest::NativeArrayTest, UnitTest_NativeArrayTest);
HK_MANUALLY_REGISTER_TYPE(UnitTest::StringTest, UnitTest_StringTest);
HK_MANUALLY_REGISTER_TYPE(UnitTest::ArrayTestElem, UnitTest_ArrayTestElem);
HK_MANUALLY_REGISTER_TYPE(UnitTest::ArrayTestParent, UnitTest_ArrayTestParent);
HK_MANUALLY_REGISTER_TYPE(UnitTest::ArrayTest, UnitTest_ArrayTest);
HK_MANUALLY_REGISTER_TYPE(UnitTest::EmbedWithVtable, UnitTest_EmbedWithVtable);
HK_MANUALLY_REGISTER_TYPE(UnitTest::ArrayOfVirtuals, UnitTest_ArrayOfVirtuals);
HK_MANUALLY_REGISTER_TYPE(UnitTest::ArrayOfArrayOfVirtuals, UnitTest_ArrayOfArrayOfVirtuals);
HK_MANUALLY_REGISTER_TYPE(UnitTest::TupleTest, UnitTest_TupleTest);
HK_MANUALLY_REGISTER_TYPE(UnitTest::TupleTest::NestedFinishCtor, UnitTest_TupleTest_NestedFinishCtor);
HK_MANUALLY_REGISTER_TYPE(UnitTest::TupleTest::NestedNonFinishCtor, UnitTest_TupleTest_NestedNonFinishCtor);
HK_MANUALLY_REGISTER_TYPE(UnitTest::TemplateTest_B, UnitTest_TemplateTest_B);
HK_MANUALLY_REGISTER_TYPE(UnitTest::TypeCycleTest_Base, UnitTest_TypeCycleTest_Base);
HK_MANUALLY_REGISTER_TYPE(UnitTest::TypeCycleTest_A, UnitTest_TypeCycleTest_A);
HK_MANUALLY_REGISTER_TYPE(UnitTest::TypeCycleTest_X, UnitTest_TypeCycleTest_X);
HK_MANUALLY_REGISTER_TYPE(UnitTest::TypeCycleTest_Y, UnitTest_TypeCycleTest_Y);
HK_MANUALLY_REGISTER_TYPE(UnitTest::VariantArrayTest, UnitTest_VariantArrayTest);
HK_MANUALLY_REGISTER_TYPE(UnitTest::CArrayOfhkArray, UnitTest_CArrayOfhkArray);
HK_MANUALLY_REGISTER_TYPE(UnitTest::WithTypeRef, UnitTest_WithTypeRef);
HK_MANUALLY_REGISTER_TYPE(UnitTest::WithProperty, UnitTest_WithProperty);
HK_MANUALLY_REGISTER_TYPE(UnitTest::OpaqueTest, UnitTest_OpaqueTest);
HK_MANUALLY_REGISTER_TYPE(UnitTest::Ref0, UnitTest_Ref0);
HK_MANUALLY_REGISTER_TYPE(UnitTest::Ref1, UnitTest_Ref1);
HK_MANUALLY_REGISTER_TYPE(UnitTest::TestDynamic, UnitTest_TestDynamic);
HK_MANUALLY_REGISTER_TYPE(UnitTest::TestCharArray, UnitTest_TestCharArray);
HK_MANUALLY_REGISTER_TYPE(UnitTest::ClassTest0, UnitTest_ClassTest0);
HK_MANUALLY_REGISTER_TYPE(UnitTest::ClassTest1, UnitTest_ClassTest1);
HK_MANUALLY_REGISTER_TYPE(UnitTest::ClassTest2, UnitTest_ClassTest2);
HK_MANUALLY_REGISTER_TYPE(UnitTest::ClassTest3, UnitTest_ClassTest3);
HK_MANUALLY_REGISTER_TYPE(UnitTest::ClassWithClassWithHashMap, UnitTest_ClassWithClassWithHashMap);
HK_MANUALLY_REGISTER_TYPE(UnitTest::ClassWithArrayOfClassWithClassWithHashMap, UnitTest_ClassWithArrayOfClassWithClassWithHashMap);
HK_MANUALLY_REGISTER_TYPE(UnitTest::AfterReflect, UnitTest_AfterReflect);
HK_MANUALLY_REGISTER_TYPE(UnitTest::AfterReflectWrapper1, UnitTest_AfterReflectWrapper1);
HK_MANUALLY_REGISTER_TYPE(UnitTest::AfterReflectWrapper2, UnitTest_AfterReflectWrapper2);
HK_MANUALLY_REGISTER_TYPE(UnitTest::ObjKey, UnitTest_ObjKey);
HK_MANUALLY_REGISTER_TYPE(UnitTest::ArrayOfRefPtrs, UnitTest_ArrayOfRefPtrs);
HK_MANUALLY_REGISTER_TYPE(UnitTest::PointerToArray, UnitTest_PointerToArray);
HK_MANUALLY_REGISTER_TYPE(UnitTest::Interface0, UnitTest_Interface0);
HK_MANUALLY_REGISTER_TYPE(UnitTest::Interface1, UnitTest_Interface1);
HK_MANUALLY_REGISTER_TYPE(UnitTest::MultipleInheritance, UnitTest_MultipleInheritance);
HK_MANUALLY_REGISTER_TYPE(UnitTest::NonSerializableField, UnitTest_NonSerializableField);
HK_MANUALLY_REGISTER_TYPE(UnitTest::AlignTest0, UnitTest_AlignTest0);
HK_MANUALLY_REGISTER_TYPE(UnitTest::AlignTest1, UnitTest_AlignTest1);
HK_MANUALLY_REGISTER_TYPE(UnitTest::AlignTest2, UnitTest_AlignTest2);
HK_MANUALLY_REGISTER_TYPE(UnitTest::AlignTest3, UnitTest_AlignTest3);
HK_MANUALLY_REGISTER_TYPE(UnitTest::WithEnum, UnitTest_WithEnum);
HK_MANUALLY_REGISTER_TYPE(UnitTest::ConversionTest0, UnitTest_ConversionTest0);
HK_MANUALLY_REGISTER_TYPE(UnitTest::ConversionTest1, UnitTest_ConversionTest1);

namespace UnitTest
{
    struct CustomArrayType_Impl : public hkReflect::Detail::ArrayImpl
    {
        CustomArrayType_Impl() { /* keep clang happy */ }

        struct Dummy { hkUlong pad0; void* ptr; hkUlong pad1; hkInt16 size; hkUlong pad2; bool m_afterReflectNewCalled; bool m_dontDeallocate; };

        virtual hkResult getValue(const void* arrAddr, const hkReflect::ArrayType* arrType, _Out_ hkReflect::ArrayValue* val) const HK_OVERRIDE
        {
            const Dummy* array = static_cast<const Dummy*>(arrAddr);
            *val = hkReflect::ArrayValue(array->ptr, array->size, arrType->getSubType() );
            return HK_SUCCESS;
        }

        virtual AllocResult allocateElements( void* arrAddr, const hkReflect::ArrayType* arrType, hkReflect::QualType, int nelem) const HK_OVERRIDE
        {
            Dummy* array = static_cast<Dummy*>(arrAddr);
            if( array->size != nelem )
            {
                hkReflect::QualType elemType = arrType->getSubType();
                //copy&paste of setSize()
                int elemSize = elemType->getSizeOf();
                void* d = hkMemDebugBlockAlloc<void>(nelem * elemSize);
                const int bytesToCopy = elemSize * hkMath::min2<int>(nelem,array->size);
                const int bytesToZero = elemSize * nelem - bytesToCopy;
                hkMemUtil::memCpy(d, array->ptr, bytesToCopy);
                if(!elemType->asValue() && (bytesToZero > 0))
                {
                    hkMemUtil::memSet(hkAddByteOffset(d, bytesToCopy), 0, bytesToZero);
                }
                hkMemDebugBlockFree<void>(array->ptr, elemSize * array->size );
                array->ptr = d;
                array->size = hkInt16(nelem);
            }
            return ALLOC_SUCCESS;
        }

        virtual hkResult setNumElements( void* arrAddr, const hkReflect::ArrayType* arrType, int nelem) const HK_OVERRIDE
        {
            HK_ASSERT_NO_MSG(0x8e5fb68,0);
            return HK_FAILURE;
        }

        hkResult inplaceFixup( void* self, const hkReflect::Type* selfType, void* target, const hkReflect::Type* targetType, int count) const HK_OVERRIDE
        {
            Dummy* array = static_cast<Dummy*>(self);
            array->pad0 = 0;
            array->ptr = target;
            array->pad1 = 0;
            array->size = hkLosslessCast<hkInt16>(count);
            array->pad2 = 0;
            array->m_dontDeallocate = true;
            return HK_SUCCESS;
        }
    };

    const CustomArrayType_Impl CustomArrayType_impl;


    const int TEST_RELARRAY_SIZE = 5;
    // --------------------------------------- hkTestRelArray Utilities ---------------------------------------- //

    hkTestRelArray* hkTestRelArray::create()
    {
        // create buffer
        const int objSize = HK_NEXT_MULTIPLE_OF(HK_REAL_ALIGNMENT, sizeof(hkTestRelArray));
        const int arrSize = HK_NEXT_MULTIPLE_OF(HK_REAL_ALIGNMENT, sizeof(int)*TEST_RELARRAY_SIZE);
        const int blockSize = objSize + arrSize;
        void* block = hkMemHeapBlockAlloc<void>(blockSize);
        // new object
        hkTestRelArray* obj = new(block) hkTestRelArray;
        obj->setMemorySizeFlagsAndReferenceCount( blockSize, 1 );
        HK_MEMORY_TRACKER_ADD_EXPLICIT(hkTestRelArray, obj, blockSize);
        // initialize object
        void* arrayBufAddr = hkAddByteOffset(block, objSize);
        int offset = hkGetByteOffsetInt(&obj->m_array, arrayBufAddr);
        HK_ASSERT_NO_MSG(0x5500f8f1, offset > 0);
        obj->m_array._setOffset( static_cast<hkUint16>(offset) );
        obj->m_array._setSize(TEST_RELARRAY_SIZE);
        return obj;
    }
}

// This could be much more complex, like a singleton with a stringmap etc.
// Lets keep it simple for the test.
static const char* namePropertyLut[] =
{
    "zero", "one", "two", "three"
};

const char* UnitTest::WithProperty::getName() const
{
    HK_ASSERT_NO_MSG(0x7bb248eb, m_id < HK_COUNT_OF(namePropertyLut));
    return namePropertyLut[m_id];
}

void UnitTest::WithProperty::registerName(const char* name)
{
    if (name)
    {
        for (int i = 0; i < HK_COUNT_OF(namePropertyLut); ++i)
        {
            if (hkString::strCmp(namePropertyLut[i], name) == 0)
            {
                m_id = i;
                return;
            }
        }
    }
    m_id = 0;
}

UnitTest::ConversionTest0::ConversionTest0()
    : m_largeToSmall( hkTrait::NumericLimits<hkInt16>::maxValue() )
    , m_smallToLarge( hkTrait::NumericLimits<hkInt16>::minValue() )
    , m_intToBool( 1 )
    , m_boolToInt( true )
    , m_boolToBool( true )
    , m_floatToDouble( hkTrait::NumericLimits<float>::maxValue() )
    , m_doubleToFloat( hkTrait::NumericLimits<float>::maxValue() )
{
}

UnitTest::ConversionTest1::ConversionTest1()
    : m_largeToSmall( 0 )
    , m_smallToLarge( 0 )
    , m_intToBool( 0 )
    , m_boolToInt( false )
    , m_boolToBool( false )
    , m_floatToDouble( 0 )
    , m_doubleToFloat( 0 )
{
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
