// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

class hkStreamReader;
class hkStreamWriter;

namespace UnitTest
{

namespace Cloning
{
        /// Prototype for the function to be tested. Must return a clone of the object hierarchy pointed by root.
    typedef hkReflect::Var (*CloneFunc)(const char* testName, const hkReflect::Var& root);

        /// Tests the cloning function on a predefined set of object hierarchies, checking if
        /// clones are semantically equal to source objects.
    void test(CloneFunc cloneFunc, bool mustDeleteCopy = true);

        /// Prototype for a serialization function to be tested.
    typedef void (*SerializeFunc)(const char* testName, const hkReflect::Var& source, hkStreamWriter* sw);
        /// Prototype for a deserialization function to be tested.
    typedef hkReflect::Var (*DeserializeFunc)(const char* testName, hkStreamReader* sr);

        /// Test a serialization/deserialization pipeline on a predefined set of object hierarchies, checking if
        /// - products are semantically equal to source objects;
        /// - re-serialization of de-serialized objects produces the same bitstream of the first serialization.
    void test(SerializeFunc serializeFunc, DeserializeFunc deserializeFunc);


    // ------------------------------------ Advanced interface ---------------------------------- //

        /// Virtual class containing the cloning function to be tested
    class Cloner
    {
    public:

        virtual ~Cloner() {}

            /// Function to be tested - copies a hierarchy of objects.
        virtual hkReflect::Var clone(const char* testName, const hkReflect::Var& root) = 0;

            /// Must return true if operator() actually produces object copies,
            /// false if it outputs the input objects directly (used to correctly delete copies).
        virtual bool mustDeleteCopy() = 0;

            /// Check if the cloner is a serializer.
        virtual bool isSerializer() const { return false; }
    };

    class Serializer : public Cloner
    {
    public:

        virtual ~Serializer() {}

            /// Serializes an object hierarchy on a bitstream.
        virtual void serialize(const char* testName, const hkReflect::Var& root, hkStreamWriter* sw) = 0;
            /// Deserializes an object hierarchy from a bitstream.
        virtual hkReflect::Var deserialize(const char* testName, hkStreamReader* sr) = 0;

            /// Clones an object hierarchy by serializing it to a stream then deserializing it.
            /// In addition, tests that the serializing the clone produces the same byte stream as the original.
        virtual hkReflect::Var clone(const char* testName, const hkReflect::Var& root) HK_OVERRIDE;

            /// Check if the cloner is a serializer.
        virtual bool isSerializer() const HK_OVERRIDE { return true; }

        virtual bool mustDeleteCopy() HK_OVERRIDE { return true; }
    };

    enum DisableEnum
    {
        DISABLE_NONE = 0,
        DISABLE_NO_XML = 1 << 0, // Disable all features not supported by the XML format (type references, empty variant arrays with type, Opt::ATTRIBUTE_STRING)
        DISABLE_INPLACE = 1 << 1, 
        DISABLE_POINTERS = 1 << 2, 
        DISABLE_DYNAMICTYPES = 1 << 3, 
        DISABLE_NON_RELOCATABLE = 1 << 4, 
        DISABLE_NULL_VARIANT = 1 << 5, 
    };
    typedef hkFlags<DisableEnum, hkUint32> DisableFlags;

        /// Tests the cloning function on a predefined set of object hierarchies, checking if
        /// products are semantically equal to source objects.
    void TEST_MAIN_BREAK_HERE(Cloner& cloner, DisableFlags disable);
}

}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
