// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/hkBase.h>
#include <Common/Base/UnitTest/Cloning/CloneTest.h>
#include <Common/Base/UnitTest/hkUnitTest.h>
#include <Common/Base/System/Io/IStream/hkIStream.h>
#include <Common/Base/System/Io/OStream/hkOStream.h>

#include <Common/Base/Types/Geometry/hkGeometry.h>
#include <Common/Base/Container/Set/hkSet.h>
#include <Common/Base/Types/Properties/hkRefCountedProperties.h>
#include <Common/Base/Types/Geometry/LocalFrame/hkLocalFrame.h>

#include <Common/Base/UnitTest/Cloning/CloneTestClasses.h>
#include <Common/Base/Reflect/Core/Detail/hkReflectTypeDetail.h>
#include <Common/Base/Reflect/Util/hkReflectAny.h>
#include <Common/Base/Reflect/Builder/hkTypeBuilder.h>
#include <Common/Base/Reflect/Builder/hkRecordLayout.h>

#if defined(HK_BUILDING_WITH_ENGINE)
#include <Common/NewBase/Reflection/Util/hkDynamicTypeManager.h>                
#include <Common/NewBase/ObjectTracker/hkReflectDiffDetail.h>                   
#endif
#include <Common/Base/UnitTest/Reflection/RecordPropertiesTest.h>

namespace UnitTest
{

namespace Cloning
{
    // --------------------------------------- hkTestRelArray Utilities ---------------------------------------- //

    static void s_initializeObject(hkTestRelArray& object)
    {
        // set some starting values
        object.m_array[0] = 1;
        object.m_array[1] = 1;
        object.m_array[2] = 2;
        object.m_array[3] = 3;
        object.m_array[4] = 5;
    }

    static void s_checkObject(const hkTestRelArray& object)
    {
        // check the starting values
        if( HK_TEST(object.m_array.getSize() == 5) )
        {
            HK_TEST(object.m_array[0] == 1);
            HK_TEST(object.m_array[1] == 1);
            HK_TEST(object.m_array[2] == 2);
            HK_TEST(object.m_array[3] == 3);
            HK_TEST(object.m_array[4] == 5);
        }
    }

    // --------------------------------------- Test code ---------------------------------------- //

    template<typename T>
    static T* testObject(Cloner& cloner, const T& t, const char* testName = HK_NULL)
    {
        if (!testName)
        {
            testName = hkReflect::getName<T>();
        }
        hkReflect::Var clone = cloner.clone(testName, hkReflect::Var(&t));
        HK_TEST2(clone.isValid(), "Test '" << testName << "' failed.");
        return clone.dynCast<T>();
    }

    static bool s_isInplace(hkReferencedObject* obj)
    {
        if( (obj->getReferenceCount() == 0) && (obj->getMemorySizeAndFlags() == 0) )
        {
            return true;
        }
        return false;
    }

    template<typename KEY>
    static void checkHashMap(const ClassWithHashMap<KEY>& testClass, ClassWithHashMap<KEY>* loaded)
    {
        typedef ClassWithHashMap<KEY> TestClass;

        if(HK_TEST(loaded != HK_NULL))
        {
            {
                for(typename TestClass::HashMap::Iterator it = testClass.m_hashMap.getIterator(); testClass.m_hashMap.isValid(it); it = testClass.m_hashMap.getNext(it))
                {
                    const int indexOfOriginalKey = testClass.m_keys.indexOf(testClass.m_hashMap.getKey(it));
                    HK_TEST(indexOfOriginalKey != -1);
                    typename TestClass::HashMap::Iterator loadedIt = loaded->m_hashMap.find(loaded->m_keys[indexOfOriginalKey]);
                    HK_TEST(loaded->m_hashMap.isValid(loadedIt));
                    HK_TEST(loaded->m_hashMap.getValue(loadedIt) == testClass.m_hashMap.getValue(it));
                }
                HK_TEST(loaded->m_hashMap.getSize() == testClass.m_hashMap.getSize());
            }

            {
                for(typename TestClass::HashSet::Iterator it = testClass.m_hashSet.getIterator(); testClass.m_hashSet.isValid(it); it = testClass.m_hashSet.getNext(it))
                {
                    const int indexOfOriginalKey = testClass.m_keys.indexOf(testClass.m_hashSet.getElement(it));
                    HK_TEST(indexOfOriginalKey != -1);
                    HK_TEST(loaded->m_hashSet.contains(loaded->m_keys[indexOfOriginalKey]));
                }
                HK_TEST(loaded->m_hashSet.getSize() == testClass.m_hashSet.getSize());
            }
        }
    }

    template<typename KEY>
    static void testHashMap( Cloner& cloner, hkArrayView<KEY> keyArray, const char* testName )
    {
        typedef ClassWithHashMap<KEY> TestClass;
        TestClass testClass( keyArray );

        TestClass* loaded = testObject(cloner, testClass, testName);
        if(HK_TEST(loaded))
        {
            checkHashMap(testClass, loaded);

            if(cloner.mustDeleteCopy())
            {
                loaded->removeReference();
            }
        }
    }

    static void testHashMap2(Cloner& cloner, hkArrayView<int> keyArray)
    {
        ClassWithClassWithHashMap testClass(keyArray);

        ClassWithClassWithHashMap* loaded = testObject(cloner, testClass);
        if(HK_TEST(loaded))
        {
            checkHashMap(testClass.m_rec, &loaded->m_rec);

            if(cloner.mustDeleteCopy())
            {
                loaded->removeReference();
            }
        }
    }

    static void testHashMap3(Cloner& cloner, hkArrayView<int> keyArray)
    {
        ClassWithArrayOfClassWithClassWithHashMap testClass(keyArray);

        ClassWithArrayOfClassWithClassWithHashMap* loaded = testObject(cloner, testClass);
        if(HK_TEST(loaded))
        {
            checkHashMap(testClass.m_arr[0].m_rec, &loaded->m_arr[0].m_rec);

            if(cloner.mustDeleteCopy())
            {
                loaded->removeReference();
            }
        }
    }

    template<typename TYPE>
    void initAligned(TYPE& t)
    {
        t.m_first = 1111;
        t.m_aligned = 0x404;
        for(int i = 0; i < HK_COUNT_OF(t.m_array); ++i)
            t.m_array[i] = 100 + i;
    }


    template<typename TYPE>
    static void testAlignment(Cloner& cloner)
    {
        TYPE* copy = HK_NULL;
        {
            TYPE orig; initAligned(orig);
            copy = testObject(cloner, orig);
        }
        if(HK_TEST(copy))
        {
            TYPE orig; initAligned(orig);
            HK_TEST(copy->m_first == orig.m_first);
            HK_TEST(copy->m_aligned == orig.m_aligned);
            for(int i = 0; i < HK_COUNT_OF(orig.m_array); ++i)
            {
                HK_TEST(copy->m_array[i] == orig.m_array[i]);
            }
            if(cloner.mustDeleteCopy())
            {
                delete copy;
            }
        }
    }

    HK_DETAIL_DIAG_MSVC_OFF(4702)

    void TEST_MAIN_BREAK_HERE(Cloner& cloner, DisableFlags disable)
    {
        bool testEnabled = true;
        if (testEnabled && disable.noneIsSet(DISABLE_INPLACE) )
        {
            WithProperty orig("two");
            WithProperty* copy = testObject(cloner, orig);
            if(HK_TEST(copy))
            {
                HK_TEST(copy->m_id == orig.m_id);
                if (cloner.mustDeleteCopy())
                {
                    delete copy;
                }
            }
        }
        if (testEnabled && disable.noneIsSet(DISABLE_INPLACE))
        {
            hkArray<WithProperty> orig;
            orig.pushBack( WithProperty("three"));
            orig.pushBack( WithProperty("two"));
            orig.pushBack( WithProperty("one"));
            hkArray<WithProperty>* copy = testObject(cloner, orig, "hkArrayWithProperty");
            if(HK_TEST(copy))
            {
                HK_TEST(copy->getSize() == orig.getSize());
                HK_TEST(copy[0][0].m_id == 3);
                HK_TEST(copy[0][1].m_id == 2);
                HK_TEST(copy[0][2].m_id == 1);
                if (cloner.mustDeleteCopy())
                {
                    delete copy;
                }
            }
        }
        // Testing hkInplaceArray with POD elements that fit in internal storage
        if (testEnabled)
        {
            hkInplaceArray<int, 3> orig;
            orig.pushBack(3);
            orig.pushBack(2);
            orig.pushBack(1);
            hkInplaceArray<int, 3>* copy = testObject(cloner, orig, "hkInplaceArraySimple");
            if (HK_TEST(copy))
            {
                HK_TEST(copy->getSize() == orig.getSize());
                HK_TEST(copy[0][0] == 3);
                HK_TEST(copy[0][1] == 2);
                HK_TEST(copy[0][2] == 1);

                
                if (disable.noneIsSet(DISABLE_INPLACE))
                {
                    HK_TEST(!copy->wasReallocated());
                }

                if (cloner.mustDeleteCopy())
                {
                    delete copy;
                }
            }
        }
        // Testing hkInplaceArray with elements that don't fit in internal storage
        if (testEnabled && disable.noneIsSet(DISABLE_INPLACE))
        {
            hkInplaceArray<WithProperty, 2> orig;
            orig.pushBack(WithProperty("three"));
            orig.pushBack(WithProperty("two"));
            orig.pushBack(WithProperty("one"));
            hkInplaceArray<WithProperty, 2>* copy = testObject(cloner, orig, "hkInplaceArrayWithProperty");
            if (HK_TEST(copy))
            {
                HK_TEST(copy->getSize() == orig.getSize());
                HK_TEST(copy[0][0].m_id == 3);
                HK_TEST(copy[0][1].m_id == 2);
                HK_TEST(copy[0][2].m_id == 1);
                HK_TEST(copy->wasReallocated());
                if (cloner.mustDeleteCopy())
                {
                    delete copy;
                }
            }
        }
        if (testEnabled)
        {
            WithEmpty orig;
            orig.m_0.setAndDontIncrementRefCount( new EmptyClass0() );
            orig.m_1.setAndDontIncrementRefCount( new EmptyClass1() );
            WithEmpty* copy = testObject(cloner, orig);
            if( HK_TEST(copy) )
            {
                HK_TEST(copy->m_0);
                HK_TEST(copy->m_1);
                if (cloner.mustDeleteCopy())
                {
                    delete copy;
                }
            }
        }
        if (testEnabled)
        {
            WithEnum orig = { VALUE2, EnumClassImplicit::VALUE1, EnumClassExplicit::VALUE2 };
            WithEnum* copy = testObject(cloner, orig, "UnitTest__WithEnum0");
            if (HK_TEST(copy))
            {
                HK_TEST(copy->m_enum == orig.m_enum);
                HK_TEST(copy->m_implicit == orig.m_implicit);
                HK_TEST(copy->m_explicit == orig.m_explicit);
                if (cloner.mustDeleteCopy())
                {
                    delete copy;
                }
            }
        }
        if (testEnabled)
        {
            WithEnum orig = { static_cast<TestEnum>(137), static_cast<EnumClassImplicit>(237), static_cast<EnumClassExplicit>(337) };
            WithEnum* copy = testObject(cloner, orig, "UnitTest__WithEnum1");
            if (HK_TEST(copy))
            {
                HK_TEST(copy->m_enum == orig.m_enum);
                HK_TEST(copy->m_implicit == orig.m_implicit);
                HK_TEST(copy->m_explicit == orig.m_explicit);
                if (cloner.mustDeleteCopy())
                {
                    delete copy;
                }
            }
        }
        if (testEnabled)
        {
            hkArray<int> orig;
            orig.pushBack(10);
            orig.pushBack(11);
            orig.pushBack(12);
            hkArray<int>* copy = testObject(cloner, orig);
            if( HK_TEST(copy) )
            {
                if( HK_TEST(copy->getSize() == orig.getSize()) )
                {
                    HK_TEST(copy[0][0] == orig[0]);
                    HK_TEST(copy[0][1] == orig[1]);
                    HK_TEST(copy[0][2] == orig[2]);
                }
                if (cloner.mustDeleteCopy())
                {
                    delete copy;
                }
            }
        }

        if (testEnabled)
        {
            hkStringPtr orig = "hello";
            hkStringPtr* copy = testObject(cloner, orig);
            if( HK_TEST(copy) )
            {
                HK_TEST(orig==*copy);
                if (cloner.mustDeleteCopy())
                {
                    delete copy;
                }
            }
        }

        if (testEnabled)
        {
            // simple types
            int i = 24;
            int* iCopy = testObject(cloner, i);
            if(HK_TEST(iCopy))
            {
                HK_TEST(*iCopy == i);
                if(cloner.mustDeleteCopy()) hkMemHeapDestroy(iCopy);
            }

            float f = 1234.56f;
            float* fCopy = testObject(cloner, f);
            if(HK_TEST(fCopy))
            {
                HK_TEST(*fCopy == f);
                if(cloner.mustDeleteCopy()) hkMemHeapDestroy(fCopy);
            }

            hkViewPtr<int> ptr = &i;
            hkViewPtr<int>* ptrCopy = testObject(cloner, ptr);
            if(HK_TEST(ptrCopy))
            {
                HK_TEST(**ptrCopy == *ptr);
                if(cloner.mustDeleteCopy())
                {
                    if(*ptrCopy != ptr)
                    {
                        hkMemHeapDestroy(ptrCopy->val());
                    }
                    delete ptrCopy;
                }
            }
        }

        if (testEnabled)
        {
            hkTestRecursive rec;
            hkTestRecursive* copy = testObject(cloner, rec);

            if (HK_TEST(copy != HK_NULL))
            {
                HK_TEST_EQ(copy->m_int0, rec.m_int0);
                HK_TEST_EQ(copy->m_u64, rec.m_u64);
                HK_TEST_EQ(copy->m_ulong, rec.m_ulong);
                HK_TEST_EQ(copy->m_nested.m_array[0], rec.m_nested.m_array[0]);
                HK_TEST_EQ(copy->m_nested.m_array[1], rec.m_nested.m_array[1]);
                HK_TEST(hkMath::equal(copy->m_nested.m_double0, rec.m_nested.m_double0));
                HK_TEST(hkMath::equal(copy->m_real, rec.m_real));
                HK_TEST(copy->m_bool32.m_storage == 0);
                HK_TEST(copy->m_someOtherBool == true);
                HK_TEST(hkMath::equal(copy->m_nested.m_real, rec.m_nested.m_real));
                HK_TEST(copy->m_vector.allExactlyEqual<4>(rec.m_vector));
                if (cloner.mustDeleteCopy()) delete copy;
            }
        }

        if (testEnabled)
        {
            SemanticArrayTest semArray;
            semArray.m_embedTypeArray.setSize(2);

            hkTFEmbedType et;
            et.m_emb_b = -90;
            semArray.m_embedTypeArray[0] = et;
            et.m_emb_b = 54;
            semArray.m_embedTypeArray[1] = et;

            semArray.m_simpleArray.setSize(10);
            for (int i = 0; i < semArray.m_simpleArray.getSize(); ++i)
            {
                semArray.m_simpleArray[i] = i;
            }

            semArray.m_realArray.setSize(20);
            for (int i = 0; i < semArray.m_realArray.getSize(); ++i)
            {
                semArray.m_realArray[i] = hkReal(i*1000);
            }

            HK_TEST(semArray.m_embedTypeArray.m_afterReflectNewCalled==false);
            HK_TEST(semArray.m_emptyArray.m_afterReflectNewCalled==false);
            HK_TEST(semArray.m_simpleArray.m_afterReflectNewCalled==false);
            HK_TEST(semArray.m_realArray.m_afterReflectNewCalled==false);
            HK_TEST(semArray.m_realSize.m_afterReflectNewCalled==false);

            SemanticArrayTest* arrayCopy = testObject(cloner, semArray);
            if (HK_TEST(arrayCopy != HK_NULL))
            {
                HK_TEST(arrayCopy->m_embedTypeArray.m_afterReflectNewCalled);
                HK_TEST(arrayCopy->m_emptyArray.m_afterReflectNewCalled);
                HK_TEST(arrayCopy->m_simpleArray.m_afterReflectNewCalled);
                HK_TEST(arrayCopy->m_realArray.m_afterReflectNewCalled);
                HK_TEST(arrayCopy->m_realSize.m_afterReflectNewCalled);

                if (HK_TEST(arrayCopy->m_embedTypeArray.getSize() == 2))
                {
                    HK_TEST(arrayCopy->m_embedTypeArray[0].m_emb_b == -90);
                    HK_TEST(arrayCopy->m_embedTypeArray[1].m_emb_b == 54);
                }

                HK_TEST(arrayCopy->m_emptyArray.getSize() == 0);

                HK_TEST(arrayCopy->m_simpleArray.getSize() == semArray.m_simpleArray.getSize());
                for (int i = 0; i < arrayCopy->m_simpleArray.getSize(); ++i)
                {
                    HK_TEST(arrayCopy->m_simpleArray[i] == semArray.m_simpleArray[i]);
                }

                HK_TEST(arrayCopy->m_realArray.getSize() == semArray.m_realArray.getSize());
                for (int i = 0; i < arrayCopy->m_realArray.getSize(); ++i)
                {
                    HK_TEST(hkMath::equal(arrayCopy->m_realArray[i], semArray.m_realArray[i]));
                }

                if (cloner.mustDeleteCopy())
                {
                    delete arrayCopy;
                }
            }
        }

        if (testEnabled)
        {
            NativeArrayTest nativeArray;
            hkTFEmbedType et;
            et.m_emb_b = -90;
            nativeArray.m_embedTypehkArray.pushBack(et);
            et.m_emb_b = 54;
            nativeArray.m_embedTypehkArray.pushBack(et);

            for (int i = 0; i < 10; ++i)
            {
                nativeArray.m_simpleArray.pushBack(i);
            }

            for (unsigned i = 0; i < 20; ++i)
            {
                nativeArray.m_realArray.pushBack( hkReal(i*1000) );
            }

            NativeArrayTest* arrayCopy = testObject(cloner, nativeArray);
            if (HK_TEST(arrayCopy != HK_NULL))
            {
                if (HK_TEST(arrayCopy->m_embedTypehkArray.getSize() == 2))
                {
                    HK_TEST(arrayCopy->m_embedTypehkArray[0].m_emb_b == -90);
                    HK_TEST(arrayCopy->m_embedTypehkArray[1].m_emb_b == 54);
                }

                HK_TEST(arrayCopy->m_emptyArray.getSize() == 0);

                HK_TEST(arrayCopy->m_simpleArray.getSize() == nativeArray.m_simpleArray.getSize());
                for (int i = 0; i < arrayCopy->m_simpleArray.getSize(); ++i)
                {
                    HK_TEST(arrayCopy->m_simpleArray[i] == nativeArray.m_simpleArray[i]);
                }

                HK_TEST(arrayCopy->m_realArray.getSize() == nativeArray.m_realArray.getSize());
                for (int i = 0; i < arrayCopy->m_realArray.getSize(); ++i)
                {
                    HK_TEST(hkMath::equal(arrayCopy->m_realArray[i], nativeArray.m_realArray[i]));
                }

                if (cloner.mustDeleteCopy()) delete arrayCopy;
            }
        }

        if (testEnabled)
        {
            StringTest strTest;
            strTest.m_stringArray.pushBack("testArray1");
            strTest.m_stringArray.pushBack("testArray2");
            StringTest* copy = testObject(cloner, strTest);

            if (HK_TEST(copy != HK_NULL))
            {
                HK_TEST(copy->m_nullString.getLength() == 0);
                HK_TEST(copy->m_nullString.cString() == HK_NULL);
                HK_TEST(copy->m_literallyNull == "null");
                HK_TEST(copy->m_emptyString.getLength() == 0);
                HK_TEST(copy->m_emptyString.cString() != HK_NULL);
                HK_TEST(copy->m_emptyStringAgain.getLength() == 0);
                HK_TEST(copy->m_emptyStringAgain.cString() != HK_NULL);
                HK_TEST(copy->m_string1.compareTo(strTest.m_string1) == 0);
                HK_TEST(copy->m_string2.compareTo(strTest.m_string2) == 0);
                HK_TEST(copy->m_string1again.compareTo(strTest.m_string1) == 0);
                HK_TEST(copy->m_stringArray.getSize() == 2);
                HK_TEST(copy->m_stringArray[0].compareTo(strTest.m_stringArray[0]) == 0);
                HK_TEST(copy->m_stringArray[1].compareTo(strTest.m_stringArray[1]) == 0);
                HK_TEST(copy->m_stringArray[0].compareTo(strTest.m_stringArray[1]) != 0);
            }

            if (cloner.mustDeleteCopy())
            {
                delete copy;
            }
        }

        if (testEnabled)
        {
            ArrayTest arrayTest;
            ArrayTestElem elem1, elem2;
            elem1.m_name = "elem1";
            elem1.m_strings.pushBack("");
            elem1.m_strings.pushBack("elem1string");
            elem2.m_name = "elem2";
            elem2.m_strings.pushBack("elem2string");

            arrayTest.m_name = "test";
            arrayTest.m_array.pushBack(elem1);
            arrayTest.m_array.pushBack(elem2);

            ArrayTest* copy = testObject(cloner, arrayTest);

            if (HK_TEST(copy != HK_NULL))
            {
                HK_TEST(copy->m_name.compareTo(arrayTest.m_name) == 0);
                HK_TEST(copy->m_array.getSize() == 2);

                if (copy->m_array.getSize() == 2)
                {
                    ArrayTestElem& elem1copy = copy->m_array[0];
                    HK_TEST(elem1copy.m_name.compareTo(elem1.m_name) == 0);
                    HK_TEST(elem1copy.m_strings.getSize() == 2);
                    HK_TEST(elem1copy.m_strings[0].getLength() == 0);
                    HK_TEST(elem1copy.m_strings[1].compareTo(elem1.m_strings[1]) == 0);

                    ArrayTestElem& elem2copy = copy->m_array[1];
                    HK_TEST(elem2copy.m_name.compareTo(elem2.m_name) == 0);
                    HK_TEST(elem2copy.m_strings.getSize() == 1);
                    HK_TEST(elem2copy.m_strings[0].compareTo(elem2.m_strings[0]) == 0);
                }
                if (cloner.mustDeleteCopy()) delete copy;
            }
        }

        if (testEnabled && disable.noneIsSet(DISABLE_POINTERS))
        {
            hkTFTestNewPatching testMe;
            hkTFSecondEmbedType secondObject;

            testMe.m_mem = 2.0f;
            testMe.m_a = -15;
            testMe.m_embed.m_emb_b = 0xeebbeebb;
            testMe.m_e = 0xeeeeeeee;
            testMe.m_add_rem_add = 0x1;
            testMe.m_embed2.m_emb_c = 1000;
            testMe.m_embedPtr = &secondObject;
            testMe.m_embedPtr->m_emb_c = 0x00cc00cc;
            testMe.m_embedPtr->m_tnp = &testMe;
            testMe.m_embed2.m_tnp = &testMe;
            testMe.m_ptr = 0;
            testMe.m_array[0] = 5;
            testMe.m_array[1] = 10;
            testMe.m_array[2] = 15;
            testMe.m_array[3] = 20;

            hkMatrix3 mat;
            mat.setIdentity();
            testMe.m_matPtr = &mat;

            hkTFTestNewPatching* loaded = testObject(cloner, testMe);

            if (HK_TEST(loaded != HK_NULL))
            {
                HK_TEST(loaded->m_a == -15);
                HK_TEST(loaded->m_embed.m_emb_b == 0xeebbeebb);
                HK_TEST(loaded->m_e == 0xeeeeeeee);
                HK_TEST(loaded->m_embed2.m_emb_c == 1000);
                HK_TEST(loaded->m_mem == 2.0);

                HK_TEST(loaded->m_ptr == 0);

                HK_TEST(loaded->m_embedPtr != HK_NULL);
                if(loaded->m_embedPtr)
                {
                    HK_TEST(loaded->m_embedPtr->m_emb_c == 0x00cc00cc);
                    HK_TEST(loaded->m_embedPtr->m_tnp == loaded);
                    HK_TEST(loaded->m_embed2.m_tnp == loaded);
                }

                HK_TEST(loaded->m_array[0] == 5);
                HK_TEST(loaded->m_array[1] == 10);
                HK_TEST(loaded->m_array[2] == 15);
                HK_TEST(loaded->m_array[3] == 20);

                if (HK_TEST(loaded->m_matPtr))
                {
                    HK_TEST(loaded->m_matPtr->isApproximatelyEqual(mat));
                }

                if (cloner.mustDeleteCopy())
                {
                    delete loaded->m_embedPtr;
                    delete loaded->m_matPtr;
                    delete loaded;
                }
            }
        }

        hkGeometry geometry;
        hkTestGeometryContainer container;
        hkTestGeometryContainer container2;

        {
            // Make a 'box' geometry of dimensions 2x4x6
            hkVector4 halfExtents; halfExtents.set( 1.0f, 2.0f, 3.0f);

            hkVector4* v = geometry.m_vertices.expandBy(8);
            v[0].set( -halfExtents(0),  halfExtents(1),  halfExtents(2));
            v[1].set(  halfExtents(0),  halfExtents(1),  halfExtents(2));
            v[2].set(  halfExtents(0), -halfExtents(1),  halfExtents(2));
            v[3].set( -halfExtents(0), -halfExtents(1),  halfExtents(2));
            v[4].set( -halfExtents(0),  halfExtents(1), -halfExtents(2));
            v[5].set(  halfExtents(0),  halfExtents(1), -halfExtents(2));
            v[6].set(  halfExtents(0), -halfExtents(1), -halfExtents(2));
            v[7].set( -halfExtents(0), -halfExtents(1), -halfExtents(2));

            hkGeometry::Triangle* t = geometry.m_triangles.expandBy(12);
            t[0].set(3, 2, 1);
            t[1].set(3, 1, 0);
            t[2].set(6, 7, 4);
            t[3].set(6, 4, 5);
            t[4].set(4, 7, 3);
            t[5].set(4, 3, 0);
            t[6].set(2, 6, 5);
            t[7].set(2, 5, 1);
            t[8].set(7, 6, 2);
            t[9].set(7, 2, 3);
            t[10].set(1, 5, 4);
            t[11].set(1, 4, 0);

            container.m_name = "Container 1";
            container.m_obj = &geometry;
            container.m_a_member = -27;
            container.m_link = &container2;

            container2.m_name = "Container 2";
            container2.m_a_member = 100;
            container2.m_obj = HK_NULL;
            container2.m_link = &container;
        }

        if (testEnabled)
        {
            hkGeometry* geom = testObject(cloner, geometry);
            if (HK_TEST(geom != HK_NULL))
            {
                for(int i=0;i<8;i++)
                {
                    HK_TEST(geom->m_vertices[i].allExactlyEqual<4>(geometry.m_vertices[i]));
                }
                for(int i=0;i<12;i++)
                {
                    HK_TEST(geom->m_triangles[i].m_a == geometry.m_triangles[i].m_a);
                    HK_TEST(geom->m_triangles[i].m_b == geometry.m_triangles[i].m_b);
                    HK_TEST(geom->m_triangles[i].m_c == geometry.m_triangles[i].m_c);
                    HK_TEST(geom->m_triangles[i].m_material == geometry.m_triangles[i].m_material);
                }
                if (cloner.mustDeleteCopy()) delete geom;
            }
        }

        // Test a more complex case with three objects, forward and backward references with loops
        if (testEnabled && disable.noneIsSet(DISABLE_POINTERS))
        {
            hkTestGeometryContainer* cont = testObject(cloner, container);

            if (HK_TEST(cont != HK_NULL))
            {
                HK_TEST(cont->m_name == container.m_name);
                if(HK_TEST(cont->m_obj != HK_NULL))
                {
                    // Check geometry
                    for(int i=0;i<8;i++)
                    {
                        HK_TEST(cont->m_obj->m_vertices[i].allExactlyEqual<4>(geometry.m_vertices[i]));
                    }
                    for(int i=0;i<12;i++)
                    {
                        HK_TEST(cont->m_obj->m_triangles[i].m_a == geometry.m_triangles[i].m_a);
                        HK_TEST(cont->m_obj->m_triangles[i].m_b == geometry.m_triangles[i].m_b);
                        HK_TEST(cont->m_obj->m_triangles[i].m_c == geometry.m_triangles[i].m_c);
                        HK_TEST(cont->m_obj->m_triangles[i].m_material == geometry.m_triangles[i].m_material);
                    }
                }

                // Check members and structure
                HK_TEST(cont->m_a_member == container.m_a_member);
                HK_TEST(cont->m_link != HK_NULL);

                if(cont->m_link != HK_NULL)
                {
                    HK_TEST(cont->m_link->m_name == container2.m_name);
                    HK_TEST(cont->m_link->m_a_member == container.m_link->m_a_member);
                    HK_TEST(cont->m_link->m_obj == HK_NULL);
                    HK_TEST(cont->m_link->m_link == cont);
                }

                if (cloner.mustDeleteCopy())
                {
                    // This structure is more complex, find all of the containers and geometries and free them
                    hkSet<hkTestGeometryContainer*> containers;
                    hkSet<hkGeometry*> geometries;
                    while(cont)
                    {
                        if(containers.contains(cont))
                        {
                            break;
                        }

                        containers.insert(cont);
                        if(cont->m_obj)
                        {
                            geometries.insert(cont->m_obj);
                        }
                        cont = cont->m_link;
                    }

                    for(hkSet<hkGeometry*>::Iterator i = geometries.getIterator(); geometries.isValid(i); i = geometries.getNext(i))
                    {
                        hkGeometry* g = geometries.getElement(i);
                        delete g;
                    }
                    for(hkSet<hkTestGeometryContainer*>::Iterator i = containers.getIterator(); containers.isValid(i); i = containers.getNext(i))
                    {
                        hkTestGeometryContainer* c = containers.getElement(i);
                        delete c;
                    }
                }
            }
        }

        
        /*
        if (testEnabled) // members of different sizes
        {
            hkContactPointMaterial cp;
            cp.reset();
            cp.setFriction(.1f);
            cp.setRestitution(.2f);
            cp.setUserData(3);
            cp.setMaxImpulsePerStep(.4f);

            hkContactPointMaterial* newCp = testObject(cloner, cp);

            if (HK_TEST(newCp != HK_NULL))
            {
                HK_TEST(newCp->getUserData() == cp.getUserData());
                HK_TEST(newCp->getFriction() == cp.getFriction());
                HK_TEST(newCp->getRestitution() == cp.getRestitution());
                HK_TEST(newCp->m_maxImpulse == cp.m_maxImpulse);
                HK_TEST(newCp->m_flags == cp.m_flags);

                // Is this valid?
                if (cloner.mustDeleteCopy())
                {
                    delete newCp;
                }
            }
        }
        */

        if (testEnabled && disable.noneIsSet(DISABLE_POINTERS)) // pointers
        {
            hkSimpleLocalFrame* newFrame = HK_NULL;
            hkTransform transform;
            transform.setIdentity();
            hkVector4 vec;
            vec.set(3.40282e+38f, 0, 0, 0);
            transform.setTranslation(vec);
            {
                hkRefPtr<hkRefCountedProperties> newProps;
                {
                    hkRefCountedProperties props;
                    hkSimpleLocalFrame frame;
                    frame.m_name = "Frame Name";
                    props.addProperty(10, &frame);
                    frame.setLocalTransform(transform);

                    newProps.setAndDontIncrementRefCount(testObject(cloner, props));
                }

                if (HK_TEST(newProps != HK_NULL))
                {
                    HK_TEST(newProps->getReferenceCount() == 1 || s_isInplace(newProps) );
                    newFrame = (hkSimpleLocalFrame*)newProps->accessProperty(10);
                    if (cloner.mustDeleteCopy())
                    {
                        if( HK_TEST(newFrame != HK_NULL) )
                        {
                            newFrame->addReference();
                            HK_TEST(newFrame->getReferenceCount()== 2 || s_isInplace(newFrame) );
                            HK_TEST(!hkString::strCmp(newFrame->getName(), "Frame Name"));
                            HK_TEST(newFrame->m_transform.isApproximatelyEqual(transform));
                        }
                    }
                }
            }
            if (cloner.mustDeleteCopy() && newFrame != HK_NULL)
            {
                HK_TEST(newFrame->getReferenceCount()== 1); // Still alive
                newFrame->removeReference();
            }
        }

        if (testEnabled)
        {
            // Test owned(false) pointers
            //     f1       .
            //    /  \      .
            //   f2   f3    .
            hkSimpleLocalFrame* newFrame;

            {
                // On the heap so they can be refcounted
                hkSimpleLocalFrame *f1 = new hkSimpleLocalFrame(); // Parent
                hkSimpleLocalFrame *f2 = new hkSimpleLocalFrame(); // Child 1
                hkSimpleLocalFrame *f3 = new hkSimpleLocalFrame(); // Child 2

                f1->m_transform.setIdentity();
                f2->addReference();
                f1->m_children.pushBack(f2);
                f3->addReference();
                f1->m_children.pushBack(f3);
                f1->m_name = "f1";

                f2->m_transform.setIdentity();
                f2->m_parentFrame = f1;
                f2->m_name = "f2";

                f3->m_transform.setIdentity();
                f3->m_parentFrame = f1;
                f3->m_name = "f3";

                newFrame = testObject(cloner, *f1, "OwnedPointersTest");

                f1->removeReference();
                f2->removeReference();
                f3->removeReference();
            }

            if (HK_TEST(newFrame != HK_NULL))
            {
                if (cloner.mustDeleteCopy())
                {
                    HK_TEST(newFrame->getReferenceCount() == 1); // Back refs should not add to refcount
                    HK_TEST(newFrame->m_name.compareTo("f1") == 0);
                    HK_TEST(newFrame->getNumChildFrames() == 2);

                    hkSimpleLocalFrame* childA = hkReflect::exactMatchDynCast<hkSimpleLocalFrame>(newFrame->getChildFrame(0));
                    HK_TEST(childA != HK_NULL);
                    HK_TEST(childA->getReferenceCount() == 1); // Forward ref does add to refcount
                    HK_TEST(childA->m_name.compareTo("f2") == 0);
                    HK_TEST(childA->getNumChildFrames() == 0);
                    childA->addReference();

                    hkSimpleLocalFrame* childB = hkReflect::exactMatchDynCast<hkSimpleLocalFrame>(newFrame->getChildFrame(1));
                    HK_TEST(childB != HK_NULL);
                    HK_TEST(childB->getReferenceCount() == 1); // Forward ref does add to refcount
                    HK_TEST(childB->m_name.compareTo("f3") == 0);
                    HK_TEST(childB->getNumChildFrames() == 0);
                    childB->addReference();

                    newFrame->removeReference();
                    HK_TEST(childA->getReferenceCount() == 1); // Child is still alive
                    HK_TEST(childB->getReferenceCount() == 1); // Child is still alive
                    childA->removeReference();
                    childB->removeReference();
                }
            }
        }

        if (testEnabled)
        {
            // test object with rel array
            hkTestRelArray* obj = hkTestRelArray::create();
            HK_ASSERT_NO_MSG(0x16114b6d, obj != HK_NULL);
            s_initializeObject(*obj);
            {
                hkTestRelArray* newObj = testObject(cloner, *obj);

                if(HK_TEST(newObj != HK_NULL))
                {
                    s_checkObject(*newObj);
                    if (cloner.mustDeleteCopy())
                    {
                        newObj->removeReference();
                    }
                }
            }
            obj->removeReference();
        }

        if (testEnabled)
        {
            hkMatrix3 matrix;

            // Set the matrix to something so we know it isn't just getting default-zeroed
            matrix.setIdentity();

            hkReflect::Var var(&matrix);

            const hkReflect::Var* vtest_copy = testObject(cloner, var);
            if (HK_TEST(vtest_copy != HK_NULL))
            {
                hkReflect::Var var_copy = *vtest_copy;
                HK_TEST(var_copy);
                HK_TEST(var_copy.getType());
                HK_TEST(var_copy.getType()->equals(var.getType()) );

                const hkMatrix3* copy = var_copy.dynCast<hkMatrix3>();
                HK_TEST(matrix.isApproximatelyEqual(*copy));

                if (cloner.mustDeleteCopy())
                {
                    if (copy != &matrix)
                    {
                        delete copy;
                    }
                    delete vtest_copy;
                }
            }
        }

        if (testEnabled)
        {
            ArrayOfArrayOfVirtuals* copy;

            ArrayOfVirtuals embA;
            embA.m_memA = 1;
            embA.m_arr.expandOne().set(26.0f);
            embA.m_arr.expandOne().set(-56.0f);
            embA.m_arr.expandOne().set(100.0f);

            ArrayOfVirtuals embB;
            embB.m_memA = 2;
            embB.m_arr.expandOne().set(77.223f);
            embB.m_arr.expandOne().set(100000.0f);
            embB.m_arr.expandOne().set(-1.0f);

            ArrayOfArrayOfVirtuals compound;
            compound.m_memA = 0;
            compound.m_arr.pushBack(embA);
            compound.m_arr.pushBack(embB);

            copy = testObject(cloner, compound);

            if (HK_TEST(copy != HK_NULL))
            {
                HK_TEST(copy->m_memA == 0);
                if(HK_TEST(copy->m_arr.getSize() == 2))
                {
                    const ArrayOfVirtuals& embAcopy = copy->m_arr[0];
                    HK_TEST(embAcopy.m_memA == 1);
                    if(HK_TEST(embAcopy.m_arr.getSize() == 3))
                    {
                        HK_TEST(embAcopy.m_arr[0].m_float == 26.0f);
                        HK_TEST(hkDynCast<EmbedWithVtable>(&embAcopy.m_arr[0]));
                        HK_TEST(embAcopy.m_arr[1].m_float == -56.0f);
                        HK_TEST(hkDynCast<EmbedWithVtable>(&embAcopy.m_arr[1]));
                        HK_TEST(embAcopy.m_arr[2].m_float == 100.0f);
                        HK_TEST(hkDynCast<EmbedWithVtable>(&embAcopy.m_arr[2]));
                    }

                    const ArrayOfVirtuals& embBcopy = copy->m_arr[1];
                    HK_TEST(embBcopy.m_memA == 2);
                    if(HK_TEST(embBcopy.m_arr.getSize() == 3))
                    {
                        HK_TEST(embBcopy.m_arr[0].m_float == 77.223f);
                        HK_TEST(hkDynCast<EmbedWithVtable>(&embBcopy.m_arr[0]));
                        HK_TEST(embBcopy.m_arr[1].m_float == 100000.0f);
                        HK_TEST(hkDynCast<EmbedWithVtable>(&embBcopy.m_arr[1]));
                        HK_TEST(embBcopy.m_arr[2].m_float == -1.0f);
                        HK_TEST(hkDynCast<EmbedWithVtable>(&embBcopy.m_arr[2]));
                    }
                }

                if (cloner.mustDeleteCopy())
                {
                    delete copy;
                }
            }
        }

        if (testEnabled)
        {
            TupleTest test;
            test.m_integer = 4;
            test.m_tuple1.m_0 = 12;
            test.m_tuple1.m_1 = 5.5f;
            test.m_tuple2.m_0.m_field = 3;
            test.m_tuple2.m_1.m_field = 4;

            TupleTest* copy = HK_NULL;

            copy = testObject(cloner, test);

            if (HK_TEST(copy != HK_NULL))
            {
                HK_TEST(copy->m_integer == 4);
                HK_TEST(copy->m_tuple1.m_0 == 12);
                HK_TEST(copy->m_tuple1.m_1 == 5.5f);
                HK_TEST(copy->m_tuple2.m_0.m_field == 3);
                HK_TEST(copy->m_tuple2.m_1.m_field == 4);
                if (cloner.mustDeleteCopy())
                {
                    delete copy;
                }
            }
        }

        // Simple template load.
        if (testEnabled)
        {
            UnitTest::TemplateTest_A<int> t_a;
            t_a.m_t = 25;
            UnitTest::TemplateTest_A<int>* test_a = testObject(cloner, t_a, "TemplateInt");
            if (HK_TEST(test_a))
            {
                HK_TEST(test_a->m_t == 25);
            }

            if (cloner.mustDeleteCopy())
            {
                delete test_a;
            }
        }

        if (testEnabled)
        {
            UnitTest::TemplateTest_A<hkVector4> t_a;
            t_a.m_t.set(1.0f, 2.0f, 3.0f, 4.0f);
            UnitTest::TemplateTest_A<hkVector4>* test_a = testObject(cloner, t_a, "TemplateVector");

            if (HK_TEST(test_a))
            {
                HK_TEST(hkMath::equal(test_a->m_t(0), 1.0f));
                HK_TEST(hkMath::equal(test_a->m_t(1), 2.0f));
                HK_TEST(hkMath::equal(test_a->m_t(2), 3.0f));
                HK_TEST(hkMath::equal(test_a->m_t(3), 4.0f));
            }

            if (cloner.mustDeleteCopy())
            {
                delete test_a;
            }
        }

        if (testEnabled)
        {
            TemplateTest_B test;
            test.m_dA.m_t = 0.5;
            test.m_t = 4;

            TemplateTest_B* copy = HK_NULL;

            // The hkExpandedPatchingTypeSet used by the versioning provider looks for cached computed types by
            // name, but if templates share the same name instances will be reused.
            copy = testObject(cloner, test);

            if (HK_TEST(copy != HK_NULL))
            {
                HK_TEST(copy->m_dA.m_t == test.m_dA.m_t);
                HK_TEST(copy->m_t == test.m_t);

                if (cloner.mustDeleteCopy())
                {
                    delete copy;
                }
            }
        }

        // Test versioning with a loop (via a hkViewPtr) in the type system
        if (testEnabled && disable.noneIsSet(DISABLE_POINTERS))
        {
            TypeCycleTest_A testA;
            TypeCycleTest_Y testY;
            testA.m_int = 5;
            testA.m_double = 6.0;
            testA.m_y = &testY;
            testY.m_int = 3;
            testY.m_shortInt = 7;
            testY.m_y = &testY;

            TypeCycleTest_A* copy = HK_NULL;

            // Since the hkExpandedPatchingType set types are built in the versioning step by copying the fields
            // from the parents, this can break if you have a loop of types.
            // It starts looking at A and tries to calculate the type for Base as a parent (to copy the fields
            // from it). Then it finds the pointer to Y, starts to build X, which requires Base as well.
            // Construction of Base is not finished yet, but we still copy the fields inside X. Since the type is
            // not finished, we will copy nothing and the two fields of the pointed object will not be copied
            // (remaining zero).
            // This must be fixed by reworking the way temporary patching types are built.
            copy = testObject(cloner, testA);

            if(HK_TEST(copy != HK_NULL))
            {
                HK_TEST(copy->m_int == 5);
                HK_TEST(copy->m_double == 6.0);
                //HK_TEST(copy->m_y != copy);
                HK_TEST(copy->m_y->m_int == 3);
                HK_TEST(copy->m_y->m_shortInt == 7);
                HK_TEST(copy->m_y == copy->m_y->m_y);

                if(cloner.mustDeleteCopy())
                {
                    delete copy->m_y;
                    delete copy;
                }
            }
        }

        if (testEnabled)
        {
            UnitTest::CArrayOfhkArray obj;

            for (int i = 0; i < 3; ++i)
            {
                for (int j = 0; j < 10; ++j)
                {
                    obj.m_arrays[i].pushBack(i * 10 + j);
                }
            }
            UnitTest::CArrayOfhkArray* copy = testObject(cloner, obj);

            if (HK_TEST(copy) && HK_TEST(copy->m_arrays[0].getSize() == 10) && HK_TEST(copy->m_arrays[1].getSize() == 10) && HK_TEST(copy->m_arrays[2].getSize() == 10))
            {
                for (int i = 0; i < 3; ++i)
                {
                    for (int j = 0; j < 10; ++j)
                    {
                        HK_TEST(copy->m_arrays[i][j] == i * 10 + j);
                    }
                }
            }

            if (cloner.mustDeleteCopy())
            {
                delete copy;
            }
        }

        if (testEnabled)
        {
            VariantArrayTest testInt;
            testInt.m_array.allocate(10, hkReflect::getType<int>());
            for (int i = 0; i < 10; ++i)
            {
                testInt.m_array.setElement(i, i*i);
            }

            VariantArrayTest* copyInt = testObject(cloner, testInt);
            if (HK_TEST(copyInt != HK_NULL))
            {
                for (int i = 0; i < 10; ++i)
                {
                    HK_TEST(copyInt->m_array.getElement<int>(i) == testInt.m_array.getElement<int>(i));
                }
            }

            if (cloner.mustDeleteCopy())
            {
                delete copyInt;
            }

            if (disable.noneIsSet(DISABLE_POINTERS))
            {
                VariantArrayTest testPtr;
                testPtr.m_array.allocate(1, hkReflect::getType< hkViewPtr<VariantArrayTest> >());
                testPtr.m_array.setElement(0, hkViewPtr<VariantArrayTest>(&testPtr));

                VariantArrayTest* copyPtr = testObject(cloner, testPtr, "VariantArrayTest2");
                if (HK_TEST(copyPtr != HK_NULL))
                {
                    VariantArrayTest* testPtrCopy = copyPtr->m_array.getElement< hkViewPtr<VariantArrayTest> >(0);
                    HK_TEST(testPtrCopy == copyPtr);
                }

                if (cloner.mustDeleteCopy())
                {
                    delete copyPtr;
                }
            }

            // variant array with NULL type
            if(disable.noneIsSet(DISABLE_NO_XML))
            {
                hkVariantArray orig;

                hkVariantArray* copy = testObject(cloner, orig, "VariantArrayNull");
                if(HK_TEST(copy))
                {
                    HK_TEST(copy->getType().isNull());
                    if(cloner.mustDeleteCopy())
                    {
                        delete copy;
                    }
                }
            }

            // variant array with not-NULL type
            if(disable.noneIsSet(DISABLE_NO_XML | DISABLE_NULL_VARIANT))
            {
                hkVariantArray orig;
                orig.allocate(0, hkReflect::getType<double>());

                hkVariantArray* copy = testObject(cloner, orig, "VariantArrayDouble");
                if(HK_TEST(copy))
                {
                    HK_TEST_EQ(copy->getType(), hkReflect::getType<double>());
                    if(cloner.mustDeleteCopy())
                    {
                        delete copy;
                    }
                }
            }
        }

        if (testEnabled)
        {
            hkReflect::Any anyInt = hkReflect::Any::fromObj(42);
            hkReflect::Any* copyInt = testObject(cloner, anyInt);
            if (HK_TEST(copyInt != HK_NULL))
            {
                hkReflect::IntVar copyVar = copyInt->var();
                if (HK_TEST(copyVar))
                {
                    HK_TEST(copyVar.getValue().equals(42));
                }
            }

            hkReflect::Any anyRec = hkReflect::Any::fromDefaultObj<hkTestRecursive>();
            hkTestRecursive* orig = anyRec.var().dynCast<hkTestRecursive>();
            orig->m_nested.m_ptr = HK_NULL;

            hkReflect::Any* copyRec = testObject(cloner, anyRec, "AnyTest2");
            if (HK_TEST(copyRec != HK_NULL))
            {
                hkReflect::RecordVar copyVar = copyRec->var();
                if (HK_TEST(copyVar))
                {
                    hkTestRecursive* copyTr = copyVar.dynCast<hkTestRecursive>();
                    HK_TEST(copyTr->m_int0 == orig->m_int0);
                }
            }

            hkSimpleLocalFrame frame;
            hkTransform transform;
            transform.setIdentity();
            hkVector4 vec;
            vec.set(3.40282e+38f, 0, 0, 0);
            transform.setTranslation(vec);
            frame.setLocalTransform(transform);

            hkReflect::Any anyPtr = hkReflect::Any::fromObj( hkRefPtr<hkReferencedObject>(&frame) );

            hkReflect::Any* copyPtr = testObject(cloner, anyPtr, "AnyTest3");
            if (HK_TEST(copyPtr != HK_NULL))
            {
                hkReflect::PointerVar copyVar = copyPtr->var();
                if (HK_TEST(copyVar))
                {
                    hkSimpleLocalFrame* copyFrame = copyVar.getValue().dynCast<hkSimpleLocalFrame>();
                    if (HK_TEST(copyFrame != HK_NULL))
                    {
                        hkTransform copyTrans;
                        copyFrame->getLocalTransform(copyTrans);
                        HK_TEST(copyTrans.isApproximatelyEqual(transform));
                    }
                }
            }

            if (cloner.mustDeleteCopy())
            {
                delete copyInt;
                delete copyRec;
                delete copyPtr;
            }
        }

#if defined(HK_BUILDING_WITH_ENGINE)
        if (testEnabled && disable.noneIsSet(DISABLE_NO_XML | DISABLE_INPLACE)) // XML does not support ATTRIBUTE_STRING, inplace does not support unnamed types
        {
            hkReflect::Type* unnamedType1 = HK_NULL;
            hkReflect::Type* unnamedType2 = HK_NULL;

            {
                DynamicFieldsTest test;
                test.m_int = 10;

                hkReflect::RecordVar var = hkReflect::Var(&test);
                HK_TEST(hkReflect::DynamicFieldArray::getDynamicFields(var) == &test.m_dynFields);

                int intField = 20;

                test.m_dynFields.set("int", hkReflect::Var(&intField));

                hkTFEmbedType rec;
                rec.m_emb_b = 30;
                test.m_dynFields.set("record", hkReflect::Var(&rec));

                Ref0 refObj;
                refObj.m_i0 = 40;
                refObj.m_d = 3.14159;
                hkRefPtr<hkReferencedObject> refPtr(&refObj);
                test.m_dynFields.set("ptr", hkReflect::Var(&refPtr));

                TestEnum enumValue = VALUE2;
                test.m_dynFields.set("enum", hkReflect::Var(&enumValue));

                // Check we captured the enum as an enum and not as an integer - this is important for the YAML format which serializes as the string "VALUE2" rather than "2"
                HK_TEST(hkString::strStr(test.m_dynFields.get("enum").getType()->getName(), "TestEnum") != HK_NULL);

                const hkReflect::Type* dynamicEnumType = HK_NULL;
                if (disable.noneIsSet(DISABLE_NO_XML | DISABLE_INPLACE)) // XML does not support ATTRIBUTE_STRING, inplace does not support unnamed types
                {
                    // Again, but dynamically built an enum-like type
                    dynamicEnumType = hkDynamicTypeManager::getInstance().getAttributedTypeOf(hkReflect::getType<int>(), "hk::Presets({VALUE0=0,VALUE1=1,VALUE2=2})");

                    int dynamicEnumValue = VALUE2;
                    test.m_dynFields.set("dynEnum", hkReflect::Var(&dynamicEnumValue, dynamicEnumType));

                    {
                        hkReflect::TypeBuilder builder;
                        builder.setRecomputeLayout(true);
                        builder.beginRecord(HK_NULL, hkReflect::getType<hkReflect::Detail::DiffTypeParent>());
                        builder.addMember("FieldInt", hkReflect::Decl::DECL_DATA_FIELD, hkReflect::getType<int>());
                        builder.addFlags(hkReflect::Type::TYPE_DYNAMIC);
                        builder.addItem<hkReflect::Opt::ALLOC_IMPL>(&hkReflect::Detail::HeapAllocImpl::s_instance);
                        builder.addTrivialSpecialMethods();
                        builder.addDeleteInfo();

                        unnamedType1 = builder.allocate(hkMemHeapAllocator());
                    }

                    {
                        hkReflect::TypeBuilder builder;
                        builder.setRecomputeLayout(true);
                        builder.beginRecord(HK_NULL, hkReflect::getType<hkReflect::Detail::DiffTypeParent>());
                        builder.addMember("FieldFloat", hkReflect::Decl::DECL_DATA_FIELD, hkReflect::getType<float>());
                        builder.addFlags(hkReflect::Type::TYPE_DYNAMIC);
                        builder.addItem<hkReflect::Opt::ALLOC_IMPL>(&hkReflect::Detail::HeapAllocImpl::s_instance);
                        builder.addTrivialSpecialMethods();
                        builder.addDeleteInfo();

                        unnamedType2 = builder.allocate(hkMemHeapAllocator());
                    }

                    int intValue = 0x12345;
                    float floatValue = 366.0f;

                    test.m_dynFields.set("unnamedType1", hkReflect::Var(&intValue, unnamedType1));
                    test.m_dynFields.set("unnamedType2", hkReflect::Var(&floatValue, unnamedType2));
                }

                DynamicFieldsTest* copy = testObject(cloner, test);
                if (HK_TEST(copy))
                {
                HK_TEST(copy->m_int == 10);

                hkReflect::RecordVar varCopy = hkReflect::Var(copy);
                HK_TEST(hkReflect::DynamicFieldArray::getDynamicFields(varCopy) == &copy->m_dynFields);

                hkReflect::Var intFieldCopy = copy->m_dynFields.get("int");
                if (HK_TEST(intFieldCopy))
                {
                    hkReflect::IntVar intFieldVar = intFieldCopy;
                    if (HK_TEST(intFieldVar))
                    {
                        HK_TEST(intFieldVar.getValue().absValue() == 20);
                    }
                }

                hkReflect::RecordVar recFieldVar = copy->m_dynFields.get("record");
                if (HK_TEST(recFieldVar))
                {
                    hkTFEmbedType* recCopy = recFieldVar.dynCast<hkTFEmbedType>();
                    if (HK_TEST(recCopy))
                    {
                        HK_TEST(recCopy->m_emb_b == 30);
                    }
                }

                hkReflect::PointerVar ptrFieldVar = copy->m_dynFields.get("ptr");
                if (HK_TEST(ptrFieldVar))
                {
                    Ref0* pointedCopy = ptrFieldVar.getValue().dynCast<Ref0>();
                    if (HK_TEST(pointedCopy))
                    {
                        HK_TEST(pointedCopy->m_i0 == 40);
                        HK_TEST(pointedCopy->m_d == 3.14159);
                    }
                }

                hkReflect::IntVar enumVar = copy->m_dynFields.get("enum");
                if (HK_TEST(enumVar))
                {
                    TestEnum* enumCopy = enumVar.dynCast<TestEnum>();
                    if (HK_TEST(enumCopy))
                    {
                        HK_TEST(*enumCopy == VALUE2);
                    }
                }

                    if (disable.noneIsSet(DISABLE_NO_XML | DISABLE_INPLACE))
                {
                    hkReflect::IntVar dynEnumVar = copy->m_dynFields.get("dynEnum");
                    if (HK_TEST(dynEnumVar))
                    {
                        HK_TEST(dynEnumVar.isInstanceOf(dynamicEnumType));
                        int* dynEnumCopy = dynEnumVar.dynCast<int>();
                        if (HK_TEST(dynEnumCopy))
                        {
                            HK_TEST(*dynEnumCopy == VALUE2);
                        }
                    }

                    hkReflect::RecordVar unnamed1 = copy->m_dynFields.get("unnamedType1");
                    if (HK_TEST(unnamed1))
                    {
                        hkReflect::IntVar value = unnamed1["FieldInt"];
                        if (HK_TEST(value))
                        {
                            HK_TEST(value.getValue().convertTo<int>() == 0x12345);
                        }
                    }

                    hkReflect::RecordVar unnamed2 = copy->m_dynFields.get("unnamedType2");
                    if (HK_TEST(unnamed2))
                    {
                        hkReflect::FloatVar value = unnamed2["FieldFloat"];
                        if (HK_TEST(value))
                        {
                            HK_TEST(value.getValue().m_value == 366.0f);
                        }
                    }
                }

                if (cloner.mustDeleteCopy())
                {
                    delete copy;
                }
            }
            }

            // Must be deleted after destruction of the dynamic field array
            if (disable.noneIsSet(DISABLE_NO_XML | DISABLE_INPLACE))
            {
                HK_TEST(hk::DeleteTypeInfo::deleteType(unnamedType1));
                HK_TEST(hk::DeleteTypeInfo::deleteType(unnamedType2));
            }
        }
#endif
        if (testEnabled )
        {
            OpaqueTest t;
            t.m_f = 100;
            // this should be lost in copying
            t.m_nrArray.expandOne().m_a = 5000;

            const OpaqueTest* copy = testObject(cloner, t);

            if (HK_TEST(copy))
            {
                HK_TEST(copy->m_f == 100);

                if (cloner.mustDeleteCopy())
                {
                    // tests if the bypass constructor has set values correctly
                    if (disable.noneIsSet(DISABLE_POINTERS))
                    {
                        if (HK_TEST(copy->m_nrPtr != HK_NULL))
                        {
                            HK_TEST(copy->m_nrPtr->m_a == 100);
                        }
                        if (HK_TEST_EQ(copy->m_nrArray.getSize(), 1))
                        {
                            HK_TEST(copy->m_nrArray[0].m_a == 200);
                        }
                    }
                    delete copy;
                }
            }
        }

        if (testEnabled && disable.noneIsSet(DISABLE_POINTERS))
        {
            hkSimpleLocalFrame* node1 = new hkSimpleLocalFrame;
            hkSimpleLocalFrame* node2 = new hkSimpleLocalFrame;
            node1->setLocalTransform(hkTransform::getIdentity());
            node2->setLocalTransform(hkTransform::getIdentity());

            node1->m_children.pushBack(node2);
            node2->addReference();
            node2->m_parentFrame = node1; // not owned

            {
                hkSimpleLocalFrame* node1Clone = HK_NULL;
                node1Clone = testObject(cloner, *node1, "Cyclic local frame");

                if (HK_TEST(node1Clone != HK_NULL))
                {
                    HK_TEST(node1Clone->getChildFrame(0)->getParentFrame() == node1Clone);

                    if (cloner.mustDeleteCopy())
                    {
                        node1Clone->removeReference();
                    }
                }
            }

            node2->removeReference();
            node1->removeReference();
        }

#if defined(HK_BUILDING_WITH_ENGINE)
        if (testEnabled)
        {
            hkReflect::Type* memberType = HK_NULL;
            {
                hkReflect::TypeBuilder builder;
                builder.beginRecord("zzzz_stlSerialize_testDynamicType_dynamic", HK_NULL);
                builder.addMember("mem", 0, hkReflect::getType<int>());
                builder.addTrivialSpecialMethods();
                builder.setItem<hkReflect::Opt::FLAGS>(hkReflect::RecordType::TYPE_DYNAMIC);
                builder.addDeleteInfo();
                memberType = builder.allocate(hkMemHeapAllocator());
                hkReflect::RecordLayout::recomputeNative(memberType);
            }

            TestDynamic* loadedDyn = HK_NULL;
            {
                TestDynamic dyn;
                dyn.m_name = "testMe";
                dyn.m_data.allocate(2, memberType);
                *dyn.m_data[0]["mem"].dynCast<int>() = -25;
                *dyn.m_data[1]["mem"].dynCast<int>() = 121;
                loadedDyn = testObject(cloner, dyn);
            }

            if (HK_TEST(loadedDyn != HK_NULL))
            {
                HK_TEST(loadedDyn->m_name.compareTo("testMe") == 0);
                if (HK_TEST(loadedDyn->m_data.getSize() == 2))
                {
                    HK_TEST(*loadedDyn->m_data[0]["mem"].dynCast<int>() == -25);
                    HK_TEST(*loadedDyn->m_data[1]["mem"].dynCast<int>() == 121);
                }
            }

            if (cloner.mustDeleteCopy())
            {
                delete loadedDyn;
            }
            hk::DeleteTypeInfo::deleteType(memberType);
        }
#endif

#if !defined(HK_NO_STL_TESTS)
        hkDisableError allowGlobalNew(0xf0c34ded);

        if (testEnabled && disable.noneIsSet(DISABLE_INPLACE))
        {
            TestVector swv;

            swv.m_vec.push_back(20);
            swv.m_vec.push_back(40);
            swv.m_vec.push_back(60);
            swv.m_vec.push_back(80);
            swv.m_vec.push_back(100);

            TestVector* loadedSwv = testObject(cloner, swv);

            HK_TEST(loadedSwv);
            if (loadedSwv)
            {
                HK_TEST(loadedSwv->m_vec.size() == 5);
                if (loadedSwv->m_vec.size() == 5)
                {
                    HK_TEST(loadedSwv->m_vec[0] == 20);
                    HK_TEST(loadedSwv->m_vec[1] == 40);
                    HK_TEST(loadedSwv->m_vec[2] == 60);
                    HK_TEST(loadedSwv->m_vec[3] == 80);
                    HK_TEST(loadedSwv->m_vec[4] == 100);
                }
            }

            if (cloner.mustDeleteCopy())
            {
                delete loadedSwv;
            }
        }

        if(testEnabled && disable.noneIsSet(DISABLE_INPLACE))
        {
            TestString* loadedStr = HK_NULL;
            {
                TestString testStr;
                testStr.m_str = "Hello World";
                loadedStr = testObject(cloner, testStr);
                // Just in case the pointer hangs around
                testStr.m_str = "-----------";
            }

            HK_TEST(loadedStr);
            if (loadedStr)
            {
                HK_TEST(loadedStr->m_str.compare("Hello World") == 0);
            }

            if (cloner.mustDeleteCopy())
            {
                delete loadedStr;
            }
        }

        if(testEnabled && disable.noneIsSet(DISABLE_INPLACE))
        {
            TestVectorString* loadedVecStr = HK_NULL;
            {
                TestVectorString testVecStr;
                testVecStr.m_vecStr.push_back("Hello World");
                testVecStr.m_vecStr.push_back("Hello World 2");
                testVecStr.m_vecStr.push_back("Hello World 3");
                loadedVecStr = testObject(cloner, testVecStr);
            }

            HK_TEST(loadedVecStr);
            if (loadedVecStr)
            {
                HK_TEST(loadedVecStr->m_vecStr.size() == 3);
                if (loadedVecStr->m_vecStr.size() == 3)
                {
                    HK_TEST(loadedVecStr->m_vecStr[0].compare("Hello World") == 0);
                    HK_TEST(loadedVecStr->m_vecStr[1].compare("Hello World 2") == 0);
                    HK_TEST(loadedVecStr->m_vecStr[2].compare("Hello World 3") == 0);
                }
            }

            if (cloner.mustDeleteCopy())
            {
                delete loadedVecStr;
            }
        }

        if(testEnabled && disable.noneIsSet(DISABLE_INPLACE))
        {
            TestComplicated* loadedCt = HK_NULL;
            {
                TestComplicated tc;
                tc.m_root = 0;
                tc.m_names.push_back("Name 0");
                tc.m_names.push_back("Name 1");

                hkRefPtr<TestComplicated::NestedRef> nr0 = hkRefNew<TestComplicated::NestedRef>(new TestComplicated::NestedRef);
                nr0->m_name = "nr0";
                nr0->m_data.pushBack(22);
                nr0->m_data.pushBack(44);
                nr0->m_data.pushBack(66);

                hkRefPtr<TestComplicated::NestedRef> nr1 = hkRefNew<TestComplicated::NestedRef>(new TestComplicated::NestedRef);
                nr1->m_name = "nr1";
                nr1->m_data.pushBack(-1);
                nr1->m_data.pushBack(-3);
                nr1->m_data.pushBack(-4);

                tc.m_nests.push_back(TestComplicated::Nested(nr0, "con0"));
                tc.m_nests.push_back(TestComplicated::Nested(nr0, "con1"));
                tc.m_nests.push_back(TestComplicated::Nested(nr1, "con2"));

                loadedCt = testObject(cloner, tc);
            }

            if (HK_TEST(loadedCt))
            {
                if (HK_TEST(loadedCt->m_names.size() == 2))
                {
                    HK_TEST(loadedCt->m_names[0].compare("Name 0") == 0);
                    HK_TEST(loadedCt->m_names[1].compare("Name 1") == 0);
                }

                if (HK_TEST(loadedCt->m_nests.size() == 3))
                {
                    HK_TEST(loadedCt->m_nests[0].m_containerName.compareTo("con0") == 0);
                    HK_TEST(loadedCt->m_nests[1].m_containerName.compareTo("con1") == 0);
                    HK_TEST(loadedCt->m_nests[2].m_containerName.compareTo("con2") == 0);

                    HK_TEST(loadedCt->m_nests[0].m_ref == loadedCt->m_nests[1].m_ref);

                    HK_TEST(loadedCt->m_nests[0].m_ref->m_name.compare("nr0") == 0);
                    if (HK_TEST(loadedCt->m_nests[0].m_ref->m_data.getSize() == 3))
                    {
                        HK_TEST(loadedCt->m_nests[0].m_ref->m_data[0] == 22);
                        HK_TEST(loadedCt->m_nests[0].m_ref->m_data[1] == 44);
                        HK_TEST(loadedCt->m_nests[0].m_ref->m_data[2] == 66);
                    }

                    HK_TEST(loadedCt->m_nests[2].m_ref->m_name.compare("nr1") == 0);
                    if (HK_TEST(loadedCt->m_nests[2].m_ref->m_data.getSize() == 3))
                    {
                        HK_TEST(loadedCt->m_nests[2].m_ref->m_data[0] == -1);
                        HK_TEST(loadedCt->m_nests[2].m_ref->m_data[1] == -3);
                        HK_TEST(loadedCt->m_nests[2].m_ref->m_data[2] == -4);
                    }
                }
            }

            if (cloner.mustDeleteCopy())
            {
                delete loadedCt;
            }
        }
#endif

        if( testEnabled && disable.noneIsSet( DISABLE_NO_XML  ) )
        {
            UnitTest::WithTypeRef* loaded = HK_NULL;
            {
                UnitTest::WithTypeRef obj;
                obj.m_float = 100.0f;
                obj.m_type0 = hkReflect::getType<UnitTest::StringTest>(); // ref a new type
                obj.m_type1 = hkReflect::getType<UnitTest::WithTypeRef>(); // ref an already used type
                obj.m_type2 = HK_NULL; // null types handled?
                obj.m_type3 = hkReflect::getType<UnitTest::StringTest>(); // duplicate type
                obj.m_type4 = hkReflect::getType<UnitTest::Ref0>(); // unrelated type

                obj.m_decl1 = hkReflect::DataFieldDecl(&UnitTest::hkTestRecursive::m_int0);
                obj.m_decl2 = hkReflect::DataFieldDecl(&UnitTest::hkTestRecursive::m_nested);
                obj.m_decl3 = hkReflect::DataFieldDecl(&UnitTest::WithTypeRef::m_decl3);
                obj.m_decl4 = hkReflect::getType<UnitTest::WithProperty>()->findDecl("prop").asField();
                obj.m_decl5 = hkReflect::DataFieldDecl(&UnitTest::hkTestRecursive::m_nonSerializable);

                obj.m_string = HK_NULL;

                loaded = testObject(cloner, obj);
            }

            if(HK_TEST(loaded))
            {
                HK_TEST(loaded->m_float==100.0f);
                HK_TEST(loaded->m_type0);
                HK_TEST(loaded->m_type0 == loaded->m_type3);
                HK_TEST(loaded->m_type2.isNull() );
                //HK_TEST(loaded->m_type1.get() == res->getContentsType() );
                HK_TEST(loaded->m_type0 == hkReflect::getType<UnitTest::StringTest>() );

                HK_TEST(loaded->m_decl0.getType().isNull());
                HK_TEST_EQ(loaded->m_decl1, hkReflect::DataFieldDecl(&UnitTest::hkTestRecursive::m_int0));
                HK_TEST_EQ(loaded->m_decl2, hkReflect::DataFieldDecl(&UnitTest::hkTestRecursive::m_nested));
                HK_TEST_EQ(loaded->m_decl3, hkReflect::DataFieldDecl(&UnitTest::WithTypeRef::m_decl3));
                HK_TEST_EQ(loaded->m_decl4, hkReflect::getType<UnitTest::WithProperty>()->findDecl("id"));
                HK_TEST_EQ(loaded->m_decl5, hkReflect::DataFieldDecl(&UnitTest::hkTestRecursive::m_nonSerializable));

                if( cloner.mustDeleteCopy() )
                {
                    delete loaded;
                }
            }
        }

        if (testEnabled && 0)
        {
            TestCharArray* loadedCa = HK_NULL;
            {
                TestCharArray tc;
                hkString::memSet(&tc, 0, sizeof(tc));

                hkString::strNcpy(tc.m_chars, "Test this string", hkSizeOf(tc.m_chars));

                loadedCa = testObject(cloner, tc);
            }

            if (HK_TEST(loadedCa != HK_NULL))
            {
                HK_TEST(hkString::strCmp(loadedCa->m_chars, "Test this string") == 0);

                if (cloner.mustDeleteCopy())
                {
                    delete loadedCa;
                }
            }
        }

        if ( testEnabled )
        {
            int keys[] = { 15, 2, 12, 25, 36, 2, -2, 99, 0, -2, 2, 2, 2, 16, 27, 2, 3, 99, 82, 109, 0, 0 };
            testHashMap<int>( cloner, hkArrayView<int>( keys, HK_COUNT_OF(keys) ), "HashMapOfInts" );
            testHashMap2(cloner, hkArrayView<int>(keys, HK_COUNT_OF(keys)));
            testHashMap3(cloner, hkArrayView<int>(keys, HK_COUNT_OF(keys)));
        }

        if ( testEnabled )
        {
            hkArray<hkStringPtr> keys;
            {
                const char* source[] = { "Hello", "Goodbye", "Goodbye", "Hello2", "Bob", "How", "are", "you", "Hello2", "Tum-tee-tum" };
                for ( int i = 0; i < HK_COUNT_OF( source ); ++i )
                {
                    keys.expandOne() = source[i];
                }
            }
            testHashMap<hkStringPtr>( cloner, keys, "HashMapOfStrings" );
        }

        if ( testEnabled && disable.noneIsSet(DISABLE_NON_RELOCATABLE) )
        {
            // This hash object is not relocatable because the hashes computed on afterReflectNew() after loading
            // depend on the addresses, when the address changes the hash structure needs to be re-indexed, it won't
            // happen automatically.

            hkArray< hkRefPtr<const ObjKey> > keys;
            // Create an array of key objects, with some objects repeated and some nulls.
            {
                typedef hkHashMap<int, const ObjKey*> IndexArray;
                IndexArray objectIndexFromKeyIndex;
                const int source[] = { 15, 2, 12, 25, 36, 2, -2, 99, 0, -2, 2, 2, 2, 16, 27, 2, 3, 99, 82, 109, 0, 0 };
                for ( int i = 0; i < HK_COUNT_OF(source); ++i )
                {
                    if ( source[i] != 0 )
                    {
                        IndexArray::Iterator it = objectIndexFromKeyIndex.findOrInsertKey( source[i], HK_NULL );
                        if ( objectIndexFromKeyIndex.getValue( it ) == HK_NULL )
                        {
                            keys.expandOne().setAndDontIncrementRefCount( new ObjKey( source[i] ) );
                            objectIndexFromKeyIndex.setValue( it, keys.back() );
                        }
                        else
                        {
                            keys.pushBack( objectIndexFromKeyIndex.getValue( it ) );
                        }
                    }
                    else
                    {
                        keys.pushBack( HK_NULL );
                    }
                }
            }
            testHashMap< hkRefPtr<const ObjKey> >( cloner, keys, "HashMapOfRefPtrs" );
        }

        if ( testEnabled )
        {
            typedef hkTuple<hkUint64, hkStringPtr, int> Tuple;
            hkArray<Tuple> keys;
            {
                const char* source[] = { "Hello", "Goodbye", "Goodbye", "Hello2", "Bob", "How", "are", "you", "Hello2", "Tum-tee-tum" };
                for ( int i = 0; i < HK_COUNT_OF( source ); ++i )
                {
                    Tuple& tuple = keys.expandOne();
                    tuple.m_0 = i;
                    tuple.m_1 = source[i];
                    tuple.m_2 = i;
                }
            }

            testHashMap<Tuple>( cloner, keys, "HashMapOfTuples" );
        }

        if (testEnabled)
        {
            AfterReflectWrapper2 wrapper;
            wrapper.init();
            AfterReflectWrapper2* copy = testObject(cloner, wrapper);

            if (HK_TEST(copy != HK_NULL))
            {
                HK_TEST(copy->m_ar.m_i == 42);
                HK_TEST(copy->m_arw.m_ar.m_i == 42);

                for (int i = 0; i < 10; ++i)
                {
                    HK_TEST(copy->m_repeat[i].m_i == 42);
                }

                if (HK_TEST(copy->m_array.getSize() == 10))
                {
                    for (int i = 0; i < 10; ++i)
                    {
                        HK_TEST(copy->m_array[i].m_i == 42);
                    }
                }
            }

            if (cloner.mustDeleteCopy())
            {
                delete copy;
            }
        }

        if(testEnabled && disable.noneIsSet(DISABLE_POINTERS))
        {
            // Modify the cloned version to check that it can clean itself up correctly.
            // We take care to modify a NON-ROOT object because typically the root object is easily destroyed correctly.
            ArrayOfRefPtrs* rootCopy = HK_NULL;
            {
                ArrayOfRefPtrs childOrig;
                childOrig.m_ptrs.expandOne().setAndDontIncrementRefCount(new EmbedWithVtable(100));
                childOrig.m_ptrs.expandOne().setAndDontIncrementRefCount(new EmbedWithVtable(200));
                ArrayOfRefPtrs rootOrig;
                rootOrig.m_child = &childOrig;
                rootCopy = testObject(cloner, rootOrig);
            }
            if(HK_TEST(rootCopy))
            {
                HK_TEST(rootCopy->m_ptrs.getSize() == 0);
                ArrayOfRefPtrs* childCopy = rootCopy->m_child;

                childCopy->m_ptrs.expandOne().setAndDontIncrementRefCount(new EmbedWithVtable(1300));
                childCopy->m_ptrs.expandOne().setAndDontIncrementRefCount(new EmbedWithVtable(1400));
                childCopy->m_ptrs.expandOne().setAndDontIncrementRefCount(new EmbedWithVtable(1500));
                HK_TEST(childCopy->m_ptrs.getSize() == 5);
                if(cloner.mustDeleteCopy())
                {
                    delete rootCopy;
                }
            }
        }

        if(testEnabled && disable.noneIsSet(DISABLE_POINTERS))
        {
            PointerToArray* rootCopy = HK_NULL;
            {
                PointerToArray rootOrig;
                hkVector4 vec; vec.set(1, 2, 3, 4);
                rootOrig.m_vec = &vec;
                hkArray<int> arr;
                arr.pushBack(100);
                arr.pushBack(101);
                rootOrig.m_arr = &arr;

                rootCopy = testObject(cloner, rootOrig);
                hkCriticalSection sec1;
                hkCriticalSection sec2;
                hkCriticalSection sec3;
                hkCriticalSection sec4;
            }
            if(HK_TEST(rootCopy))
            {
                HK_TEST(rootCopy->m_vec);
                HK_TEST(rootCopy->m_arr);

                if(cloner.mustDeleteCopy())
                {
                    delete rootCopy->m_vec;
                    delete rootCopy->m_arr;
                    delete rootCopy;
                }
            }
        }

        if(testEnabled)
        {
            MultipleInheritance* copy = HK_NULL;
            {
                MultipleInheritance orig;
                orig.m_double = 3.14;
                copy = testObject(cloner, orig);
            }
            if(HK_TEST(copy))
            {
                HK_TEST(copy->m_double == 3.14);
                if(cloner.mustDeleteCopy())
                {
                    delete copy;
                }
            }
        }

        if(testEnabled)
        {
            testAlignment<AlignTest0>(cloner);
            testAlignment<AlignTest1>(cloner);
            testAlignment<AlignTest2>(cloner);
            testAlignment<AlignTest3>(cloner);
        }

        if (testEnabled)
        {
            SetterTest obj;
            obj.init();

            const SetterTest* copy = testObject(cloner, obj);
            if (HK_TEST(copy))
            {
                HK_TEST(obj == *copy);
                HK_TEST(!copy->m_intSet);
                HK_TEST(!copy->m_stringSet);
                HK_TEST(!copy->m_pointerSet);
                HK_TEST(!copy->m_nestedSet);
                HK_TEST(!copy->m_nested.m_twiceNestedSet);
                HK_TEST(!copy->m_arraySet);
                HK_TEST(!copy->m_arrayRecSet);
                HK_TEST(!copy->m_arrayArraySet);
                if (cloner.mustDeleteCopy())
                {
                    delete copy;
                }
            }
        }

        if ( testEnabled && cloner.isSerializer() )
        {
            Serializer& serializer = static_cast<Serializer&>( cloner );

            static const double ORIG_VALUE = 3.14;

            NonSerializableField orig;
            orig.m_double = ORIG_VALUE; // set to non-default value

            hkReflect::Var var( &orig );

            // Attacker modifies the local reflection data
            hkReflect::Type* modifiedType = nullptr;
            {
                // Get original record type
                const hkReflect::Type* const origType = var.getType();

                // Get original record field
                auto* const decls = hkReflect::TypeDetail::getDeclsArray( origType );
                auto const origField = decls->getField( 0 ); // 'm_double'

                // Create type copy with modified field
                hkReflect::TypeBuilder builder;
                builder.beginShallowClone( origType );
                builder.setItem<hkReflect::Opt::DECLS>( nullptr );
                auto const origFlags = origField.getFlags().get();
                HK_TEST( origFlags & hkReflect::Decl::DECL_NOT_SERIALIZABLE );
                hkReflect::Decl::DeclFlags modifiedFieldFlags( origField.getFlags().get() & ~hkReflect::Decl::DECL_NOT_SERIALIZABLE );
                builder.addMember( origField.getName(), origField.getOffset(), modifiedFieldFlags, origField.getType() );
                builder.addDeleteInfo();
                modifiedType = builder.allocate( hkMemHeapAllocator() );

                var = hkReflect::Var( &orig, modifiedType );
            }

            auto* const testName = hkReflect::getName<NonSerializableField>();

            // Serialize data as normal
            hkArray<char> buffer;
            serializer.serialize( testName, var, hkOstream( buffer ).getStreamWriter() );

            // Deserialize
            hkReflect::Var copyVar = serializer.deserialize( testName, hkIstream( buffer.begin(), buffer.getSize() ).getStreamReader() );

            // Check that non-serializable field was correctly skipped
            if ( HK_TEST( copyVar ) )
            {
                auto* const copy = copyVar.dynCast<NonSerializableField>();
                if ( HK_TEST( copy ) )
                {
                    HK_TEST_NE( ORIG_VALUE, copy->m_double ); // deserialized with default value because hk::Serialize(false) on target
                    if ( cloner.mustDeleteCopy() )
                    {
                        delete copy;
                    }
                }
            }

            if ( modifiedType )
            {
                hk::DeleteTypeInfo::deleteType( modifiedType );
            }
        }
    }

#define ENABLE_DEBUG_LOGS 0
#if ENABLE_DEBUG_LOGS
    #define LOG_OPERATION(LOG, ...) \
        hkLog::connectToOutput( "s11n", &LOG, hkLog::Level::Debug ); \
        hkLog::connectToOutput( "reflect.Clone", &LOG, hkLog::Level::Debug ); \
        __VA_ARGS__; \
        hkLog::flush(); \
        hkLog::disconnect( "s11n", &LOG ); \
        hkLog::disconnect( "reflect.Clone", &LOG )
#else
    #define LOG_OPERATION(LOG, ...) __VA_ARGS__
#endif

    hkReflect::Var Serializer::clone(const char* testName, const hkReflect::Var& root)
    {
        // serialization and de-serialization
        hkArray<char> firstBuffer, secondBuffer;
        hkLog::TextOutput firstSerializeLog(hkLog::Level::Debug), deserializeLog( hkLog::Level::Debug ), secondSerializeLog( hkLog::Level::Debug );

        LOG_OPERATION( firstSerializeLog, serialize( testName, root, hkOstream( firstBuffer ).getStreamWriter() ) );

        // For debugging

        //if(sizeof(void*) == 8)
        //{
        //  hkOstream("debugFile_64.hkt").write(firstBuffer.begin(), firstBuffer.getSize());
        //}
        //else
        //{
        //  hkOstream("debugFile.hkt").write(firstBuffer.begin(), firstBuffer.getSize());
        //}

        hkReflect::Var res;
        LOG_OPERATION( deserializeLog,
            res = deserialize( testName, hkIstream( firstBuffer.begin(), firstBuffer.getSize() ).getStreamReader() ) );

        if (res)
        {
            // re-serialization and comparison
            LOG_OPERATION( secondSerializeLog, serialize( testName, res, hkOstream( secondBuffer ).getStreamWriter() ) );
            const int sizeToCompare = hkMath::min2(firstBuffer.getSize(), secondBuffer.getSize());
            bool sameContents = firstBuffer.getSize() == secondBuffer.getSize() &&
                hkString::memCmp(firstBuffer.begin(), secondBuffer.begin(), sizeToCompare) == 0;
            //for( int i= 0; i < sizeToCompare; ++i )
            //{
            //  if( firstBuffer[i] != secondBuffer[i] )
            //  {
            //      //HK_BREAKPOINT(0);
            //  }
            //}
            HK_TEST2(sameContents, "Test '" << testName << "' failed, contents of serialized buffer are different");
            if ( ENABLE_DEBUG_LOGS && !sameContents )
            {
                hkStringBuf buf;
                hkOstream( "debugLog_s11n_serialize1.txt" ) << firstSerializeLog.getText(buf);
                hkOstream( "debugLog_s11n_deserialize.txt" ) << deserializeLog.getText(buf);
                hkOstream( "debugLog_s11n_serialize2.txt" ) << secondSerializeLog.getText(buf);
            }
        }
        return res;
    }

    // ------------------------------------- Wrapper for the C-function versions ---------------------------------------- //

    class CloneFuncWrapper : public Cloner
    {
    public:
        CloneFuncWrapper(CloneFunc func, bool mustDeleteCopy)
            : m_func(func)
            , m_mustDeleteCopy(mustDeleteCopy)
        {
        }

        virtual hkReflect::Var clone(const char* testName, const hkReflect::Var& root) HK_OVERRIDE
        {
            return m_func(testName, root);
        }

        virtual bool mustDeleteCopy() HK_OVERRIDE { return m_mustDeleteCopy; }

    private:
        CloneFunc m_func;
        bool m_mustDeleteCopy;
    };

    class SerializeFuncWrapper : public Serializer
    {
    public:
        SerializeFuncWrapper(SerializeFunc serializeFunc, DeserializeFunc deserializeFunc)
            : m_serializeFunc(serializeFunc)
            , m_deserializeFunc(deserializeFunc)
        {
        }

        virtual void serialize(const char* testName, const hkReflect::Var& root, hkStreamWriter* sw) HK_OVERRIDE
        {
            m_serializeFunc(testName, root, sw);
        }

        virtual hkReflect::Var deserialize(const char* testName, hkStreamReader* sr) HK_OVERRIDE
        {
            return m_deserializeFunc(testName, sr);
        }

    private:
        SerializeFunc m_serializeFunc;
        DeserializeFunc m_deserializeFunc;
    };

    void test(CloneFunc cloneFunc, bool mustDeleteCopy)
    {
        CloneFuncWrapper wrapper(cloneFunc, mustDeleteCopy);
        TEST_MAIN_BREAK_HERE(wrapper, DISABLE_NONE);
    }

    void test(SerializeFunc serializeFunc, DeserializeFunc deserializeFunc)
    {
        SerializeFuncWrapper wrapper(serializeFunc, deserializeFunc);
        TEST_MAIN_BREAK_HERE(wrapper, DISABLE_NONE);
    }
}

}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
