// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Base/hkBase.h>
#include <Common/Base/UnitTest/hkUnitTest.h>


static void* custom_alloc( int numBytes ) { return HK_NULL; }
static void custom_free( void*, int numBytes ) { }

class HK_EXPORT_COMMON CustomAllocator : public hkMemoryAllocator
{
    public:

        virtual _Ret_notnull_ _Post_writable_byte_size_(numBytes) void* blockAlloc(int numBytes) HK_OVERRIDE
        {
            if (auto* p = custom_alloc(numBytes))
            {
                return p;
            }

            if(numBytes)
            {
                return outOfMemory();
            }
            else
            {
                return nullptr;
            }
        }
        virtual void blockFree(_In_opt_bytecount_(numBytes) void* p, int numBytes ) HK_OVERRIDE { return custom_free(p, numBytes); }
        virtual void getMemoryStatistics( MemoryStatistics& u ) const HK_OVERRIDE { }
        virtual int getAllocatedSize(_In_bytecount_(numBytes) const void* obj, int numBytes) const HK_OVERRIDE { return numBytes; }
};


int allocator_test_main()
{
    CustomAllocator c;
    return 0;
}

HK_TEST_REGISTER(allocator_test_main, "Fast", "Common/Test/UnitTest/Base/", __FILE__);

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
