// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Base/hkBase.h>
#include <Common/Base/UnitTest/hkUnitTest.h>

static int constructs;
static int destructs;

struct Foo : public hkReferencedObject
{
    HK_DECLARE_CLASS(Foo, NewOpaque);

    Foo()
    {
        m_value = hkUnitTest::rand();
        ++constructs;
    }
    Foo(int n)
    {
        m_value = n;
        ++constructs;
    }


    ~Foo()
    {
        ++destructs;
    }
    Foo( const Foo& f)
        : hkReferencedObject(f)
    {
        m_value = f.m_value;
        ++constructs;
    }
    void operator=(const Foo& f)
    {
        m_value = f.m_value;
        ++constructs;
        ++destructs;
    }

    hkBool operator==(const Foo& f) const
    {
        return m_value == f.m_value;
    }
    hkBool operator!=(const Foo& f) const
    {
        return m_value != f.m_value;
    }


    int m_value;
};

static void object_array()
{
    constructs = 0;
    destructs = 0;

    int i;
    {
        hkArray<Foo> a;
        HK_TEST(a.getSize()==0);
        HK_TEST(a.isEmpty());
        HK_TEST(constructs==0);
        HK_TEST(destructs==0);
    }

    constructs = 0;
    destructs = 0;

    {
        hkArray<Foo> b(10);
        HK_TEST(constructs==10);
        HK_TEST(destructs==0);
        HK_TEST(b.getSize()==10);
        HK_TEST(!b.isEmpty());

        b.popBack();
        HK_TEST(constructs==10);
        HK_TEST(destructs==1);
        HK_TEST(b.getSize()==9);

        b.clear();
        HK_TEST(constructs==10);
        HK_TEST(destructs==10);
        HK_TEST(b.getSize()==0);
        HK_TEST(b.isEmpty());
        HK_TEST(b.getCapacity()!=0);
    }

    constructs = 0;
    destructs = 0;

    {
        hkArray<Foo> a;
        a.reserve(5);
        HK_TEST(constructs==0);
        HK_TEST(destructs==0);
        a.setSize(3);
        HK_TEST(constructs==3);
        HK_TEST(destructs==0);
        a.setSize(4);
        HK_TEST(constructs==4);
        HK_TEST(destructs==0);
    }

    constructs = 0;
    destructs = 0;

    {
        hkArray<Foo> a;
        a.reserve(10);
        HK_TEST(constructs==0);
        HK_TEST(destructs==0);
        a.setSize(5);
        HK_TEST(constructs==5);
        HK_TEST(destructs==0);
        a.setSize(15);
        HK_TEST(constructs==15);
        HK_TEST(destructs==0);
    }

    constructs = 0;
    destructs = 0;

    {
        Foo initial = 99;
        hkArray<Foo> c(5, initial);
        HK_TEST(c.getSize()==5);
        for(i=0; i<c.getSize(); ++i)
        {
            HK_TEST(c[i]==initial);
        }
        HK_TEST(constructs==6); // 5 + 1 for initial
        HK_TEST(destructs==0);

        c.clearAndDeallocate();
        HK_TEST(constructs==6);
        HK_TEST(destructs==5);
        HK_TEST(c.getSize()==0);
        HK_TEST(c.getCapacity()==0);
    }

    constructs = 0;
    destructs = 0;

    {
        hkArray<Foo> d(10);
        for(i=0; i<d.getSize(); ++i)
        {
            d[i] = i;
        }
        HK_TEST(constructs - destructs == 10);

        d.removeAt(5);
        HK_TEST(constructs - destructs == 9);
        HK_TEST(d.getSize()==9);
        HK_TEST(d[5]!=5);
        HK_TEST(d[4]==4);
        HK_TEST(d[6]==6);
    }

    constructs = 0;
    destructs = 0;

    {
        hkArray<Foo> d(10);
        for(i=0; i<d.getSize(); ++i)
        {
            d[i] = i;
        }
        HK_TEST(constructs - destructs == 10);

        d.removeAtAndCopy(5);
        HK_TEST(constructs - destructs == 9);
        HK_TEST(d.getSize()==9);
        HK_TEST(d[5]==6);
        HK_TEST(d[4]==4);
        HK_TEST(d[6]==7);
    }

    constructs = 0;
    destructs = 0;

    {
        hkArray<Foo> d;
        d.setSize(10);
        for(i=0; i<d.getSize(); ++i)
        {
            d[i] = i;
        }
        HK_TEST(constructs - destructs == 10);
        d.removeAtAndCopy(5);
        HK_TEST(constructs - destructs == 9);

        HK_TEST(d.getSize()==9);
        HK_TEST(d[4]==4);
        HK_TEST(d[5]==6);
        HK_TEST(d[6]==7);
        HK_TEST(d.indexOf(4)==4);
        HK_TEST(d.indexOf(5)==-1);
        HK_TEST(d.indexOf(6)==5);
    }

    {
        hkArray<Foo> d(10);
        for(i=0; i<d.getSize(); ++i)
        {
            d[i] = i%5;
        }
        HK_TEST(d.indexOf(3)==3);
        HK_TEST(d.lastIndexOf(3)==8);
    }

    {
        hkArray<Foo> d;
        for(i=0; i<10; ++i)
        {
            d.pushBack(i);
        }
        for(i=0; i<10; ++i)
        {
            HK_TEST(d[i]==i);
        }
    }

    {
        hkArray<Foo> d;
        d.reserve(10);
        for(i=0; i<10; ++i)
        {
            d.pushBack(i);
        }
        HK_TEST(d.getSize()==10);
        for(i=0; i<10; ++i)
        {
            HK_TEST(d[i]==i);
        }
    }

    {
        hkArray<Foo> d;
        d.reserve(10);
        for(i=0; i<10; ++i)
        {
            d.pushBack(i);
        }
        HK_TEST(d.getSize()==10);
        for(i=0; i<10; ++i)
        {
            HK_TEST(d[i]==i);
        }
    }

    {
        hkArray<Foo> d;
        d.reserve(10);
        for(i=0; i<10; ++i)
        {
            d.pushBack(i);
        }
        for(i=0; i<10; ++i)
        {
            HK_TEST(d[i]==i);
        }
    }

    {
        hkArray<Foo> d;
        d.reserve(10);
        d.setSize(5);
        HK_TEST(d.getSize()==5);
        HK_TEST(d.getCapacity()>=10);
    }

    constructs = 0;
    destructs = 0;

    {
        hkArray<Foo> d;
        d.expandBy(1);
        d.expandBy(1);
        HK_TEST(constructs - destructs == 2);
    }
/*
    {
        hkArray<Foo> d;
        for(i=0; i<10; ++i)
        {
            d.pushBack(i);
        }
        Foo foo = 99;
        d.insertAt(0, foo);
        HK_TEST(d.getSize()==11);
        HK_TEST(d[0]==foo);
        for(i=0; i<10; ++i)
        {
            HK_TEST(d[i+1] == i);
        }
    }
*/
/*
    {
        hkArray<Foo> d;
        hkArray<Foo> e;
        for(i=0; i<10; ++i)
        {
            d.pushBack(i);
            e.pushBack(-i);
        }
        d.insertAt(3,e);
        HK_TEST(d.getSize()==20);
        HK_TEST(d[2]==2);
        HK_TEST(d[3]==0);
        HK_TEST(d[4]==-1);
        HK_TEST(d[12]==-9);
        HK_TEST(d[13]==3);
        HK_TEST(d[14]==4);
        HK_TEST(d[19]==9);
    }
*/
    {
        hkArray< hkArray<int> > a;
        a.setSize(10);
    }
    {
        hkArray< hkArray<Foo> > a;
        a.setSize(10);
    }

}

int object_array_main()
{
    object_array();
    return 0;
}

HK_TEST_REGISTER(object_array_main, "Fast", "Common/Test/UnitTest/Base/", __FILE__     );

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
