// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Base/hkBase.h>
#include <Common/Base/UnitTest/hkUnitTest.h>
#include <Common/Base/Algorithm/Sort/hkSort.h>
#include <Common/Base/Algorithm/PseudoRandom/hkPseudoRandomGenerator.h>
#include <Common/Base/Algorithm/Hash/hkHash.h>

#include <Common/Base/System/Stopwatch/hkStopwatch.h>

namespace HashTest
{

static const char * sourceString0 = "dadsuou iwemn cxzk chjkeq r789213khasnmkdbmasc ukzuhsddkjsamrnweb";
static const char * sourceString1 = "2938 asdkl xmcnm$KLASJD SDJ powew )()( SKDJS ||| sdskdjk";

}

int hash_main()
{
    using namespace HashTest;

    {
        hkUint32 hash = hkHash::computeCrc32( sourceString0, hkString::strLen( sourceString0 ) );
        HK_TEST( hash == 0x9ad31362 ); // Checked against on-line calculator.
        hkUint32 nextHash = hkHash::appendCrc32( hash, sourceString1, hkString::strLen( sourceString1 ) );
        HK_TEST( nextHash == 0xb4827832 ); // Checked against on-line calculator.
    }
    {
        hkUint64 hash = hkHash::computeCrc64( sourceString0, hkString::strLen( sourceString0 ) );
        HK_TEST( hash == 0xd2c2b335570a29bfull );
        hkUint64 nextHash = hkHash::appendCrc64( hash, sourceString1, hkString::strLen( sourceString1 ) );
        HK_TEST( nextHash == 0xd8853e7a1e394924ull );
    }
    {
        hkUint32 hash = hkHash::computeCrc32(sourceString0);
        HK_TEST(hash == 0x9ad31362); // Checked against on-line calculator.
        hkUint32 nextHash = hkHash::appendCrc32(hash, sourceString1);
        HK_TEST(nextHash == 0xb4827832); // Checked against on-line calculator.
    }
    {
        hkUint64 hash = hkHash::computeCrc64(sourceString0);
        HK_TEST(hash == 0xd2c2b335570a29bfull);
        hkUint64 nextHash = hkHash::appendCrc64(hash, sourceString1);
        HK_TEST(nextHash == 0xd8853e7a1e394924ull);
    }
    {
        hkUint32 hash = hkHash::computeFNV1Hash32( sourceString0 );
        HK_TEST( hash == 0x852d798f ); // Checked against on-line calculator.
    }
    {
        hkUint64 hash = hkHash::computeFNV1Hash64( sourceString0 );
        HK_TEST( hash == 0xd79619bc58e93b2f ); // Checked against on-line calculator.
    }
    {
        hkStringPtr sourceStringPtr = sourceString0;
        hkUint32 hash = hkHash::computeMurmurHash3( sourceStringPtr.cString(), sourceStringPtr.getLength() );
        HK_TEST( hash == 0xb175a70a ); // Checked against on-line calculator.
    }
    {
        // Ensure null strings can be safely hashed, and that the null string hashes to a different value from the empty string.
        hkUint32 nullHash = hkHash::hkHashValue(static_cast<const char*>(HK_NULL));
        hkUint32 emptyHash = hkHash::hkHashValue("");
        HK_TEST( nullHash != emptyHash );
    }

    {
        hkStringPtr sourceStringPtr = sourceString0;
        hkUint64 hash[2];
        hkHash::computeMurmurHash3_128( sourceStringPtr.cString(), sourceStringPtr.getLength(), hash );
        // Checked against on-line calculator.
        HK_TEST( hash[0] == 0xd7aa42968493cbfbull );
        HK_TEST( hash[1] == 0x6b22066a274ce6abull );
    }
    {
        // Ensure null strings can be safely hashed, and that the null string hashes to a different value from the empty string.
        hkUint32 nullHash = hkHash::hkHashValue(static_cast<const char*>(HK_NULL));
        hkUint32 emptyHash = hkHash::hkHashValue("");
        HK_TEST( nullHash != emptyHash );
    }

    return 0;
}

HK_TEST_REGISTER(hash_main, "Fast", "Common/Test/UnitTest/Base/", __FILE__     );

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
