// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/Types/hkTrait.h>

template<typename T>
HK_INLINE hkWeakPtr<T>::hkWeakPtr()
{
    set(HK_NULL);
}

template<typename T>
template<typename U>
HK_INLINE hkWeakPtr<T>::hkWeakPtr(const hkWeakPtr<U>& obj)
{
    set(obj);
}

template<typename T>
template<typename U>
HK_INLINE hkWeakPtr<T>::hkWeakPtr(const hkRefPtr<U>& obj)
{
    set(obj);
}

template<typename T>
template<typename U>
HK_INLINE hkWeakPtr<T>::hkWeakPtr(const hkViewPtr<U>& obj)
{
    set(obj);
}


template<typename T>
HK_INLINE hkWeakPtr<T>::hkWeakPtr(_In_opt_ const void* obj)
{
    HK_ASSERT_NO_MSG(0x5f900759, obj == HK_NULL);
    set(obj);
}


template<typename T>
template<typename U>
HK_INLINE hkWeakPtr<T>::hkWeakPtr(_In_opt_ U* obj)
{
    hkRefPtr<U> o = obj;
    set(o);
}

template<typename T>
template<typename U>
HK_INLINE void hkWeakPtr<T>::set(const hkWeakPtr<U>& obj)
{
#ifdef HK_ARCH_X64
    
    HK_COMPILE_TIME_ASSERT(hkTrait::IsConvertibleTo<U, T>::result);
#endif
    m_status = obj.m_status;
}

template<typename T>
template<typename U>
HK_INLINE void hkWeakPtr<T>::set(const hkRefPtr<U>& obj)
{
#ifdef HK_ARCH_X64
    
    HK_COMPILE_TIME_ASSERT(hkTrait::IsConvertibleTo<U, T>::result);
#endif
    if(obj)
    {
        m_status = hkWeakPtrDetail::StatusRegistry::getInstance().getOrCreateStatus(hkPtrConstCast< typename hkTrait::RemoveConst<U>::type >(obj));
    }
    else
    {
        m_status = HK_NULL;
    }
}

template<typename T>
template<typename U>
HK_INLINE void hkWeakPtr<T>::set(const hkViewPtr<U>& obj)
{
    set(obj.val());
}


template<typename T>
template<typename U>
HK_INLINE void hkWeakPtr<T>::set(_In_opt_ U* obj)
{
    hkRefPtr<U> o = obj;
    set(o);
}

template<typename T>
HK_INLINE void hkWeakPtr<T>::set(_In_opt_ const void* obj)
{
    HK_ASSERT_NO_MSG(0x111dc1d2, obj == HK_NULL);
    set(hkRefPtr<T>());
}

template<typename T>
template<typename U>
HK_INLINE hkWeakPtr<T>& hkWeakPtr<T>::operator=(const hkWeakPtr<U>& rhs)
{
    set(rhs);
    return *this;
}

template<typename T>
template<typename U>
HK_INLINE hkWeakPtr<T>& hkWeakPtr<T>::operator=(const hkRefPtr<U>& rhs)
{
    set(rhs);
    return *this;
}

template<typename T>
template<typename U>
hkWeakPtr<T>& hkWeakPtr<T>::operator=(const hkViewPtr<U>& rhs)
{
    set(rhs);
    return *this;
}

template<typename T>
template<typename U>
HK_INLINE hkWeakPtr<T>&  hkWeakPtr<T>::operator=(_In_opt_ U* obj)
{
    hkRefPtr<U> o = obj;
    set(o);
    return *this;
}

template<typename T>
HK_INLINE hkWeakPtr<T>& hkWeakPtr<T>::operator=(_In_opt_ const void* obj)
{
    HK_ASSERT_NO_MSG(0x146e525e, obj == HK_NULL);
    set(obj);
    return *this;
}

template<typename T>
HK_INLINE hkRefPtr<T> hkWeakPtr<T>::acquire() const
{
    hkRefPtr<T> refPtr;
    if (m_status)
    {
        hkWeakPtrDetail::StatusRegistry::ReadLock lock(hkWeakPtrDetail::StatusRegistry::getInstance().getLock());

        if (T* ptr = static_cast<T*>(m_status->getPtr()))
        {
            // We can't simply call addReference here because there is a risk that the object is being
            // deleted but we haven't updated the m_status yet. In that case the reference count will
            // be 0 so we call a special method which will atomically increase the reference count if
            // it is not 0.
            if (ptr->addReferenceIfNotZero())
            {
                refPtr.setAndDontIncrementRefCount(ptr);
            }
            // else: the refcount reached 0, consider the object dead.
        }
    }
    return refPtr;
}

template<typename T>
HK_INLINE _Ret_maybenull_ T* hkWeakPtr<T>::unsafeAcquire() const
{
    if(m_status)
    {
        return static_cast<T*>(m_status->getPtr());
    }
    else
    {
        return HK_NULL;
    }
}

template<typename T>
HK_INLINE bool hkWeakPtr<T>::isDead() const
{
    if(m_status)
    {
        return m_status->getPtr() == HK_NULL;
    }

    return true;
}

template<typename T>
HK_INLINE bool hkWeakPtr<T>::operator==(const hkWeakPtr<T>& other) const
{
    return m_status == other.m_status;
}

template<typename T>
HK_INLINE hkUint32 hkHashValue(const hkWeakPtr<T>& ptr)
{
    // We use the address of the Status object as identity. This means that the identity (hash) of the hkWeakPtr
    // won't change even if the hkReferencedObject dies (if it did we might violate invariants of hkHash* containers).
    return hkHash::hkHashValue(ptr.m_status.val());
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
