// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Common/Base/Reflect/Core/hkReflectVar.h>
#include <Common/Base/System/Error/hkAssert.h>

namespace hkVarArgs
{
    /// Vector style variant of the varargs interface.
    /// See hkVarArgs.h for the list style variants and the details about both.
    struct HK_EXPORT_COMMON Vector
    {
        HK_ALWAYS_INLINE Vector() : m_begin(HK_NULL), m_end(HK_NULL) {}

        /// Constructor from an existing contiguous storage (C-style array).
        /// Borrows the storage but does not take ownership.
        HK_ALWAYS_INLINE Vector( _In_reads_opt_ (numVars) hkReflect::Detail::AddrAndType* vars, hkUlong numVars )
            : m_begin( vars ), m_end( vars + numVars )
        {
            HK_ASSERT_IMPLEMENTATION( 0, m_begin || (getSize() == 0),
                "Cannot build hkVarArgs::Vector with size={} and m_begin={}.", getSize(), m_begin );
        }

        /// Constructor from a view of an array of hkReflect::Var.
        /// Borrows the storage but does not take ownership.
        HK_ALWAYS_INLINE Vector( hkArrayView<hkReflect::Detail::AddrAndType> view ) : m_begin( view.begin() ), m_end( view.end() ) {}

        HK_ALWAYS_INLINE hkUlong getSize() const
        {
            HK_ASSERT_IMPLEMENTATION( 0, m_end >= m_begin, "Inconsistent begin/end pointers in hkVarArgs::Vector." );
            return hkUlong( m_end - m_begin );
        }

            /// Use implicit conversion of Detail::AddrAndType -> Var
        HK_ALWAYS_INLINE hkReflect::Var operator[]( hkUlong index ) const
        {
            HK_ASSERT_IMPLEMENTATION( 0, m_begin && index < hkUlong(m_end-m_begin), "Out of bounds varargs access" );
            return m_begin[index];
        }

        HK_ALWAYS_INLINE operator hkArrayView<hkReflect::Detail::AddrAndType>() const
        {
            return hkArrayView<hkReflect::Detail::AddrAndType>( m_begin, m_end );
        }

        HK_ALWAYS_INLINE hkReflect::Detail::AddrAndType* begin() const { return m_begin; }
        HK_ALWAYS_INLINE hkReflect::Detail::AddrAndType* end() const { return m_end; }

        /// Unpack as many arguments as the internal storage can hold.
        /// This can unpack less arguments than present in the types argument
        /// if there are more than getSize().
        /// Return the number of arguments actually unpacked.
        hkUlong unpack(VaTypes types, va_list& args);

    protected:

        /// Beginning of Var view (pointer to first Var in storage).
        hkReflect::Detail::AddrAndType* m_begin;

        /// End of Var view (pointer past last Var in storage).
        hkReflect::Detail::AddrAndType* m_end;
    };

    /// Utility class providing some in-place storage for a hkVarArgs vector.
    template<hkUlong N>
    struct HK_EXPORT_COMMON FixedArray : public Vector
    {
        HK_ALWAYS_INLINE FixedArray() : Vector( m_vars, N ) {}

        void setSize( hkUlong size )
        {
            HK_ASSERT_IMPLEMENTATION( 0, size <= N, "Invalid FixedArray size {} greater than array capacity {}.", size, N );
            HK_ASSERT_IMPLEMENTATION( 0, m_begin || (size == 0), "Cannot setSize({}) with m_begin={}.", size, m_begin );
            m_end = m_begin + size;
        }

        void unpack( VaTypes types, va_list& args )
        {
            const hkUlong numUnpackedTypes = Vector::unpack( types, args );
            setSize( numUnpackedTypes );
        }

    private:

        /// In-place storage for N arguments.
        hkReflect::Detail::AddrAndType m_vars[ N ];
    };
}

/// Macro to unpack a varargs list into a given hkVarArgs::FixedArray.
/// Usage:
///   void foo( hkVarArgs::VaTypes argTypes, ... )
///   {
///       hkVarArgs::FixedArray<16> buffer;
///       HK_VARARGS_UNPACK( buffer, argTypes );
///       // use buffer...
///   }
#define HK_VARARGS_UNPACK(BUFOUT, ARGTYPES) { \
    va_list vlist; \
    va_start( vlist, ARGTYPES ); \
    BUFOUT.unpack( ARGTYPES, vlist ); \
    va_end( vlist ); }


//
// Overloads declare a function NAME, returning TYPE which forward to VARARGS_FUNC

#define HK_VARARGS_FUNCTION_0(RET, NAME, VARARGS_FUNC ) \
    HK_DETAIL_VARARGS_FUNCTION_0(RET, return, NAME, VARARGS_FUNC )
#define HK_VARARGS_FUNCTION_1(RET, NAME, ARG0, arg0, VARARGS_FUNC ) \
    HK_DETAIL_VARARGS_FUNCTION_1(RET, return, NAME, ARG0, arg0, VARARGS_FUNC )
#define HK_VARARGS_FUNCTION_2(RET, NAME, ARG0, arg0, ARG1, arg1, VARARGS_FUNC ) \
    HK_DETAIL_VARARGS_FUNCTION_2(RET, return, NAME, ARG0, arg0, ARG1, arg1, VARARGS_FUNC )
#define HK_VARARGS_FUNCTION_3(RET, NAME, ARG0, arg0, ARG1, arg1, ARG2, arg2, VARARGS_FUNC ) \
    HK_DETAIL_VARARGS_FUNCTION_3(RET, return, NAME, ARG0, arg0, ARG1, arg1, ARG2, arg2, VARARGS_FUNC )
#define HK_VARARGS_FUNCTION_4(RET, NAME, ARG0, arg0, ARG1, arg1, ARG2, arg2, ARG3, arg3, VARARGS_FUNC ) \
    HK_DETAIL_VARARGS_FUNCTION_4(RET, return, NAME, ARG0, arg0, ARG1, arg1, ARG2, arg2, ARG3, arg3, VARARGS_FUNC )

// Overloads for constructor NAME which foward to VARARGS_FUNC initializer method (since we can't forward constructors)

#define HK_VARARGS_CONSTRUCTOR_0(NAME, VARARGS_FUNC ) \
    HK_DETAIL_VARARGS_FUNCTION_0(/**/,/**/, NAME, VARARGS_FUNC )
#define HK_VARARGS_CONSTRUCTOR_1(NAME, ARG0, arg0, VARARGS_FUNC ) \
    HK_DETAIL_VARARGS_FUNCTION_1(/**/,/**/, NAME, ARG0, arg0, VARARGS_FUNC )
#define HK_VARARGS_CONSTRUCTOR_2(NAME, ARG0, arg0, ARG1, arg1, VARARGS_FUNC ) \
    HK_DETAIL_VARARGS_FUNCTION_2(/**/,/**/, NAME, ARG0, arg0, ARG1, arg1, VARARGS_FUNC )

/// Convenience for when the first argument is a format string.
#define HK_VARARGS_FUNCTION_FORMAT(RET, NAME, VNAME) \
    HK_VARARGS_FUNCTION_1(RET, NAME, const char*, fmt, VNAME)


// Generated by //depot/Other/Personal/Stephen.Kennedy/reflectdata/GenerateVarArgs.py

#define HK_DETAIL_VARARGS_FUNCTION_0(RETURN_TYPE, RETURN_KEYWORD, NAME, VARARGS_FUNC ) \
    inline RETURN_TYPE NAME() \
    { RETURN_KEYWORD VARARGS_FUNC(hkVarArgs::Vector()); } \
    template <typename T0> inline RETURN_TYPE NAME(const T0& t0) \
    { hkReflect::Detail::AddrAndType args[1] = { &t0 }; RETURN_KEYWORD VARARGS_FUNC(hkVarArgs::Vector(args, HK_COUNT_OF(args))); } \
    template <typename T0, typename T1> inline RETURN_TYPE NAME(const T0& t0, const T1& t1) \
    { hkReflect::Detail::AddrAndType args[2] = { &t0, &t1 }; RETURN_KEYWORD VARARGS_FUNC(hkVarArgs::Vector(args, HK_COUNT_OF(args))); } \
    template <typename T0, typename T1, typename T2> inline RETURN_TYPE NAME(const T0& t0, const T1& t1, const T2& t2) \
    { hkReflect::Detail::AddrAndType args[3] = { &t0, &t1, &t2 }; RETURN_KEYWORD VARARGS_FUNC(hkVarArgs::Vector(args, HK_COUNT_OF(args))); } \
    template <typename T0, typename T1, typename T2, typename T3> inline RETURN_TYPE NAME(const T0& t0, const T1& t1, const T2& t2, const T3& t3) \
    { hkReflect::Detail::AddrAndType args[4] = { &t0, &t1, &t2, &t3 }; RETURN_KEYWORD VARARGS_FUNC(hkVarArgs::Vector(args, HK_COUNT_OF(args))); } \
    template <typename T0, typename T1, typename T2, typename T3, typename T4> inline RETURN_TYPE NAME(const T0& t0, const T1& t1, const T2& t2, const T3& t3, const T4& t4) \
    { hkReflect::Detail::AddrAndType args[5] = { &t0, &t1, &t2, &t3, &t4 }; RETURN_KEYWORD VARARGS_FUNC(hkVarArgs::Vector(args, HK_COUNT_OF(args))); } \
    template <typename T0, typename T1, typename T2, typename T3, typename T4, typename T5> inline RETURN_TYPE NAME(const T0& t0, const T1& t1, const T2& t2, const T3& t3, const T4& t4, const T5& t5) \
    { hkReflect::Detail::AddrAndType args[6] = { &t0, &t1, &t2, &t3, &t4, &t5 }; RETURN_KEYWORD VARARGS_FUNC(hkVarArgs::Vector(args, HK_COUNT_OF(args))); }

#define HK_DETAIL_VARARGS_FUNCTION_1(RETURN_TYPE, RETURN_KEYWORD, NAME, ARG0, arg0, VARARGS_FUNC ) \
    inline RETURN_TYPE NAME(ARG0 arg0) \
    { RETURN_KEYWORD VARARGS_FUNC(arg0, hkVarArgs::Vector()); } \
    template <typename T0> inline RETURN_TYPE NAME(ARG0 arg0, const T0& t0) \
    { hkReflect::Detail::AddrAndType args[1] = { &t0 }; RETURN_KEYWORD VARARGS_FUNC(arg0, hkVarArgs::Vector(args, HK_COUNT_OF(args))); } \
    template <typename T0, typename T1> inline RETURN_TYPE NAME(ARG0 arg0, const T0& t0, const T1& t1) \
    { hkReflect::Detail::AddrAndType args[2] = { &t0, &t1 }; RETURN_KEYWORD VARARGS_FUNC(arg0, hkVarArgs::Vector(args, HK_COUNT_OF(args))); } \
    template <typename T0, typename T1, typename T2> inline RETURN_TYPE NAME(ARG0 arg0, const T0& t0, const T1& t1, const T2& t2) \
    { hkReflect::Detail::AddrAndType args[3] = { &t0, &t1, &t2 }; RETURN_KEYWORD VARARGS_FUNC(arg0, hkVarArgs::Vector(args, HK_COUNT_OF(args))); } \
    template <typename T0, typename T1, typename T2, typename T3> inline RETURN_TYPE NAME(ARG0 arg0, const T0& t0, const T1& t1, const T2& t2, const T3& t3) \
    { hkReflect::Detail::AddrAndType args[4] = { &t0, &t1, &t2, &t3 }; RETURN_KEYWORD VARARGS_FUNC(arg0, hkVarArgs::Vector(args, HK_COUNT_OF(args))); } \
    template <typename T0, typename T1, typename T2, typename T3, typename T4> inline RETURN_TYPE NAME(ARG0 arg0, const T0& t0, const T1& t1, const T2& t2, const T3& t3, const T4& t4) \
    { hkReflect::Detail::AddrAndType args[5] = { &t0, &t1, &t2, &t3, &t4 }; RETURN_KEYWORD VARARGS_FUNC(arg0, hkVarArgs::Vector(args, HK_COUNT_OF(args))); } \
    template <typename T0, typename T1, typename T2, typename T3, typename T4, typename T5> inline RETURN_TYPE NAME(ARG0 arg0, const T0& t0, const T1& t1, const T2& t2, const T3& t3, const T4& t4, const T5& t5) \
    { hkReflect::Detail::AddrAndType args[6] = { &t0, &t1, &t2, &t3, &t4, &t5 }; RETURN_KEYWORD VARARGS_FUNC(arg0, hkVarArgs::Vector(args, HK_COUNT_OF(args))); }

#define HK_DETAIL_VARARGS_FUNCTION_2(RETURN_TYPE, RETURN_KEYWORD, NAME, ARG0, arg0, ARG1, arg1, VARARGS_FUNC ) \
    inline RETURN_TYPE NAME(ARG0 arg0, ARG1 arg1) \
    { RETURN_KEYWORD VARARGS_FUNC(arg0, arg1, hkVarArgs::Vector()); } \
    template <typename T0> inline RETURN_TYPE NAME(ARG0 arg0, ARG1 arg1, const T0& t0) \
    { hkReflect::Detail::AddrAndType args[1] = { &t0 }; RETURN_KEYWORD VARARGS_FUNC(arg0, arg1, hkVarArgs::Vector(args, HK_COUNT_OF(args))); } \
    template <typename T0, typename T1> inline RETURN_TYPE NAME(ARG0 arg0, ARG1 arg1, const T0& t0, const T1& t1) \
    { hkReflect::Detail::AddrAndType args[2] = { &t0, &t1 }; RETURN_KEYWORD VARARGS_FUNC(arg0, arg1, hkVarArgs::Vector(args, HK_COUNT_OF(args))); } \
    template <typename T0, typename T1, typename T2> inline RETURN_TYPE NAME(ARG0 arg0, ARG1 arg1, const T0& t0, const T1& t1, const T2& t2) \
    { hkReflect::Detail::AddrAndType args[3] = { &t0, &t1, &t2 }; RETURN_KEYWORD VARARGS_FUNC(arg0, arg1, hkVarArgs::Vector(args, HK_COUNT_OF(args))); } \
    template <typename T0, typename T1, typename T2, typename T3> inline RETURN_TYPE NAME(ARG0 arg0, ARG1 arg1, const T0& t0, const T1& t1, const T2& t2, const T3& t3) \
    { hkReflect::Detail::AddrAndType args[4] = { &t0, &t1, &t2, &t3 }; RETURN_KEYWORD VARARGS_FUNC(arg0, arg1, hkVarArgs::Vector(args, HK_COUNT_OF(args))); } \
    template <typename T0, typename T1, typename T2, typename T3, typename T4> inline RETURN_TYPE NAME(ARG0 arg0, ARG1 arg1, const T0& t0, const T1& t1, const T2& t2, const T3& t3, const T4& t4) \
    { hkReflect::Detail::AddrAndType args[5] = { &t0, &t1, &t2, &t3, &t4 }; RETURN_KEYWORD VARARGS_FUNC(arg0, arg1, hkVarArgs::Vector(args, HK_COUNT_OF(args))); } \
    template <typename T0, typename T1, typename T2, typename T3, typename T4, typename T5> inline RETURN_TYPE NAME(ARG0 arg0, ARG1 arg1, const T0& t0, const T1& t1, const T2& t2, const T3& t3, const T4& t4, const T5& t5) \
    { hkReflect::Detail::AddrAndType args[6] = { &t0, &t1, &t2, &t3, &t4, &t5 }; RETURN_KEYWORD VARARGS_FUNC(arg0, arg1, hkVarArgs::Vector(args, HK_COUNT_OF(args))); }

#define HK_DETAIL_VARARGS_FUNCTION_3(RETURN_TYPE, RETURN_KEYWORD, NAME, ARG0, arg0, ARG1, arg1, ARG2, arg2, VARARGS_FUNC ) \
    inline RETURN_TYPE NAME(ARG0 arg0, ARG1 arg1, ARG2 arg2) \
    { RETURN_KEYWORD VARARGS_FUNC(arg0, arg1, arg2, hkVarArgs::Vector()); } \
    template <typename T0> inline RETURN_TYPE NAME(ARG0 arg0, ARG1 arg1, ARG2 arg2, const T0& t0) \
    { hkReflect::Detail::AddrAndType args[1] = { &t0 }; RETURN_KEYWORD VARARGS_FUNC(arg0, arg1, arg2, hkVarArgs::Vector(args, HK_COUNT_OF(args))); } \
    template <typename T0, typename T1> inline RETURN_TYPE NAME(ARG0 arg0, ARG1 arg1, ARG2 arg2, const T0& t0, const T1& t1) \
    { hkReflect::Detail::AddrAndType args[2] = { &t0, &t1 }; RETURN_KEYWORD VARARGS_FUNC(arg0, arg1, arg2, hkVarArgs::Vector(args, HK_COUNT_OF(args))); } \
    template <typename T0, typename T1, typename T2> inline RETURN_TYPE NAME(ARG0 arg0, ARG1 arg1, ARG2 arg2, const T0& t0, const T1& t1, const T2& t2) \
    { hkReflect::Detail::AddrAndType args[3] = { &t0, &t1, &t2 }; RETURN_KEYWORD VARARGS_FUNC(arg0, arg1, arg2, hkVarArgs::Vector(args, HK_COUNT_OF(args))); } \
    template <typename T0, typename T1, typename T2, typename T3> inline RETURN_TYPE NAME(ARG0 arg0, ARG1 arg1, ARG2 arg2, const T0& t0, const T1& t1, const T2& t2, const T3& t3) \
    { hkReflect::Detail::AddrAndType args[4] = { &t0, &t1, &t2, &t3 }; RETURN_KEYWORD VARARGS_FUNC(arg0, arg1, arg2, hkVarArgs::Vector(args, HK_COUNT_OF(args))); } \
    template <typename T0, typename T1, typename T2, typename T3, typename T4> inline RETURN_TYPE NAME(ARG0 arg0, ARG1 arg1, ARG2 arg2, const T0& t0, const T1& t1, const T2& t2, const T3& t3, const T4& t4) \
    { hkReflect::Detail::AddrAndType args[5] = { &t0, &t1, &t2, &t3, &t4 }; RETURN_KEYWORD VARARGS_FUNC(arg0, arg1, arg2, hkVarArgs::Vector(args, HK_COUNT_OF(args))); } \
    template <typename T0, typename T1, typename T2, typename T3, typename T4, typename T5> inline RETURN_TYPE NAME(ARG0 arg0, ARG1 arg1, ARG2 arg2, const T0& t0, const T1& t1, const T2& t2, const T3& t3, const T4& t4, const T5& t5) \
    { hkReflect::Detail::AddrAndType args[6] = { &t0, &t1, &t2, &t3, &t4, &t5 }; RETURN_KEYWORD VARARGS_FUNC(arg0, arg1, arg2, hkVarArgs::Vector(args, HK_COUNT_OF(args))); }

#define HK_DETAIL_VARARGS_FUNCTION_4(RETURN_TYPE, RETURN_KEYWORD, NAME, ARG0, arg0, ARG1, arg1, ARG2, arg2, ARG3, arg3, VARARGS_FUNC ) \
    inline RETURN_TYPE NAME(ARG0 arg0, ARG1 arg1, ARG2 arg2, ARG3 arg3) \
    { RETURN_KEYWORD VARARGS_FUNC(arg0, arg1, arg2, arg3, hkVarArgs::Vector()); } \
    template <typename T0> inline RETURN_TYPE NAME(ARG0 arg0, ARG1 arg1, ARG2 arg2, ARG3 arg3, const T0& t0) \
    { hkReflect::Detail::AddrAndType args[1] = { &t0 }; RETURN_KEYWORD VARARGS_FUNC(arg0, arg1, arg2, arg3, hkVarArgs::Vector(args, HK_COUNT_OF(args))); } \
    template <typename T0, typename T1> inline RETURN_TYPE NAME(ARG0 arg0, ARG1 arg1, ARG2 arg2, ARG3 arg3, const T0& t0, const T1& t1) \
    { hkReflect::Detail::AddrAndType args[2] = { &t0, &t1 }; RETURN_KEYWORD VARARGS_FUNC(arg0, arg1, arg2, arg3, hkVarArgs::Vector(args, HK_COUNT_OF(args))); } \
    template <typename T0, typename T1, typename T2> inline RETURN_TYPE NAME(ARG0 arg0, ARG1 arg1, ARG2 arg2, ARG3 arg3, const T0& t0, const T1& t1, const T2& t2) \
    { hkReflect::Detail::AddrAndType args[3] = { &t0, &t1, &t2 }; RETURN_KEYWORD VARARGS_FUNC(arg0, arg1, arg2, arg3, hkVarArgs::Vector(args, HK_COUNT_OF(args))); } \
    template <typename T0, typename T1, typename T2, typename T3> inline RETURN_TYPE NAME(ARG0 arg0, ARG1 arg1, ARG2 arg2, ARG3 arg3, const T0& t0, const T1& t1, const T2& t2, const T3& t3) \
    { hkReflect::Detail::AddrAndType args[4] = { &t0, &t1, &t2, &t3 }; RETURN_KEYWORD VARARGS_FUNC(arg0, arg1, arg2, arg3, hkVarArgs::Vector(args, HK_COUNT_OF(args))); } \
    template <typename T0, typename T1, typename T2, typename T3, typename T4> inline RETURN_TYPE NAME(ARG0 arg0, ARG1 arg1, ARG2 arg2, ARG3 arg3, const T0& t0, const T1& t1, const T2& t2, const T3& t3, const T4& t4) \
    { hkReflect::Detail::AddrAndType args[5] = { &t0, &t1, &t2, &t3, &t4 }; RETURN_KEYWORD VARARGS_FUNC(arg0, arg1, arg2, arg3, hkVarArgs::Vector(args, HK_COUNT_OF(args))); } \
    template <typename T0, typename T1, typename T2, typename T3, typename T4, typename T5> inline RETURN_TYPE NAME(ARG0 arg0, ARG1 arg1, ARG2 arg2, ARG3 arg3, const T0& t0, const T1& t1, const T2& t2, const T3& t3, const T4& t4, const T5& t5) \
    { hkReflect::Detail::AddrAndType args[6] = { &t0, &t1, &t2, &t3, &t4, &t5 }; RETURN_KEYWORD VARARGS_FUNC(arg0, arg1, arg2, arg3, hkVarArgs::Vector(args, HK_COUNT_OF(args))); }

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
