// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Base/hkBase.h>
#include <Common/Base/Types/hkVarArgsV.h>
#include <Common/Base/Fwd/hkcstdarg.h>

hkUlong hkVarArgs::Vector::unpack(VaTypes types, va_list& args)
{
    // By convention types is NULL if there is nothing in the list.
    // See hkVarArgsDetail::ReflectionOf<void> specialization.
    if (!types)
    {
        return 0;
    }

    // The underlying storage of hkVarArgs might contain less space for Var
    // than the actual number of arguments in va_list and types (for example
    // when using a fixed-size hKVarArgsBuf<N>).
    auto const numAvailTypes = types->m_numTypes;
    auto const numUnpackedTypes = hkMath::min2<hkUlong>(numAvailTypes, getSize());

    typedef hkVarArgs::Detail::VarArgsTypeArray<1> BaseStorage;
    auto const typeArray = reinterpret_cast<const BaseStorage*>(types);
    const hkReflect::Type* const* typeItems = typeArray->m_types;

    hkReflect::Detail::AddrAndType* var = m_begin;
    for (hkUlong typeIndex = 0u; typeIndex < numUnpackedTypes; ++typeIndex)
    {
        var[typeIndex].m_addr = va_arg(args, void*);
        var[typeIndex].m_type = typeItems[typeIndex];
    }

    return hkLosslessCast<hkUlong>(numUnpackedTypes);
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
