// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

HK_DETAIL_DIAG_MSVC_PUSH()
HK_DETAIL_DIAG_MSVC_OFF(4296)

namespace hkString
{
    HK_EXPORT_COMMON int HK_CALL strCmp(_In_z_ const char* s1, _In_z_ const char* s2 );
}

namespace hkReflect
{
    namespace Detail
    {
        template<typename T> struct PresetsOf;
    }
}

namespace hkTrait
{
    struct UnusedType
    {
    };

    // Boolean trait

    template <bool N>
    struct TraitBool
    {
        typedef TraitBool<N> type;
        typedef type Type;
        enum { result = N };
    };

    typedef TraitBool<true> TrueType;
    typedef TraitBool<false> FalseType;

    template<typename T, T VALUE>
    struct IntegralConstant
    {
        typedef T value_type;
        enum { value = VALUE };
    };

    typedef char Yes;
    typedef long No;


    // Types are equal

    template <typename T, typename U>
    struct TypesAreEqual : public FalseType { };

    template <typename T>
    struct TypesAreEqual<T, T> : public TrueType { };


    template <typename T, typename U>
    struct TypesAreDifferent : public TrueType {};

    template <typename T>
    struct TypesAreDifferent<T, T> : public FalseType {};


    // Type signedness

    template<typename T>
    struct IsSigned : public TraitBool < T(-1) < T(0) > { };


    // If

    template<bool COND, typename IF_TRUE, typename IF_FALSE>
    struct If;

    template<typename IF_TRUE, typename IF_FALSE>
    struct If<true, IF_TRUE, IF_FALSE>
    {
        typedef IF_TRUE Type;
    };

    template<typename IF_TRUE, typename IF_FALSE>
    struct If<false, IF_TRUE, IF_FALSE>
    {
        typedef IF_FALSE Type;
    };

    // Wraps a constant integer value

    template<int N>
    struct Constant
    {
        enum { Result = N };
    };

#if defined(HK_COMPILER_GHS)
    // warning #1934-D: aggregate type passed through ellipsis
#pragma ghs nowarning 1934
#endif

    /// Returns true if Source can be converted to Destination (ie. if you can create a Destination from a Source)
    /// This means typically that either:
    /// * Source inherits publicly from Destination
    /// * Source has a public non-explicit constructor such as: Source(const Destination&)
    /// * Source can be coerced into Destination (int to double, ...)
    template< typename Source, typename Destination >
    struct IsConvertibleTo
    {
        static hkTrait::Yes isConvertible(const Destination&);
        static hkTrait::No isConvertible(...);

        enum
        {
            result = (sizeof(isConvertible(static_cast<Source&>(*reinterpret_cast<Source*>(128)))) == sizeof(Yes))
        };
    };

    /// Specialize this to enable ViewAsOther on couples of binary-compatible types.
    template<typename Source, typename Destination>
    struct CanBeReinterpreted : public FalseType {};

    // Specializations below make specializing the trait for specific types easier (can write a specialization just for
    // <T,U> and not for <const T, U> etc.

    // If an A can be reinterpreted as a B, it can be reinterpreted as a const B.
    template<typename Source, typename Destination>
    struct CanBeReinterpreted<Source, const Destination> : public CanBeReinterpreted<Source, Destination> {};

    // If an A can be reinterpreted as a const B, a const A can be reinterpreted as a const B.
    template<typename Source, typename Destination>
    struct CanBeReinterpreted<const Source, const Destination> : public CanBeReinterpreted<Source, const Destination> {};

    /// Utility to convert between pointers to binary-compatible types.
    /// The default (for CanBeReinterpreted == false) uses implicit cast so it will handle the case where From extends
    /// or equals To. Explicit specializations of CanBeReinterpreted are defined for couple of types which are known to
    /// be binary-compatible.
    template<typename From, typename To, bool CONVERTIBLE = CanBeReinterpreted<From, To>::result>
    struct ViewAsOther
    {
        static HK_ALWAYS_INLINE _Ret_maybenull_ To* view(_In_opt_ From* obj)
        {
            return obj;
        }
    };

    template<typename From, typename To>
    struct ViewAsOther<From, To, true>
    {
        static HK_ALWAYS_INLINE _Ret_maybenull_ To* view(_In_opt_ From* obj)
        {
            // Types are known to be compatible so just reinterpret_cast.
            return reinterpret_cast<To*>( obj );
        }
    };

    /// Returns true if Test inherits from Base.
    /// Tests that a pointer to Test can be implicitly converted to a pointer to Base (and Base is not void).
    
    template <typename Test, typename Base>
    struct InheritsFrom : public TraitBool<
        TypesAreDifferent<Base, void>::result &&
        TypesAreDifferent<Base, const void>::result &&
        IsConvertibleTo<Test*, const Base* const>::result
    > {};

    template <typename Test, typename Base>
    struct InheritsFrom<Test&, Base> : public FalseType {};

    template <typename Test, typename Base>
    struct InheritsFrom<Test*, Base> : public FalseType {};

#if defined(HK_COMPILER_GHS)
#pragma ghs endnowarning
#endif

    /// Trait used to restrict a template function to a category of types.
    /// Enables the function if Cond is true: template<class T> EnableIf< IsPod<T>::result, void >::Type foo(const T& t); // foo(v) compiles only if v is a Pod
    /// See std::enable_if.
    template<bool Cond, typename T = void>
    struct EnableIf;

    template<typename T>
    struct EnableIf<true, T>
    {
        typedef T Type;
    };


    /// Trait used to restrict a template function to a category of types. See std::enable_if.
    /// Disables the function if Cond is true: template<class T> DisableIf< IsPod<T>::result, void >::Type foo(const T& t); // foo(v) compiles only if v isn't a Pod
    /// See boost::disable_if_c. This could also be: template<bool B, typename T = void> using DisableIf = EnableIf<!B, T>;
    template<bool Cond, typename T = void>
    struct DisableIf;

    template<typename T>
    struct DisableIf<false, T>
    {
        typedef T Type;
    };

    /// VoidValue transforms 'void' into a type which behaves as a value and leaves any other type untouched.
    template<typename T>
    struct VoidValue
    {
        typedef T Type;
        typedef T* PtrType;
    };

    namespace Detail
    {
        // Behaves like a void pointer, except with pointer arithmetics.
        // Should be used internally only.
        template<typename VOID_T>
        struct VoidPtr
        {
            VOID_T* m_ptr;

            VoidPtr() {}
            VoidPtr(_In_opt_ VOID_T* p) : m_ptr(p) {}
            _Ret_maybenull_ operator VOID_T*() const { return m_ptr; }
            _Ret_notnull_ VOID_T* operator+(hkLong off) const { return (VOID_T*)((hkUlong(m_ptr) + off)); }
            _Ret_notnull_ VOID_T* operator-(hkLong off) const { return (VOID_T*)((hkUlong(m_ptr) - off)); }
            hkLong operator-(_In_opt_ const void* other) const { return hkLong(m_ptr) - hkLong(other); }
        };
    }

    template<>
    struct VoidValue<void>
    {
        typedef hkUint8 Type;
        typedef Detail::VoidPtr<void> PtrType;
    };

    template<>
    struct VoidValue<const void>
    {
        typedef const hkUint8 Type;
        typedef Detail::VoidPtr<const void> PtrType;
    };

    /// Trait that determines if T is a builtin type (int, float, ...).
    template<typename T>
    struct IsBuiltinType
    {
        typedef char yes;
        typedef int no;

        template<typename U>
        static no testfunc(void (U::*)());

        template<typename U>
        static yes testfunc(...);

        enum { Result = sizeof(testfunc<T>(0)) == sizeof(yes) };
    };
    /// Trait that determines if T is a pointer type.
    template<typename T> struct IsPointerType : public FalseType {};
    template<typename T> struct IsPointerType<T*> : public TrueType {};

    template<typename T> struct IsReferenceType : public FalseType {};
    template<typename T> struct IsReferenceType<T&> : public TrueType {};

    /// Trait that determines if T is a builtin string type.
    template<typename T> struct IsStringType : public FalseType {};
    template<typename T> struct IsStringType<const T> : public IsStringType<T> {};
    template<> struct IsStringType<char*> : public TrueType{};
    template<> struct IsStringType<const char*> : public TrueType{};
    template<unsigned N> struct IsStringType<char[N]> : public TrueType{};
    template<unsigned N> struct IsStringType<const char[N]> : public TrueType{};

    namespace Detail
    {
        /// Return hkTrait::Yes if the given pointer is const, hkTrait::No otherwise. Use through hkIsConstPointer.
        struct IsConstPointerHelper
        {
            static hkTrait::Yes result(const void*);
            static hkTrait::No result(void*);
        };
    }

    /// Evaluates to a compile-time constant true if the pointer is const, false otherwise.
#define hkIsConstPointer(VALUE) (sizeof(hkTrait::Detail::IsConstPointerHelper::result(VALUE)) == sizeof(hkTrait::Yes))

    /// Compare two values using strcmp if strings, otherwise '=='.
    template<typename T, typename S, bool IS_STR = hkTrait::IsStringType<T>::result && hkTrait::IsStringType<S>::result>
    struct EqualValues
    {
        static HK_ALWAYS_INLINE bool func(const T& l, const S& r) { return l == r; }
    };

    template<typename T, typename S>
    struct EqualValues<T, S, true>
    {
        static HK_ALWAYS_INLINE bool func(const T& l, const S& r)
        {
            if(l == r) { return true; }
            if(l && r) { return hkString::strCmp(l, r) == 0; }
            return false;
        }
    };

    // C++17 style voider
    // http://en.cppreference.com/w/cpp/types/void_t
    template<class> struct Voider { typedef void Type; };

    /// Declares a trait called HashMethod_METHOD_NAME which determines if a given type has a method or not.
    /// It exposes three values:
    ///     HasMethod_XXX<T>::NonConst: true if T has a non-const XXX method
    ///     HasMethod_XXX<T>::Const: true if T has a const XXX method
    ///     HasMethod_XXX<T>::Any: true if T has a either a const or non-const XXX method
#define HK_DECLARE_HAS_METHOD_TRAIT(METHOD_RETURN_TYPE, METHOD_NAME, ... /*METHOD_ARGS as variadic args*/) \
    template<typename T, bool IsBuiltinType = hkTrait::IsBuiltinType<T>::Result != 0> \
    struct HasMethod_ ## METHOD_NAME { enum { NonConst = 0, Const = 0, Any = 0 }; }; \
    \
    template<typename T> \
    struct HasMethod_ ## METHOD_NAME <T, false>\
    { \
        typedef char yes; \
        typedef int no; \
    \
        typedef METHOD_RETURN_TYPE (T::*MethodType)(__VA_ARGS__); \
    \
        template <typename Deferred, MethodType f> struct hasMethod {}; \
        template <typename Deferred> \
        static yes check(hasMethod<Deferred, &Deferred::METHOD_NAME>*); \
    \
        template <typename Deferred> \
        static no check(...); \
    \
        typedef METHOD_RETURN_TYPE (T::*ConstMethodType)(__VA_ARGS__) const; \
    \
        template <typename Deferred, ConstMethodType f> struct hasMethodConst {}; \
        template <typename Deferred> \
        static yes checkConst(hasMethodConst<Deferred, &Deferred::METHOD_NAME>*); \
    \
        template <typename Deferred> \
        static no checkConst(...); \
    \
        enum { NonConst = sizeof(check<T>(0)) == sizeof(yes) }; \
        enum { Const = sizeof(checkConst<T>(0)) == sizeof(yes) }; \
        enum { Any = int(NonConst || Const) }; \
    };

    template<typename T> struct EnumCheck : public FalseType {};
    template<typename T> struct EnumCheck<typename hkReflect::Detail::PresetsOf<T> > : public TrueType {};

    template<typename T>
    struct IsReflectedEnum
    {
        typedef EnumCheck<T> Type;
    };
}

HK_DETAIL_DIAG_MSVC_POP()

#include <Common/Base/Types/Traits/hkTraitModifier.h>

namespace hk
{

    template<typename T>
    HK_CONSTEXPR T&& forward(
        typename hkTrait::RemoveRef<T>::Type& arg) HK_NOEXCEPT
    {   // forward an lvalue as either an lvalue or an rvalue
        return (static_cast<T&&>(arg));
    }

    template<typename T>
    HK_CONSTEXPR T&& forward(
        typename hkTrait::RemoveRef<T>::Type&& arg) HK_NOEXCEPT
    {   // forward an rvalue as an rvalue
        return (static_cast<T&&>(arg));
    }

    // TEMPLATE FUNCTION move
    template<typename T>
    HK_CONSTEXPR typename hkTrait::RemoveRef<T>::Type&&
        move(T&& arg) HK_NOEXCEPT
    {   // forward _Arg as movable
        return (static_cast<typename hkTrait::RemoveRef<T>::Type&&>(arg));
    }

}  // namespace hk

#include <Common/Base/Types/Traits/hkTraitIsPod.h>
#include <Common/Base/Types/Traits/hkTraitArithmetic.h>

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
