// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

HK_SIGNAL_PARAMETERS
struct HK_SIGNAL_TYPE : hkSignal
{

    HK_DECLARE_CLASS(hkSignal, NewOpaque); 

    /// Base slot declaration.
    struct Slot : hkSlot
    {
        HK_DECLARE_CLASS(Slot, NewOpaque); 

        /// Constructor.
        template <typename TYPE>
        HK_INLINE Slot(SlotList& _slots, _Inout_ TYPE* object, _In_z_ const char* name) : hkSlot(_slots, object, name) {}

        /// Virtual destructor.
        virtual         ~Slot() {}

        /// Fire method.
        virtual void    call(HK_SIGNAL_ARGUMENTS)=0;

        /// Subscribe this slot to a given signal.
        virtual void    subscribe( HK_SIGNAL_TYPE& signal ) = 0;

        /// Retrieve method infos.
        virtual void    getMethod( const void*& methodDataOut, int& methodLengthOut ) const = 0;
    };

    /// Global slot.
    template <typename METHOD>
    struct GlobalSlot : Slot
    {
        HK_DECLARE_CLASS(GlobalSlot, NewOpaque);

        HK_INLINE       GlobalSlot(SlotList& _slots, METHOD method, _In_z_ const char* name) : Slot(_slots, (void*)HK_NULL, name), m_method(method) {}
        virtual void        call(HK_SIGNAL_ARGUMENTS) HK_OVERRIDE { m_method(HK_SIGNAL_NAMES); }
        virtual hkBool32    matchMethod(_In_ const void* methodData, int methodLength) const HK_OVERRIDE { return methodLength == sizeof(METHOD) && *reinterpret_cast<const METHOD*>(methodData) == m_method; }
        virtual void        subscribe( HK_SIGNAL_TYPE& signal ) HK_OVERRIDE{ signal.template subscribe<METHOD>( m_method, hkSlot::getName() ); }
        virtual void        getMethod( _Outref_ const void*& methodDataOut, _Out_ int& methodLengthOut ) const HK_OVERRIDE{ methodDataOut = &m_method; methodLengthOut = sizeof( METHOD ); }

        METHOD  m_method;
    };

    template <typename T>
    struct SlotMethodType
    {
        typedef void (T::*type)(HK_SIGNAL_ARGUMENTS);
    };

    /// Member slot.
    template <typename TYPE, typename METHOD>
    struct MemberSlot : Slot
    {
        HK_DECLARE_CLASS(MemberSlot, NewOpaque);

        enum { SIZE_OF_METHOD = sizeof(METHOD), };

        HK_INLINE       MemberSlot(SlotList& _slots, _Inout_ TYPE* object, METHOD method, _In_z_ const char* name) : Slot(_slots, object, name), m_method(method) {}

        /// Call the signal handler. If you have a compile error here, your functions signature does not match the signature of the signal.
        virtual void        call(HK_SIGNAL_ARGUMENTS) HK_OVERRIDE { (reinterpret_cast<TYPE*>(Slot::m_object)->*m_method)(HK_SIGNAL_NAMES); }

        virtual hkBool32    matchMethod(_In_ const void* methodData, int methodLength) const HK_OVERRIDE
        {
            const bool sizeMatch = methodLength == SIZE_OF_METHOD;
            const bool addrMatch = *reinterpret_cast<const METHOD*>(methodData) == m_method;
            return sizeMatch && addrMatch;
        }

        virtual void        subscribe( HK_SIGNAL_TYPE& signal ) HK_OVERRIDE{ signal.template subscribe<TYPE, METHOD>( reinterpret_cast<TYPE*>(Slot::m_object), m_method, hkSlot::getName() ); }
        virtual void        getMethod( _Outref_ const void*& methodDataOut, _Out_ int& methodLengthOut ) const HK_OVERRIDE{ methodDataOut = &m_method; methodLengthOut = sizeof( METHOD ); }

        METHOD  m_method;
    };
    typedef void (*SlotFunctionType)(HK_SIGNAL_ARGUMENTS);

    template <typename FUNCTION>
    struct FunctionSlot : Slot
    {
        HK_DECLARE_CLASS(FunctionSlot, NewOpaque);

        HK_INLINE       FunctionSlot(SlotList& _slots, FUNCTION function) : Slot(_slots, this, HK_NULL), m_function(function) {}

        /// Call the signal handler. If you have a compile error here, your functions signiture does not match the signiture of the signal.
        virtual void        call(HK_SIGNAL_ARGUMENTS) HK_OVERRIDE { m_function (HK_SIGNAL_NAMES); }

        virtual hkBool32    matchMethod(_In_ const void* methodData, int methodLength) const HK_OVERRIDE { return (methodData==HK_NULL) && (methodLength==666); }

        
        virtual void        subscribe( HK_SIGNAL_TYPE& signal ) HK_OVERRIDE{ HK_ASSERT_NO_MSG(0x353edf2e, false);    }
        virtual void        getMethod(_Outref_ const void*& methodDataOut, _Out_ int& methodLengthOut) const HK_OVERRIDE { methodDataOut = HK_NULL; methodLengthOut = 0; HK_ASSERT_NO_MSG(0x6fe5d378, false); }

        FUNCTION m_function;
    };

    // Signal constructor.
    HK_INLINE           HK_SIGNAL_TYPE(_In_z_ const char* signalName = "") : hkSignal(signalName) {}

    // Connect a global method to this signal.
    template <typename METHOD>
    HK_NEVER_INLINE _Ret_notnull_ Slot* subscribe(METHOD method, _In_opt_z_ const char* name)
    {
        #ifdef HK_SIGNAL_DEBUG
        if(find(HK_NULL, &method, sizeof(METHOD)))
        {
            HK_ERROR(0x11D7EEA0, "Global slot already subscribing to signal '" << getName() << "'");
        }
        #endif
        return new GlobalSlot<METHOD>(m_slots, method, name);
    }

    // Returns true if the given method is already registered
    template <typename TYPE, typename METHOD>
    HK_NEVER_INLINE bool hasSubscription(_In_ TYPE* object, METHOD method)
    {
        return find(object, &method, sizeof(METHOD)) != HK_NULL;
    }

    // Connect a member method to this signal.
    template <typename TYPE, typename METHOD>
    HK_NEVER_INLINE _Ret_notnull_ Slot* subscribe(_Inout_ TYPE* object, METHOD method, _In_opt_z_ const char* name)
    {
        #ifdef HK_SIGNAL_DEBUG
        if(find(object, &method, sizeof(METHOD)))
        {
            HK_ERROR(0x11D7EEA1, "Member slot already subscribing to signal '" << getName() << "'");
        }
        #endif
        return new MemberSlot<TYPE,METHOD>(m_slots, object, method, name);
    }

    template <typename FUNCTION>
    HK_NEVER_INLINE ConnectionId subscribe(FUNCTION function)
    {
        // Use the slot address to identify the connection.
        return new FunctionSlot<FUNCTION>(m_slots, function);
    }

    // Disconnect a member method from this signal.
    template <typename TYPE, typename METHOD>
    HK_NEVER_INLINE hkBool  unsubscribe(_Inout_ TYPE* object, METHOD method) { return hkSignal::unsubscribeInternal(object, &method, sizeof(METHOD)); }

    // Disconnect a global method from this signal.
    template <typename METHOD>
    HK_INLINE hkBool    unsubscribe(METHOD method) { return hkSignal::unsubscribeInternal(HK_NULL, &method, sizeof(METHOD)); }

    // Fire the signal.
#ifndef HK_COMPILER_GHS
    HK_NEVER_INLINE
#endif
        void    fire(HK_SIGNAL_ARGUMENTS) { _fire(HK_SIGNAL_NAMES); }

    // Fire the signal inlined.
    HK_INLINE   void    _fire(HK_SIGNAL_ARGUMENTS)
    {
        // lock the list by setting a flag in m_slots to prevent immediate deletion of the slots in the list
        // if one of the called slots unsubscribe them
        m_slots.setInt(1);

        SlotList*   prev = &m_slots;
        for(hkSlot* slot = getSlots(); slot;)
        {
            hkSlot* next = slot->getNext();
            if(slot->hasNoSubscription())
            {
                delete slot;
                //the set of the next pointer needs to preserve the last bit, used to tag empty slots
                prev->setPtr(next);
            }
            else
            {
                ((Slot*)slot)->call(HK_SIGNAL_NAMES);
                prev = &slot->m_next;
            }
            slot = next;
        }

        // unlock the list
        m_slots.setInt(0);
    }

    // Return true if the slot exists.
    inline bool exists(_In_ const Slot* otherSlot) const
    {
        const void* methodData;
        int         methodLength;
        otherSlot->getMethod( methodData, methodLength );

        for ( const hkSlot* slot = getSlots(); slot; slot = slot->getNext() )
        {
            if ( slot == otherSlot ) return true;
            if ( slot->m_object == otherSlot->m_object )
            {
                if ( slot->matchMethod( methodData, methodLength ) ) return true;
            }
        }

        return false;
    }

    // Append another signal subscritions.
    inline HK_SIGNAL_TYPE& operator+=( const HK_SIGNAL_TYPE& other )
    {
        if ( this != &other )
        {
            for ( hkSlot* slot = other.getSlots(); slot; slot = slot->getNext() )
            {
                Slot* otherSlot = reinterpret_cast<Slot*>( slot );
                if ( !exists( otherSlot ) )
                {
                    otherSlot->subscribe( *this );
                }
            }
        }
        return *this;
    }
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
