// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL !REFLECT
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/Types/hkPtrAndInt.h>

// Compile time configuration.
// By default, enable debugging and tracking only when HK_DEBUG is defined.
#if defined(HK_DEBUG)
    
    //#define HK_SIGNAL_DEBUG
#endif

#ifdef HK_SIGNAL_DEBUG
    #include <Common/Base/DebugUtil/GlobalProperties/hkGlobalProperties.h>
    #define HK_ENABLE_SIGNAL_TRACKING
    #define HK_SIGNAL_ON_DEBUG(_code_)          _code_
    #define HK_SIGNAL_SET_NAME(_key_, _value_)  hkGlobalProperties::getInstance().set(_key_, _value_);
    #define HK_SIGNAL_GET_NAME(_key_)           hkGlobalProperties::getInstance().get(_key_, "Unnamed")
    #define HK_SIGNAL_CLR_NAME(_key_)           hkGlobalProperties::getInstance().clear(_key_);
#else
    #define HK_SIGNAL_ON_DEBUG(_code_)
    #define HK_SIGNAL_SET_NAME(_key_, _value_)
    #define HK_SIGNAL_GET_NAME(_key_)           "Unnamed"
    #define HK_SIGNAL_CLR_NAME(_key_)
#endif

/// Abstract slot.
struct HK_EXPORT_COMMON hkSlot
{
    HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE, hkSlot);

    typedef hkPtrAndInt<hkSlot, unsigned, 3> SlotList;

    HK_INLINE hkSlot(SlotList& slots, _Inout_ void* object, _In_opt_z_ const char* HK_SIGNAL_ON_DEBUG(name)) : m_next(slots.getPtr()), m_object(object)
    {
        slots.setPtr(this);
        HK_SIGNAL_SET_NAME(this, name);
    }
    HK_INLINE virtual       ~hkSlot()                   { HK_SIGNAL_CLR_NAME(this); }
    HK_INLINE void          unsubscribe()               { m_next.setInt(1); }
    HK_INLINE hkBool32      hasNoSubscription() const   { return (hkBool32)m_next.getInt(); }
    HK_INLINE _Ret_maybenull_ hkSlot* getNext() const { return m_next.getPtr(); }
    HK_INLINE _Ret_z_ const char*   getName() const             { return reinterpret_cast<const char*>(HK_SIGNAL_GET_NAME(this)); }
    virtual hkBool32        matchMethod(_In_ const void* methodData, int methodLength) const = 0;

    /// The last bit is set when the slot is unsubscribed.
    mutable SlotList m_next;
    void* m_object;

private:
    hkSlot(const hkSlot&);
    void operator=(const hkSlot&);
};

/// Abstract signal.
struct HK_EXPORT_COMMON hkSignal
{
    HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE, hkSignal);

    typedef void* ConnectionId;

    typedef hkPtrAndInt<hkSlot, unsigned, 3> SlotList;

    HK_INLINE               hkSignal(_In_z_ const char* name) : m_slots(HK_NULL) { hkSignal::beginTrack(this); HK_SIGNAL_SET_NAME(this, name); }
    HK_INLINE               ~hkSignal()                                     { hkSignal::endTrack(this); destroy(); HK_SIGNAL_CLR_NAME(this); }
    HK_INLINE _Ret_z_ const char* getName() const { return reinterpret_cast<const char*>(HK_SIGNAL_GET_NAME(this)); }
    HK_INLINE   hkSlot*     getSlots() const                                { return m_slots.getPtr(); }
    HK_INLINE bool          hasSubscriptions() const                        { return getSlots() != HK_NULL; }
    int                     getNumSubscriptions() const;
    void                    unsubscribeAll(_Inout_ void* object);
    hkBool                  unsubscribeInternal(_Inout_ void* object, _In_ const void* method, int length);
    hkBool                  unsubscribe(ConnectionId id);
    _Ret_maybenull_ hkSlot* find(_Inout_ void* object, _In_ const void* method, int length);
    void                    printReport() const;
    void                    destroy();
    void                    reset();

    #ifdef HK_ENABLE_SIGNAL_TRACKING
    static void HK_CALL         beginTrack(_Inout_ hkSignal* signal);
    static void HK_CALL         endTrack(_Inout_ hkSignal* signal);
    static HK_INLINE _Ret_maybenull_ hkSignal*  getFirstSignal() { return s_root; }
    HK_INLINE _Ret_maybenull_ hkSignal*         getNext() const             { return m_links[1]; }

    hkSignal*               m_links[2];
    static hkSignal*        s_root;
    #else
    static HK_INLINE void   beginTrack(hkSignal*) {}
    static HK_INLINE void   endTrack(hkSignal*) {}
    #endif

    /// The last bit of this is set when the list is in-use (while the signal is being fired to the slots)
    /// and reset when the list is free to be modified.
    mutable SlotList m_slots;

private:

    hkSignal(const hkSignal&) {}
    void operator=(const hkSignal&) {}

};

/// Declare a signal.
#define HK_QUOTE_SIGNAL_NAME(_name_) #_name_
#define HK_DECLARE_SIGNAL(_name_ , ...) \
    struct _name_ : __VA_ARGS__ \
    { \
        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE, _name_); \
        HK_INLINE _name_() : __VA_ARGS__(HK_QUOTE_SIGNAL_NAME(_name_)) {} \
        _name_(const _name_&) : __VA_ARGS__() { }\
        template <typename CLASS_TYPE> \
        HK_INLINE hkSlot* implicitSubscribe(CLASS_TYPE* instance, const char* slotname) \
        { \
            return subscribe( instance , &CLASS_TYPE::on##_name_ , slotname ); \
        } \
    }

/// Subscribe to a signal using the implicit method match of a class instance ('on' + signal type name, i.e. 'hkMySignal' -> 'onhkMySignal').
#define HK_SUBSCRIBE_TO_SIGNAL( _signal_ , _instance_, _class_ ) ((_signal_).implicitSubscribe(_instance_, HK_QUOTE_SIGNAL_NAME(_class_)))

//
// Implementations.
//

// 0
#define HK_SIGNAL_TYPE          hkSignal0
#define HK_SIGNAL_PARAMETERS
#define HK_SIGNAL_ARGUMENTS
#define HK_SIGNAL_NAMES
    #include <Common/Base/Types/hkSignalSlots.hxx> 
#undef HK_SIGNAL_PARAMETERS
#undef HK_SIGNAL_ARGUMENTS
#undef HK_SIGNAL_NAMES
#undef HK_SIGNAL_TYPE

// 1
#define HK_SIGNAL_TYPE          hkSignal1
#define HK_SIGNAL_PARAMETERS    template <typename P0>
#define HK_SIGNAL_ARGUMENTS     P0 p0
#define HK_SIGNAL_NAMES         p0
    #include <Common/Base/Types/hkSignalSlots.hxx> 
#undef HK_SIGNAL_PARAMETERS
#undef HK_SIGNAL_ARGUMENTS
#undef HK_SIGNAL_NAMES
#undef HK_SIGNAL_TYPE

// 2
#define HK_SIGNAL_TYPE          hkSignal2
#define HK_SIGNAL_PARAMETERS    template <typename P0,typename P1>
#define HK_SIGNAL_ARGUMENTS     P0 p0, P1 p1
#define HK_SIGNAL_NAMES         p0, p1
    #include <Common/Base/Types/hkSignalSlots.hxx> 
#undef HK_SIGNAL_PARAMETERS
#undef HK_SIGNAL_ARGUMENTS
#undef HK_SIGNAL_NAMES
#undef HK_SIGNAL_TYPE

// 3
#define HK_SIGNAL_TYPE          hkSignal3
#define HK_SIGNAL_PARAMETERS    template <typename P0,typename P1,typename P2>
#define HK_SIGNAL_ARGUMENTS     P0 p0, P1 p1, P2 p2
#define HK_SIGNAL_NAMES         p0, p1, p2
    #include <Common/Base/Types/hkSignalSlots.hxx> 
#undef HK_SIGNAL_PARAMETERS
#undef HK_SIGNAL_ARGUMENTS
#undef HK_SIGNAL_NAMES
#undef HK_SIGNAL_TYPE

// 4
#define HK_SIGNAL_TYPE          hkSignal4
#define HK_SIGNAL_PARAMETERS    template <typename P0,typename P1,typename P2,typename P3>
#define HK_SIGNAL_ARGUMENTS     P0 p0, P1 p1, P2 p2, P3 p3
#define HK_SIGNAL_NAMES         p0, p1, p2, p3
    #include <Common/Base/Types/hkSignalSlots.hxx> 
#undef HK_SIGNAL_PARAMETERS
#undef HK_SIGNAL_ARGUMENTS
#undef HK_SIGNAL_NAMES
#undef HK_SIGNAL_TYPE

// 5
#define HK_SIGNAL_TYPE          hkSignal5
#define HK_SIGNAL_PARAMETERS    template <typename P0,typename P1,typename P2,typename P3,typename P4>
#define HK_SIGNAL_ARGUMENTS     P0 p0, P1 p1, P2 p2, P3 p3, P4 p4
#define HK_SIGNAL_NAMES         p0, p1, p2, p3, p4
    #include <Common/Base/Types/hkSignalSlots.hxx> 
#undef HK_SIGNAL_PARAMETERS
#undef HK_SIGNAL_ARGUMENTS
#undef HK_SIGNAL_NAMES
#undef HK_SIGNAL_TYPE

#if 0   // No use case for more than 5 parameters for the moment.

// 6
#define HK_SIGNAL_TYPE          hkSignal6
#define HK_SIGNAL_PARAMETERS    template <typename P0,typename P1,typename P2,typename P3,typename P4,typename P5>
#define HK_SIGNAL_ARGUMENTS     P0 p0, P1 p1, P2 p2, P3 p3, P4 p4, P5 p5
#define HK_SIGNAL_NAMES         p0, p1, p2, p3, p4, p5
    #include <Common/Base/Types/hkSignalSlots.hxx> 
#undef HK_SIGNAL_PARAMETERS
#undef HK_SIGNAL_ARGUMENTS
#undef HK_SIGNAL_NAMES
#undef HK_SIGNAL_TYPE

// 7
#define HK_SIGNAL_TYPE          hkSignal7
#define HK_SIGNAL_PARAMETERS    template <typename P0,typename P1,typename P2,typename P3,typename P4,typename P5, typename P6>
#define HK_SIGNAL_ARGUMENTS     P0 p0, P1 p1, P2 p2, P3 p3, P4 p4, P5 p5, P6 p6
#define HK_SIGNAL_NAMES         p0, p1, p2, p3, p4, p5, p6
    #include <Common/Base/Types/hkSignalSlots.hxx> 
#undef HK_SIGNAL_PARAMETERS
#undef HK_SIGNAL_ARGUMENTS
#undef HK_SIGNAL_NAMES
#undef HK_SIGNAL_TYPE

// 8
#define HK_SIGNAL_TYPE          hkSignal8
#define HK_SIGNAL_PARAMETERS    template <typename P0,typename P1,typename P2,typename P3,typename P4,typename P5, typename P6, typename P7>
#define HK_SIGNAL_ARGUMENTS     P0 p0, P1 p1, P2 p2, P3 p3, P4 p4, P5 p5, P6 p6, P7 p7
#define HK_SIGNAL_NAMES         p0, p1, p2, p3, p4, p5, p6, p7
    #include <Common/Base/Types/hkSignalSlots.hxx> 
#undef HK_SIGNAL_PARAMETERS
#undef HK_SIGNAL_ARGUMENTS
#undef HK_SIGNAL_NAMES
#undef HK_SIGNAL_TYPE

#endif

// Cleanup PP.

#undef HK_SIGNAL_SET_NAME
#undef HK_SIGNAL_GET_NAME
#undef HK_SIGNAL_CLR_NAME

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
