// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

template <typename T>
HK_ALWAYS_INLINE hkScopedPtr<T>::hkScopedPtr()
    : m_object(nullptr)
{}

template <typename T>
HK_ALWAYS_INLINE hkScopedPtr<T>::hkScopedPtr(hkScopedPtr&& other) : m_object(other.m_object)
{
    other.m_object = nullptr;
}

template <typename T>
template <typename TOther>
HK_ALWAYS_INLINE hkScopedPtr<T>::hkScopedPtr(hkScopedPtr<TOther>&& other)
    : m_object(other.m_object)
{
    other.m_object = nullptr;
}

template <typename T>
HK_ALWAYS_INLINE hkScopedPtr<T>::hkScopedPtr(_In_opt_ T* assignIn)
    : m_object(assignIn)
{}

template <typename T>
template <typename TOther>
HK_ALWAYS_INLINE void hkScopedPtr<T>::moveAssign(hkScopedPtr<TOther>&& other)
{
    // Temporary variable handles the self-move case
    T* tmp = other.m_object;
    other.m_object = nullptr;
    delete m_object;
    m_object = tmp;
}

template <typename T>
HK_ALWAYS_INLINE hkScopedPtr<T>& hkScopedPtr<T>::operator=(hkScopedPtr&& other)
{
    moveAssign(hk::move(other));
    return *this;
}

template <typename T>
template <typename TOther>
HK_ALWAYS_INLINE hkScopedPtr<T>& hkScopedPtr<T>::operator=(hkScopedPtr<TOther>&& other)
{
    moveAssign(hk::move(other));
    return *this;
}

template <typename T>
HK_ALWAYS_INLINE hkScopedPtr<T>::~hkScopedPtr()
{
    delete m_object;
}

template <typename T>
HK_ALWAYS_INLINE _Ret_maybenull_ T* hkScopedPtr<T>::get() const
{
    return m_object;
}

template <typename T>
HK_ALWAYS_INLINE _Ret_maybenull_ T* hkScopedPtr<T>::steal()
{
    T* tmp = m_object;
    m_object = nullptr;
    return tmp;
}

template <typename T>
HK_ALWAYS_INLINE void hkScopedPtr<T>::reset(_In_opt_ T* newObj)
{
    HK_ASSERT_NO_MSG(0x6e8dd216, !newObj || (newObj != m_object));  // Always indicates an ownership bug.
    delete m_object;
    m_object = newObj;
}

template <typename T>
HK_ALWAYS_INLINE void hkScopedPtr<T>::swap(hkScopedPtr& other)
{
    
    auto* tmp = m_object;
    m_object = other.m_object;
    other.m_object = tmp;
}

template <typename T>
HK_ALWAYS_INLINE hkScopedPtr<T>::operator hkBoolOperator::BoolType() const
{
    return hkBoolOperator::cast(m_object);
}

template <typename T>
HK_ALWAYS_INLINE typename hkTrait::VoidValue<T>::Type& hkScopedPtr<T>::operator*() const
{
    HK_ASSERT_NO_MSG(0x164fd77e, m_object != nullptr);
    return *m_object;
}

template <typename T>
HK_ALWAYS_INLINE _Ret_notnull_ T* hkScopedPtr<T>::operator -> () const
{
    HK_ASSERT_NO_MSG(0x7068a58e, m_object != nullptr);
    return m_object;
}


template <typename T>
HK_ALWAYS_INLINE hkScopedPtr<T> hk::makeUnique()
{
    return hkScopedPtr<T>(new T);
}

template <typename T, typename T1>
HK_ALWAYS_INLINE hkScopedPtr<T> hk::makeUnique(T1&& t1)
{
    return hkScopedPtr<T>(new T(hk::forward<T1>(t1)));
}

template <typename T, typename T1, typename T2>
HK_ALWAYS_INLINE hkScopedPtr<T> hk::makeUnique(T1&& t1, T2&& t2)
{
    return hkScopedPtr<T>(new T(hk::forward<T1>(t1), hk::forward<T2>(t2)));
}

template <typename T, typename T1, typename T2, typename T3>
HK_ALWAYS_INLINE hkScopedPtr<T> hk::makeUnique(T1&& t1, T2&& t2, T3&& t3)
{
    return hkScopedPtr<T>(new T(hk::forward<T1>(t1), hk::forward<T2>(t2), hk::forward<T3>(t3)));
}

template <typename T, typename T1, typename T2, typename T3, typename T4>
HK_ALWAYS_INLINE hkScopedPtr<T> hk::makeUnique(T1&& t1, T2&& t2, T3&& t3, T4&& t4)
{
    return hkScopedPtr<T>(new T(hk::forward<T1>(t1), hk::forward<T2>(t2), hk::forward<T3>(t3), hk::forward<T4>(t4)));
}

template <typename T, typename T1, typename T2, typename T3, typename T4, typename T5>
HK_ALWAYS_INLINE hkScopedPtr<T> hk::makeUnique(T1&& t1, T2&& t2, T3&& t3, T4&& t4, T5&& t5)
{
    return hkScopedPtr<T>(new T(hk::forward<T1>(t1), hk::forward<T2>(t2), hk::forward<T3>(t3), hk::forward<T4>(t4), hk::forward<T5>(t5)));
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
