// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

namespace hkReflect { namespace Detail { struct ScopedPtrImpl; } }

/// hkScopedPtr is a smart pointer that owns a pointer and destroys it when going out of scope.
template <typename T>
class hkScopedPtr
{
public:

    typedef hkScopedPtr<T> ThisType;
    HK_DECLARE_CLASS(hkScopedPtr, New, Reflect);
    HK_REFLECT_AS_POINTER(&hkReflect::Detail::ScopedPtrImpl::s_instance, T);
    friend struct hkReflect::Detail::ScopedPtrImpl;

    /// Create a new hkScopedPtr initialized to \c nullptr.
    hkScopedPtr();

    /// Takes the ownership from \c other
    hkScopedPtr(hkScopedPtr&& other);

    /// Takes the ownership from \c other
    template <typename TOther>
    hkScopedPtr(hkScopedPtr<TOther>&& other);

    /// Pass in an already constructed object. The hkScopedPtr now owns this object
    explicit hkScopedPtr(_In_opt_ T* assignIn);

    /// Transfers the ownership from \c other
    hkScopedPtr& operator=(hkScopedPtr&& other);

    /// Transfers the ownership from \c other
    template <typename TOther>
    hkScopedPtr& operator=(hkScopedPtr<TOther>&& other);

    ~hkScopedPtr();

    /// Returns the pointed resource without transferring ownership.
    _Ret_maybenull_ T* get() const;

    /// Returns the pointed resource and transfers ownership to the caller.
    _Ret_maybenull_ T* steal();

    /// Resets this pointer to point to newObj and deletes the current resource if any.
    void reset(_In_opt_ T* newObj = nullptr);

    /// Swaps the ownership of objects with \c other
    void swap(hkScopedPtr& other);

    /// Safe conversion-to-bool operator which returns true if the pointer is not \c nullptr, false otherwise.
    operator hkBoolOperator::BoolType() const;

    /// Dereference operator.
    typename hkTrait::VoidValue<T>::Type& operator*() const;

    /// Arrow operator.
    _Ret_notnull_
    T* operator -> () const;

private:
    template<typename TOther>
    void moveAssign(hkScopedPtr<TOther>&& other);

    T* m_object;
    // hkScopedPtr is not copyable or assignable
    
    hkScopedPtr(const hkScopedPtr<T>& copyIn) { HK_ASSERT_NO_MSG(0x3c41c6f4, 0); }
    hkScopedPtr<T>& operator = (const hkScopedPtr<T>& copyIn) { HK_ASSERT_NO_MSG(0x3c41c6f5, 0); return *this; }

    template <typename TOther>
    friend class hkScopedPtr;
};

template<typename T>
HK_ALWAYS_INLINE void swap(hkScopedPtr<T>& lhs, hkScopedPtr<T>& rhs)
{
    lhs.swap(rhs);
}

template<typename T, typename U>
HK_ALWAYS_INLINE bool operator==(const hkScopedPtr<T>& lhs, _In_opt_ const U* rhs)
{
    return lhs.get() == rhs;
}

template<typename T, typename U>
HK_ALWAYS_INLINE bool operator==(_In_opt_ const U* lhs, const hkScopedPtr<T>& rhs)
{
    return lhs == rhs.get();
}

template<typename T, typename U>
HK_ALWAYS_INLINE bool operator==(const hkScopedPtr<T>& lhs, const hkScopedPtr<U>& rhs)
{
    return lhs.get() == rhs.get();
}

template<typename T, typename U>
HK_ALWAYS_INLINE bool operator!=(const hkScopedPtr<T>& lhs, _In_opt_ const U* rhs)
{
    return lhs.get() != rhs;
}

template<typename T, typename U>
HK_ALWAYS_INLINE bool operator!=(_In_opt_ const U* lhs, const hkScopedPtr<T>& rhs)
{
    return lhs != rhs.get();
}

template<typename T, typename U>
HK_ALWAYS_INLINE bool operator!=(const hkScopedPtr<T>& lhs, const hkScopedPtr<U>& rhs)
{
    return lhs.get() != rhs.get();
}

namespace hkReflect { namespace Detail
{
    struct HK_EXPORT_COMMON ScopedPtrImpl : public hkReflect::Detail::PointerImpl
    {
        ScopedPtrImpl() { /* keep clang happy */ }
        static const ScopedPtrImpl s_instance;

        virtual hkResult setValue(_Inout_ void* self, _In_ const PointerType* type, const Var& var) const HK_OVERRIDE;
        virtual hkResult getValue(_In_ const void* self, _In_ const PointerType* type, _Out_ Var* val) const HK_OVERRIDE;
    };
} }

namespace hk
{

    /// Constructs a new object using provided arguments and returns an owning hkScopedPtr
    
    template <typename TYPE>
    hkScopedPtr<TYPE> makeUnique();

    template <typename TYPE, typename T1>
    hkScopedPtr<TYPE> makeUnique(T1&& t1);

    template <typename TYPE, typename T1, typename T2>
    hkScopedPtr<TYPE> makeUnique(T1&& t1, T2&& t2);

    template <typename TYPE, typename T1, typename T2, typename T3>
    hkScopedPtr<TYPE> makeUnique(T1&& t1, T2&& t2, T3&& t3);

    template <typename TYPE, typename T1, typename T2, typename T3, typename T4>
    hkScopedPtr<TYPE> makeUnique(T1&& t1, T2&& t2, T3&& t3, T4&& t4);

    template <typename TYPE, typename T1, typename T2, typename T3, typename T4, typename T5>
    hkScopedPtr<TYPE> makeUnique(T1&& t1, T2&& t2, T3&& t3, T4&& t4, T5&& t5);

}  // namespace hk

#include <Common/Base/Types/hkScopedPtr.inl>
#include <Common/Base/_Auto/TemplateTypes/hkScopedPtr_Types.inl>

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
