// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Base/hkBase.h>
#include <Common/Base/Types/hkScopedPtr.h>

hkResult hkReflect::Detail::ScopedPtrImpl::setValue(_Inout_ void* self, _In_ const hkReflect::PointerType* type, const Var& val) const
{
    hkScopedPtr<void>* ptr = reinterpret_cast<hkScopedPtr<void>*>(self);

    if (val.getAddress() == ptr->get())
    {
        // Self assignment.
        return HK_SUCCESS;
    }

    if (!hkReflect::Detail::canSetPtr(type->getSubType(), val))
    {
        return HK_FAILURE;
    }

    hkReflect::Var v(ptr->steal(), type->getSubType());
    v.destroy();

    ptr->m_object = val.getAddress();

    return HK_SUCCESS;
}

hkResult hkReflect::Detail::ScopedPtrImpl::getValue(_In_ const void* self, _In_ const hkReflect::PointerType* type, _Out_ hkReflect::Var* val) const
{
    const hkScopedPtr<void>* ptr = reinterpret_cast<const hkScopedPtr<void>*>(self);
    const void* addr = ptr->get();
    *val = hkReflect::Var(exactObj(addr, type->getSubType()));
    return HK_SUCCESS;
}

const hkReflect::Detail::ScopedPtrImpl hkReflect::Detail::ScopedPtrImpl::s_instance;

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
