// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/hkBase.h>
#include <Common/Base/Types/hkRefVariant.h>

#if defined(HK_DEBUG_SLOW)
static void checkObject(_In_opt_ const void* o, _In_ const hkReflect::Type* k)
{
    if( !o )
    {
        return;
    }

    const hkReflect::Type* realType = hkReflect::exactTypeOf(static_cast<const hkReferencedObject*>(o));
    HK_ASSERT(0x4183e922, k, "Cannot set variant with type pointer HK_NULL. Object must be HK_NULL too.");
    const char* rec = realType->getName();
    const char* realRec = k->getName();
    HK_ASSERTV(0x28cc2069, realType->extendsOrEquals(k),
        "The given class '{}' is different from object's class '{}'.", rec, realRec);
}
#endif //defined(HK_DEBUG_SLOW)

hkRefVariant::hkRefVariant(_In_opt_ void* o, _In_ const hkReflect::Type* k)
: hkRefPtr<hkReferencedObject>(static_cast<hkReferencedObject*>(o))
{
    HK_ON_DEBUG_SLOW(checkObject(o, k));
}

hkRefVariant::hkRefVariant(const hkReflect::Var& v)
: hkRefPtr<hkReferencedObject>(static_cast<hkReferencedObject*>((void*)v.getData()))
{
    HK_ON_DEBUG_SLOW(checkObject(v.getData(), v.getType()));
}

void hkRefVariant::set(_In_opt_ void* o, _In_ const hkReflect::Type* k)
{
    HK_ON_DEBUG_SLOW(checkObject(o, k));
    hkRefPtr<hkReferencedObject>::operator=(static_cast<hkReferencedObject*>(o));
}

_Ret_maybenull_
const hkReflect::Type* hkRefVariant::getType() const
{
    return val() ? hkReflect::exactTypeOf(val()) : HK_NULL;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
