// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

template<class PTYPE, class ITYPE, ITYPE MASK>
HK_INLINE hkPtrAndInt<PTYPE, ITYPE, MASK>::hkPtrAndInt()
    : m_ptrAndInt(HK_NULL)
{
}

template<class PTYPE, class ITYPE, ITYPE MASK>
HK_INLINE hkPtrAndInt<PTYPE, ITYPE, MASK>::hkPtrAndInt(_In_opt_ PTYPE* pntr, ITYPE i)
    : m_ptrAndInt(reinterpret_cast<PTYPE*>(reinterpret_cast<hkUlong>(pntr) | i))
{
    HK_ASSERT_NO_MSG(0x22f46bc5, (reinterpret_cast<hkUlong>(pntr) & MASK) == 0);
    HK_ASSERT_NO_MSG(0x67f2573e, (i & ~MASK) == 0);
}

template<class PTYPE, class ITYPE, ITYPE MASK>
template<typename RTYPE>
HK_INLINE hkPtrAndInt<PTYPE, ITYPE, MASK>::hkPtrAndInt(const hkPtrAndInt<RTYPE, ITYPE, MASK>& p)
{
    operator=(p);
}

template<class PTYPE, class ITYPE, ITYPE MASK>
template<typename RTYPE>
HK_INLINE void hkPtrAndInt<PTYPE, ITYPE, MASK>::operator=(const hkPtrAndInt<RTYPE, ITYPE, MASK>& p)
{
    m_ptrAndInt = p.m_ptrAndInt;
}

template<class PTYPE, class ITYPE, ITYPE MASK>
HK_INLINE _Ret_maybenull_ PTYPE* hkPtrAndInt<PTYPE, ITYPE, MASK>::getPtr() const
{
    return hkClearBits(m_ptrAndInt, MASK);
}

template<class PTYPE, class ITYPE, ITYPE MASK>
HK_INLINE ITYPE hkPtrAndInt<PTYPE, ITYPE, MASK>::getInt() const
{
    return static_cast<ITYPE>(reinterpret_cast<hkUlong>(m_ptrAndInt) & MASK);
}

template<class PTYPE, class ITYPE, ITYPE MASK>
HK_INLINE void hkPtrAndInt<PTYPE, ITYPE, MASK>::get(_Outref_result_maybenull_ PTYPE*& p, _Out_ ITYPE& i) const
{
    p = hkClearBits(m_ptrAndInt, MASK);
    i = static_cast<ITYPE>(reinterpret_cast<hkUlong>(m_ptrAndInt) & MASK);
}

template<class PTYPE, class ITYPE, ITYPE MASK>
HK_INLINE void hkPtrAndInt<PTYPE, ITYPE, MASK>::setPtr(_In_opt_ PTYPE* e)
{
    HK_ASSERT_NO_MSG(0x72310206, (reinterpret_cast<hkUlong>(e) & MASK) == 0);
    m_ptrAndInt = reinterpret_cast<PTYPE*>(
        reinterpret_cast<hkUlong>(e) | (reinterpret_cast<hkUlong>(m_ptrAndInt) & MASK));
}

template<class PTYPE, class ITYPE, ITYPE MASK>
HK_INLINE void hkPtrAndInt<PTYPE, ITYPE, MASK>::setInt(ITYPE i)
{
    HK_ASSERT_NO_MSG(0x3b0721e5, (i & ~MASK) == 0);
    m_ptrAndInt = reinterpret_cast<PTYPE*>(reinterpret_cast<hkUlong>(hkClearBits(m_ptrAndInt, MASK)) | i);
}

template<class PTYPE, class ITYPE, ITYPE MASK>
HK_INLINE void hkPtrAndInt<PTYPE, ITYPE, MASK>::set(_In_opt_ PTYPE* p, ITYPE i)
{
    HK_ASSERT_NO_MSG(0x6151c0f0, (reinterpret_cast<hkUlong>(p) & MASK) == 0);
    HK_ASSERT_NO_MSG(0xe689e52, (i & ~MASK) == 0);
    m_ptrAndInt = reinterpret_cast<PTYPE*>(reinterpret_cast<hkUlong>(p) | i);
}

template<class PTYPE, class ITYPE, ITYPE MASK>
HK_INLINE void hkPtrAndInt<PTYPE, ITYPE, MASK>::reset()
{
    m_ptrAndInt = nullptr;
}

template<typename PTYPE, typename ITYPE, ITYPE MASK>
template<typename RTYPE>
HK_INLINE bool hkPtrAndInt<PTYPE, ITYPE, MASK>::operator==(const hkPtrAndInt<RTYPE, ITYPE, MASK>& p) const
{
    return m_ptrAndInt == p.m_ptrAndInt;
}

template<typename PTYPE, typename ITYPE, ITYPE MASK>
template<typename RTYPE>
HK_INLINE bool hkPtrAndInt<PTYPE, ITYPE, MASK>::operator!=(const hkPtrAndInt<RTYPE, ITYPE, MASK>& p) const
{
    return !(*this == p);
}

template<typename PTYPE, typename ITYPE, ITYPE MASK>
template<typename TARGET>
HK_INLINE hkPtrAndInt<TARGET, ITYPE, MASK> hkPtrAndInt<PTYPE, ITYPE, MASK>::staticCast() const
{
    hkPtrAndInt<TARGET, ITYPE, MASK> ret;
    ret.m_ptrAndInt = static_cast<TARGET*>(m_ptrAndInt);
    return ret;
}

template<typename PTYPE, typename ITYPE, ITYPE MASK>
template<typename TARGET>
HK_INLINE hkPtrAndInt<TARGET, ITYPE, MASK> hkPtrAndInt<PTYPE, ITYPE, MASK>::constCast() const
{
    hkPtrAndInt<TARGET, ITYPE, MASK> ret;
    ret.m_ptrAndInt = const_cast<TARGET*>(m_ptrAndInt);
    return ret;
}

template<typename PTYPE, typename ITYPE, ITYPE MASK>
template<typename TARGET>
HK_INLINE hkPtrAndInt<TARGET, ITYPE, MASK> hkPtrAndInt<PTYPE, ITYPE, MASK>::reinterpretCast() const
{
    hkPtrAndInt<TARGET, ITYPE, MASK> ret;
    ret.m_ptrAndInt = reinterpret_cast<TARGET*>(m_ptrAndInt);
    return ret;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
