// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

/// A simple helper class which encapsulates a pointer and an integer value.
template <typename PTYPE, typename ITYPE, ITYPE MASK>
class hkPtrAndInt
{
    public:

        HK_DECLARE_CLASS(hkPtrAndInt, New, Reflect);
        HK_RECORD_ATTR(hk::Serialize(false));

        /// Default constructor.
        /// Stored pointer is set to HK_NULL.
        HK_INLINE hkPtrAndInt();

        /// Sets pointer and integer.
        HK_INLINE explicit hkPtrAndInt(_In_opt_ PTYPE* pntr, ITYPE i = static_cast<ITYPE>(0));

        /// Copies pointer and integer.
        template<typename RTYPE>
        HK_INLINE hkPtrAndInt(const hkPtrAndInt<RTYPE, ITYPE, MASK>& p);

        /// Copies pointer and integer.
        template<typename RTYPE>
        HK_INLINE void operator=(const hkPtrAndInt<RTYPE, ITYPE, MASK>& p);

        /// Returns the stored pointer.
        HK_INLINE _Ret_maybenull_ PTYPE* getPtr() const;

        /// Returns the integer value.
        HK_INLINE ITYPE getInt() const;

        /// Gets pointer and integer.
        HK_INLINE void get(_Outref_result_maybenull_ PTYPE*& p, _Out_ ITYPE& i) const;

        /// Sets the pointer value.
        /// The integer value is not modified.
        HK_INLINE void setPtr(_In_opt_ PTYPE* p);

        /// Sets the integer value.
        /// The pointer is not modified.
        HK_INLINE void setInt(ITYPE p);

        /// Sets pointer and integer.
        HK_INLINE void set(_In_opt_ PTYPE* p, ITYPE i);

        /// Sets pointer and integer to zero
        HK_INLINE void reset();

        /// Returns true if pointers and int values are equal.
        template<typename RTYPE>
        HK_INLINE bool operator==(const hkPtrAndInt<RTYPE, ITYPE, MASK>& p) const;

        template<typename RTYPE>
        HK_INLINE bool operator!=(const hkPtrAndInt<RTYPE, ITYPE, MASK>& p) const;

        /// Cast to a different pointed type using static_cast.
        template<typename TARGET>
        HK_INLINE hkPtrAndInt<TARGET, ITYPE, MASK> staticCast() const;

        /// Cast to a different pointed type using const_cast.
        template<typename TARGET>
        HK_INLINE hkPtrAndInt<TARGET, ITYPE, MASK> constCast() const;

        /// Cast to a different pointed type using reinterpret_cast.
        template<typename TARGET>
        HK_INLINE hkPtrAndInt<TARGET, ITYPE, MASK> reinterpretCast() const;

    private:

        /// The int value is stored in MASK, the pointer value is stored in ~MASK.
        PTYPE* m_ptrAndInt;

template <typename P, typename I, I M>
friend class hkPtrAndInt;

};

#include <Common/Base/Types/hkPtrAndInt.inl>

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
