// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

// Specialized version of hkMapOperations<> for using hkHandle in a map.
template<typename TYPE, TYPE INVALID_VALUE, typename DISCRIMINANT>
struct hkMapOperations<hkHandle<TYPE, INVALID_VALUE, DISCRIMINANT> >
{
    inline static unsigned hash( const hkHandle<TYPE, INVALID_VALUE, DISCRIMINANT>& key, unsigned mod )
    {
        // We ignore the lowest four bits of the value, since most handles will be addresses and most addresses will be 16-byte aligned
        // Knuth's multiplicative golden hash
        return unsigned((hkUlong(key.value()) >> 4) * 2654435761U) & mod;
    }
    inline static void invalidate( hkHandle<TYPE, INVALID_VALUE, DISCRIMINANT>& key )
    {
        key = hkHandle<TYPE, INVALID_VALUE, DISCRIMINANT>(INVALID_VALUE);
    }
    inline static hkBool32 isValid( const hkHandle<TYPE, INVALID_VALUE, DISCRIMINANT>& key )
    {
        return key != hkHandle<TYPE, INVALID_VALUE, DISCRIMINANT>(INVALID_VALUE);
    }
    inline static hkBool32 equal( const hkHandle<TYPE, INVALID_VALUE, DISCRIMINANT>& key0, const hkHandle<TYPE, INVALID_VALUE, DISCRIMINANT>& key1 )
    {
        return key0 == key1;
    }
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
