// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/Container/String/hkUtf8.h>

/// Namespace used by unit tests to generate failures
namespace hkFailureGenerator
{
        /// Return true and overwrite res to inject a failure.
        /// Return false and leave res unmodified otherwise.
    typedef bool (HK_CALL *InjectFailFn)(hkResult& res);

    /// Returns a potentially different result given the original
    extern HK_EXPORT_COMMON InjectFailFn injectFailFn;
};

#if !defined(HK_COMPILER_RAZZLE)
    // We want to be able to synthetically trigger failures in the code based on some global decision function
    #undef HK_DETAIL_RESULT_SYNTHETIC_FAIL
    #define HK_DETAIL_RESULT_SYNTHETIC_FAIL(hRes) (hkFailureGenerator::injectFailFn ? (*hkFailureGenerator::injectFailFn)(hRes) : false)
#endif

#if defined(HK_COMPILER_RAZZLE)
#include <wil/resultmacros.h>

namespace wil
{
    namespace details
    {
        __declspec(noinline) inline void ReportFailureUtf8(__R_FN_PARAMS_FULL, FailureType type, HRESULT hr, _In_ const char* message)
        {
            wchar_t wmsg[2048];
            hkUtf8::wideFromUtf8(wmsg, HK_COUNT_OF(wmsg), message);
            wil::details::ReportFailure(__R_DIRECT_FN_CALL FailureType::Return, hr, wmsg);
        }

        namespace __R_NS_NAME
        {
            __R_DIRECT_METHOD(void, Return_HrFmt)(__R_DIRECT_FN_PARAMS HRESULT hr) WI_NOEXCEPT
            {
                __R_FN_LOCALS;
                wil::details::ReportFailure_Hr(__R_DIRECT_FN_CALL FailureType::Return, hr);
            }
            __R_DIRECT_METHOD(void, Return_HrFmt)(__R_DIRECT_FN_PARAMS HRESULT hr, const char* msg) WI_NOEXCEPT
            {
                __R_FN_LOCALS;
                wil::details::ReportFailureUtf8(__R_DIRECT_FN_CALL FailureType::Return, hr, msg);
            }
            template<typename T0>
            __R_DIRECT_METHOD(void, Return_HrFmt)(__R_DIRECT_FN_PARAMS HRESULT hr, const char* fmt, const T0& t0) WI_NOEXCEPT
            {
                hkStringBuf sb; sb.format(fmt, t0);
                __R_FN_LOCALS;
                wil::details::ReportFailureUtf8(__R_DIRECT_FN_CALL FailureType::Return, hr, sb.cString());
            }
        }
    }
}

    #undef HK_DETAIL_RESULT_LOG
    #define HK_DETAIL_RESULT_LOG(hRes,sInfo,...) \
        do { if(hRes.isFailure()) { __R_FN(Return_HrFmt)(__R_INFO(sInfo) HRESULT(hRes.m_code), __VA_ARGS__ ); } } while(0,0)
#endif

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
