// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Common/Base/hkBase.h>
#include <Common/Base/Types/hkEndian.h>

#if HK_ENDIAN_BIG
    #define ENDIAN_SUFFIX_NATIVE Be
    #define ENDIAN_SUFFIX_SWAPPED Le
#else
    #define ENDIAN_SUFFIX_NATIVE Le
    #define ENDIAN_SUFFIX_SWAPPED Be
#endif

#define REGISTER_TYPE2(SYMBOL, TYPE) \
    static hkReflect::Detail::TypeRegNode SYMBOL(HK_REFLECT_GET_NON_CONST_TYPE(TYPE))
#define REGISTER_TYPE(TYPE) REGISTER_TYPE2(TYPE##_typeRegNode, TYPE)

template<>
HK_ALWAYS_INLINE hkFloat32 hkLosslessCast<hkFloat32, hkHalf16>(hkHalf16 src)
{
    return src.getFloat32();
}

namespace hkReflect { namespace Detail
{
    template<typename NATIVE, typename STORAGE>
    struct HK_EXPORT_COMMON EndianIntImplN : public hkReflect::Detail::IntImpl
    {
        EndianIntImplN() {}
//      virtual ~EndianIntImplN() {}
        virtual hkResult setValue(_Inout_ void* addr, _In_opt_ const hkReflect::IntType*, const hkReflect::IntValue& val) const HK_OVERRIDE
        {
            const NATIVE s = val.convertTo<NATIVE>();
            *reinterpret_cast<STORAGE*>(addr) = s;
            return HK_SUCCESS; 
        }

        virtual hkResult getValue(_In_ const void* addr, _In_opt_ const hkReflect::IntType*, _Out_ hkReflect::IntValue* val) const HK_OVERRIDE
        {
            val->set<NATIVE>(*reinterpret_cast<const STORAGE*>(addr));
            return HK_SUCCESS;
        }

        static const EndianIntImplN s_instance;
    };
    template<typename NATIVE, typename STORAGE>
    const EndianIntImplN<NATIVE,STORAGE> EndianIntImplN<NATIVE,STORAGE>::s_instance;

    template<typename NATIVE, typename STORAGE>
    struct HK_EXPORT_COMMON EndianFloatImplN : public hkReflect::Detail::FloatImpl
    {
        EndianFloatImplN() {}
        virtual ~EndianFloatImplN() {}
        virtual hkResult setValue(_Inout_ void* addr, _In_ const hkReflect::FloatType*, hkReflect::FloatValue val) const HK_OVERRIDE
        {
            const NATIVE s = (NATIVE)val;
            *reinterpret_cast<STORAGE*>(addr) = s;
            return HK_SUCCESS;
        }

        virtual hkResult getValue(_In_ const void* addr, const FloatType*, _Out_ hkReflect::FloatValue* val) const HK_OVERRIDE
        {
            STORAGE s = *reinterpret_cast<const STORAGE*>(addr);
            *val = static_cast<NATIVE>(s);
            return HK_SUCCESS;
        }

        static const EndianFloatImplN s_instance;
    };
    template<typename NATIVE, typename STORAGE>
    const EndianFloatImplN<NATIVE,STORAGE> EndianFloatImplN<NATIVE,STORAGE>::s_instance;

    template<typename STORAGE>
    struct HK_EXPORT_COMMON EndianFloatImplN<hkHalf16, STORAGE> : public hkReflect::Detail::FloatImpl
    {
        EndianFloatImplN() {}
        virtual ~EndianFloatImplN() {}
        virtual hkResult setValue(_Inout_ void* addr, _In_opt_ const hkReflect::FloatType*, hkReflect::FloatValue val) const HK_OVERRIDE
        {
            hkHalf16 s; s.setReal<false>((float)val);
            *reinterpret_cast<STORAGE*>(addr) = s;
            return HK_SUCCESS;
        }

        virtual hkResult getValue(_In_ const void* addr, _In_opt_ const FloatType*, _Out_ hkReflect::FloatValue* val) const HK_OVERRIDE
        {
            STORAGE s = *reinterpret_cast<const STORAGE*>(addr);
            hkHalf16 n; n.set<false>((hkFloat32)(s));
            *val = n.getFloat32();
            return HK_SUCCESS;
        }

        static const EndianFloatImplN s_instance;
    };

    template<typename STORAGE>
    const EndianFloatImplN<hkHalf16, STORAGE> EndianFloatImplN<hkHalf16, STORAGE>::s_instance;
} }

#define DEFINE_ENDIAN_TYPE_INTERNAL(TYPE, TYPE_FORMAT, TYPE_IMPL) \
    hkReflect::Detail::TypeData hkReflect::ReflectionOf< TYPE >::typeData = { \
            hkReflect::Opt::FORMAT | hkReflect::Opt::IMPL | hkReflect::Opt::NAME | hkReflect::Opt::DEF_CONSTRUCTOR | \
            hkReflect::Opt::COPY_CONSTRUCTOR | hkReflect::Opt::COPY_ASSIGNMENT | hkReflect::Opt::INHERITANCE | \
            hkReflect::Opt::ALLOC_IMPL | hkReflect::Opt::SIZE_ALIGN, \
            0, \
            HK_REFLECT_TYPE_OPTIONAL(Opt::FORMAT, TYPE_FORMAT), \
            HK_REFLECT_TYPE_OPTIONAL(Opt::IMPL, TYPE_IMPL), \
            HK_REFLECT_TYPE_OPTIONAL(Opt::NAME, #TYPE), \
            HK_REFLECT_TYPE_OPTIONAL(Opt::DEF_CONSTRUCTOR, &hkReflect::Detail::Trivial<Opt::DEF_CONSTRUCTOR>::func), \
            HK_REFLECT_TYPE_OPTIONAL(Opt::COPY_CONSTRUCTOR, &hkReflect::Detail::Trivial<Opt::COPY_CONSTRUCTOR>::func),\
            HK_REFLECT_TYPE_OPTIONAL(Opt::COPY_ASSIGNMENT, &hkReflect::Detail::Trivial<Opt::COPY_ASSIGNMENT>::func), \
            HK_REFLECT_TYPE_OPTIONAL(Opt::INHERITANCE, 0), \
            HK_REFLECT_TYPE_OPTIONAL(Opt::ALLOC_IMPL, &hkReflect::Detail::HeapAllocImpl::s_instance), \
            HK_REFLECT_TYPE_OPTIONAL_SIZE_ALIGN(sizeof(TYPE), HK_ALIGN_OF(TYPE), 0) \
        }; \
    REGISTER_TYPE( TYPE )

#define DEFINE_ENDIAN_TYPE_INT_2(NATIVE_TYPE, ENDIAN_TYPE, ENDIAN_VAL) \
    DEFINE_ENDIAN_TYPE_INTERNAL(ENDIAN_TYPE, \
        (hkReflect::Format::OfIntGeneric<ENDIAN_VAL, hkTrait::IsSigned<NATIVE_TYPE>::result, sizeof(NATIVE_TYPE)*8>::Value), \
        (&hkReflect::Detail::EndianIntImplN<NATIVE_TYPE, ENDIAN_TYPE>::s_instance) )

#define DEFINE_ENDIAN_TYPE_INT(TYPE) \
    DEFINE_ENDIAN_TYPE_INT_2(TYPE, TYPE##Le, 0); \
    DEFINE_ENDIAN_TYPE_INT_2(TYPE, TYPE##Be, 1)

DEFINE_ENDIAN_TYPE_INT(hkInt8);
DEFINE_ENDIAN_TYPE_INT(hkInt16);
DEFINE_ENDIAN_TYPE_INT(hkInt32);
DEFINE_ENDIAN_TYPE_INT(hkInt64);
DEFINE_ENDIAN_TYPE_INT(hkUint8);
DEFINE_ENDIAN_TYPE_INT(hkUint16);
DEFINE_ENDIAN_TYPE_INT(hkUint32);
DEFINE_ENDIAN_TYPE_INT(hkUint64);

// helper for floats

#define DEFINE_ENDIAN_TYPE_FLOAT_2(NATIVE_TYPE, ENDIAN_TYPE, ENDIAN_VAL, EXP_BITS, SIGNIF_BITS) \
    DEFINE_ENDIAN_TYPE_INTERNAL(ENDIAN_TYPE, \
        (hkReflect::Format::OfFloatGeneric<ENDIAN_VAL, 1, 1, EXP_BITS, SIGNIF_BITS>::Value), \
        (&hkReflect::Detail::EndianFloatImplN<NATIVE_TYPE, ENDIAN_TYPE>::s_instance) )

#define DEFINE_ENDIAN_TYPE_FLOAT(TYPE, EXP_BITS, SIGNIF_BITS) \
    DEFINE_ENDIAN_TYPE_FLOAT_2(TYPE, TYPE##Le, 0, EXP_BITS, SIGNIF_BITS); \
    DEFINE_ENDIAN_TYPE_FLOAT_2(TYPE, TYPE##Be, 1, EXP_BITS, SIGNIF_BITS)

typedef hkDouble64 hkFloat64;
DEFINE_ENDIAN_TYPE_FLOAT(hkHalf16, 8, 7);
DEFINE_ENDIAN_TYPE_FLOAT(hkFloat32, 8, 23);
DEFINE_ENDIAN_TYPE_FLOAT(hkFloat64, 11, 52);

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
