// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL !REFLECT
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#define HK_BINARY_INTERNAL2(n) \
    ((n & 0x0000000FU ?   1 :0) \
    |(n & 0x000000F0U ?   2 :0) \
    |(n & 0x00000F00U ?   4 :0) \
    |(n & 0x0000F000U ?   8 :0) \
    |(n & 0x000F0000U ?  16 :0) \
    |(n & 0x00F00000U ?  32 :0) \
    |(n & 0x0F000000U ?  64 :0) \
    |(n & 0xF0000000U ? 128 :0) )

#define HK_BINARY_INTERNAL(n) HK_BINARY_INTERNAL2(0x##n##U)

// Define a constant binary number. Any hex digits can be used, each digit
// corresponds to a single bit, nonzero indicating a 1 and zero a 0. Thus nonzero bits could be
// be numbered e.g. HK_BINARY_8(120406) == HK_BINARY_8(110101)
#define HK_BINARY_8(n) hkUint8(HK_BINARY_INTERNAL(n))
#define HK_BINARY_16(msb,lsb) hkUint16( (HK_BINARY_INTERNAL(msb)<<8) | HK_BINARY_INTERNAL(lsb) )
#define HK_BINARY_32(msb,mb1,lb1,lsb) ( (HK_BINARY_INTERNAL(msb)<<24) | (HK_BINARY_INTERNAL(mb1)<<16) | (HK_BINARY_INTERNAL(lb1)<<8) | HK_BINARY_INTERNAL(lsb) )

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
