// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/hkBase.h>
#include <Common/Base/Container/Tuple/hkTuple.h>
#define DEBUG_LOG_IDENTIFIER "base.types"
#include <Common/Base/System/Log/hkLog.hxx>

const hkFloat32 hkUInt8ToFloat32[256] =
{
    0,      1,      2,      3,      4,      5,      6,      7,      8,      9,      10,     11,     12,     13,     14,     15,
    16,     17,     18,     19,     20,     21,     22,     23,     24,     25,     26,     27,     28,     29,     30,     31,
    32,     33,     34,     35,     36,     37,     38,     39,     40,     41,     42,     43,     44,     45,     46,     47,
    48,     49,     50,     51,     52,     53,     54,     55,     56,     57,     58,     59,     60,     61,     62,     63,
    64,     65,     66,     67,     68,     69,     70,     71,     72,     73,     74,     75,     76,     77,     78,     79,
    80,     81,     82,     83,     84,     85,     86,     87,     88,     89,     90,     91,     92,     93,     94,     95,
    96,     97,     98,     99,     100,    101,    102,    103,    104,    105,    106,    107,    108,    109,    110,    111,
    112,    113,    114,    115,    116,    117,    118,    119,    120,    121,    122,    123,    124,    125,    126,    127,
    128,    129,    130,    131,    132,    133,    134,    135,    136,    137,    138,    139,    140,    141,    142,    143,
    144,    145,    146,    147,    148,    149,    150,    151,    152,    153,    154,    155,    156,    157,    158,    159,
    160,    161,    162,    163,    164,    165,    166,    167,    168,    169,    170,    171,    172,    173,    174,    175,
    176,    177,    178,    179,    180,    181,    182,    183,    184,    185,    186,    187,    188,    189,    190,    191,
    192,    193,    194,    195,    196,    197,    198,    199,    200,    201,    202,    203,    204,    205,    206,    207,
    208,    209,    210,    211,    212,    213,    214,    215,    216,    217,    218,    219,    220,    221,    222,    223,
    224,    225,    226,    227,    228,    229,    230,    231,    232,    233,    234,    235,    236,    237,    238,    239,
    240,    241,    242,    243,    244,    245,    246,    247,    248,    249,    250,    251,    252,    253,    254,    255
};

template <bool ROUND>
void hkFloat16::setReal(hkReal r)
{
    union { float f; int i; } bits; bits.f = hkFloat32(r);

    hkUint32 result;

    hkUint32 intValue = bits.i;
    hkUint32 sign = (intValue & 0x80000000U) >> 16U;
    intValue = intValue & 0x7FFFFFFFU;      // Hack off the sign

    if (intValue > 0x477FE000U)
    {
        // The number is too large to be represented as a half.  Saturate to infinity.
        if (((intValue & 0x7F800000) == 0x7F800000) && ((intValue & 0x7FFFFF) != 0))
        {
            result = 0x7FFF; // NAN
        }
        else
        {
            result = 0x7C00U; // INF
        }
    }
    else
    {
        if (intValue < 0x38800000U)
        {
            // The number is too small to be represented as a normalized half.
            // Convert it to a denormalized value.
            hkUint32 shift = 113U - (intValue >> 23U);
            intValue = (0x800000U | (intValue & 0x7FFFFFU)) >> shift;
        }
        else
        {
            // Rebias the exponent to represent the value as a normalized half.
            intValue += 0xC8000000U;
        }

        if (ROUND)
        {
            result = ((intValue + 0x0FFFU + ((intValue >> 13U) & 1U)) >> 13U) & 0x7FFFU;
        }
        else
        {
            result = intValue >> 13U;
        }
    }

    m_value = (hkUint16)(result | sign);
}

hkFloat32 hkFloat16::getFloat32() const
{
    hkUint32 mantissa = (hkUint32)(m_value & 0x03FF);

    hkUint32 exponent = (m_value & 0x7C00);
    if (exponent == 0x7C00) // INF/NAN
    {
        exponent = (hkUint32)0x8f;
    }
    else if (exponent != 0)  // The value is normalized
    {
        exponent = (hkUint32)((m_value >> 10) & 0x1F);
    }
    else if (mantissa != 0)     // The value is denormalized
    {
        // Normalize the value in the resulting float
        exponent = 1;

        do
        {
            exponent--;
            mantissa <<= 1;
        } while ((mantissa & 0x0400) == 0);

        mantissa &= 0x03FF;
    }
    else                        // The value is zero
    {
        exponent = (hkUint32)-112;
    }

    hkUint32 result = ((m_value & 0x8000) << 16) | // Sign
        ((exponent + 112) << 23) | // Exponent
        (mantissa << 13);          // Mantissa

    union { float f; int i; } bits; bits.i = result;
    return bits.f;
}

template HK_EXPORT_COMMON void hkFloat16::setReal<false>(hkReal);
template HK_EXPORT_COMMON void hkFloat16::setReal<true>(hkReal);
namespace
{
    struct ResultStringTuple
    {
        int code;
        const char* str;
        const char* desc;
    };
    const ResultStringTuple hkResultToString[] =
    {
        // To keep this table in sync:
        // 1. Copy and paste the #defines from the header
        // 2. Select the pasted block
        // 3. Run this regex find/replace on the selection
            // #define\s+([^\s]+)(\s*)[^\(]+\(([^\)]+)\)(\s*)//\s*([^\r\n]*)
            // { $1.m_code,$2"$1",$2$4"$5" },
        { HK_SUCCESS.m_code,                "HK_SUCCESS",                 "Success." },
        { HK_FAILURE.m_code,                "HK_FAILURE",                 "Generic failure." },
        { HK_E_FILE_NOT_FOUND.m_code,       "HK_E_FILE_NOT_FOUND",        "File not found." },
        { HK_E_OUTOFMEMORY.m_code,          "HK_E_OUTOFMEMORY",           "Out of memory, cannot perform operation." },
        { HK_E_WRITE_PROTECT.m_code,        "HK_E_WRITE_PROTECT",         "Cannot access write-protected entity." },
        { HK_E_HANDLE_EOF.m_code,           "HK_E_HANDLE_EOF",            "End of file." },
        { HK_E_NOT_SUPPORTED.m_code,        "HK_E_NOT_SUPPORTED",         "Operation not supported." },
        { HK_E_INVALID_PARAMETER.m_code,    "HK_E_INVALID_PARAMETER",     "Invalid operation parameter." },
        { HK_E_NOT_IMPLEMENTED.m_code,      "HK_E_NOT_IMPLEMENTED",       "Operation not implemented." },
        { HK_E_ALREADY_EXISTS.m_code,       "HK_E_ALREADY_EXISTS",        "Cannot create or modify object of operation because it already exists." },
        { HK_E_UNEXPECTED.m_code,           "HK_E_UNEXPECTED",            "Unexpected internal state." },
    };
}
void hkResult::toString(hkStringBuf& sb) const
{
    sb.clear();
    for (int i = 0; i < HK_COUNT_OF(hkResultToString); i++)
    {
        if (hkResultToString[i].code == m_code)
        {
            sb.append(hkResultToString[i].str);
            return;
        }
    }

    // In case an hkResult was created from an HRESULT using the fromErrorCode function.
    Log_Warning("No corresponding string is defined for hkResult with code 0x{:X8}.", unsigned(m_code));
    sb.appendFormat( m_code >= 0 ? "HK_SUCCESS_{:X8}" : "HK_E_{:X8}", unsigned(m_code));
}

void hkResult::toString(const hkReflect::Var& var, hkStringBuf& sb, const hkStringView& extra)
{
    var.dynCast<hkResult>()->toString(sb);
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
