// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#ifndef HKBASE_HKBASEDEFS_H
#define HKBASE_HKBASEDEFS_H

// Double-precision math is enabled in GlobalConfig.h (for double-precision build targets only)
//#define HK_REAL_IS_DOUBLE

#if !defined(HK_REAL_IS_DOUBLE)
#   define HK_REAL_IS_FLOAT
#   define HK_ON_REAL_IS_DOUBLE( X )
#   define HK_ON_REAL_IS_FLOAT( X ) X
#else
#   define HK_ON_REAL_IS_DOUBLE( X ) X
#   define HK_ON_REAL_IS_FLOAT( X )
#endif

//
// compiler
//

#if 0 && defined(__INTEL_COMPILER)
#   define HK_COMPILER_INTEL
#elif defined(__clang__)
#   define HK_COMPILER_CLANG
#elif defined(__SNC__)
#   define HK_COMPILER_SNC
#elif defined(__GNUC__) || defined(__CC_ARM) || defined(__ARMCC__) || defined(__ghs__)
#   define HK_COMPILER_GCC // ARMCC and GCC are very similar so often can treat them the same.
#   if defined(__CC_ARM) || defined(__ARMCC__)
#       define HK_COMPILER_ARMCC
#   elif defined(__ghs__)
#       define HK_COMPILER_GHS
#   endif
#elif defined(_MSC_VER) // Intel compiler defines this too (most of the time, not on LRB etc though)
#   define HK_COMPILER_MSVC
#else
#   error Could not detect compiler
#endif

//
// architecture
//

#if defined(__i386__) || defined(_M_IX86)
#   define HK_ARCH_IA32
#   define HK_ARCH_INTEL
#   define HK_ENDIAN_LITTLE 1
#   define HK_ENDIAN_BIG    0
#   define HK_POINTER_SIZE 4
#   define HK_NUM_SIMD_REGISTERS 8
#elif defined(_M_AMD64) || defined(_M_X64) || defined(__amd64) || defined(__x86_64)
#   define HK_ARCH_X64
#   define HK_ARCH_INTEL
#   define HK_ENDIAN_LITTLE 1
#   define HK_ENDIAN_BIG    0
#   define HK_POINTER_SIZE 8
#   define HK_ARCH_SUPPORTS_INT64
#   define HK_NUM_SIMD_REGISTERS 16
#elif defined(_PPC_) || defined(__POWERPC__) || defined(_M_PPC) || defined(_M_PPCBE) || defined(GEKKO) || defined(EPPC)
#   define HK_ARCH_PPC
#   define HK_ENDIAN_LITTLE 0
#   define HK_ENDIAN_BIG    1
#   define HK_POINTER_SIZE 4
#   define HK_ARCH_SUPPORTS_INT64
#   define HK_NUM_SIMD_REGISTERS 8
#elif defined(arm) || defined(__arm__) || defined(_M_ARM) || defined(__arm64__) || defined(__aarch64__) || defined(_M_ARM64) || defined(__AARCH64EL__) || defined(__AARCH64EB__)
#   define HK_ARCH_ARM
#   if defined(__LP64__) || defined(__aarch64__) || defined(__arm64__) || defined(_M_ARM64)
#       define HK_ARCH_ARM_64 1
#   endif
#   if defined(__ARM64_ARCH_8__) || defined(__ARM64_ARCH_8__) || (__ARM_ARCH == 8)
#       define HK_ARCH_ARM_V8 1
#   elif defined(__ARM_ARCH_7A__) || defined(__ARM_ARCH_7__) || defined(__ARM_ARCH_7R__) || defined (__ARM_ARCH_7M__) || defined(__ARM_ARCH_7S__) || ( defined(_M_ARM) && (_M_ARM >= 7) )
#       define HK_ARCH_ARM_V7 1
#   elif defined(__ARM_ARCH_6__) || defined(__ARM_ARCH_6J__) || defined(__ARM_ARCH_6K__) || defined(__ARM_ARCH_6Z__) || defined(__ARM_ARCH_6ZK__) || defined(__ARM_ARCH_6T2__) || defined(NN_PROCESSOR_ARM) || defined(NN_PROCESSOR_ARM_V6) || ( defined(_M_ARM) && (_M_ARM < 7) )
#       define HK_ARCH_ARM_V6 1
#   else
#       error Unexpected ARM arch
#   endif
#   if defined(__ARMEB__) || defined(__AARCH64EB__)
#       define HK_ENDIAN_LITTLE 0
#       define HK_ENDIAN_BIG    1
#   else
#       define HK_ENDIAN_LITTLE 1
#       define HK_ENDIAN_BIG    0
#   endif
#   if defined(HK_ARCH_ARM_64)
#       define HK_POINTER_SIZE 8
#       define HK_NATIVE_ALIGN_CHECK 0x7 
#       define HK_NUM_SIMD_REGISTERS 8
#   else
#       define HK_POINTER_SIZE 4
#       define HK_NATIVE_ALIGN_CHECK 0x7 
#       define HK_NUM_SIMD_REGISTERS 8
#   endif
#else
#   error Could not autodetect target architecture
#endif

#ifndef HK_NATIVE_ALIGN_CHECK
#   define HK_NATIVE_ALIGN_CHECK 0xf 
#endif

//
// platform
//

#if defined(__ORBIS__)
#   define HK_PLATFORM_PS4
#   define HK_PLATFORM_IS_CONSOLE 1
#   include <sdk_version.h> 
#   define HK_PS4_SDK_VERSION SCE_ORBIS_SDK_VERSION

#elif defined(__APPLE_CC__)
#   if !defined(__HAVOK_PARSER__)
#       include <TargetConditionals.h> // Specific to the current SDK, in usr\include
#   endif
#   if defined( HK_ARCH_INTEL )
#       if defined(TARGET_IPHONE_SIMULATOR) && TARGET_IPHONE_SIMULATOR
#           define HK_PLATFORM_IS_CONSOLE 1
#           define HK_PLATFORM_IOS
#           define HK_PLATFORM_IOS_SIM
#       else
#           define HK_PLATFORM_MAC
#           define HK_PLATFORM_IS_CONSOLE 0
#           define HK_PLATFORM_MAC386
#       endif
#   elif defined( HK_ARCH_X64 ) && !defined(HK_ARCH_ARM_64)
#       define HK_PLATFORM_MAC
#       define HK_PLATFORM_IS_CONSOLE 0
#       define HK_PLATFORM_MAC64
#   elif defined( HK_ARCH_PPC )
#       define HK_PLATFORM_MAC
#       define HK_PLATFORM_MACPPC
#       define HK_PLATFORM_IS_CONSOLE 0
#   elif defined( HK_ARCH_ARM ) // iPhone /iPod Touch/ iPad
#       define HK_PLATFORM_IOS
#       define HK_PLATFORM_IS_CONSOLE 1
#       if defined(TARGET_OS_TV) && TARGET_OS_TV
#           define HK_PLATFORM_TVOS 1
#       endif
#       if defined(__ARM_NEON__) && (defined(HK_ARCH_ARM_V7) || defined(HK_ARCH_ARM_V8)) && !defined(HK_DISABLE_NEON)
#           define HK_COMPILER_HAS_INTRINSICS_NEON
#       endif
#   else
#       error Mac platform undefined
#   endif
#elif defined(__NX)
#   define HK_PLATFORM_NX 1
#   define HK_PLATFORM_IS_CONSOLE 1
#   if defined(_WIN32)
#       if defined(HK_ARCH_X64)
#           define HK_PLATFORM_NX_X64 1
#       else
#           define HK_PLATFORM_NX_WIN32 1
#       endif
#   else
#       define HK_COMPILER_HAS_INTRINSICS_NEON 1
#   endif
#elif defined(_WIN32)
#   define HK_PLATFORM_WIN32
#   if defined(_WIN64)
#       define HK_PLATFORM_WIN64
#   endif
    // so that we can include this .h before windows etc ones, we use the values not the defines
#   ifndef WINAPI_FAMILY_APP
#       define WINAPI_FAMILY_APP         0x1
#       define WINAPI_FAMILY_DESKTOP_APP 0x2
#       define WINAPI_FAMILY_PHONE_APP   0x3
#       define ___UNDEF_FAMILY 1
#   endif
#   if defined(WINAPI_FAMILY) && ((WINAPI_FAMILY==WINAPI_FAMILY_APP) || (WINAPI_FAMILY==WINAPI_FAMILY_PHONE_APP))
#       define HK_PLATFORM_WINRT
#       if WINAPI_FAMILY == WINAPI_FAMILY_APP
#           define HK_PLATFORM_METRO 1
#       elif WINAPI_FAMILY == WINAPI_FAMILY_PHONE_APP
#           define HK_PLATFORM_IS_CONSOLE 1
#       endif
#   elif defined(_DURANGO)
#       define HK_PLATFORM_DURANGO
#       define HK_PLATFORM_IS_CONSOLE 1
#   endif
#   ifdef HK_UWP
#       define HK_PLATFORM_UWP
#   endif
#   ifdef ___UNDEF_FAMILY
#       undef WINAPI_FAMILY_APP
#       undef WINAPI_FAMILY_DESKTOP_APP
#       undef WINAPI_FAMILY_PHONE_APP
#       undef ___UNDEF_FAMILY
#   endif
#   ifndef HK_PLATFORM_IS_CONSOLE
#       define HK_PLATFORM_IS_CONSOLE 0
#   endif
#   if defined(HK_BUILDING_WITH_ENGINE) && (defined(HK_PLATFORM_UWP) || defined(HK_COMPILER_RAZZLE))
#       define HK_NONSDK_BUILD
#   endif

#elif defined(ANDROID_NDK) || defined(ANDROID) || defined(NDK) || defined(__ANDROID_API__) || defined(__ANDROID__) // Android before Linux as it is that too
#   define HK_PLATFORM_ANDROID
#   define HK_PLATFORM_IS_CONSOLE 1
#   if (defined(HK_ARCH_ARM_V7) || defined(HK_ARCH_ARM_V8)) && !defined(HK_DISABLE_NEON)
#       define HK_COMPILER_HAS_INTRINSICS_NEON 1
#   endif

#elif defined(HK_PLATFORM_TIZEN) || defined(__tizen__) || defined(TIZEN)
#   ifndef HK_PLATFORM_TIZEN
#       define HK_PLATFORM_TIZEN
#       define HK_STD_NAMESPACE std
//#     if defined(HK_ARCH_ARM_V7) && !defined(HK_DISABLE_NEON)
//#         define HK_COMPILER_HAS_INTRINSICS_NEON 1
//#     endif
#   endif
#   define HK_PLATFORM_IS_CONSOLE 1

#elif (defined(__unix__) || defined(__linux__))
#   define HK_PLATFORM_LINUX
#   define HK_PLATFORM_IS_CONSOLE 0
#   if defined(__native_client__) || defined(__nacl__) || defined(NACL)
#       define HK_PLATFORM_NACL
#       undef HK_POINTER_SIZE
#       define HK_POINTER_SIZE 4 // always 4 in NaCl
#   endif

#elif defined(CAFE) || defined(HK_COMPILER_GHS)
#   include <cafe.h>
#   include <ppc_ghs.h> // allow use of intrinsics throughout Havok code
#   define HK_PLATFORM_WIIU
#   if !defined(HK_ENABLE_PAIRED_SINGLE_OPTS)
#       define HK_ENABLE_PAIRED_SINGLE_OPTS
#   endif
#   define HK_VECTOR_PARTS_MUST_BE_VALID
#   define HK_PLATFORM_IS_CONSOLE 1

#elif defined(__CTR__) || defined(NN_PLATFORM_CTR)
#   define HK_PLATFORM_CTR
#   define HK_PLATFORM_IS_CONSOLE 1

#elif (defined(HK_ARCH_ARM) && defined(HK_COMPILER_SNC))
#   define HK_PLATFORM_PSVITA 1
#   define HK_PLATFORM_IS_CONSOLE 1
#   define HK_COMPILER_HAS_INTRINSICS_NEON 1
#   define HK_STD_NAMESPACE std

#else
#   error Could not autodetect target platform.
#endif

//
// useful macros
//

#if (defined(DEBUG) || defined(_DEBUG) || defined(HK_DEBUG)) && !defined(HK_DISABLE_DEBUG)
#   undef HK_DEBUG
#   define HK_DEBUG
#   define HK_ON_DEBUG(...) __VA_ARGS__
#else
#   undef HK_DEBUG
#   define HK_ON_DEBUG(...)
#endif

#if defined(HK_DEBUG_SLOW) && !defined(HK_DISABLE_DEBUG)
#   define HK_ON_DEBUG_SLOW(...) __VA_ARGS__
#else
#   undef HK_DEBUG_SLOW
#   define HK_ON_DEBUG_SLOW(...)
#endif

// use the compiler friendly but programmer ugly version for release only
#if defined(HK_DEBUG_SLOW) || defined(__clang__)
#   define HK_MULTILINE_MACRO_BEGIN do {
#   define HK_MULTILINE_MACRO_END   } while(0)
#else
#   define HK_MULTILINE_MACRO_BEGIN if(1) {
#   define HK_MULTILINE_MACRO_END   } else
#endif

#if defined(HK_ARCH_IA32) || defined(HK_ARCH_X64) && !defined(HK_PLATFORM_PS4)
#   if defined(HK_COMPILER_MSVC)
#       define HK_BREAKPOINT(ID) __debugbreak()
#   elif defined(HK_PLATFORM_NACL) // not allowed raise interrupts
#       define HK_BREAKPOINT(ID) ((*((int*)0)) = ID)
#   elif defined(HK_COMPILER_GCC) || defined(HK_COMPILER_CLANG)
#       define HK_BREAKPOINT(ID) asm("int $3")
#   else
#       error unknown asm syntax for PC platform
#   endif
#elif defined(HK_PLATFORM_PS4)
#   include <libdbg.h>
#   define HK_BREAKPOINT(ID) SCE_BREAK()
#elif defined(HK_PLATFORM_WIIU)
#   define HK_BREAKPOINT(ID) OSDebug()
#elif defined(HK_PLATFORM_CTR)
#   include <nn/dbg.h>
#   define HK_BREAKPOINT(ID) ::nn::dbg::Break(nn::dbg::BREAK_REASON_ASSERT)
#elif defined(HK_PLATFORM_NX)
#   if defined(HK_ARCH_ARM_64)
#       define HK_BREAKPOINT(ID)__asm__("svc #38")
#   else
#       include <nn/diag/diag_Break.h>
#       define HK_BREAKPOINT(ID) NN_DIAG_BREAK();
#   endif
#elif defined(HK_ARCH_ARM)
#   if defined(HK_COMPILER_MSVC)
#       define HK_BREAKPOINT(ID) __debugbreak()
#   elif defined(HK_COMPILER_SNC)
#       define HK_BREAKPOINT(ID) __breakpoint(0)
#   else
#       define HK_BREAKPOINT(ID) __builtin_trap()
#   endif
#else
#   define HK_BREAKPOINT(ID) ((*((int*)0)) = ID)
#endif

// Utility structure, for use with the HK_DEBUG_ONLY_MEMBER macro. This class should not be used directly.
template<typename T>
struct hkDebugOnlyMember
{
    hkDebugOnlyMember() : member() {}
private:
    T member;
};

// Debug-only members, for use with state assertions. All such members should
// be declared with //+serialized(false), if declared in a reflected class.

#if defined(HK_DEBUG) || defined(__HAVOK_PARSER__) // In debug mode, or for reflection, declare normally
#   define HK_DEBUG_ONLY_MEMBER(TYPE, NAME) TYPE NAME
#else // In release mode, declare as inaccessible padding, to prevent accidental use
#   define HK_DEBUG_ONLY_MEMBER(TYPE, NAME) hkDebugOnlyMember<TYPE> NAME
#endif


#define HK_NULL nullptr
#if !defined(HK_PLATFORM_DURANGO) // nullptr_t is a compiler builtin.
    namespace std { typedef decltype(nullptr) nullptr_t; };
#endif
using ::std::nullptr_t;

#if !defined(HK_OVERRIDE) // Defined in the case of Visual Assist with va_stdafx.h
    // check for native support
    #if defined(_MANAGED)
        // use the no-op versions - "override" requires an explicit "virtual" which is painful
    #elif __cplusplus >= 201103 || defined(HK_PLATFORM_NX)
        #define HK_OVERRIDE override
        #define HK_FINAL final
        #define HK_FINAL_OVERRIDE final override
    #elif defined (HK_COMPILER_MSVC)
        #if (_MSC_VER >= 1700)
            #define HK_OVERRIDE override
            #define HK_FINAL    final
            #define HK_FINAL_OVERRIDE final override
        #elif (_MSC_VER >= 1600)
            #define HK_OVERRIDE override
            #define HK_FINAL    sealed
            #define HK_FINAL_OVERRIDE sealed override
        #elif (_MSC_VER >=1400)
            #define HK_OVERRIDE override
            #define HK_FINAL
            #define HK_FINAL_OVERRIDE override
        #endif
    #endif
    // no support, make them no-ops
    #if !defined(HK_OVERRIDE)
        #define HK_OVERRIDE
        #define HK_FINAL
        #define HK_FINAL_OVERRIDE
    #endif
#endif




// Move semantics
#if __cplusplus >= 201103 || defined(HK_PLATFORM_NX)
#   define HK_MOVE_SEMANTICS
#elif defined (HK_COMPILER_MSVC)
#   if (_MSC_VER >= 1600)           // VS 2010 and later
#       define HK_MOVE_SEMANTICS
#   endif
#endif

// noexcept
#if __cplusplus >= 201103
    #define HK_NOEXCEPT noexcept
#else
    #define HK_NOEXCEPT throw()
#endif

// Variadic template
#if __cplusplus >= 201103
#   define HK_VARIADIC_TEMPLATES
#elif defined (HK_COMPILER_MSVC)
#   if (_MSC_VER >= 1800)           // VS 2013 and later
#       define HK_VARIADIC_TEMPLATES
#   endif
#endif

#include <Common/Base/PreProcessor/hkPreProcessor.h>

#if defined(HK_COMPILER_MSVC) || defined(HK_COMPILER_INTEL)
#   define HK_ALIGN_OF(...) __alignof(__VA_ARGS__)
#elif defined(HK_COMPILER_GCC) || defined(HK_COMPILER_SNC) || defined(HK_COMPILER_CLANG)
#   define HK_ALIGN_OF(...) __alignof__(__VA_ARGS__)
#else
#   error fixme
#endif

/// Note that ALIGNMENT must be a power of two for this to work.
/// Note: to use this macro you must cast your pointer to a byte pointer or to an integer value.
#define HK_NEXT_MULTIPLE_OF(ALIGNMENT, ...)  ( ((__VA_ARGS__) + ((ALIGNMENT)-1)) & (~((ALIGNMENT)-1)) )

    /// Returns the offset of a member within a structure. The first argument should be the class name and the second the field name.
    /// If the class name may contain commas (such as in a template), use HK_ROFFSET_OF intead.
    /// Casts to char& before taking the address because operator& might be overloaded.
#define HK_OFFSET_OF(TYPE, FIELD) \
    int(hkUlong(&(char&)(reinterpret_cast<TYPE*>(32)->FIELD))-32)

    /// Returns the offset of a member within a structure. The first argument should be the field and second the class name
    /// Note: it is a variadic macro in order to handle correctly template types that introduce commas.
    /// Examples: HK_ROFFSET_OF(m_field, Bar), HK_ROFFSET_OF(m_field, Bar<int, int, int>)
    /// Casts to char& before taking the address because operator& might be overloaded.
#define HK_ROFFSET_OF(FIELD, ...) \
    int(hkUlong(&(char&)(reinterpret_cast<__VA_ARGS__*>(32)->FIELD))-32)

/// A check for whether the offset of a member within a structure is as expected
#define HK_OFFSET_EQUALS(CLASS,MEMBER,OFFSET) (HK_OFFSET_OF(CLASS,MEMBER)==OFFSET)

/// Computes the offset between a from a derived class to it's base class in the case of multiple inheritance.
/// Both arguments should be of the form "(T*)", e.g. HK_OFFSET_TO_BASE((MyClass*), (MyInterface*)).
#define HK_OFFSET_TO_BASE(DERIVED, BASE) \
    hkLong(hkLong(BASE(DERIVED(128)))-128)

/// Join two preprocessor tokens, even when a token is itself a macro.
#define HK_PP_JOIN(A,B) HK_DETAIL_PP_JOIN2(A,B)
#define HK_PREPROCESSOR_JOIN_TOKEN(A,B) HK_DETAIL_PP_JOIN2(A,B)
#define HK_DETAIL_PP_JOIN2(A,B) HK_DETAIL_PP_JOIN3(A,B)
#define HK_DETAIL_PP_JOIN3(A,B) A##B

/// Stringify the name of some constant. Eg. HK_PP_STRINGIFY_NAME(HK_FLOAT_PI) => "HK_FLOAT_PI"
#define HK_PP_STRINGIFY_NAME(A) #A
/// Stringify the value of some constant. Eg. HK_PP_STRINGIFY_VALUE(HK_FLOAT_PI) => "3.14159265358979f"
#define HK_PP_STRINGIFY_VALUE(A) HK_PP_STRINGIFY_NAME(A)

#define HK_COMMON_BUILD 1
#define HK_PHYSICS_BUILD 2
#define HK_ANIMATION_BUILD 3
#define HK_BEHAVIOR_BUILD 4
#define HK_CLOTH_BUILD 5
#define HK_DESTRUCTION_BUILD 6
#define HK_AI_BUILD 7
#define HK_FX_BUILD 8
#define HK_ENGINE_BUILD 9
#define HK_EDITOR_BUILD 10
#define HK_RENDERER_BUILD 11
#define HK_PHYSICS_2012_BUILD 12
#define HK_DESTRUCTION_2012_BUILD 13
#define HK_VDB_BUILD 14
#define HK_RESEARCH_BUILD 15

//
// compiler specific settings
//

    // *************************************
    //          GCC, SN and CLANG
    // *************************************
#if defined(HK_COMPILER_GCC) || defined(HK_COMPILER_SNC) || defined(HK_COMPILER_GHS) || defined(__GCCXML__) || defined(HK_COMPILER_CLANG)

#   if !defined(HK_COMPILER_ARMCC)
#       if defined(__GNUC_PATCHLEVEL__)
#           define HK_COMPILER_GCC_VERSION (__GNUC__ * 10000 + __GNUC_MINOR__ * 100 +__GNUC_PATCHLEVEL__)
#       else
#           define HK_COMPILER_GCC_VERSION (__GNUC__ * 10000 + __GNUC_MINOR__ * 100)
#       endif
#   else
#       define HK_COMPILER_GCC_VERSION 0
#   endif

#   define HK_RESTRICT __restrict

#   if (defined( HK_COMPILER_GCC ) || defined(HK_COMPILER_CLANG) || defined( HK_COMPILER_SNC ))
#       define HK_VERY_UNLIKELY(EXPR) __builtin_expect(bool(EXPR),0)
#       define HK_VERY_LIKELY(EXPR) __builtin_expect(bool(EXPR),1)
#   endif

#   if (HK_COMPILER_GCC_VERSION >= 40000)
#       undef HK_OFFSET_OF
#       undef HK_ROFFSET_OF
#       define HK_OFFSET_OF(...) __builtin_offsetof( __VA_ARGS__ )
#       define HK_ROFFSET_OF(FIELD, ...) __builtin_offsetof(__VA_ARGS__, FIELD)
#       if (HK_COMPILER_GCC_VERSION >= 40500) && !defined(HK_DEBUG)
#           define HK_UNREACHABLE(ID, ...) __builtin_unreachable()
#       endif
#   endif

#   if ( HK_COMPILER_GCC_VERSION >= 40000 ) && !defined( HK_COMPILER_SNC )
#       undef HK_OFFSET_EQUALS
#       define HK_OFFSET_EQUALS(C,M,O) true
#   endif

#   define HK_ALIGN(DECL, ALIGNMENT) DECL __attribute__((aligned(ALIGNMENT)))
#   define HK_CLASSALIGN(DECL, ALIGNMENT) HK_ALIGN(DECL, ALIGNMENT)

#   if defined(HK_DYNAMIC_DLL)
#       if defined(HK_DLL_BUILD) && (HK_DLL_BUILD==HK_COMMON_BUILD) // DLL export for base etc
#           define HK_EXPORT_COMMON __attribute__((visibility("default")))
#           define HK_EXPORT_COMMON_TEMPLATE_SPECIALIZATION
#       else // Being used in a non common build, but still a dll
#           define HK_EXPORT_COMMON
#           define HK_EXPORT_COMMON_TEMPLATE_SPECIALIZATION extern // see http://support.microsoft.com/kb/168958
#       endif
#   endif
#

#   if defined(HK_ARCH_ARM) || defined(HK_COMPILER_GHS) || defined(HK_PLATFORM_IOS_SIM) || defined(HK_PLATFORM_TIZEN)
#       define HK_ALIGN_RELAX_CHECKS 1
#   endif

#   if defined(HK_COMPILER_SNC) || defined(HK_COMPILER_GHS)
#       define HK_VISIBILITY_HIDDEN /*empty*/
    #else
#       define HK_VISIBILITY_HIDDEN __attribute__((visibility("hidden")))
#   endif

#   if defined(HK_COMPILER_GHS)
#       define HK_LINKONCE_VTABLES 0
#       if __GHS_VERSION_NUMBER >= 5314
#           define HK_HASHCODE_VTABLE_REGISTRY 1
#       endif
#   endif

typedef unsigned long long hkUint64;
typedef long long hkInt64;

#   if defined(HK_PLATFORM_PS4) || (defined(HK_PLATFORM_LINUX) && defined(HK_ARCH_X64) && !defined(HK_PLATFORM_NACL)) // LINUX64 but not NACL64
#       define HK_COMPILER_HAS_INTRINSICS_IA32
#   endif

#   if defined(HK_PLATFORM_MAC386) || defined(HK_PLATFORM_MAC64)    // but not PPC
#       define HK_COMPILER_HAS_INTRINSICS_IA32
#   endif

#   if defined(HK_PLATFORM_CTR)
        typedef unsigned int hkSystemTime;
#   else
        typedef long hkSystemTime;
#   endif

#   if defined(HK_PLATFORM_MAC386) || defined(HK_PLATFORM_MACPPC) || defined(HK_PLATFORM_IOS) || defined(HK_PLATFORM_PS4)
        typedef unsigned long hk_size_t;
#   elif ( defined(HK_PLATFORM_LINUX) && defined(HK_ARCH_X64) && !defined(HK_PLATFORM_NACL) ) || (defined(__GCCXML__) && defined(__x86_64)) || defined(HK_PLATFORM_MAC64) || defined(HK_ARCH_ARM_64)// LINUX64 but not NACL64
        typedef long unsigned int hk_size_t;
#   elif defined(HK_PLATFORM_WIN64)
        typedef unsigned long long hk_size_t;
#   else
        typedef unsigned hk_size_t;
#   endif

#   if (defined(HK_ARCH_IA32) && HK_COMPILER_GCC_VERSION >= 30100) || defined(HK_PLATFORM_NACL)
#       define HK_COMPILER_HAS_INTRINSICS_IA32
#   endif

#   ifdef __HAVOK_PARSER__
#       define HK_INLINE /*nothing*/
#       define HK_ALWAYS_INLINE HK_INLINE
#   elif defined(HK_PLATFORM_CTR)
#       define HK_INLINE __forceinline
#       define HK_ALWAYS_INLINE HK_INLINE
#   elif defined(HK_COMPILER_GCC) || defined(HK_COMPILER_CLANG)
#       if defined(HK_DEBUG)
#           define HK_INLINE inline
#       else
#           define HK_INLINE inline __attribute__((always_inline))
#       endif
#       define HK_ALWAYS_INLINE inline __attribute__((always_inline))
#   else
#       define HK_INLINE inline
#       define HK_ALWAYS_INLINE HK_INLINE
#   endif

// calling convention
#   define HK_CALL
#   define HK_FAST_CALL

// deprecation
#   define HK_DEPRECATED /* nothing */
#   define HK_DEPRECATED2(MSG) /* nothing */


    // *************************************
    //          MICROSOFT and INTEL
    // *************************************
#elif defined(HK_COMPILER_MSVC) || defined(HK_COMPILER_INTEL)

#   define HK_COMPILER_SUPPORTS_PCH
#   define HK_COMPILER_MSVC_VERSION _MSC_VER
#   define HK_OVERRIDE_INLINE

#   ifdef __INTEL_COMPILER
#       define HK_COMPILER_INTEL_VERSION __INTEL_COMPILER
#   else
#       define HK_COMPILER_INTEL_VERSION _MSC_VER
#   endif

#   if (_MSC_VER >= 1400)
#       if _MSC_FULL_VER == 190023506
#           pragma message("WARNING: Visual Studio Update 1 detected - disabling HK_RESTRICT to avoid compiler bugs. Upgrading to Update 2 is recommended.")
#           define HK_RESTRICT
#       else
#           define HK_RESTRICT __restrict
#       endif
#   else
#       define HK_RESTRICT
#   endif

#   if defined(HK_PLATFORM_WIN32) || defined(HK_PLATFORM_NX)
#       define HK_ALIGN(DECL, ALIGNMENT) __declspec(align(ALIGNMENT)) DECL
#       define HK_CLASSALIGN(DECL, ALIGNMENT) DECL __declspec(align(ALIGNMENT))
#       if !defined(HK_COMPILER_INTEL) && !defined(HK_ARCH_ARM_64)
#           if defined(HK_DEBUG_SLOW)
#               define HK_ALWAYS_INLINE __forceinline
#               define HK_INLINE inline
#               define HK_EMULATE_ALWAYS_INLINE_ON_WIN32
#               pragma inline_depth( 0 )
#           else
#               define HK_INLINE __forceinline
#               define HK_ALWAYS_INLINE HK_INLINE
#           endif
#       else // ICC has no force inline intrinsic
#           define HK_INLINE inline
#           define HK_ALWAYS_INLINE HK_INLINE
#       endif
#       define HK_VISIBILITY_HIDDEN /*empty*/
#       define HK_NEVER_INLINE __declspec(noinline)
#   elif defined(HK_PLATFORM_LINUX)
#       define HK_ALIGN(DECL, ALIGNMENT) DECL __attribute__((aligned(ALIGNMENT)))
#       define HK_CLASSALIGN(DECL, ALIGNMENT) HK_ALIGN(DECL, ALIGNMENT)
#       define HK_INLINE inline
#       define HK_ALWAYS_INLINE HK_INLINE
#       define HK_VISIBILITY_HIDDEN /*empty*/
#   else
#       error "fix the alignment on this platform"
#   endif

#   if defined(HK_ARCH_IA32) || defined(HK_ARCH_ARM)
        typedef unsigned __int64 hkUint64;
        typedef __int64 hkInt64;
        typedef long hkSystemTime;
#       if defined(HK_COMPILER_MSVC) && (_MSC_VER >= 1900)
            typedef size_t hk_size_t; // use the MSVC definition of size_t to avoid formal parameter errors
#       elif defined(HK_COMPILER_MSVC) && (_MSC_VER >= 1300) && (!defined(HK_PLATFORM_NX) || defined(HK_ARCH_ARM_64))
            typedef unsigned __w64 hk_size_t; // VC7.0 or higher, 64bit warnings
#       else
            typedef unsigned hk_size_t;
#       endif
#       ifdef HK_ARCH_IA32
#           define HK_COMPILER_HAS_INTRINSICS_IA32
#       elif defined(HK_ARCH_ARM) && !defined(HK_DISABLE_NEON)
#           define HK_COMPILER_HAS_INTRINSICS_NEON
#       endif
#   elif defined( HK_ARCH_PPC )
        typedef unsigned __int64 hkUint64;
        typedef __int64 hkInt64;
        typedef unsigned hk_size_t;
        typedef __int64 hkSystemTime; // 64bit time
#       define HK_COMPILER_HAS_INTRINSICS_PPC
#   elif defined(HK_ARCH_X64)
        typedef unsigned __int64 hkUint64;
        typedef __int64 hkInt64;
        typedef __int64 hkSystemTime;
        typedef unsigned __int64 hk_size_t;
#       ifdef HK_ARCH_LRB
#           define HK_COMPILER_HAS_INTRINSICS_LRB
#       else
#           define HK_COMPILER_HAS_INTRINSICS_IA32
#       endif
#   else
#       error No defs for this architecture
#   endif

    #   if defined(HK_DYNAMIC_DLL)
    #       if defined(HK_DLL_BUILD) && (HK_DLL_BUILD==HK_COMMON_BUILD) // DLL export for base etc
    #           define HK_EXPORT_COMMON __declspec(dllexport)
    #           define HK_EXPORT_COMMON_TEMPLATE_SPECIALIZATION
    #       else // Being used in a non common build, but still a dll
    #           define HK_EXPORT_COMMON __declspec(dllimport)
    #           define HK_EXPORT_COMMON_TEMPLATE_SPECIALIZATION extern // see http://support.microsoft.com/kb/168958
    #       endif
    #   endif

// calling convention
#   ifndef HK_COMPILER_INTEL
#       define HK_CALL __cdecl
#       define HK_FAST_CALL __fastcall
#   else
#       define HK_CALL
#       define HK_FAST_CALL
#   endif

// deprecation
#   if defined(HK_PLATFORM_WIN32) && !defined(MIDL_PASS)
#       define HK_DEPRECATED __declspec(deprecated)
#       define HK_DEPRECATED2(MSG) __declspec(deprecated(MSG))
#   else
#       define HK_DEPRECATED /* nothing */
#       define HK_DEPRECATED2(MSG) /* nothing */
#   endif

// unreachable
#   if !defined(HK_DEBUG)
#       define HK_UNREACHABLE(ID, ...) __assume(0)
#   endif

#else
#   error Unknown compiler
#endif // compilers

// sometimes you want to make a virtual function inline, in this case you need to use HK_INLINE_VIRTUAL to avoid compiler warnings on some platforms
#if !defined(HK_INLINE_VIRTUAL)
#   define HK_INLINE_VIRTUAL HK_INLINE
#endif

#if !defined(HK_OVERRIDE_INLINE)
#   define HK_OVERRIDE_INLINE HK_OVERRIDE
#endif

#ifndef HK_LINKONCE_VTABLES
#   define HK_LINKONCE_VTABLES 1
#endif

#ifndef HK_HASHCODE_VTABLE_REGISTRY
#   define HK_HASHCODE_VTABLE_REGISTRY 0
#endif

#ifndef HK_NATIVE_ALIGNMENT
#   define HK_NATIVE_ALIGNMENT 16
#endif

#ifndef HK_EXPORT_COMMON
#   define HK_EXPORT_COMMON
#   define HK_EXPORT_COMMON_TEMPLATE_SPECIALIZATION
#   ifndef HK_DYNAMIC_DLL // then not in a DLL build at all. Define all products to none so that no impact in code to existing setups
#       define HK_EXPORT_AI
#       define HK_EXPORT_ANIMATION
#       define HK_EXPORT_BEHAVIOR
#       define HK_EXPORT_CLOTH
#       define HK_EXPORT_DESTRUCTION
#       define HK_EXPORT_DESTRUCTION_2012
#       define HK_EXPORT_EDITOR
#       define HK_EXPORT_ENGINE
#       define HK_EXPORT_ENGINE_UX
#       define HK_EXPORT_FX
#       define HK_EXPORT_PHYSICS
#       define HK_EXPORT_PHYSICS_2012
#   endif
#endif

#if defined(HK_PLATFORM_WIN32) || defined(HK_PLATFORM_MAC) || defined(HK_PLATFORM_LINUX) || defined(HK_PLATFORM_PSVITA) || defined(HK_PLATFORM_IOS) || defined(HK_PLATFORM_ANDROID) || defined(HK_PLATFORM_WIIU) || defined(HK_PLATFORM_PS4) || defined(HK_PLATFORM_TIZEN) || defined(HK_PLATFORM_NX)
#   define HK_PLATFORM_MULTI_THREAD
#endif

#ifndef HK_NEVER_INLINE
#   if (defined(HK_COMPILER_GCC) && !defined(HK_COMPILER_ARMCC)) || defined(HK_COMPILER_CLANG)
#       define HK_NEVER_INLINE __attribute__((noinline))
#   elif defined(HK_COMPILER_CLANG)
#       define HK_NEVER_INLINE __attribute__((noinline))
#   else
#       define HK_NEVER_INLINE
#   endif
#endif

#ifndef HK_RESTRICT
#   define HK_RESTRICT
#endif

#ifndef HK_VERY_UNLIKELY
#   define HK_VERY_UNLIKELY(EXPR) EXPR
#   define HK_VERY_LIKELY(EXPR) EXPR
#endif

// The HK_NO_DEFAULT_CASE(id, message) macro is used to specify that a switch
// statement is always expected to match one of its cases, and that failing to
// match one of the cases should be treated as a fatal error, rather than
// exiting the statement without executing a case. This can improve performance,
// and will prevent uninitialized variable warnings for variables which are
// initialized in each switch case. It should be placed at the beginning of the
// switch block, before any cases, and have a semicolon after it.
#define HK_NO_DEFAULT_CASE(id, ...) default: HK_UNREACHABLE(id, __VA_ARGS__) // fall through to the first case to avoid uninitialized var warnings

//
// HK_STD_NAMESPACE definition
//
namespace std {}

#ifndef HK_STD_NAMESPACE    // nothing
#   ifdef __HAVOK_PARSER__
#       define HK_STD_NAMESPACE std
    // Where CRT use is not allowed HK_STD_NAMESPACE remains undefined and will cause a compile error
#   elif !defined(HK_CRT_NOT_ALLOWED)   // where CRT use is not allowed HK_STD_NAMESPACE remains undefined and will cause a compile error
#       define HK_STD_NAMESPACE
#   endif
#endif

#ifndef HK_UNREACHABLE
#   define HK_UNREACHABLE(ID, ...) HK_ASSERT(ID, false, __VA_ARGS__); do {} while(1)
#endif

#ifndef HK_UNREACHABLE_NO_MSG
#   define HK_UNREACHABLE_NO_MSG() HK_UNREACHABLE(0x28f9c119, "Unreachable code path executed")
#endif

//
// types
//

/// hkFloat is provided if floats are explicitly required.
typedef float  hkFloat32;
/// hkDouble is provided if doubles are explicit required.
typedef double hkDouble64;

/// Signed 8 bit integer
typedef signed char     hkChar;
/// Signed 8 bit integer
typedef signed char     hkInt8;
/// Signed 16 bit integer
typedef signed short    hkInt16;
/// Signed 32 bit integer
typedef signed int      hkInt32;

/// Unsigned 8 bit integer
typedef unsigned char   hkUchar;
/// Unsigned 8 bit integer
typedef unsigned char   hkUint8;
/// Unsigned 16 bit integer
typedef unsigned short  hkUint16;
/// Unsigned 32 bit integer
typedef unsigned int    hkUint32;

#if HK_POINTER_SIZE == 8
#   if defined(HK_COMPILER_MSVC)
        typedef unsigned __int64 hkUlong;  // MS- specific
        typedef signed __int64 hkLong;  // MS- specific
#   else
        typedef unsigned long long hkUlong;
        typedef signed long long hkLong;
#   endif
#elif defined(HK_COMPILER_MSVC) && (_MSC_VER >= 1300)
    typedef unsigned long __w64 hkUlong; // VC7.0 or higher, 64bit warnings
    typedef signed long __w64 hkLong;
#else
    typedef unsigned long hkUlong;
    typedef signed long hkLong;
#endif

#if !(defined(__HAVOK_PARSER__) || defined(NN_COMPILER_RVCT) || (defined(HK_PLATFORM_ANDROID) && defined(HK_COMPILER_CLANG)))
#   define HK_STANDARD_HEADER_USE_C_PREFIX
#endif

#define HK_MIN2( A,B ) (((A)<(B))?(A):(B))
#define HK_MAX2( A,B ) (((A)>(B))?(A):(B))

#define HK_ALIGN8(DECL) HK_ALIGN(DECL,8)
#define HK_ALIGN16(DECL) HK_ALIGN(DECL,16)
#define HK_ALIGN32(DECL) HK_ALIGN(DECL,32)
#define HK_ALIGN64(DECL) HK_ALIGN(DECL,64)
#define HK_ALIGN128(DECL) HK_ALIGN(DECL,128)
#define HK_CLASSALIGN8(DECL) HK_CLASSALIGN(DECL,8)
#define HK_CLASSALIGN16(DECL) HK_CLASSALIGN(DECL,16)

#define HK_ALIGN_FLOAT(DECL) HK_ALIGN16(DECL)
#define HK_ALIGN_DOUBLE(DECL) HK_ALIGN32(DECL)
#define HK_FLOAT_ALIGNMENT 16
#define HK_DOUBLE_ALIGNMENT 32
#define HK_FLOAT_SIZE 4
#define HK_DOUBLE_SIZE 8

#if defined(__HAVOK_PARSER__)
    // Reflection needs to know that something is specifically "align real", not just "16"
    #define HK_DETAIL_ALIGN_REAL HK_ATTR(hk::AlignReal)
#else
    #define HK_DETAIL_ALIGN_REAL
#endif

#if defined(HK_REAL_IS_DOUBLE)
    typedef hkDouble64 hkReal;
    #define HK_ALIGN_REAL(DECL) HK_ALIGN_DOUBLE(DECL) HK_DETAIL_ALIGN_REAL
    #define HK_REAL_ALIGNMENT HK_DOUBLE_ALIGNMENT
    #define HK_REAL_SIZE HK_DOUBLE_SIZE
    typedef unsigned long long hkUintReal;
#else
    typedef hkFloat32 hkReal;
    #define HK_ALIGN_REAL(DECL) HK_ALIGN_FLOAT(DECL) HK_DETAIL_ALIGN_REAL
    #define HK_REAL_ALIGNMENT HK_FLOAT_ALIGNMENT
    #define HK_REAL_SIZE HK_FLOAT_SIZE
    typedef unsigned int hkUintReal;
#endif

#if !defined(__HAVOK_PARSER__) && (defined(HK_COMPILER_GCC) || defined(HK_COMPILER_SNC))
    #define HK_POSSIBLY_UNUSED __attribute__((unused))
#else
    #define HK_POSSIBLY_UNUSED
#endif

#if (defined(HK_UWP) || defined(HK_SUPPORT_DWM)) && (_APISET_TARGET_VERSION >= _APISET_TARGET_VERSION_WIN10_TH2)
    #define HK_SUPPORTS_WINDOWS_HOLOGRAPHIC
#endif

#if HK_POINTER_SIZE == 8
#   define HK_DETAIL_PACKING_SIZE 16
#else
#   define HK_DETAIL_PACKING_SIZE 8
#endif

#ifdef HK_COMPILER_MSVC
#   define HK_DETAIL_PRAGMA_MSVC(Pragma)            __pragma(Pragma)
#   define HK_DETAIL_DIAG_MSVC_PUSH()               HK_DETAIL_PRAGMA_MSVC( warning(push) )
#   define HK_DETAIL_DIAG_MSVC_POP()                HK_DETAIL_PRAGMA_MSVC( warning(pop) )
#   define HK_DETAIL_DIAG_MSVC_OFF(WARNINGS)        HK_DETAIL_PRAGMA_MSVC( warning(disable: WARNINGS) )
#   define HK_DETAIL_DIAG_MSVC_ON(WARNINGS)         HK_DETAIL_PRAGMA_MSVC( warning(default: WARNINGS) )
#   define HK_DETAIL_DIAG_MSVC_SUPPRESS(WARNINGS)   HK_DETAIL_PRAGMA_MSVC( warning(suppress: WARNINGS) )
#   define HK_DETAIL_SET_PACKING                    HK_DETAIL_PRAGMA_MSVC( pack(push, HK_DETAIL_PACKING_SIZE) )
#   define HK_DETAIL_RESTORE_PACKING                HK_DETAIL_PRAGMA_MSVC( pack(pop) )
#   define HK_DETAIL_OPTIMIZATIONS_OFF()            HK_DETAIL_PRAGMA_MSVC( optimize("", off) )
#   define HK_DETAIL_OPTIMIZATIONS_ON()             HK_DETAIL_PRAGMA_MSVC( optimize("", on) )
#else
#   define HK_DETAIL_PRAGMA_MSVC(x)
#   define HK_DETAIL_DIAG_MSVC_PUSH()
#   define HK_DETAIL_DIAG_MSVC_POP()
#   define HK_DETAIL_DIAG_MSVC_OFF(x)
#   define HK_DETAIL_DIAG_MSVC_SUPPRESS(x)
#endif

#if defined(HK_DYNAMIC_DLL)
#   define HK_DETAIL_DIAG_MSVC_DLL_OFF(WARNINGS)    HK_DETAIL_DIAG_MSVC_OFF(WARNINGS)
#else
#   define HK_DETAIL_DIAG_MSVC_DLL_OFF(WARNINGS)
#endif

#if defined(HK_DEBUG)
#   define HK_DETAIL_DIAG_MSVC_DEBUG_OFF(WARNINGS)  HK_DETAIL_DIAG_MSVC_OFF(WARNINGS)
#else
#   define HK_DETAIL_DIAG_MSVC_DEBUG_OFF(WARNING)
#endif

//
// The following are some version specific ways of disabling warnings. And for reference:
//
//   MSVC++ 14.0 _MSC_VER == 1900 (Visual Studio 2015)
//   MSVC++ 12.0 _MSC_VER == 1800 (Visual Studio 2013)
//   MSVC++ 11.0 _MSC_VER == 1700 (Visual Studio 2012)
//   MSVC++ 10.0 _MSC_VER == 1600 (Visual Studio 2010)
//   MSVC++ 9.0  _MSC_VER == 1500 (Visual Studio 2008)
//   MSVC++ 8.0  _MSC_VER == 1400 (Visual Studio 2005)
//   MSVC++ 7.1  _MSC_VER == 1310 (Visual Studio 2003)
//   MSVC++ 7.0  _MSC_VER == 1300
//   MSVC++ 6.0  _MSC_VER == 1200
//   MSVC++ 5.0  _MSC_VER == 1100
//

#if defined(HK_COMPILER_MSVC) && _MSC_VER >= 1400
#   define HK_DETAIL_DIAG_MSVC_1400_OFF(WARNINGS)   HK_DETAIL_DIAG_MSVC_OFF(WARNINGS)
#else
#   define HK_DETAIL_DIAG_MSVC_1400_OFF(WARNINGS)
#endif

#if defined(HK_COMPILER_MSVC) && _MSC_VER >= 1700
#   define HK_DETAIL_DIAG_MSVC_1700_OFF(WARNINGS)   HK_DETAIL_DIAG_MSVC_OFF(WARNINGS)
#else
#   define HK_DETAIL_DIAG_MSVC_1700_OFF(WARNINGS)
#endif

#if defined(HK_COMPILER_GCC) && (((__GNUC__ * 100) + __GNUC_MINOR__) >= 402)
#   define HK_DETAIL_DIAG_GCC_STR(s)                #s
#   define HK_DETAIL_DIAG_GCC_JOINSTR(x,y)          HK_DETAIL_DIAG_GCC_STR(x ## y)
#   define HK_DETAIL_DIAG_GCC_DO_PRAGMA(x)          _Pragma (#x)
#   define HK_DETAIL_DIAG_GCC_PRAGMA(x)             HK_DETAIL_DIAG_GCC_DO_PRAGMA(GCC diagnostic x)
#   if ((__GNUC__ * 100) + __GNUC_MINOR__) >= 406
#       define HK_DETAIL_DIAG_GCC_PUSH()            HK_DETAIL_DIAG_GCC_PRAGMA(push)
#       define HK_DETAIL_DIAG_GCC_POP()             HK_DETAIL_DIAG_GCC_PRAGMA(pop)
#   else
#       define HK_DETAIL_DIAG_GCC_PUSH()
#       define HK_DETAIL_DIAG_GCC_POP()
#   endif
#   define HK_DETAIL_DIAG_GCC_OFF(x)                HK_DETAIL_DIAG_GCC_PRAGMA(ignored HK_DETAIL_DIAG_GCC_JOINSTR(-W,x))
#   define HK_DETAIL_DIAG_GCC_ON(x)                 HK_DETAIL_DIAG_GCC_PRAGMA(warning HK_DETAIL_DIAG_GCC_JOINSTR(-W,x))
#   define HK_DETAIL_SET_PACKING                    HK_DETAIL_DIAG_GCC_PRAGMA(pack(HK_DETAIL_DIAG_GCC_JOINSTR(push, HK_DETAIL_PACKING_SIZE)))
#   define HK_DETAIL_RESTORE_PACKING                HK_DETAIL_DIAG_GCC_PRAGMA(pack(pop))
#else
#   define HK_DETAIL_DIAG_GCC_PUSH()
#   define HK_DETAIL_DIAG_GCC_POP()
#   define HK_DETAIL_DIAG_GCC_OFF(x)
#   define HK_DETAIL_DIAG_GCC_ON(x)
#endif // GCC

#if defined(HK_COMPILER_CLANG)
#   define HK_DETAIL_DIAG_CLANG_STR(s)              #s
#   define HK_DETAIL_DIAG_CLANG_JOINSTR(x,y)        HK_DETAIL_DIAG_CLANG_STR(x ## y)
#   define HK_DETAIL_DIAG_CLANG_DO_PRAGMA(x)        _Pragma (#x)
#   define HK_DETAIL_DIAG_CLANG_PRAGMA(x)           HK_DETAIL_DIAG_CLANG_DO_PRAGMA(clang diagnostic x)
#   define HK_DETAIL_DIAG_CLANG_PUSH()              HK_DETAIL_DIAG_CLANG_PRAGMA(push)
#   define HK_DETAIL_DIAG_CLANG_POP()               HK_DETAIL_DIAG_CLANG_PRAGMA(pop)
#   define HK_DETAIL_DIAG_CLANG_OFF(x)              HK_DETAIL_DIAG_CLANG_PRAGMA(ignored HK_DETAIL_DIAG_CLANG_JOINSTR(-W,x))
#   define HK_DETAIL_DIAG_CLANG_ON(x)               HK_DETAIL_DIAG_CLANG_PRAGMA(warning HK_DETAIL_DIAG_CLANG_JOINSTR(-W,x))
#   define HK_DETAIL_SET_PACKING                    HK_DETAIL_DIAG_CLANG_DO_PRAGMA(pack(push,HK_DETAIL_PACKING_SIZE))
#   define HK_DETAIL_RESTORE_PACKING                HK_DETAIL_DIAG_CLANG_DO_PRAGMA(pack(pop))
#else
#   define HK_DETAIL_DIAG_CLANG_PUSH()
#   define HK_DETAIL_DIAG_CLANG_POP()
#   define HK_DETAIL_DIAG_CLANG_OFF(x)
#   define HK_DETAIL_DIAG_CLANG_ON(x)
#endif // defined(HK_COMPILER_CLANG)

#ifndef HK_DETAIL_SET_PACKING
#   define HK_DETAIL_SET_PACKING
#endif

#ifndef HK_DETAIL_RESTORE_PACKING
#   define HK_DETAIL_RESTORE_PACKING
#endif

#if !defined(HK_DETAIL_OPTIMIZATIONS_OFF)
#   define HK_DETAIL_OPTIMIZATIONS_OFF()
#   define HK_DETAIL_OPTIMIZATIONS_ON()
#endif

#define HK_DETAIL_DIAG_PUSH() \
    HK_DETAIL_DIAG_MSVC_PUSH() \
    HK_DETAIL_DIAG_GCC_PUSH() \
    HK_DETAIL_DIAG_CLANG_PUSH()

#define HK_DETAIL_DIAG_POP() \
    HK_DETAIL_DIAG_MSVC_POP() \
    HK_DETAIL_DIAG_GCC_POP() \
    HK_DETAIL_DIAG_CLANG_POP()

#if defined HK_COMPILER_MSVC
    // C4100 'identifier' : unreferenced formal parameter
    //      a function need not use all its arguments
    // C4127 conditional expression is constant
    //      constant conditionals are often used inside asserts
    // C4344: behavior change: use of explicit template arguments results in call to different function
    // C4351 new behavior: elements of array ... will be default initialized
    //      changing from non standard to standard behavior
    // C4505 'function' : unreferenced local function has been removed
    //      lots of inline functions are not used in a compilation unit
    // C4510 'class' : default constructor could not be generated
    // C4511 'class' : copy constructor could not be generated
    // C4512 'class' : assignment operator could not be generated
    //      many classes are not designed with value semantics
    // C4514 unreferenced inline/local function has been removed
    //      lots of inline functions are not used in a compilation unit
    // C4714 force inlined function not inlined. This warning is only disabled in debug modes.
    // C4481: nonstandard extension used: override specifier 'override'
    //      disable warning if we're using HK_OVERRIDE
    // C4344: behavior change: use of explicit template arguments results in call to different function
    // C4786: Debug truncated to 255
    // C4530: C++ Exception handler used but not enabled:(used in <xstring>)
#   define HK_DETAIL_DIAG_DISABLE_WARNINGS \
        /* Reinterpret_cast used between related classes */ \
        HK_DETAIL_DIAG_MSVC_ON(4370) \
        /* Warn about struct packing differences */ \
        HK_DETAIL_DIAG_MSVC_OFF(4100 4127 4324 4344 4351 4505 4510 4511 4512 4514 4800 4946) \
        /* Templated types not exported */ \
        HK_DETAIL_DIAG_MSVC_DLL_OFF(4251) \
        /* extern used before templated type */ \
        HK_DETAIL_DIAG_MSVC_DLL_OFF(4231) \
        /* template specialization */ \
        HK_DETAIL_DIAG_MSVC_DLL_OFF(4661) \
        HK_DETAIL_DIAG_MSVC_DEBUG_OFF(4714) \
        HK_DETAIL_DIAG_MSVC_1400_OFF(4481) \
        /* hkMath: constant compared against constant: happens all the time with our templated opts */ \
        HK_DETAIL_DIAG_MSVC_1700_OFF(6326) \
        /* Debug truncated to 255 */ \
        HK_DETAIL_DIAG_MSVC_OFF(4786) \
        /* C++ Exception handler used but not enabled:(used in <xstring>) */ \
        HK_DETAIL_DIAG_MSVC_OFF(4530) \

#   ifndef _CRT_SECURE_NO_DEPRECATE
#       define _CRT_SECURE_NO_DEPRECATE     1
#   endif
#   ifndef _CRT_NONSTDC_NO_DEPRECATE
#       define _CRT_NONSTDC_NO_DEPRECATE    1
#   endif

#elif defined(HK_COMPILER_CLANG)
#   ifndef __HAVOK_PARSER__
#       define HK_DETAIL_DIAG_CLANG_OFF_PARSER(W) HK_DETAIL_DIAG_CLANG_OFF(W)
#   else
#       define HK_DETAIL_DIAG_CLANG_OFF_PARSER(W)
#   endif

#   define HK_DETAIL_DIAG_DISABLE_WARNINGS \
        /* "invalid-offsetof" expands to "invalid-__builtin_offsetof" */ \
        HK_DETAIL_DIAG_CLANG_PRAGMA(ignored HK_DETAIL_DIAG_CLANG_JOINSTR(-Winvalid-offset,of)) \
        HK_DETAIL_DIAG_CLANG_OFF(unused-function) \
        HK_DETAIL_DIAG_CLANG_OFF(unused-variable) \
        HK_DETAIL_DIAG_CLANG_OFF(unused-value)
#endif

// This is defined per compiler so if a compiler didn't specify any warnings
// to disable then lets define it as empty
#ifndef HK_DETAIL_DIAG_DISABLE_WARNINGS
#   define HK_DETAIL_DIAG_DISABLE_WARNINGS
#endif

// Used by hkBase.h, hkIncludeStart.h, and hkIncludeEnd.h to determine whether
// or not warnings have been disabled and whether or not they've been pushed
// and need to be popped back later
#ifndef HK_DIAG_DISABLE_WARNING_OVERRIDE
#   define HK_DIAG_DISABLE_WARNING_OVERRIDE 0
#endif

// Push the state and
#define HK_DETAIL_DIAG_DISABLE_WARNINGS_PUSH \
    HK_DETAIL_DIAG_PUSH() \
    HK_DETAIL_DIAG_DISABLE_WARNINGS

#define HK_DETAIL_DIAG_DISABLE_WARNINGS_POP \
    HK_DETAIL_DIAG_POP()

// This is a helper macro to disable the warnings not handled by the Havok code base
// and sets the packing correctly as well. Used by hkIncludeStart.h
#define HK_DETAIL_INCLUDE_START \
    HK_DETAIL_DIAG_DISABLE_WARNINGS_PUSH \
    HK_DETAIL_SET_PACKING

// Use this macro at the end of the includes so that the state of the compiler is
// restored. Used by hkIncludeEnd.h
#define HK_DETAIL_INCLUDE_END \
    HK_DETAIL_DIAG_DISABLE_WARNINGS_POP \
    HK_DETAIL_RESTORE_PACKING

//
// Switch fallthrough
//
#ifdef _MSC_VER
#   define HK_FALLTHROUGH __fallthrough
#else
#   define HK_FALLTHROUGH
#endif

//
// Constexpr
//

#if (__cplusplus >= 201103L) || (defined(_MSC_VER) && (_MSC_VER >= 1900))
    #define HK_CONSTEXPR constexpr
#else
    #define HK_CONSTEXPR
#endif

#if !defined(HK_COMPILER_RAZZLE) || defined(HK_DEBUG)

// This define is used to keep any developer debug/profiling functionality
// out from release builds
// This functionality includes
// - Timers
// - Memory profilers
// - Visual Debugger, VDB Component and VirtualFramebufferServer
// - File System Server

#define HK_ENABLE_INTERNAL_DEVELOPER_TOOLS

#endif

#endif // HKBASE_HKBASEDEFS_H

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
