// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#ifndef HK_UUID_MAP_OPERATIONS_CXX
#define HK_UUID_MAP_OPERATIONS_CXX

#include <Common/Base/Types/Uuid/hkUuid.h>

// Specialized version of hkMapOperations<> for using hkUuid in a map.
template <>
struct hkMapOperations<hkUuid>
{
    inline static unsigned hash( const hkUuid& key, unsigned mod )
    {
        // We take just a part of the Uuid, collisions will be more likely to happen but
        // will work well as a hash.
        return key.getData<0>() & mod;
    }
    inline static void invalidate( hkUuid& key )
    {
        key = hkUuid::getNil();
    }
    inline static hkBool32 isValid( const hkUuid& key ) { return key != hkUuid::getNil(); }
    inline static hkBool32 equal(const hkUuid& key0, const hkUuid& key1) { return key0 == key1; }
};

#endif // HK_UUID_MAP_OPERATIONS_CXX

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
