// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0


inline hkBool32 hkUuid::operator==(const hkUuid& rhs) const
{
    hkIntVector lv;                 lv.load<4, HK_IO_NATIVE_ALIGNED>(m_data);
    hkIntVector rv;                 rv.load<4, HK_IO_NATIVE_ALIGNED>(rhs.m_data);
    const hkVector4Comparison cmp   = lv.equalS32(rv);

    return cmp.allAreSet();
}

inline hkBool32 hkUuid::operator!=(const hkUuid& rhs) const
{
    hkIntVector lv;             lv.load<4, HK_IO_NATIVE_ALIGNED>(m_data);
    hkIntVector rv;             rv.load<4, HK_IO_NATIVE_ALIGNED>(rhs.m_data);
    hkVector4Comparison cmp;    cmp.setNot(lv.equalS32(rv));

    return cmp.anyIsSet();
}

//
//  Comparison operator (binary less than)

inline hkBool32 hkUuid::operator<(const hkUuid& rhs) const
{
    hkIntVector lv;             lv.load<4, HK_IO_NATIVE_ALIGNED>(m_data);
    hkIntVector rv;             rv.load<4, HK_IO_NATIVE_ALIGNED>(rhs.m_data);
    const hkVector4Comparison l = lv.compareLessThanS32(rv);    // [aw < bw, az < bz, ay < by, ax < bx]
    const hkVector4Comparison e = lv.equalS32(rv);              // [aw == bw, az == bz, ay == by, ax == bx]

    const int maskL = l.getMask();
    const int maskE = e.getMask();

    // Compare l.yzw < r.yzw
    const int codeYZW   = ((maskL << 1) & 0x1C) | ((maskE >> 1) & 3);
    const int lessYZW   = (0xFAF8FAF0 >> codeYZW) & 1;

    // Finish comparison
    const int lessX     = (maskL & 1);
    const int equalX    = (maskE & 1);
    const int lessXYZW  = lessX | (equalX & lessYZW);
    return lessXYZW;
}

//
//  Gets the data

template <int I> HK_INLINE hkUint32 hkUuid::getData() const {   return m_data[I];   }
HK_INLINE hkUint32 hkUuid::getData(int I) const             {   return m_data[I];   }

//
//  Sets the data

template <int I> HK_INLINE void hkUuid::setData(hkUint32 v) {   m_data[I] = v;      }
HK_INLINE void hkUuid::setData(int I, hkUint32 v)               {   m_data[I] = v;      }

/// Returns true if this UUID is the nil UUID.
bool hkUuid::isNil() const
{
    return m_data[0] == 0
        && m_data[1] == 0
        && m_data[2] == 0
        && m_data[3] == 0;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
