// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Common/Base/Reflect/Attributes/hkToolAttributes.h>

namespace hkTrait
{

// Arithmetic operations

template<typename T>
struct Plus
{
    HK_DECLARE_CLASS(Plus, Reflect, New);
    HK_RECORD_ATTR(hk::Ui_TypeName("Plus"));

    typedef T FirstArgType;
    typedef T SecondArgType;
    typedef T ResultType;

    T operator()(const T& lhs, const T& rhs) const { return lhs + rhs; }
};

template<typename T>
struct Minus
{
    HK_DECLARE_CLASS(Minus, Reflect, New);
    HK_RECORD_ATTR(hk::Ui_TypeName("Minus"));

    typedef T FirstArgType;
    typedef T SecondArgType;
    typedef T ResultType;

    T operator()(const T& lhs, const T& rhs) const { return lhs - rhs; }
};

template<typename T>
struct Min
{
    HK_DECLARE_CLASS(Min, Reflect, New);
    HK_RECORD_ATTR(hk::Ui_TypeName("Min"));

    typedef T FirstArgType;
    typedef T SecondArgType;
    typedef T ResultType;

    T operator()(const T& lhs, const T& rhs) const { return hkMath::min2<T>(lhs, rhs); }
};

template<typename T>
struct Max
{
    HK_DECLARE_CLASS(Max, Reflect, New);
    HK_RECORD_ATTR(hk::Ui_TypeName("Max"));

    typedef T FirstArgType;
    typedef T SecondArgType;
    typedef T ResultType;

    T operator()(const T& lhs, const T& rhs) const { return hkMath::max2<T>(lhs, rhs); }
};

template<typename T>
struct Multiplies
{
    HK_DECLARE_CLASS(Multiplies, Reflect, New);
    HK_RECORD_ATTR(hk::Ui_TypeName("Multiplies"));

    typedef T FirstArgType;
    typedef T SecondArgType;
    typedef T ResultType;

    T operator()(const T& lhs, const T& rhs) const { return lhs * rhs; }
};

template<typename T>
struct Divides
{
    HK_DECLARE_CLASS(Divides<T>, Reflect, New);
    HK_RECORD_ATTR(hk::Ui_TypeName("Divides"));

    typedef T FirstArgType;
    typedef T SecondArgType;
    typedef T ResultType;

    T operator()(const T& lhs, const T& rhs) const
    {
        if ( rhs != T(0) )
        {
            return lhs / rhs;
        }
        return T(0);
    }
};

template<>
struct HK_EXPORT_COMMON Divides<hkVector4>
{
    HK_DECLARE_CLASS(Divides, Reflect, New);
    HK_RECORD_ATTR(hk::Ui_TypeName("Divides"));

    typedef hkVector4 FirstArgType;
    typedef hkVector4 SecondArgType;
    typedef hkVector4 ResultType;

    hkVector4 operator()(const hkVector4& lhs, const hkVector4& rhs) const
    {
        hkVector4 res; res.setDiv<HK_ACC_FULL, HK_DIV_SET_ZERO>(lhs, rhs);
        return res;
    }
};

template<typename T>
struct Modulus
{
    HK_DECLARE_CLASS(Modulus, Reflect, New);
    HK_RECORD_ATTR(hk::Ui_TypeName("Modulus"));

    typedef T FirstArgType;
    typedef T SecondArgType;
    typedef T ResultType;

    T operator()(const T& lhs, const T& rhs) const { return ( rhs != 0 ) ? lhs % rhs : 0; }
};

template<typename T>
struct Negate
{
    HK_DECLARE_CLASS(Negate, Reflect, New);
    HK_RECORD_ATTR(hk::Ui_TypeName("Negate"));

    typedef T ArgType;
    typedef T ResultType;

    T operator()(const T& arg) const { return -arg; }
};

// Comparisons

template<typename T>
struct EqualTo
{
    HK_DECLARE_CLASS(EqualTo, Reflect, New);
    HK_RECORD_ATTR(hk::Ui_TypeName("EqualTo"));

    typedef T FirstArgType;
    typedef T SecondArgType;
    typedef bool ResultType;

    bool operator()(const T& lhs, const T& rhs) const { return lhs == rhs; }
};

template<typename T>
struct NotEqualTo
{
    HK_DECLARE_CLASS(NotEqualTo, Reflect, New);
    HK_RECORD_ATTR(hk::Ui_TypeName("NotEqualTo"));

    typedef T FirstArgType;
    typedef T SecondArgType;
    typedef bool ResultType;

    bool operator()(const T& lhs, const T& rhs) const { return lhs != rhs; }
};

template<typename T>
struct Greater
{
    HK_DECLARE_CLASS(Greater, Reflect, New);
    HK_RECORD_ATTR(hk::Ui_TypeName("Greater"));

    typedef T FirstArgType;
    typedef T SecondArgType;
    typedef bool ResultType;

    bool operator()(const T& lhs, const T& rhs) const { return lhs > rhs; }
};

template<typename T>
struct Less
{
    HK_DECLARE_CLASS(Less, Reflect, New);
    HK_RECORD_ATTR(hk::Ui_TypeName("Less"));

    typedef T FirstArgType;
    typedef T SecondArgType;
    typedef bool ResultType;

    bool operator()(const T& lhs, const T& rhs) const { return lhs < rhs; }
};

template<typename T>
struct GreaterEqual
{
    HK_DECLARE_CLASS(GreaterEqual, Reflect, New);
    HK_RECORD_ATTR(hk::Ui_TypeName("GreaterEqual"));

    typedef T FirstArgType;
    typedef T SecondArgType;
    typedef bool ResultType;

    bool operator()(const T& lhs, const T& rhs) const { return lhs >= rhs; }
};

template<typename T>
struct LessEqual
{
    HK_DECLARE_CLASS(LessEqual, Reflect, New);
    HK_RECORD_ATTR(hk::Ui_TypeName("LessEqual"));

    typedef T FirstArgType;
    typedef T SecondArgType;
    typedef bool ResultType;

    bool operator()(const T& lhs, const T& rhs) const { return lhs <= rhs; }
};

// Logical operations

template<typename T>
struct LogicalAnd
{
    HK_DECLARE_CLASS(LogicalAnd, Reflect, New);
    HK_RECORD_ATTR(hk::Ui_TypeName("LogicalAnd"));

    typedef T FirstArgType;
    typedef T SecondArgType;
    typedef bool ResultType;

    bool operator()(const T& lhs, const T& rhs) const { return lhs && rhs; }
};

template<typename T>
struct LogicalOr
{
    HK_DECLARE_CLASS(LogicalOr, Reflect, New);
    HK_RECORD_ATTR(hk::Ui_TypeName("LogicalOr"));

    typedef T FirstArgType;
    typedef T SecondArgType;
    typedef bool ResultType;

    bool operator()(const T& lhs, const T& rhs) const { return lhs || rhs; }
};

template<typename T>
struct LogicalNot
{
    HK_DECLARE_CLASS(LogicalNot, Reflect, New);
    HK_RECORD_ATTR(hk::Ui_TypeName("LogicalNot"));

    typedef T ArgType;
    typedef bool ResultType;

    bool operator()(const T& arg) const { return !arg; }
};

// Bitwise operations

template<typename T>
struct BitAnd
{
    HK_DECLARE_CLASS(BitAnd, Reflect, New);
    HK_RECORD_ATTR(hk::Ui_TypeName("BitAnd"));

    typedef T FirstArgType;
    typedef T SecondArgType;
    typedef T ResultType;

    T operator()(const T& lhs, const T& rhs) const { return lhs & rhs; }
};

template<typename T>
struct BitOr
{
    HK_DECLARE_CLASS(BitOr, Reflect, New);
    HK_RECORD_ATTR(hk::Ui_TypeName("BitOr"));

    typedef T FirstArgType;
    typedef T SecondArgType;
    typedef T ResultType;

    T operator()(const T& lhs, const T& rhs) const { return lhs | rhs; }
};

template<typename T>
struct BitXor
{
    HK_DECLARE_CLASS(BitXor, Reflect, New);
    HK_RECORD_ATTR(hk::Ui_TypeName("BitXor"));

    typedef T FirstArgType;
    typedef T SecondArgType;
    typedef T ResultType;

    T operator()(const T& lhs, const T& rhs) const { return lhs ^ rhs; }
};

template<typename T>
struct BitNot
{
    HK_DECLARE_CLASS(BitNot, Reflect, New);
    HK_RECORD_ATTR(hk::Ui_TypeName("BitNot"));

    typedef T ArgType;
    typedef T ResultType;

    T operator()(const T& arg) const { return ~arg; }
};

}

#include <Common/Base/_Auto/TemplateTypes/hkTraitOperators_Types.inl>

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
