// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

namespace hkTrait
{
    typedef TraitBool<true> TypeIsConst;
    typedef TraitBool<false> TypeIsNonConst;

    // Type with one level of const removed: hkRemoveConst<int>::type is int, so is hkRemoveConst<const int>::type
    template <typename T>
    struct RemoveConst{ typedef T type; };

    template <typename T>
    struct RemoveConst<const T>{ typedef T type; };

    template <typename T>
    struct RemoveRef { typedef T Type; };

    template <typename T>
    struct RemoveRef<T&>{ typedef T Type; };

#ifdef HK_MOVE_SEMANTICS
    template <typename T>
    struct RemoveRef<T&&> { typedef T Type; };
#endif

    template <typename T>
    struct ArrayToPointer { typedef T Type; };

    template <typename T, int N>
    struct ArrayToPointer<T (&)[N]> { typedef T* Type; };

    template <typename T, int N>
    struct ArrayToPointer<T[N]> { typedef T* Type; };

    template <typename T>
    struct RemoveConstRef { typedef typename RemoveConst< typename RemoveRef<T>::Type >::type Type; };

    template <typename T>
    struct RemoveConstPtr { typedef T Type; };

    template <typename T>
    struct RemoveConstPtr<const T*> { typedef T* Type; };

    // Adds a const to the type if it isn't already const (const int => const int ; int => const int).
    template <typename T>
    struct AddConst { typedef const T type; };

    template <typename T>
    struct AddConst<const T> { typedef const T type; };

    // Checking for "const"
    template <typename T>
    struct IsConstType : public FalseType {};
    template <typename T>
    struct IsConstType<const T> : public TrueType {};


    // Adds const if the boolean parameter is true
    template <bool Add, typename Output>
    struct ConstIfTrue { typedef typename AddConst<Output>::type type; };

    template <typename Output>
    struct ConstIfTrue<false, Output> { typedef Output type; };

    // Adds const to the second parameter if the first one is const
    template <typename Input, typename Output>
    struct ConstIfConst { typedef typename ConstIfTrue<IsConstType<Input>::result, Output>::type type; };

    // Erases type while preserving constness
    template <typename T>
    struct ToVoid { typedef typename ConstIfConst<T, void>::type type; };


    template <typename T>
    struct RemovePointer { typedef T type; };

    template <typename T>
    struct RemovePointer<T*> { typedef T type; };
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
