// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

// This can be used to define a type as a pod type.
#define HK_DEFINE_AS_POD_TYPE(T) \
    namespace hkTrait{ template<> struct IsPodType< T > : public TypeIsPod {}; }

namespace hkTrait
{
    typedef TraitBool<true> TypeIsPod;
    typedef TraitBool<false> TypeIsClass;

    template <typename T>
    hkTrait::No operator==(const T&, const TypeIsPod&);

    // Default hkIsPodType<T>::type() == hkBoolean<false>.
    template <typename T>
    struct IsPodType : public TraitBool< ( sizeof(*reinterpret_cast<T*>(128) == *reinterpret_cast<const TypeIsPod*>(128)) == sizeof(hkTrait::Yes) ) > {};

    // Pointers are pod types
    template <typename T> struct IsPodType<T*> : public TypeIsPod {};
    // Arrays
    template <typename T, unsigned int N> struct IsPodType<T[N]> : public IsPodType< T > {};
    // Const types
    template <typename T> struct IsPodType<const T> : public IsPodType< T > {};

    template <typename T0, typename T1 = int, typename T2 = int, typename T3 = int, typename T4 = int,
              typename T5 = int, typename T6 = int, typename T7 = int, typename T8 = int, typename T9 = int>
    struct ArePodTypes
        : public TraitBool< IsPodType<T0>::result && IsPodType<T1>::result && IsPodType<T2>::result && IsPodType<T3>::result && IsPodType<T4>::result &&
                            IsPodType<T5>::result && IsPodType<T6>::result && IsPodType<T7>::result && IsPodType<T8>::result && IsPodType<T9>::result
                          >
    {};
}
//
// Define Havok pod types.
//
HK_DEFINE_AS_POD_TYPE(bool);
HK_DEFINE_AS_POD_TYPE(char);
HK_DEFINE_AS_POD_TYPE(signed char);
HK_DEFINE_AS_POD_TYPE(unsigned char);
HK_DEFINE_AS_POD_TYPE(short);
HK_DEFINE_AS_POD_TYPE(unsigned short);
HK_DEFINE_AS_POD_TYPE(int);
HK_DEFINE_AS_POD_TYPE(unsigned int);
HK_DEFINE_AS_POD_TYPE(long);
HK_DEFINE_AS_POD_TYPE(unsigned long);
HK_DEFINE_AS_POD_TYPE(long long);
HK_DEFINE_AS_POD_TYPE(unsigned long long);

HK_DEFINE_AS_POD_TYPE(hkFloat32);
HK_DEFINE_AS_POD_TYPE(hkDouble64);


// This declaration is required to treat a class or struct as a pod type. Must have public visibility.
#define HK_DECLARE_POD_TYPE() \
    HK_SINGLE_RECORD_ATTR(hk::Pod); \
    hkTrait::Yes operator== (const hkTrait::TypeIsPod&) const HK_SINGLE_ATTR( hk::Reflect(false) )

#define HK_DECLARE_POD_TYPE_IF_POD(...) \
    hkTrait::Yes operator== (const hkTrait::TraitBool< hkTrait::ArePodTypes< __VA_ARGS__ >::result >&) const HK_SINGLE_ATTR( hk::Reflect(false) )

#define HK_DECLARE_CLASS_Pod(N) \
    HK_DECLARE_POD_TYPE();

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
