// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#if defined(HK_REAL_IS_DOUBLE)
inline void hkSimplePropertyValue::setReal( const hkReal r )
{
    union {
        hkReal r;
        hkUint64 u;
    } u;
    u.r = r;
    m_data = u.u;
}
#else
inline void hkSimplePropertyValue::setReal( const hkReal r )
{
    // Use a union to ensure that the hkReal is
    // always stored in the LSB end of m_data
    // regardless of platform endianness
    union {
        hkReal r;
        hkUint32 u;
    } u;
    u.r = r;
    m_data = u.u;
}
#endif

inline void hkSimplePropertyValue::setInt( const int i )
{
    m_data = i;
}

inline void hkSimplePropertyValue::setUint64(hkUint64 i)
{
    m_data = i;
}

inline void hkSimplePropertyValue::setPtr(_In_ void* p)
{
    m_data = reinterpret_cast<hkUlong>(p);
}

// constructors here for inlining

inline hkSimplePropertyValue::hkSimplePropertyValue( const int i )
{
    setInt(i);
}

inline hkSimplePropertyValue::hkSimplePropertyValue( const hkUint32 i)
{
    setInt((int)i);
}

inline hkSimplePropertyValue::hkSimplePropertyValue( const hkReal r )
{
    setReal(r);
}

inline hkSimplePropertyValue::hkSimplePropertyValue(_In_ void* p )
{
    setPtr(p);
}

inline hkSimplePropertyValue::hkSimplePropertyValue( hkUint64 i )
{
    setUint64( i );
}

#if defined(HK_REAL_IS_DOUBLE)
inline hkReal hkSimplePropertyValue::getReal() const
{
    union {
        hkReal r;
        hkUint64 u;
    } u;
    u.u = m_data;
    return u.r;
}
#else
inline hkReal hkSimplePropertyValue::getReal() const
{
    // see comment in setReal
    union {
        hkReal r;
        hkUint32 u;
    } u;
    u.u = hkUint32(m_data);
    return u.r;
}
#endif

inline int hkSimplePropertyValue::getInt() const
{
    return static_cast<int>(m_data);
}

_Ret_notnull_
inline void* hkSimplePropertyValue::getPtr() const
{
    return reinterpret_cast<void*>(static_cast<hkUlong>(m_data));
}

inline hkUint64 hkSimplePropertyValue::getUint64() const
{
    return m_data;
}

inline hkSimpleProperty::hkSimpleProperty()
{
}

inline hkSimpleProperty::hkSimpleProperty( hkUint32 key, hkInt32 value )
:   m_key(key), m_value(value)
{
}

inline hkSimpleProperty::hkSimpleProperty( hkUint32 key, hkSimplePropertyValue value )
:   m_key(key), m_value(value)
{
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
