// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0


#include <Common/Base/hkBase.h>
#include <Common/Base/Types/Properties/hkSimpleProperty.h>
#include <Common/Base/Container/StringMap/hkStringMap.h>

// used to map the property name specified by the user into a property key

void HK_CALL hkSimpleProperty::mapStringToKey(_In_z_ const char* string, hkUint32& keyOut)
{
    hkUint32 hash = 0;
    for (int i = 0; string[i] != '\0'; ++i)
    {
        hash = 31 * hash + string[i];
    }
    keyOut = hash & (hkUint32(-1)>>1); // reserve -1 for empty
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
