// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/hkBase.h>
#include <Common/Base/Types/Properties/hkRefCountedProperties.h>

//
//  Constructor

hkRefCountedProperties::hkRefCountedProperties()
{}

//
//  Copy constructor

hkRefCountedProperties::hkRefCountedProperties(const hkRefCountedProperties& other)
    : hkReferencedObject()
{
    m_entries.append(other.m_entries);
}

//
//  Destructor

hkRefCountedProperties::~hkRefCountedProperties()
{}

//
//  Adds a property to the collection. If a property is already installed for the given key, it will be replaced

void hkRefCountedProperties::addPropertyInternal(PropertyKey propertyKey, _Inout_ hkReferencedObject* propertyObject, ReferenceCountHandling referenceHandling)
{
    for (int i = m_entries.getSize() - 1; i >= 0; i--)
    {
        Entry& e = m_entries[i];
        if ( e.getKey() == propertyKey )
        {
            if ( referenceHandling == REFERENCE_COUNT_INCREMENT )
            {
                e.m_object = propertyObject;
            }
            else
            {
                e.m_object = HK_NULL;
                e.m_object.setAndDontIncrementRefCount( propertyObject );
            }
            return;
        }
    }

    // Did not find the object, must add new
    {
        Entry& e = m_entries.expandOne();
        e.setKey(propertyKey);
        if ( referenceHandling == REFERENCE_COUNT_INCREMENT )
        {
            e.m_object = propertyObject;
        }
        else
        {
            e.m_object.setAndDontIncrementRefCount( propertyObject );
        }
    }
}

//
//  Removes a property from the collection

void hkRefCountedProperties::removeProperty(PropertyKey propertyKey)
{
    for (int i = m_entries.getSize() - 1; i >= 0; i--)
    {
        if ( m_entries[i].getKey() == propertyKey )
        {
            m_entries.removeAt(i);
            return;
        }
    }
}

//
//  Replaces the property at the given key with the given object

void hkRefCountedProperties::replaceProperty(PropertyKey propertyKey, _In_ hkReferencedObject* newPropertyObject)
{
    for (int i = m_entries.getSize() - 1; i >= 0; i--)
    {
        if ( m_entries[i].getKey() == propertyKey )
        {
            m_entries[i].m_object = newPropertyObject;
        }
    }

    // Key not found, should not get here!
    HK_WARN_ALWAYS(0x1d11daed, "Failed to locate key " << propertyKey << " among the existing properties!");
}

//
//  Locates and returns the property at the given key. If no property was found, it will return null.

_Ret_maybenull_
hkReferencedObject* hkRefCountedProperties::accessProperty(PropertyKey propertyKey) const
{
    const int numEntries                = m_entries.getSize();
    const Entry* HK_RESTRICT entries    = m_entries.begin();

    // Download the array from Ppu
    hkReferencedObject* retObj = HK_NULL;
    for (int i = numEntries - 1; i >= 0; i--)
    {
        if ( entries[i].getKey() == propertyKey )
        {
            retObj = entries[i].m_object;
            break;
        }
    }

    // Return the object!
    return retObj;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
