// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/Types/Properties/hkPropertyRegistry.h>

hkStaticPropertyDescBase* hkStaticPropertyDescBase::head = HK_NULL;

static hkResult HK_CALL registerStaticProperties(_In_opt_ void*)
{
    if (hkPropertyRegistry::isInitialised() && hkReflect::Detail::TypeRegNode::isLocalEntryRegistered())
    {
        hkPropertyRegistry::getInstance().registerStaticProperties(hkStaticPropertyDescBase::head);
        return HK_SUCCESS;
    }
    return HK_FAILURE;
}

static hkResult HK_CALL unregisterStaticProperties(_In_opt_ void*)
{
    if (hkPropertyRegistry::isInitialised())
    {
        hkPropertyRegistry::getInstance().unregisterStaticProperties(hkStaticPropertyDescBase::head);
    }
    return HK_SUCCESS;
}

static hkBaseSystem::InitNode s_initStaticProperties("Register static properties",
        &registerStaticProperties,
        &unregisterStaticProperties);

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
