// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM        : ALL
// PRODUCT        : COMMON
// VISIBILITY    : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/Types/Properties/hkProperty.h>
#include <Common/Base/Container/Hash/hkHashMap.h>
#include <Common/Base/Object/hkReferencedObject.h>
#include <Common/Base/Reflect/TypeReg/hkTypeReg.h>
#include <Common/Base/Thread/CriticalSection/hkCriticalSection.h>

/// Maintain the property description to property id mapping
class HK_EXPORT_COMMON hkPropertyRegistry : public hkReferencedObject
{
    public:
        HK_DECLARE_CLASS(hkPropertyRegistry, New, Singleton);

        /// Constructor
        hkPropertyRegistry();

        /// Destructor
        ~hkPropertyRegistry();

        /// Return the property id associated with the given type and name;
        /// will create a new id if the property does not exist yet.
        hkPropertyId getPropertyId(_In_ const hkReflect::Type* type, _In_z_ const char* name, hkPropertyFlags::Enum flags);

        /// Force rebuilding of the id from key map, intended to be done when new types
        /// are added so that the typeCode can be updated.
        void rebuildIdFromKey();

        /// Patch property desc flags that are still unset with the attributes from the added types
        void addTypes(const hkArrayView<const hkReflect::Type* const>& typesAdded);

        /// Remove dynamic property desc referring to the given types
        void removeTypes(const hkArrayView<const hkReflect::Type* const>& typesRemoved);

        void replaceTypes(hkArrayView<hkReflect::MutableTypeReg::TypeReplacement> typeReplacements);

        /// Register static properties from a list, should be called when new dlls are loaded
        void registerStaticProperties(_Inout_ hkStaticPropertyDescBase* head);

        /// Unregister static properties from a list, should be called when dlls are unloaded
        void unregisterStaticProperties(_Inout_ hkStaticPropertyDescBase* head);

        typedef hkTuple<hkPropertyDesc*, bool> PropertyInfo;
        hkArrayView<const PropertyInfo> propertyInfo() const { return m_properties; }

    private:
        friend struct hkPropertyId;
        void setPropertyFlags(_In_ const hkPropertyDesc* desc, hkPropertyFlags::Enum flags);

        hkPropertyId createPropertyId(_In_ const hkReflect::Type* type, _In_z_ const char* name, hkPropertyFlags::Enum flags);

        hkArray<PropertyInfo> m_properties;

        struct Key
        {
            const char* name;
            hkUint32 typeCode;
        };

        friend hkUint32 hkHashValue(const Key& key);
        friend bool operator==(const Key& lhs, const Key& rhs);

        hkHashMap<Key, hkPropertyDesc*> m_propertyIdFromKey;
        hkReflect::MutableTypeReg::Subscription m_typeRegSubscription;
        hkCriticalSection m_cs;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
