// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/Types/Properties/hkProperty.h>
class hkDefaultPropertyBag;

    /// A property bag or null
class HK_EXPORT_COMMON hkPropertyBag : public hkPropertyInterface<hkPropertyBag>
{
    public:

        HK_DECLARE_CLASS(hkPropertyBag, NewPlacement, Reflect);
        HK_RECORD_ATTR(hk::ReflectDetails(parents = false, fields = true));
        HK_RECORD_ATTR(hk::IncludeInMgd(false));
        HK_REFLECT_AS_ARRAY(&hkPropertyBag::s_impl, hkDefaultPropertyBag);
        HK_RECORD_ATTR(hk::MemoryTracker(opaque = true, handler = &trackerHandler));

        friend struct hkPropertyInterface<hkPropertyBag>;

            /// Constructor
        hkPropertyBag() : m_bag(HK_NULL) {}

            /// Destructor
        ~hkPropertyBag();

            /// Copy
        hkPropertyBag(const hkPropertyBag& bag);
            /// Assign
        hkPropertyBag& operator=(const hkPropertyBag& bag);

            /// Remove all properties.
        void clear();

        bool isEmpty() const;
        int getSize() const;
        bool hasProperty(hkPropertyId id) const;
        hkResult addChecked(hkPropertyId id, const hkReflect::Var& value);
        hkResult removeChecked(hkPropertyId id);
        _Ret_maybenull_ void* getValueAddressChecked(_In_ const hkReflect::Type* type, hkPropertyId id) const;

        struct Entry
        {
            hkPropertyId id;
            hkReflect::Var value;
        };

        struct Iterator
        {
            Entry operator*() { return m_bag->entryAtIndex(m_index); }
            bool operator!=(Iterator i) const { return i.m_index != m_index; }
            bool operator==(Iterator i) const { return i.m_index == m_index; }
            void operator++() { m_index += 1; }
            Iterator(_In_ const hkPropertyBag* bag, int i) : m_bag(bag), m_index(i) {}
        private:
            const hkPropertyBag* m_bag;
            int m_index;
        };

        Iterator begin() const { return Iterator(this, 0); }
        Iterator end() const { return Iterator(this, getSize()); }

        void deepCopy(const hkPropertyBag& other);


    public:
        struct Impl;
        static const Impl s_impl;

        static void trackerHandler(const hkReflect::Var& var, class hkMemoryTrackerSnapshot& snapshot);

        /// Calls hackAfterReflectNew on m_bag if any which in turn calls afterReflectNew on its hashmap.
        void hackAfterReflectNew();

    protected:

        friend struct Iterator;
        Entry entryAtIndex(int i) const;

        hkDefaultPropertyBag& ensureBag();
        hkDefaultPropertyBag* m_bag HK_ATTR(hk::Serialize(false));
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
