// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once
#include <Common/Base/Types/Properties/hkProperty.h>

#include <Common/Base/Container/Hash/hkHashMap.h>
#include <Common/Base/Reflect/Util/hkReflectClone.h>
#include <Common/Base/Reflect/Util/hkReflectAny.h>

    /// Default implementation of hkPropertyBag
class HK_EXPORT_COMMON hkDefaultPropertyBag : public hkPropertyInterface<hkDefaultPropertyBag>
{
    public:

        HK_DECLARE_CLASS(hkDefaultPropertyBag, New, Reflect, BypassCtor);
        HK_RECORD_ATTR(hk::ReflectDetails(parents=false, fields=true));
        HK_RECORD_ATTR(hk::Version(1));
        HK_RECORD_ATTR(hk::ExcludeFromVersionCheck);

        typedef hkHashMap<hkPropertyId, hkReflect::Any> HashMap;
        typedef HashMap::Iterator                   Iterator;
        typedef hkTuple<hkPropertyId, hkReflect::Any>       PropertyEntry;

        /// Constructor
        hkDefaultPropertyBag() : m_locked(false) {}

        bool isEmpty() const;
        int getSize() const;
        bool hasProperty(hkPropertyId id) const;
        hkResult addChecked(hkPropertyId id, const hkReflect::Var& prop);
        hkResult removeChecked(hkPropertyId id);
        _Ret_maybenull_ void* getValueAddressChecked(_In_ const hkReflect::Type* type, hkPropertyId id) const;

        /// Copies cloneable properties from other
        void copyProperties(const hkDefaultPropertyBag& other);

        /// Calls afterReflectNew on its hashmap.
        void hackAfterReflectNew();

    protected:
        friend class hkPropertyBag;

        HashMap& getMap(hkPropertyId id);
        const HashMap& getMap(hkPropertyId id) const;

        const HashMap::Item& atIndex(int i) const;

        void copyProperties(const HashMap& src);

        /// The permanent (= serialized) properties
        HashMap m_propertyMap;

        /// The transient (= non-serialized) properties
        HashMap m_transientPropertyMap HK_ATTR(hk::Serialize(false));
    public:
        bool m_locked  HK_ATTR(hk::Serialize(false));
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
